// Example of SearchableSpace. Copyright (C) 1999 University of Washington,
// Columbia Basin Research. 
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

#import <simtoolsgui/GUISwarm.h>
#import <simtools.h>
#import <objectbase.h>
#import <objectbase/Swarm.h>
#import <random.h>

#import "SearchableSpace.h"
#import "ExampleObject.h"
#import "globals.h"

int
main (int argc, const char **argv)
{
  int i;
  id myList, newObj, randGen, randDist, searchSpace, foundObj;

  // Needed to pull in library modules, keep linker happy.
  id aSwarm;
  initSwarm (argc, argv);
  aSwarm = [GUISwarm create: globalZone];

  // Create 20 objects randomly strewn around a square.
  randGen = [MT19937gen create: globalZone setStateFromSeed: 12345];
  randDist = [UniformDoubleDist create: globalZone setGenerator: randGen
                             setDoubleMin: 0.0 setMax: 10.0];
  myList = [List create: globalZone];

  for (i = 0; i < 20; i++) {
    newObj = [ExampleObject createBegin: globalZone];
    [newObj setLocX: [randDist getDoubleSample] 
                  Y: [randDist getDoubleSample]];
    [newObj setVal: [randDist getDoubleSample]];
    [newObj createEnd];

    printf( "Object created at %f, %f, value %f\n",
             [newObj getDoubleX], [newObj getDoubleY], [newObj getVal] );

    [myList addLast: newObj];
  }

  // Put the list of objects into a SearchableSpace.
  searchSpace = [SearchableSpace createBegin: globalZone];
  [searchSpace setUseTree: FALSE];
  [searchSpace setAllowDups: TRUE];
  [searchSpace setIntCoords: FALSE];
  [searchSpace setMinX: 0.0 maxX: 10.0 minY: 0.0 maxY: 10.0];
  [searchSpace setGridSpacing: 2.0];
  [searchSpace createEnd];
  [searchSpace putObjects: myList];

  // Find the one that is closest to (5,5) with a value greater than 5.
  printf( "looking for nearest point to 5.5\n" );
  foundObj = [searchSpace getNearestObjectToX: 5.0 Y: 5.0 
                                           WithValue: GT To: 5.0];
  printf( "found: %f, %f, value %f\n", [foundObj getDoubleX],
                             [foundObj getDoubleY], [foundObj getVal] );
  
  // Iterate over all objects within (3,3), (7,7)
  printf( "find all points within (3,3) - (7,7)\n" );
  [searchSpace iterateMinX: 3.0 maxX: 7.0 minY: 3.0 maxY: 7.0];
  while ((foundObj = [searchSpace next]) != nil) {
    printf( "found: %f, %f, value %f\n", [foundObj getDoubleX],
                             [foundObj getDoubleY], [foundObj getVal] );
  }

  // Clean up and exit.
  [searchSpace drop];
  [myList drop];
  return(0);
}

