
// SimObject.m
//
// Base class for all object components of the VRRR project

#include "SimObject.h"
#import <math.h>

@implementation SimObject



//////////////////////////////////////////
//
// createBegin
//
//////////////////////////////////////////
+ (SimObject *) createBegin: aZone
{
  SimObject *obj = [super createBegin: aZone];
  
  obj->calculation= [Vector create: aZone];
  obj->oldPosition= [Vector create: aZone];

  obj->position   = [Vector create: aZone];
  obj->velocity   = [Vector create: aZone];
  obj->radius     = 1.0;
  
  obj->display    = nil;

  obj->model = aZone;

  return obj;
}



////////////////////////////////////////////
//
// createEnd
//
////////////////////////////////////////////
- createEnd
{

  return [super createEnd];

}


/////////////////////////////////////////
//
// drop
//
/////////////////////////////////////////
- (void) drop
{
  [position     drop];
  [velocity     drop];
  [calculation  drop];
  [oldPosition  drop];
  [super drop];
}

- init: (int) id : (int) type;
{
  objectID   = id;
  objectType = type;
  return self;
}

- init: (int) id : (int) type
      : (id <Vector>) p
      : (id <Vector>) v
      : (double  ) r
{
  objectID   = id;
  objectType = type;
  [position init: p];
  [velocity init: v];
  radius = r;
  return self;
}


///////////////////////////////////////////
//
// initModel
//
//////////////////////////////////////////
- initModel: m
{
  model = m;
  worldX = [model getWorldXSize];
  worldY = [model getWorldYSize];


  return self;
}


//////////////////////////////////////////
//
// createDisplay
//
//////////////////////////////////////////
- createDisplay {

  display    = [Polygon createBegin: [self getZone]];

  if(model) 
  {

      [display setCanvas: [model getCanvas]];


  }
  else 
  {
  
      [InternalError raiseEvent: "ERROR: SimObject >>>> createDisplay Model is not set\n"];

  }
  

  display = [display createEnd];



  return self;

}
- (id <Vector>)getVelocity {
  return velocity;
}

- (id <Vector>)getPosition {
  return position;
}

- (double )getRadius {
  return radius;
}

- step
{ // movement: p=p0 + v * dt. dt == 1
  [position add: velocity];
  
  return self;
}

- setVelocity: (id <Vector>)v {
  [velocity init: v];
  return self;
}
- setPosition: (id <Vector>)v {
  [position init: v];
  return self;
}
- setRadius: (double ) r {
  radius = r;
  return self;
}



//////////////////////////////////////////////////////////
//
// avoid
//
//////////////////////////////////////////////////////////
- (double) avoid: (id <Vector>)pos with: (id <Vector>) aVector
{
  double l;
  [[aVector init: pos] sub: position];

  l = [aVector getLength] - radius;

  if (l < 0.0) {
    [aVector mult: 0.001]; // in object == very close
    l = 0.001;
  } else
    [aVector setLength: l];

  return l;
}

- (int) getObjectType { return objectType; }
- (int) getObjectID   { return objectID; }



/////////////////////////////////////////////////
//
//  display
//
////////////////////////////////////////////////
- display
{
  Vector *aCalcVector;

  if( (![oldPosition eq: position]) && (display != nil) )  // need to draw
  { 

    [oldPosition init: position];    // update oldPosition

    [display erase];                 // erase the previous image

    switch (objectType) {            // create graphical display of this SimObject
    case PREY:
    case PREDATOR:

         [[display getList] deleteAll];  // delete previous display vectors
         [[calculation init: velocity] setLength: radius];

         // first point: nose
         aCalcVector = [[[Vector create: [self getZone]] init: calculation] add: position];
         [display add: aCalcVector];  // add vector to list of display vectors     


         // 2. point: right wing
         aCalcVector = [[[[Vector create: [self getZone]] init: calculation] right] add: position];
         [display add: aCalcVector];      


         // 3. point: left wing
         aCalcVector = [[[[Vector create: [self getZone]] init: calculation] left] add: position];
         [display add: aCalcVector];
         break;

    case OBSTACLE:
          
          //
          // This should happen only once for each non-moving obstacle
          //
          { 
	      double d;
	      for (d=0.0; d<2*M_PI; d+=M_PI/10.0) 
              {
	          id <Vector> v=[Vector create: [self getZone]];
	          [[v init: sin(d)*radius : cos(d)*radius] add: position];
	          [display add: v];
	      }
          }

          break;
     
    default:
         break;

    }  //switch objectType

    [display createItem];
  }

  return self;
}


////////////////////////////////////////////////
//
// drawSelfOn
//
////////////////////////////////////////////////
- drawSelfOn: aRaster {

  [aRaster drawPointX: (unsigned) [position getX] + 0.5
                    Y: (unsigned) [position getY] + 0.5
                Color: 0];


  return self;

}

@end
