#import <simtoolsgui.h>
#import "ObserverSwarm.h"

@implementation ObserverSwarm: GUISwarm

+ createBegin: aZone
{
  ObserverSwarm * obj;
  obj = [super createBegin: aZone];
  return obj;
}

- createEnd
{
  return [super createEnd];
}



//////////////////////////////////////////////////
//
// buildObjects
//
//////////////////////////////////////////////////
- buildObjects
{
  //  printf ("ObserverSwarm\tbuildObjects\n");
  [super buildObjects];
  
  modelSwarm = [ModelSwarm create: self];
  
  CREATE_PROBE_DISPLAY (modelSwarm);
  //  CREATE_PROBE_DISPLAY (self);

  [controlPanel setStateStopped];

  colorMap = [Colormap create: self];

  [colorMap setColor: 0 ToName: "white"];
  [colorMap setColor: 1 ToName: "green"];
  [colorMap setColor: 2 ToName: "blue"];
  [colorMap setColor: 3 ToName: "black"];
  [colorMap setColor: 4 ToName: "red"];
  [colorMap setColor: 5 ToName: "purple"];


  if( toupper([modelSwarm useBoidRaster][0]) == 'Y')
  {

      boidRaster = [ZoomRaster createBegin:  self];
      boidRaster = [boidRaster createEnd];
      [boidRaster enableDestroyNotification: self
                   notificationMethod: @selector (_boidRasterDeath_:)];

      [boidRaster setColormap: colorMap];

      SET_WINDOW_GEOMETRY_RECORD_NAME (boidRaster);

      [boidRaster setZoomFactor: 1];

      [boidRaster setWidth: [modelSwarm getWorldXSize] 
                    Height: [modelSwarm getWorldYSize]];

      [boidRaster setWindowTitle: "Boid World"];
      [boidRaster pack];				

      [modelSwarm setRaster: boidRaster];
  }



  

  if( toupper([modelSwarm useBoidCanvas][0]) == 'Y')
  {
      canvas = [Canvas create: globalZone];
      [canvas setWidth: [modelSwarm getWorldXSize] 
	      Height: [modelSwarm getWorldYSize]];
      [canvas setWindowTitle: "Flock World"];
      [canvas pack];

      [modelSwarm setCanvas: canvas];
  
  }



  [modelSwarm buildObjects];


  if(boidRaster)
  {

      boidDisplay = [Object2dDisplay createBegin: self];
      [boidDisplay setDisplayWidget: boidRaster];
      [boidDisplay setDiscrete2dToDisplay: [modelSwarm getBoidSpace]];
      [boidDisplay setObjectCollection: [modelSwarm getBoids]];
      [boidDisplay setDisplayMessage: M(drawSelfOn:)];   // draw method
      boidDisplay = [boidDisplay createEnd];

  }

  popGraph = [EZGraph createBegin: [self getZone]];
  SET_WINDOW_GEOMETRY_RECORD_NAME (popGraph);
  [popGraph setTitle: "Poplulation vs. time"];
  [popGraph setAxisLabelsX: "time" Y: "population"];
  popGraph = [popGraph createEnd];

  [popGraph createSequence: "Population"
            withFeedFrom: [modelSwarm getObjectList] 
            andSelector: M(getCount)];

  return self;
}  




///////////////////////////////////////////////////////////
// 
// buildActions
//
//////////////////////////////////////////////////////////
- buildActions
{
  //  printf ("ObserverSwarm\tbuildActions\n");
  [super buildActions];
  
  // build the actions for the model's schedule
  [modelSwarm buildActions];

  // create the display actions
  displayActions = [ActionGroup create: [self getZone]];
  [displayActions createActionTo: actionCache message: M(doTkEvents)];
  [displayActions createActionTo: popGraph    message: M(step)];
  [displayActions createActionTo: modelSwarm  message: M(display)];
  [displayActions createActionTo: self message: M(updateRaster)];

  // then actually schedule the display actions
  displaySchedule = [Schedule createBegin: [self getZone]];
  [displaySchedule setRepeatInterval: 1];
  displaySchedule = [displaySchedule createEnd];
  [displaySchedule at: 0 createAction: displayActions];

  return self;
}  

//////////////////////////////////////////////////////
//
// updateRaster
//
/////////////////////////////////////////////////////
- updateRaster {

   if (boidRaster) {
       [boidRaster erase];
       [boidDisplay display];
       [boidRaster drawSelf];
    }

   return self;

}


//////////////////////////////////////////////////////////
//
// activateIn
//
////////////////////////////////////////////////////////
- activateIn: swarmContext
{
  [super activateIn: swarmContext];
  [modelSwarm activateIn: self];
  [displaySchedule activateIn: self];
  
  return [self getSwarmActivity];
}



/////////////////////////////////////////////////////
//
// getDisplay
//
//////////////////////////////////////////////////////
- getDisplay
{
  return canvas;
}
@end
