#import "DemoSwarm.h"
#import <gui.h>
#import <collections.h>
#import <simtools.h>
#import "Highway.h"

@implementation DemoSwarm

#define FONTNAME "*-helvetica-medium-*-normal-14-*_*_*_*_*_*"

//------------------------------------------------------
+ createBegin: aZone
{
	DemoSwarm * obj;
	id <ProbeMap> probeMap;
  
	obj = [super createBegin: aZone];
	obj->vmax = 2;
	obj->pDecel = 0.1;
	obj->nHighways = 20;
	obj->highwayLen = 200;
	obj->minCarDensity = 0.2;
	obj->maxCarDensity = 0.6;

	probeMap = [EmptyProbeMap createBegin: aZone];
	[probeMap setProbedClass: [self class]];
	probeMap = [probeMap createEnd];

	[probeMap addProbe: [probeLibrary getProbeForVariable: "vmax"
				    inClass: [self class]]];
	[probeMap addProbe: [probeLibrary getProbeForVariable: "pDecel"
				    inClass: [self class]]];
	[probeMap addProbe: [probeLibrary getProbeForVariable: "nHighways"
				    inClass: [self class]]];
	[probeMap addProbe: [probeLibrary getProbeForVariable: "highwayLen"
				    inClass: [self class]]];
	[probeMap addProbe: [probeLibrary getProbeForVariable: "minCarDensity"
				    inClass: [self class]]];
	[probeMap addProbe: [probeLibrary getProbeForVariable: "maxCarDensity"
				    inClass: [self class]]];

	[probeLibrary setProbeMap: probeMap For: [self class]];

	return obj;
}

- createEnd
{
	return [super createEnd];
}

//--------------------------------------------------------------------
- _worldRasterDeath_ : caller
{
  [worldRaster drop];
  worldRaster = nil;
  return self;
}

- _canvasDeath_ : caller
{
	[myCanvas drop];
	myCanvas = nil;
	return self;
}

- _anGraphDeath_ : caller
{
  [anGraph drop];
  anGraph = nil;
  return self;
}

- buildObjects
{
	int i;
	id myText;
	
	[super buildObjects];
  
	// create the probe display for the observer swarm (self)
	CREATE_PROBE_DISPLAY (self);

	myCanvas = [[Canvas createBegin: self] createEnd];
	[myCanvas setWidth: 450 Height: 240];
	[myCanvas setWindowTitle: "About NaSchDemo"];
	[myCanvas enableDestroyNotification: self
		notificationMethod: @selector (_canvasDeath_:)];

	myText = [TextItem createBegin: self];
	[[myText setText: 
	"
    The Nagel-Schreckenberg (NaSch) model is a minimal cellular
automaton that exhibits the same complex behaviour as cars 
on a single lane highway.
    Each highway in this demo is a ring of cells with cars moving
to the right and reappearing at the left.  One cell corresponds
to 7.5m in reality, so the default highway is 1.5km long.
    At the start, cars are placed on the highway with random 
position and speed, according to the given densities.  A number 
of highways is stacked in the window with ever increasing car 
density. The first demo shows how, with increasing density, 
traffic jams occur and move backwards.

Ref.: cond-mat/0007053
	"] 
	setFont: FONTNAME];
	[[myText setCanvas: myCanvas] setCenterFlag: NO];
	[myText setX: 25 Y: 120];
	[myText createEnd];
	[myCanvas pack];

//	observedAquarium = [AquariumSwarm createBegin: [self getZone]];
//	observedAquarium = [observedAquarium createEnd];
//	CREATE_PROBE_DISPLAY (observedAquarium);
	
	[controlPanel setStateStopped];
	if ([controlPanel getState] == ControlStateQuit)
		return nil;

	colormap = [Colormap create: [self getZone]];
	[colormap setColor: 0 ToName: "grey"];

    world = [Grid2d create: self setSizeX: highwayLen Y: nHighways*5];

//	highwayCanvas = [HighwayCanvas create: self];
	observedHighways = [List create: self];

	for (i=0; i<nHighways; i++)
	{
		float carDensity = minCarDensity 
			+ ((maxCarDensity-minCarDensity)/(nHighways-1))*i;
		id highway = [Highway createBegin: self];
		[highway setDensity: carDensity vMax: vmax P: pDecel];
//		[highway setCanvas: highwayCanvas];
		[highway setWorld: world];
		[highway setY: 2+i*5 size: highwayLen];
		highway = [highway createEnd];
		[observedHighways addLast: highway];
		[highway buildObjects];
	}

//	[highwayCanvas setHighways: observedHighways];
//	[highwayCanvas enableDestroyNotification: self
//		notificationMethod: @selector (_highwayCanvasDeath_:)];
//	[highwayCanvas pack];				  // draw the window.
//	[highwayCanvas drawSelf];

	// the following is stolen from heatbugs
	worldRaster = [ZoomRaster create: [self getZone]];
	[worldRaster enableDestroyNotification: self
		notificationMethod: @selector (_worldRasterDeath_:)];
	[worldRaster setColormap: colormap];
	[worldRaster setZoomFactor: 5];
	[worldRaster setWidth: [world getSizeX] Height: [world getSizeY]];
	[worldRaster setWindowTitle: "NaSch Highways"];
	[worldRaster pack];				  // draw the window.
	[worldRaster drawSelf];
	
	agentDisplay = 
    	[Object2dDisplay create: self
			setDisplayWidget: worldRaster
			setDiscrete2dToDisplay: world
			setDisplayMessage: M(drawSelfOn:)];
    
 //	[[observedAquarium getSharkSet] forEach: M(setColor:) : (void*) 2];
#if 0	
	populationGraph = 
		[EZGraph create: self
			setTitle: "Population count of all species"
			setAxisLabelsX: "time" Y: "number"
			setWindowGeometryRecordName: "populationGraph"];
  
	[populationGraph enableDestroyNotification: self
		notificationMethod: @selector (_populationGraphDeath_:)];

	[populationGraph createSequence: "sharks"
		withFeedFrom: [observedAquarium getSharkSet]
		andSelector: M(getCount)];

	[populationGraph createSequence: "fish"
		withFeedFrom: [observedAquarium getFishSet]
		andSelector: M(getCount)];
#endif
		return self;
}

- buildActions
{
	[super buildActions];
  
	[observedHighways forEach: M(buildActions)];

	displayActions = [ActionGroup create: self];
	
	[displayActions createActionTo: worldRaster  message: M(erase)];
	[[displayActions createActionForEach: observedHighways
  		message: M(step)] setDefaultOrder: Randomized];
	[displayActions createActionTo: agentDisplay  message: M(display)];
	[displayActions createActionTo: worldRaster  message: M(drawSelf)];
//	[displayActions createActionTo: populationGraph  message: M(step)];
	[displayActions createActionTo: probeDisplayManager message: M(update)];
	[displayActions createActionTo: actionCache  message: M(doTkEvents)];

	displaySchedule = [Schedule createBegin: self];
	[displaySchedule setRepeatInterval: 1];
	displaySchedule = [displaySchedule createEnd];
	[displaySchedule at: 0 createAction: displayActions];
  
	return self;
}  

- activateIn: swarmContext
{
	[super activateIn: swarmContext];

	[displaySchedule activateIn: self];
  
	return [self getSwarmActivity];
}



@end
