// Agent.h
// defines agent vars and its interaction structure
// assumption: agent does not do any scheduling activity, relies on world
// to be added as Swarm scheduling is implementedd

#import <objectbase/SwarmObject.h>
#import <space/Grid2d.h>

#define MASK32 0xffffffff
#define MAXIDENT 20
#define MEMMAX 5

@interface IPDagent : SwarmObject
{
  char ident[MAXIDENT];		// agent ID tag

  // Agent features
  unsigned char memory,		// length of memory of agent
    length;			// bits needed for that memory
  unsigned strategy;		// agent transition table

  // agent internal state
  int payoff[4];
  int score;			// total score from interaction
  double average;		// average from interacts
  unsigned history;		// past actions
  unsigned iterations;		// Number of iterations suffered
}

// -- Creating
// spatial location setup
-setID: (char *) newid;

// -- Setting
// change internal state
-setPayoff: (int) place Val: (int) value;
-setStrategy: (unsigned) strat withMemory: (unsigned char) mem;
-setHistory: (int) hist;
-reset;				// Resets score and iterations
-copyAgent: (id) a2;


-(char) action;			// returns action given history
-updateAgent: (char) action;	// given actions, updates agent

// -- Using
// get info about agent
-(char*) getID;
-(unsigned char) getMemory;
-(unsigned char) getLength;
-(unsigned) getStrategy;
-(int) getScore;
-(double) getAverage;

-debugState;
-printState;			// prints agent internal state

@end
