// -*- mode: objc; -*-
// Copyright  1995-2000 Swarm Development Group.
// No warranty implied, see LICENSE for terms.

#ifndef _AGENTSWARM_H
#define _AGENTSWARM_H

#import <objectbase/Swarm.h>
#import <ga/Population.h>

#import "EvolvableIPDagent.h"	// for agents

@interface AgentSwarm: Swarm <Population> // Steady state population
{
  // Simulation parameters
  unsigned initPopSize, popSize;
  float cloning, mating, mut, 
    dup, split;			// Probabilities of application of genOps
  unsigned numIterations,	// Number of actions for each agent
    minMemory, maxMemory;
  //    generations;

  unsigned verbose;
 
  id modelActions;
  id modelSchedule;		// Scheduling data structures

  // Population variables
  id popList, evalPopList;	// Will be a collection
  unsigned  generationCount; 

} 

// Compulsory methods
+createBegin: (id) aZone;
-createEnd;
-buildObjects;
-buildActions;
-activateIn: (id) swarmContext;

@end

#endif
