// Loop through a Discrete1d, sending the displayMessage message to
// all objects found in there. One argument is passed on the message,
// the display widget.

#import "Object1dDisplay.h"
#import <simtools.h>

@implementation Object1dDisplay

-createEnd {
  [super createEnd];
  if (displayWidget == nil || discrete1d == nil || displayMessage == (SEL) nil)
    [InvalidCombination raiseEvent: "Object display improperly initialized\n"];
  return self;
}

-setDisplayWidget: (Raster *) r {
  displayWidget = r;
  return self;
}

-setDiscrete1dToDisplay: (Discrete1d *) c {
  discrete1d = c;
  return self;
}

-setDisplayMessage: (SEL) s {
  displayMessage = s;
  return self;
}

// an optional collection of objects to display. If you give us one, then
// on display we'll just forEach through the objects. Otherwise we have to
// scan the whole array.
-setObjectCollection: (id) objects {
  objectCollection = objects;
  return self;
}

-display {
  int x;
  id * lattice;
  int xsize;

  lattice = [discrete1d getLattice];
  xsize = [discrete1d getSizeX];

  // if we have a collection to display, just use that. Otherwise scan
  // the entire 1d grid.
  if (objectCollection) {
    [objectCollection forEach: displayMessage : displayWidget];
  } else {
      for (x = 0; x < xsize; x++) {
	id potentialObject;
	potentialObject = *discrete1dSiteAt(lattice, x);
	if (potentialObject)
	  [potentialObject perform: displayMessage with: displayWidget];
      }
  }

  return self;
}

// code to make a probe for an object at a specific point. This is
// good to make as a button client for Raster widgets
-makeProbeAtX: (int) x Y: (int) y {
  id obj;
  
  if (x >= 0 && x < [discrete1d getSizeX]) {
    obj = [discrete1d getObjectAtX: x];
    if (obj)
      [probeDisplayManager createProbeDisplayFor: obj];
    else
      [globalTkInterp eval: "bell"];
  } else {
    [WarningMessage raiseEvent: "Object1dDisplay: invalid coordinates to make probe (%d)\n", x];
  }
  return self;
}
      
@end
