// EPDObserverSwarm.h EPD
//Copyright James Marshall 1998-2004. Freely distributable under the GNU General Public Licence

#import "EPDSwarm.h"

#import <gui.h>
#import <simtoolsgui/GUISwarm.h>
#import <simtoolsgui.h>
#import <analysis.h>

@interface EPDObserverSwarm: GUISwarm
{
  int modelTime, averageCooperation, averageRelatedness, numModelRuns; //added ST
  double averageInteractionLength, averageCellPopulation, averageNumberOfPartners; //added ST	
  int timeCounter; //added ST



  int displayFrequency;
  id displayActions;
  id displaySchedule;
  id epdSwarm, logFile;  //included logFile for XML output
  id <Colormap> worldColourMap, populationColourMap;
  id <ZoomRaster> worldRaster, populationRaster;
  id <Value2dDisplay> worldValueDisplay, populationValueDisplay;
  id <EZGraph> coopGraph, alleleGraph, strategyGraph;
}

+createBegin: (id) aZone;
-createEnd;
-(void)drop; 	//included for end of XML log file.

-buildObjects;
-buildActions;
-activateIn: (id) swarmContext;

@end
