//Copyright Simon Tokumine 2003. Freely distributable under the GNU General Public Licence

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

/**
 * @author 	S. Tokumine
 * @date	25-Jun-2003
 * @time	10:17:55
 * @file	TextPanel.java
 * 
 * @desc INSERT CLASS DESCRIPTION HERE
 *
 */
public class TextPanel extends JPanel {

	protected JTextArea textArea;
	private JScrollPane scrollPane;

	/**
	 * creates text panel and layout
	 */
	public TextPanel() {
		super();

		
		//Create the text area used for output.
		textArea = new JTextArea(10, 30);
		scrollPane = new JScrollPane(textArea);

		//cant edit text area
		textArea.setEditable(false);

		setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));

		scrollPane.setBorder(BorderFactory.createLineBorder(Color.GRAY, 1));
		
		//Lay out the content.
		setLayout(new BorderLayout());
		setPreferredSize(new Dimension(250, 450));
		add(scrollPane /*,BorderLayout.WEST*/
		);

		print("==E3D Output Window=="); 
	}

	//USE THIS TO WRITE TO THE TEXT AREA 
	public void print(String actionDescription) {
		textArea.append(actionDescription + "\n");
	}

	//CLEAR THE TEXTAREA
	public void clearPanel() {
		textArea.setText("");
	}
	
	//CALL THIS AFTER THE CLEARPANEL TO SET THE TYPING CARET TO THE 	
	//TOP OF THE PANE AGAIN
	public void toTop() {
		textArea.setCaretPosition(0);
	}
	
	//THE FILE INPUT METHOD. YOU CALL IT WITH A STRING 	
	//CONTAINGING THE FILENAME OF YOUR TEXT FILE. IT MUST BE IN THE 	
	//DIRECTORY AS THE PROGRAM. TO CLEAR THE PANEL SEE THE CLEARPANEL 	
	//METHOD ABOVE
	public void printFile(String fileName) {
		try {
			clearPanel();
			File f = new File(fileName);
			FileInputStream fos = new FileInputStream(f);
			DataInputStream dis = new DataInputStream(fos);

			// Read every line in the file
			String line = dis.readLine();
			while (line != null) {

				// Output the line
				textArea.append(line + "\n");


				// Read next line
				line = dis.readLine();
			}
			dis.close();
			fos.close();

		} catch (IOException e) {
			textArea.append("Error occured whilst reading in help file. \n" +
							"Check the program Directory for \"" + fileName +"\"" + "\n");
		}
	}

}
