//Copyright Simon Tokumine 2003. Freely distributable under the GNU General Public Licence

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

/**
 * @author 	S. Tokumine
 * @date	26-Aug-2003
 * @time	19:50:12
 * @file	GridPanel.java
 * 
 * @desc GRidpanel provides the user level controls for the grid overlay
 *
 */
public class GridPanel extends JPanel implements ActionListener {

	ColorMapFactory colorMapFactory;//to set flags
	SlidePanel slidePanel;//to redraw
	StatusBar statusBar;//to set status
	ColorPicker colorPicker;//to update mainpanel?
	
	/**
	 * sets up radio buttons and the actions they each call
	 */
	public GridPanel(
		ColorMapFactory colorMapFactory_in,
		StatusBar statusBar_in) {
		super();
		setBorder(
			BorderFactory.createCompoundBorder(
				BorderFactory.createTitledBorder("Enable/Disable grid: "),
				BorderFactory.createEmptyBorder(15, 5, 5, 5)));

		statusBar = statusBar_in;
		colorMapFactory = colorMapFactory_in;

		JRadioButton off = new JRadioButton("Off");
		off.setMnemonic(KeyEvent.VK_O);
		off.setActionCommand("0");

		JRadioButton white = new JRadioButton("White lines");
		white.setMnemonic(KeyEvent.VK_W);
		white.setActionCommand("1");

		JRadioButton invert = new JRadioButton("Inverted Lines");
		invert.setMnemonic(KeyEvent.VK_I);
		invert.setActionCommand("2");

		JRadioButton dot = new JRadioButton("Inverted Points");
		dot.setMnemonic(KeyEvent.VK_D);
		dot.setActionCommand("3");
		dot.setSelected(true);

		//Group the radio buttons.
		ButtonGroup group = new ButtonGroup();
		group.add(off);
		group.add(white);
		group.add(invert);
		group.add(dot);

		//register action listeners
		off.addActionListener(this);
		white.addActionListener(this);
		invert.addActionListener(this);
		dot.addActionListener(this);

		//arrange buttons in a panel
		JPanel radioPanel = new JPanel(new GridLayout(0, 1));
		radioPanel.add(off);
		radioPanel.add(white);
		radioPanel.add(invert);
		radioPanel.add(dot);

		add(radioPanel, BorderLayout.LINE_START);
	}

	/** 
	 * interprets actions on the radio buttons and sets the flags in the 
	 * colourmapfactory, and status bar
	 * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
	 */
	public void actionPerformed(ActionEvent e) {
		// TODO Auto-generated method stub
		colorMapFactory.setGrid(Integer.parseInt(e.getActionCommand()));
		colorPicker.setKey();
		if (e.getActionCommand() == "0") {
			statusBar.setStatus("Grid set to: Off");
		}
		if (e.getActionCommand() == "1") {
			statusBar.setStatus("Grid set to: White lines");
		}
		if (e.getActionCommand() == "2") {
			statusBar.setStatus("Grid set to: Inverted Lines");
		}
		if (e.getActionCommand() == "3") {
			statusBar.setStatus("Grid set to: Inverted Points");
		}
	}
	
	/**
	 * set up link for colorpicker so that can update mainpanel correctly
	 */
	public void setColorPicker(ColorPicker cp_in) {
		colorPicker = cp_in;
	}
}


