//EPDObserverSwarm.m EPD
//Copyright James Marshall 1998-2004. Freely distributable under the GNU General Public Licence

#import "EPDObserverSwarm.h"
#import "math.h"

@implementation EPDObserverSwarm

+createBegin: (id) aZone
{
  EPDObserverSwarm *obj;
  id <ProbeMap> probeMap;

  obj=[super createBegin: aZone];
  obj->displayFrequency=1;

  //create the probe map for the observer Swarm
  probeMap=[EmptyProbeMap createBegin: aZone];
  [probeMap setProbedClass: [self class]];
  probeMap=[probeMap createEnd];

  //add a probe for display frequency to the probe map, and set the probe map for the observer Swarm
  [probeMap addProbe: [probeLibrary getProbeForVariable: "displayFrequency" inClass: [self class]]];
  [probeLibrary setProbeMap: probeMap For: [self class]];

  return obj;
}

-createEnd
{
  
  return [super createEnd];
}

-buildObjects
{
  id modelZone;
  int l1,l2, zf;

  [super buildObjects];

  //S.TOKUMINE 11/06/03 create the XML log file
  logFile=[OutFile create: self setName: "log.xml"];
  //S.TOKUMINE 12/06/03 create the XML file DTD header - methodify later
  [logFile putString: "<?xml version=\"1.0\"?>"];
  [logFile putNewLine];
  [logFile putString: "<!DOCTYPE epd-out ["];
  [logFile putNewLine];
  [logFile putString: "<!ELEMENT epd-out (timeslice+, interactionlength, aapayoff, abpayoff, bapayoff, bbpayoff)>\n"];
  [logFile putString: "<!ELEMENT timeslice (stratfreq)>\n"];
  [logFile putString: "<!ATTLIST timeslice time ID #REQUIRED>\n"];
  [logFile putString: "<!ELEMENT stratfreq (genotype+)>\n"];
  [logFile putString: "<!ELEMENT genotype (type, sfreq)>\n"];
  [logFile putString: "<!ELEMENT type (#PCDATA)>\n"];
  [logFile putString: "<!ELEMENT sfreq (#PCDATA)>\n"];
  [logFile putString: "<!ELEMENT interactionlength (#PCDATA)>\n"];
  [logFile putString: "<!ELEMENT aapayoff (#PCDATA)>\n"];
  [logFile putString: "<!ELEMENT abpayoff (#PCDATA)>\n"];
  [logFile putString: "<!ELEMENT bapayoff (#PCDATA)>\n"];
  [logFile putString: "<!ELEMENT bbpayoff (#PCDATA)>\n"];
  [logFile putString: "]>\n"];
  
  [logFile putNewLine];
  [logFile putString: "<epd-out>"];
  [logFile putNewLine];
  
  //S.TOKUMINE 12/06/03 initialise generation counter  
  timeCounter = 0;
  
  
  //create the model Swarm
  modelZone=[Zone create: [self getZone]];
  epdSwarm=[EPDSwarm create: modelZone];

  //create the probe displays for the model and observer Swarms
  [probeDisplayManager createProbeDisplayFor: epdSwarm];
  [probeDisplayManager createProbeDisplayFor: self];

  [controlPanel setStateStopped];

  //build the objects in the model Swarm
  [epdSwarm buildObjects];

  //create a colour map (grey scale) for displaying cell population densities
  populationColourMap=[Colormap create: modelZone];
  [populationColourMap setColor: 0 ToName: "blue"];
  for (l1=1; l1<=10; l1++)
  {
    [populationColourMap setColor: l1 ToGrey: (double)l1/10];
  }

  //create a colour map for displaying cell cooperation and relatedness levels
  worldColourMap=[Colormap create: modelZone];
  [worldColourMap setColor: 0 ToName: "black"];
  for (l1=0; l1<=10; l1++)
  {
    for (l2=0; l2<=10; l2++)
    {
      [worldColourMap setColor: (l1*11)+l2+1 ToRed: (double)l1/10 Green: (double)l2/10 Blue: (double)1];
    }
  }
  [worldColourMap setColor: 122 ToRed: 1 Green: 0 Blue: 0]; //red for individual agents

  //create a raster object for displaying cell population densities
  zf=500/[epdSwarm getWorldXSize];
  if (zf>50)
  {
    zf=50;
  }

  populationRaster=[ZoomRaster create: modelZone];
  [populationRaster setColormap: populationColourMap];
  [populationRaster setZoomFactor: zf];
  [populationRaster setWidth: [epdSwarm getWorldXSize] Height: [epdSwarm getWorldYSize]];
  [populationRaster setWindowTitle: "EPD Population"];
  [populationRaster drawSelf];
  [populationRaster pack];

  //create a raster object for displaying cell cooperation and relatedness levels
  worldRaster=[ZoomRaster create: modelZone];
  [worldRaster setColormap: worldColourMap];
  [worldRaster setZoomFactor: zf];
#ifdef testcard
  [worldRaster setWidth: 11 Height: 11];
#else
  [worldRaster setWidth: [epdSwarm getWorldXSize] Height: [epdSwarm getWorldYSize]];
#endif
  [worldRaster setWindowTitle: "EPD World"];
  [worldRaster drawSelf];
  [worldRaster pack];

  //create a display object for cell population densities
  populationValueDisplay=[Value2dDisplay createBegin: [self getZone]];
  [populationValueDisplay setDisplayWidget: populationRaster colormap: populationColourMap];
  [populationValueDisplay setDiscrete2dToDisplay: [epdSwarm getPopulationDisplay]];
  populationValueDisplay=[populationValueDisplay createEnd];
  [populationValueDisplay setDisplayMappingM: 1 C: 0];

  //create a display object for cell cooperation and relatedness levels
  worldValueDisplay=[Value2dDisplay createBegin: [self getZone]];
  [worldValueDisplay setDisplayWidget: worldRaster colormap: worldColourMap];
  [worldValueDisplay setDiscrete2dToDisplay: [epdSwarm getWorldDisplay]];
  worldValueDisplay=[worldValueDisplay createEnd];
  [worldValueDisplay setDisplayMappingM: 1 C: 0];

  //create a graph object to display global cooperation and relatedness levels
  coopGraph=[EZGraph createBegin: [self getZone]];
  [coopGraph setTitle: "Cooperation & Relatedness vs time"];
  [coopGraph setAxisLabelsX: "time" Y: "level (%)"];
  coopGraph=[coopGraph createEnd];
  [coopGraph createSequence: "Cooperation level" withFeedFrom: [epdSwarm getWorld] andSelector: M(getCoopLevel)];
  [coopGraph createSequence: "Global relatedness" withFeedFrom: [epdSwarm getWorld] andSelector: M(getGlobalRelatedness)];

  //create a graph object to display allele frequencies in the gene pool
  alleleGraph=[EZGraph createBegin: [self getZone]];
  [alleleGraph setTitle: "Allele frequencies in population"];
  [alleleGraph setAxisLabelsX: "time" Y: "Level"];
  alleleGraph=[alleleGraph createEnd];
  [alleleGraph createSequence: "Total population" withFeedFrom: [epdSwarm getWorld] andSelector: M(getWorldPopulation)];
  #ifdef pure_kin_selection
    [alleleGraph createSequence: "C allele (locus 0)" withFeedFrom: [[epdSwarm getWorld] getAlleleFrequency: 0] andSelector: M(getIntData)];
    [alleleGraph createSequence: "C allele (locus 1)" withFeedFrom: [[epdSwarm getWorld] getAlleleFrequency: 1] andSelector: M(getIntData)];
  #else
    [alleleGraph createSequence: "Friendly allele" withFeedFrom: [[epdSwarm getWorld] getAlleleFrequency: 0] andSelector: M(getIntData)];
    [alleleGraph createSequence: "Constructive allele" withFeedFrom: [[epdSwarm getWorld] getAlleleFrequency: 1] andSelector: M(getIntData)];
    [alleleGraph createSequence: "Merciful allele" withFeedFrom: [[epdSwarm getWorld] getAlleleFrequency: 2] andSelector: M(getIntData)];
    [alleleGraph createSequence: "Forgiving allele" withFeedFrom: [[epdSwarm getWorld] getAlleleFrequency: 3] andSelector: M(getIntData)];
    [alleleGraph createSequence: "Dovish allele" withFeedFrom: [[epdSwarm getWorld] getAlleleFrequency: 4] andSelector: M(getIntData)];
  #endif

  //create a graph object to display allele frequencies in the gene pool
  strategyGraph=[EZGraph createBegin: [self getZone]];
  [strategyGraph setTitle: "Strategy frequencies in population"];
  [strategyGraph setAxisLabelsX: "time" Y: "Level"];
  strategyGraph=[strategyGraph createEnd];
  [strategyGraph createSequence: "SVE" withFeedFrom: [[epdSwarm getWorld] getStrategyFrequency: 0] andSelector: M(getIntData)];
  [strategyGraph createSequence: "SVM" withFeedFrom: [[epdSwarm getWorld] getStrategyFrequency: 1] andSelector: M(getIntData)];
  [strategyGraph createSequence: "SFE" withFeedFrom: [[epdSwarm getWorld] getStrategyFrequency: 2] andSelector: M(getIntData)];
  [strategyGraph createSequence: "SFM" withFeedFrom: [[epdSwarm getWorld] getStrategyFrequency: 3] andSelector: M(getIntData)];
  [strategyGraph createSequence: "FVE" withFeedFrom: [[epdSwarm getWorld] getStrategyFrequency: 4] andSelector: M(getIntData)];
  [strategyGraph createSequence: "FVM" withFeedFrom: [[epdSwarm getWorld] getStrategyFrequency: 5] andSelector: M(getIntData)];
  [strategyGraph createSequence: "FFE" withFeedFrom: [[epdSwarm getWorld] getStrategyFrequency: 6] andSelector: M(getIntData)];
  [strategyGraph createSequence: "FFM" withFeedFrom: [[epdSwarm getWorld] getStrategyFrequency: 7] andSelector: M(getIntData)];

  
  return self;
}

-buildActions
{
  [super buildActions];

  //create the model Swarm's actions
  [epdSwarm buildActions];

  //create the action group to update the graphs and displays, and respond to user events
  displayActions=[ActionGroup create: [self getZone]];
  [displayActions createActionTo: worldValueDisplay message: M(display)];
  [displayActions createActionTo: populationValueDisplay message: M(display)];
  [displayActions createActionTo: worldRaster message: M(drawSelf)];
  [displayActions createActionTo: populationRaster message: M(drawSelf)];
  [displayActions createActionTo: coopGraph message: M(step)];
  [displayActions createActionTo: alleleGraph message: M(step)];
  [displayActions createActionTo: strategyGraph message: M(step)];
  [displayActions createActionTo: actionCache message: M(doTkEvents)];
//    [displayActions createActionTo: self message: M(drop)]; //Simon tokumine added

  //create the schedule to execute the action group with a certain display frequency
  displaySchedule=[Schedule createBegin: [self getZone]];
  [displaySchedule setRepeatInterval: displayFrequency];
  displaySchedule=[displaySchedule createEnd];

  //schedule the action group
  [displaySchedule at: 0 createAction: displayActions];

  //S. TOKUMINE 11/06/03 XML FILE LOG ACTION (copied from experimentswarm)
  [displayActions createActionTo: self message: M(logResults)];
  
  return self;
}

-activateIn: (id)swarmContext
{
  [super activateIn: swarmContext];

  [epdSwarm activateIn: self];

  [displaySchedule activateIn: self];

  return [self getSwarmActivity];
}

//S. TOKUMINE 12/06/03 XML LOG FILE GENERATION
- logResults 
{
  //to log gene locus
  int l;		
  
  //startup for each timeslice
  [logFile putString: "\r           \n"];
  [logFile putString: "\t<timeslice time=\"t"];
  [logFile putInt: timeCounter];
  timeCounter = timeCounter + 1;  
  [logFile putString: "\">\n"];
  	/*[logFile putString: "\t\t<genefreq>\n"];
		  	
	loop through each gene, outputting its number and allele frequency --> perhaps not nexcesary
	for (l=0; l<[[epdSwarm getWorld] getStrategyLength]; l++)
	{
	  	[logFile putString: "\t\t\t<gene>\n"];	  
			  	[logFile putString: "\t\t\t\t<locus>"];	  
				[logFile putInt: l];
			  	[logFile putString: "</locus>\n"];
				[logFile putString: "\t\t\t\t<co-op>"];	  
				//--> seems to return a pointer to the allelle array how to dereference?
				[logFile putInt: [[[epdSwarm getWorld] getAlleleFrequency: l] getIntData]];
			  	[logFile putString: "</co-op>\n"];
	  	[logFile putString: "\t\t\t</gene>\n"];	  	
	}
  	[logFile putString: "\t\t</genefreq>\n\n"];
	*/
  	[logFile putString: "\t\t<stratfreq>\n"];
  
  	//loop through each GENOTYPE, outputting its number and allele frequency
	for (l=0; l<(pow(2,[[epdSwarm getWorld] getStrategyLength])); l++)
	{
	  	[logFile putString: "\t\t\t<genotype>\n"];	  
			  	[logFile putString: "\t\t\t\t<type>"];	  
				[logFile putInt: l];
			  	[logFile putString: "</type>\n"];
				[logFile putString: "\t\t\t\t<sfreq>"];	  
				//--> seems to return a pointer to an array how to dereference? plus, 
				//how many strategies exist in the system? not 32? why?
				[logFile putInt: [[[epdSwarm getWorld] getStrategyFrequency: l] getIntData]];
			  	[logFile putString: "</sfreq>\n"];
	  	[logFile putString: "\t\t\t</genotype>\n"];	  	
	}
  	[logFile putString: "\t\t</stratfreq>\n"];
  
  [logFile putString: "\t</timeslice>\n"];
  
  //[logFile putSting: "</epd-out>"];
  //[logFile putString: "\r          \n];

  return self;
}

-(void)drop
{
  //S.TOKUMINE 12/06/03 Clean up XML file and close final element doesn't work?	
  char logString[80];

  sprintf(logString, "\t<interactionlength>%f</interactionlength>\n", [[epdSwarm getWorld] getAverageInteractionLength]);
  [logFile putString: logString];
  sprintf(logString, "\t<aapayoff>%d</aapayoff>\n", [[epdSwarm getWorld] getPayoffAction1: 1 action2: 1]);
  [logFile putString: logString];
  sprintf(logString, "\t<abpayoff>%d</abpayoff>\n", [[epdSwarm getWorld] getPayoffAction1: 1 action2: 0]);
  [logFile putString: logString];
  sprintf(logString, "\t<bapayoff>%d</bapayoff>\n", [[epdSwarm getWorld] getPayoffAction1: 0 action2: 1]);
  [logFile putString: logString];
  sprintf(logString, "\t<bbpayoff>%d</bbpayoff>\n", [[epdSwarm getWorld] getPayoffAction1: 0 action2: 0]);
  [logFile putString: logString];
  [logFile putString: "</epd-out>"];
  [logFile putNewLine];
  
  [super drop];
}

@end
