//Copyright Simon Tokumine 2003. Freely distributable under the GNU General Public Licence

import java.io.File;
import javax.swing.filechooser.*;


/**
 * @author 	S. Tokumine
 * @date	24-Jun-2003
 * @time	15:11:17
 * @file	XMLFilter.java
 * 
 * @desc XML file filter class
 *
 */
public class XMLFilter extends FileFilter {

	/**
	 
	public XMLFilter() {
		super();
		// TODO Auto-generated constructor stub
	}
	*/
	
	public final static String xml = "xml";
    
	//Accept all directories and all xml files.
	public boolean accept(File f) {
		if (f.isDirectory()) {
			return true;
		}

		String extension = getExtension(f);

		if (extension != null) {
			if (extension.equals(xml)) {
					return true;
			} else {
				return false;
			}
		}

		return false;
	}

	//The description of this filter
	public String getDescription() {
		return "*.XML";
	}

	public static String getExtension(File f) {

		String ext = null;
		String s = f.getName();
		int i = s.lastIndexOf('.');

		if (i > 0 &&  i < s.length() - 1) {
			ext = s.substring(i+1).toLowerCase();
		}
		return ext;
	}


}



