//EPDSwarm.m EPD
//Copyright James Marshall 1998-2002. Freely distributable under the GNU General Public Licence

#import "EPDSwarm.h"

@implementation Payoffs

-create
{
  AAPayoff=0;
  ABPayoff=0;
  BAPayoff=0;
  BBPayoff=0;

  return self;
}

-(int)getAAPayoff
{
  return AAPayoff;
}

-(int)getABPayoff
{
  return ABPayoff;
}

-(int)getBAPayoff
{
  return BAPayoff;
}

-(int)getBBPayoff
{
  return BBPayoff;
}

@end

@implementation EPDSwarm

+createBegin: (id) aZone
{
  EPDSwarm *obj;
#ifdef observer
  id <ProbeMap> probeMap;
#endif

  obj=[super createBegin: aZone];

  //initialise model Swarm parameters
  obj->worldXsize=10;
  obj->worldYsize=10;
  obj->maxAgents=200;
  obj->maxLocalAgents=5;
  obj->startAgents=75;
  #ifdef pure_kin_selection
    obj->strategyLength=2;
    obj->strategyNumber=4;
  #else
    obj->strategyLength=5;
    obj->strategyNumber=8;
  #endif
  obj->deathProbability=0.05;
  obj->moveProbability=1;
  obj->defectorProbability=0.5;
  obj->mutationRate=0.01;
  obj->crossProbability=0.1;
  #ifdef interaction_method1
    obj->startEnergy=9;
    obj->livingCost=3;
  #else
    obj->startEnergy=45;
    obj->livingCost=15;
  #endif
  obj->endTime=1000;

  #ifdef observer
    //create probe map for model Swarm
    probeMap=[EmptyProbeMap createBegin: aZone];
    [probeMap setProbedClass: [self class]];
    probeMap=[probeMap createEnd];

    //add probes for variables in model Swarm
    [probeMap addProbe: [probeLibrary getProbeForVariable: "worldXsize" inClass: [self class]]];
    [probeMap addProbe: [probeLibrary getProbeForVariable: "worldYsize" inClass: [self class]]];
    [probeMap addProbe: [probeLibrary getProbeForVariable: "maxAgents" inClass: [self class]]];
    [probeMap addProbe: [probeLibrary getProbeForVariable: "maxLocalAgents" inClass: [self class]]];
    [probeMap addProbe: [probeLibrary getProbeForVariable: "startAgents" inClass: [self class]]];
    [probeMap addProbe: [probeLibrary getProbeForVariable: "deathProbability" inClass: [self class]]];
    [probeMap addProbe: [probeLibrary getProbeForVariable: "moveProbability" inClass: [self class]]];
    [probeMap addProbe: [probeLibrary getProbeForVariable: "defectorProbability" inClass: [self class]]];
    [probeMap addProbe: [probeLibrary getProbeForVariable: "mutationRate" inClass: [self class]]];
    [probeMap addProbe: [probeLibrary getProbeForVariable: "crossProbability" inClass: [self class]]];
    [probeMap addProbe: [probeLibrary getProbeForVariable: "startEnergy" inClass: [self class]]];
    [probeMap addProbe: [probeLibrary getProbeForVariable: "livingCost" inClass: [self class]]];
    [probeMap addProbe: [probeLibrary getProbeForVariable: "endTime" inClass: [self class]]];
    [probeLibrary setProbeMap: probeMap For: [self class]];
  #endif

    // load parameters from file 'world.setup'
    [ObjectLoader load: obj fromFileNamed: "world.setup"];

  return obj;
}

-createEnd
{
  return [super createEnd];
}

-(void)drop
{
  //drop all sub-objects
  [payoffs drop];
  [[allAgents getCollection] deleteAll];
  [[allAgents getCollection] drop];
  [allAgents drop];
  [populationDisplay drop];
  [worldDisplay drop];
  [world drop];
  [modelStep drop];
  [modelSchedule drop];

  [super drop];
}

-buildObjects
{
  id <List> tempList;
  id GamePayoffs;

  //load payoffs from file
  GamePayoffs=[Payoffs create: [self getZone]];
  [ObjectLoader load: GamePayoffs fromFileNamed: "payoffs.setup"];

  //create payoff matrix for interactions (matrix preserved for compatibility... will be removed in future version)
  payoffs=[Array create: [self getZone] setCount: 2];
  [payoffs atOffset: 0 put: [Array create: [self getZone] setCount: 2]];
  [payoffs  atOffset: 1 put: [Array create: [self getZone] setCount: 2]];
  [[payoffs atOffset: 0] atOffset: 0 put: (id)[GamePayoffs getBBPayoff]];
  [[payoffs atOffset: 0] atOffset: 1 put: (id)[GamePayoffs getBAPayoff]];
  [[payoffs atOffset: 1] atOffset: 0 put: (id)[GamePayoffs getABPayoff]];
  [[payoffs atOffset: 1] atOffset: 1 put: (id)[GamePayoffs getAAPayoff]];

  //create global agent list
  tempList=[List create: [self getZone]];
  allAgents=[tempList begin: [tempList getZone]];

  //create lattice to store population density values for display
  populationDisplay=[Discrete2d createBegin: globalZone];
  [populationDisplay setSizeX: worldXsize Y: worldYsize];
  populationDisplay=[populationDisplay createEnd];
  [populationDisplay fillWithValue: 1];

  //create lattice to store cooperation and relatedness values for display
  worldDisplay=[Discrete2d createBegin: globalZone];
#ifdef testcard
  [worldDisplay setSizeX: 11 Y: 11];
#else
  [worldDisplay setSizeX: worldXsize Y: worldYsize];
#endif
  worldDisplay=[worldDisplay createEnd];
  [worldDisplay fillWithValue: 1];

  //create and initialise world
  world=[EPDWorld createBegin: globalZone];
  [world setSizeX: worldXsize Y: worldYsize];
  [world setupMaxAgents: maxAgents maxLocalAgents: maxLocalAgents startAgents: startAgents strategyLength: strategyLength strategyNumber: strategyNumber deathProbability: deathProbability moveProbability: moveProbability defectorProbability: defectorProbability mutationRate: mutationRate crossProbability: crossProbability agentList: allAgents payoffMatrix: payoffs worldDisplay: worldDisplay populationDisplay: populationDisplay startEnergy: startEnergy livingCost: livingCost];
  world=[world createEnd];

  //populate world with initial agent population
  [world populate];

  return self;
}

-buildActions
{
  //create action group to run model
  modelStep=[ActionGroup create: [self getZone]];
  [modelStep createActionForEach: [allAgents getCollection] message: M(move)];
  [modelStep createActionTo: world message: M(purge)];
  [modelStep createActionTo: world message: M(resetCoopLevel)];
  [modelStep createActionTo: world message: M(resetGlobalRelatedness)];
  [modelStep createActionTo: world message: M(resetCellTotalActions)];
  [modelStep createActionTo: world message: M(resetCellTotalDiversity)];
  [modelStep createActionTo: world message: M(resetDisplay)];
  [modelStep createActionTo: world message: M(updateAverageLocalPopSize)];
  [modelStep createActionForEach: [allAgents getCollection] message: M(play)];
//  [modelStep createActionForEach: [allAgents getCollection] message: M(mate)];
  [modelStep createActionTo: world message: M(mate)];
  [modelStep createActionTo: world message: M(display)];
  #ifdef observer
  #else
    [modelStep createActionTo: world message: M(storeValues)];
    [modelStep createActionTo: self message: M(checkToStop)];
  #endif

  modelSchedule=[Schedule createBegin: [self getZone]];
  [modelSchedule setRepeatInterval: 1];
  [modelSchedule setKeepEmptyFlag: NO];
  modelSchedule=[modelSchedule createEnd];

  [modelSchedule at: 0 createAction: modelStep];

  return self;
}

-activateIn: (id) swarmContext
{
  [super activateIn: swarmContext];

  [modelSchedule activateIn: self];

  return [self getActivity];
}

-getPopulationDisplay
{
  //return lattice containing population density values
  return populationDisplay;
}

-getWorldDisplay
{
  //return lattice containing cooperation and relatedness values
  return worldDisplay;
}

-getWorld
{
  return world;
}

-(int)getWorldXSize
{
  return (int)worldXsize;
}

-(int)getWorldYSize
{
  return (int)worldYsize;
}

-setMoveProbability: (double) moveProb
{
  //set agents' movement probability
  moveProbability=moveProb;

  return self;
}

-checkToStop
{
  //check if model run should end
  if ([world getWorldTime]==endTime || [world getWorldPopulation]==0)
  {
    [[self getActivity] terminate];
  }

  //if run has not ended, increment world's age
  [world incrementWorldTime];

  return self;
}

@end
