//EPDDefines.h EPD
//Copyright James Marshall 1998-2002. Freely distributable under the GNU General Public Licence

#define observer //define for observer mode of application, undefine for experiment mode
#define global_population_regulation //  if defined population is regulated at global level, otherwise at local (cell) level
//#define global_mating_pool // if defined mating and offspring distribution is global rather than local
//#define pure_kin_selection //if defined special version of model to study pure kin selection, with one-dimensional agent strategies (2 locus chromosomes) and roles randomly assigned at meetings
//only one of the interaction method constants below should be defined
#define interaction_method1 //one PD interaction at each meeting, with previous history (not valid if pure_kin_selection defined)
//#define interaction_method2 //three PD interactions at each meeting, with previous history (DO NOT DEFINE IF pure_kin_selection DEFINED)
//only one of the first 3 relatedness measure contants below should be defined
//#define relatedness_measure1 //global relatedness measured on global population
//#define relatedness_measure2 //global relatedness measured as average of populated cells' local relatedness
#define relatedness_measure3 //global relatedness measured on interacting pairs
//#define relatedness_measure4 //IF DEFINED IN CONJUNCTION WITH relatedness_measure3: global relatedness calculated only on merciful/exploitative and forgiving/vengeful loci (DO NOT DEFINE IF pure_kin_selection DEFINED)
//#define consider_interaction_subset //update cooperation level and relatedness level only for interactions involving merciful/exploitative and forgiving/vengeful loci (DO NOT DEFINE IF pure_kin_selection DEFINED)
//#define role_swap_cooperation //measure cooperation on instances of agents using different roles (for use with Battle of the Sexes payoff matrix)

//error checking
#if defined(interaction_method1) && defined(interaction_method2)
  #error
#endif
#if (defined(relatedness_measure1) && defined(relatedness_measure2)) || (defined(relatedness_measure1) && defined(relatedness_measure3)) || (defined(relatedness_measure2) && defined(relatedness_measure3))
  #error
#endif
#if defined(pure_kin_selection) && (defined(relatedness_measure4) || defined(consider_interaction_subset) || defined(interaction_method2))
  #error
#endif
#if defined(relatedness_measure4) && !defined(relatedness_measure3)
  #error
#endif
