
// SimObject.m
//
// Base class for all object components of the VRRR project

#include "SimObject.h"
#import <math.h>

@implementation SimObject

+ (SimObject *)create: aZone
{
  SimObject *obj=[super create:aZone];
  
  obj->calculation= [Vector create: aZone];
  obj->oldPosition= [Vector create: aZone];

  obj->position   = [Vector create: aZone];
  obj->velocity   = [Vector create: aZone];


  obj->sendPosition   = [Vector create: aZone];

  obj->paramSpace = nil;

  return obj;
}

- createEnd
{
  //[display setCanvas: [model getCanvas]];
  //display = [display createEnd];

  return [super createEnd];
}

- (void) drop
{
  [position     drop];
  [velocity     drop];
  [calculation  drop];
  [oldPosition  drop];
  [super drop];
}

- init: (int) id : (int) type;
{
  objectID   = id;
  objectType = type;
  return self;
}


- init: (int) id : (int) type
      : (id <Vector>) p
      : (id <Vector>) v {
  objectID   = id;
  objectType = type;
  [position init: p];
  [velocity init: v];
  return self;
}


- initModel: m
{
  model = (id <Model>) m;
  worldX = [model getWorldXSize];
  worldY = [model getWorldYSize];

  return self;
}


- initParamSpace: (ParameterSpace *) aParamSpace {

   paramSpace = aParamSpace;

   return self;

}


- (id <Vector>)getVelocity {
  return velocity;
}

- (id <Vector>)getPosition {
  return position;
}

- step
{ // movement: p=p0 + v * dt. dt == 1
  [position add: velocity];
  
  return self;
}

- setVelocity: (id <Vector>)v {
  [velocity init: v];
  return self;
}
- setPosition: (id <Vector>)v {
  [position init: v];
  return self;
}

- (double) avoid: (id <Vector>)pos with: (id <Vector>)calc
{
  double l;
  [[calc init: pos] sub: position];

  l = [calc getLength] - paramSpace->bodyRadius;

  if (l < 0.0) {
    [calc mult: 0.001]; // in object == very close
    l = 0.001;
  } else
    [calc setLength: l];

  return l;
}

- (int) getObjectType { return objectType; }
- (int) getObjectID   { return objectID; }

/*

//
//  this is where the draw self (to a raster) should go
//
- display
{
  Vector *calc;

  return self;

  if (![oldPosition eq: position]) { // need to draw
    [oldPosition init: position];    // update oldPosition
    [display erase];                 // erase the previous image
    switch (objectType) {            // create graphical display of this SimObject
    case PREY:
    case PREDATOR:
      [[display getList] deleteAll];
      [[calculation init: velocity] setLength: paramSpace->bodyRadius];
      calc = [[[Vector create: [self getZone]] init: calculation] add: position];
      [display add: calc];      // first point: nose

      calc = [[[[Vector create: [self getZone]] init: calculation] right] add: position];
      [display add: calc];      // 2. point: right wing

      calc = [[[[Vector create: [self getZone]] init: calculation] left] add: position];
      [display add: calc];      // 3. point: left wing
      break;
    case OBSTACLE:
    default:
      {
	double d;
        [[display getList] deleteAll];  //skj
	for (d=0.0; d<2*M_PI; d+=M_PI/10.0) {
	  id <Vector> v=[Vector create: [self getZone]];
	  [[v init: sin(d)*paramSpace->bodyRadius : cos(d)*paramSpace->bodyRadius] add: position];
	  [display add: v];
	}
      }
    break;
    }
    [display createItem];
  }

  return self;
}

*/

////////////////////////////////////////////////
//
// drawSelfOn
//
////////////////////////////////////////////////
- drawSelfOn: aRaster {

//  if(myRaster == nil) myRaster = aRaster;

 if([velocity getLength] != 0.0)  {

[aRaster lineX0: (unsigned) [position getX] + 0.5
                Y0: (unsigned) [position getY] + 0.5
                X1: (unsigned) [position getX] + [velocity getX]
                Y1: (unsigned) [position getY] + [velocity getY]
             Width: 1
                Color: 0];
  }

 else {

  [aRaster ellipseX0: (unsigned) [position getX]
                  Y0: (unsigned) [position getY]
                  X1: (unsigned) [position getX] + 8
                  Y1: (unsigned) [position getY] + 8
               Width:  1
               Color:  0];
     }

/*
  fprintf(stderr,"SIMOBJECT i'm a boid helloooo!!!!\n");
  fprintf(stderr,"SIMOBJECT position X = %f\n", [position getX]);
  fprintf(stderr,"SIMOBJECT position Y = %f\n", [position getY]);
  fflush(0);
*/


  return self;

}

@end

