#import <objectbase/Swarm.h>
#import <gui.h>
#import "ParameterSpace.h"
#import "BoidSpace.h"

@interface ModelSwarm: Swarm
{
  int numAgents;
  int numberOfBoids;
  int worldXSize, worldYSize;
  int agentID;

  id <List> objectList;

  //id <Canvas> canvas;

  id modelActions;
  id modelSchedule;

  int **visibilityMatrix;
  int boidCount; 
  // Total number of boids that have been created so far. Note that this
  // value increases monotonically, and does NOT take into account boids
  // that have been deleted.


  id boidSpace;

  id <Raster> boidRaster;

  ParameterSpace* paramSpace;

}

+ create: aZone;

- buildObjects;
- buildActions;
- activateIn: (id) swarmContext;

//- display;
//- setCanvas: (id <Canvas>) c;
- setRaster: (id <Raster>) aRaster;
//- (id <Canvas>) getCanvas;
- (id <List>) getObjectList;




//
// GET METHODS
//
- (int) getWorldXSize;
- (int) getWorldYSize;


- getBoidSpace;
- getBoids;
- (ParameterSpace *) getParameterSpace;

@end

