// RuleMaster.m
//--------------------------------------------------------------------

#import "RuleMaster.h"
#import "Interface.h"

@implementation RuleMaster

//--------------------------------------------------------------------

- createEnd
{

   id obj;

TRACE5(printf("\n%8X RuleMaster - entry createEnd\n",(int) self);)


// eye will be useful to locate the object during reading a storage
// dump
   eyeCatcher[0]='R';
   eyeCatcher[1]='M';
   eyeCatcher[2]='S';
   eyeCatcher[3]='T';
   obj = [super createEnd];

TRACE5(printf("%8X RuleMaster - exit createEnd %8X\n\n",
              (int) self,(int) obj);)

   return obj;

}

//--------------------------------------------------------------------

- setRuleMaker: (RuleMaker *) rM
{

TRACE5(printf("\n%8X RuleMaster - entry setRuleMaker: %8X\n",
              (int) self,(int) rM);)

   ruleMaker = rM;

TRACE5(printf("%8X RuleMaster - entry setRuleMaker %8X\n",
              (int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------

- setDump: (Dump *) du
{

TRACE5(printf("\n%8X RuleMaster - entry setDump: %8X\n",
              (int) self,(int) du);)

   dump = du;

TRACE5(printf("%8X RuleMaster - entry setDump %8X\n",
              (int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------

- setShuffler: (Shuffler *) sh
{

TRACE5(printf("\n%8X RuleMaster - entry setShuffler: %8X\n",
              (int) self,(int) sh);)

   shuffler = sh;

TRACE5(printf("%8X RuleMaster - entry setShuffler %8X\n",
              (int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------

- applyRuleTo: (DataWarehouse *) dW with: (id) it
{

   double  sel,err,num;

TRACE5(printf("\n%8X RuleMaster - entry getAdviceFor: %8X\n",
              (int) self,(int) it);)

// We have agreed that an agent don't give immediatly his dataWarehouse
// but only his address: this way the ruleMaster will be able to decide
// what kind of information it needs and ask the agent for.

   dataWarehouse = dW;
   interface     = (Interface *) it;


// First the ruleMaster need the own agent's data and provides
// translation of the agent's inputs: this phase is called detecting.

   [self keepData];
   [self detect];

   [dataWarehouse addSelection];

//To allow, statistically, each rule to fire at least once before the
//genetic algoritm and to give the auction time to select bad rules
//let's invoke the ruleMaker only if the number of selection is almost
//equal to number of rules; be carefull: if you remove the first part
//of test you will have zero divisition after application of evolution
//because the selAfterEvol counter is set to zero.
//If you needs more precise verification you can reduce the ratio
//in the second part of test.

   sel = (double) selAfterEvol;
   err = (double) errorCounter;
   num = (double) [ruleList getCount];

   if (((evolutionRate == 1) && (sel > num)) ||
       ((evolutionRate < 1) &&
     ([uniformDblRand getDoubleWithMin: 0 withMax: 1] < evolutionRate)))
   {

      if ((err/sel) > confidence)
      {

      [ruleMaker evolveDataWarehouse: dataWarehouse];
      [dataWarehouse addEvolution];

         //To avoid problems if a rule that have fired a message or
         //that is waiting for a reward from effector will be dropped
         //by ruleMaker let's clean messageList and give the effectors
         //order to reset theyre partnerList
         //Because we clean messageList the action of detect must be
         //repeated; also keepData must be redone because the ruleMaker
         //can modify some of the data in dataWarehouse.

         [effectorList forEach: M(resetPartnerList)];
         [self keepData];
         [self detect];

      }

   }

   [self matchRule];

//Following loop is intended to guarantee a match, if we haven't matches
//the most similar rule is asked to change the value of a non-wildkard
//allele, random chosen.

   if ([matchList getCount] == 0)
   {

      [self coverDetector];
      [self matchRule];

   }
//Having matches we can do an auction to select rules going to fire
//after that the rule have to pay some taxes.

   [self doAnAuction];
   [self collectTaxes];
   [self fire];

//The effectors try to match new messages, if some matches are done
//choose method will be going to select one of them. All the messages
//that match effectors are removed from the message list; remaining
//messages will be matched from rules in the next loop.

   [self matchEffector];

   if ([matchList getCount] == 0) [self coverEffector];

   [self choose];

//When a suggestion is made, the number of the action is returned to the
//agent and his value is stored into agent's dataWarehouse; note that is
//stored also the current bad answers counter.

   [dataWarehouse setActiveEffector: activeEffector];

TRACE5(printf("\n%8X RuleMaster - exit getAdviceAbout %d\n\n",
              (int) self,suggestion);)

   [interface setSuggestionMap: [activeEffector getBody]];
   return self;

}

//--------------------------------------------------------------------

- keepData
{

TRACE5(printf("\n%8X RuleMaster - entry keepData\n",(int) self);)

   // phase 0 - Housekeeping: asking the dataWarehouse about
   //           lists and objects


   classifierParm = [dataWarehouse  getClassifierParm];
   treasury       = [dataWarehouse  getTreasury];

   ruleList       = [dataWarehouse  getRuleList];
   effectorList   = [dataWarehouse  getEffectorList];
   messageList    = [dataWarehouse  getMessageList];
   matchList      = [dataWarehouse  getMatchList];
   winnerList     = [dataWarehouse  getWinnerList];
   workList       = [dataWarehouse  getWorkList];
   errorCounter   = [dataWarehouse  getErrorCounter];
   selAfterEvol   = [dataWarehouse  getSelAfterEvol];

   // then let's ask classifierParm for parameters

   geneLength     = [classifierParm getGeneLength];
   bidRatio       = [classifierParm getBidRatio];
   lBid1          = [classifierParm getLinearBid1];
   lBid2          = [classifierParm getLinearBid2];
   eLBid1         = [classifierParm getEffectiveLinearBid1];
   eLBid2         = [classifierParm getEffectiveLinearBid2];
   bidSigma       = [classifierParm getBidSigma];
   bidMu          = [classifierParm getBidMu];
   evolutionRate  = [classifierParm getEvolutionRate];
   confidence     = [classifierParm getConfidence];

TRACE5(printf("%8X RuleMaster - exit keepData %8X\n\n",
              (int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------
//Here we encode agent's information: for each event we can know that
//it is true or false or, may be, we don't know anything about it (#).
//encoding the information a new message is generated and put into the
//message list.
- detect
{

   char * string;
   Messag * message;

TRACE5(printf("\n%8X RuleMaster - entry detect\n",(int) self);)

   string = [interface getEventsMap];

   message = [Messag createBegin: [self getZone]];
   [message setText: &string[0]length: geneLength owner: treasury
               dump: dump];
   message = [message createEnd];

   [messageList addLast: message];

TRACE5(printf("%8X RuleMaster - exit detect %8X\n\n",
        (int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------

- matchRule
{

   int i,j,numberOfRules,numberOfMessages,match,totalMatches;
   double strength,worstStrength;
   Rule * rule;
   Messag * message;

TRACE5(printf("\n%8X RuleMaster - entry matchRule\n",(int) self);)

   //to store new matches a new match list is created after destroing
   //the old one

   [matchList removeAll];
   [shuffler shuffle: messageList];
   [shuffler shuffle: ruleList];

   numberOfRules    = [ruleList    getCount];
   numberOfMessages = [messageList getCount];
   worstStrength    = 100;

   for (i=0;i<numberOfRules;i++)
   {

      rule = [ruleList atOffset: i];
      [rule resetPartnerList];
      totalMatches = 0;

      for (j=0;j<numberOfMessages;j++)
      {

         message     = [messageList atOffset: j];

         match = [rule matchMessage: message];
         strength = [rule getStrength];

         if (match == geneLength) totalMatches++;

         if (strength < worstStrength)
         {

            worstStrength = strength;
            ruleWithBestMatch = rule;

         }

      }

      if (totalMatches > 0) [matchList addLast: rule];

   }

TRACE5(printf("%8X RuleMaster - exit matchRule %8X\n\n",
              (int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------

- coverDetector
{

   char * string;
   int i;

TRACE5(printf("\n%8X RuleMaster - entry coverDetector\n",(int) self);)

   [dataWarehouse addCoverDetector];
   i = [uniformIntRand getIntegerWithMin: 0 withMax:
        [messageList getCount]-1];

   string = [[messageList atOffset: i] getText];

   [ruleWithBestMatch modifyConditionTo: string];


TRACE5(printf("%8X RuleMaster - exit coverDetector %8X\n\n",
              (int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------

- coverEffector
{

   char * string;
   Effector * anEffector;
   int i;

TRACE5(printf("\n%8X RuleMaster - entry coverEffector\n",(int) self);)

   [dataWarehouse addCoverEffector];
   i = [uniformIntRand getIntegerWithMin: 0 withMax:
        [effectorList getCount]-1];

   anEffector = [effectorList atOffset: i];

   string = [anEffector getBody];

   [ruleWithBestAction modifyActionTo: string];
   [matchList addLast: anEffector];
   [anEffector setPartner: ruleWithBestAction];
   [messageList remove: bestMessage];
   [bestMessage drop];

TRACE5(printf("%8X RuleMaster - exit coverEffector %8X\n\n",
              (int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------

- matchEffector
{

   int i,j,numberOfEffectors,numberOfMessages,match,totalMatches;
   int numberOfMessageToRemove;
   double strength,worstStrength;
   Effector * effector;
   Messag * message;
   Rule   * rule;

TRACE5(printf("\n%8X RuleMaster - entry matchEffector\n",(int) self);)

   //to store new matches a new match list is created after destroing
   //the old one

   [matchList removeAll];
   [shuffler shuffle: messageList];
   [shuffler shuffle: effectorList];

   bestMatch = -1;
   worstStrength = 100;
   numberOfEffectors = [effectorList getCount];
   for (i=0;i<numberOfEffectors;i++)
   {

      effector = [effectorList atOffset: i];
      [effector resetPartnerList];
      totalMatches = 0;

      [workList removeAll];

      numberOfMessages = [messageList  getCount];
      for (j=0;j<numberOfMessages;j++)
      {

         message     = [messageList atOffset: j];
         rule        = [message getOwner];
         strength    = [rule getStrength];

         match = [effector matchMessage: message];

         if (strength < worstStrength)
         {

            bestMessage        = message;
            ruleWithBestAction = rule;
            worstStrength      = strength;

         }

         if (match >= geneLength)
         {

            totalMatches++;
            [workList addLast: message];

         }

      }

      if (totalMatches > 0) [matchList addLast: effector];

      numberOfMessageToRemove = [workList getCount];
      for(j=0;j<numberOfMessageToRemove;j++)
      {

         message = [workList atOffset: j];
         [messageList remove: message];
         [message drop];

      }

      [workList removeAll];

   }

TRACE5(printf("%8X RuleMaster - exit matchEffector %8X\n\n",
       (int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------

- doAnAuction
{

   Rule * rule;

   Rule * winner=nil;
   int    i,j,numberOfMatches,maxNumberOfMessages;
   double maxBid,ruleBid,sel,err;

TRACE5(printf("\n%8X RuleMaster - entry doAnAuction\n",(int) self);)

   numberOfMatches = [matchList getCount];

//First matching rules are asked to bid basing on the bid's parameters
//contained into the classifierParm.

   sel = (double) selAfterEvol + 1;
   err = (double) errorCounter + 1;
   if ((err/sel) < confidence) bidSigma = 0;

   for(i=0;i<numberOfMatches;i++)
   {

      rule = [matchList atOffset: i];
      [rule bidWithRatio: bidRatio lBid1: lBid1 lBid2: lBid2
              eLBid1: eLBid1  eLBid2: eLBid2 bidSigma: bidSigma
               bidMu: bidMu];

   }

   maxNumberOfMessages = [classifierParm getMaxNumberOfMessages];

   [winnerList removeAll];

//then several rules are chosen to fire accordingly with theyre
//bid value.

   do
   {

      maxBid = -1;
      for(j=0;j<numberOfMatches;j++)
      {

         rule = [matchList atOffset: j];
         ruleBid = [rule getEBid];
         if (ruleBid > maxBid)
         {

            maxBid = ruleBid;
            winner = rule;

         }

      }

      [winnerList addLast: winner];
      [matchList  remove:  winner];
      numberOfMatches--;
      maxNumberOfMessages--;

   } while ((maxNumberOfMessages > 0) && (numberOfMatches > 0));

TRACE5(printf("%8X RuleMaster - exit doAnAuction %8X\n\n",
              (int) self,(int) self);)

   return self;
}

//--------------------------------------------------------------------

- collectTaxes
{

   int i,numberOfRules;
   float  lifeTaxRate,bidTaxRate;
   Rule * rule;

TRACE5(printf("\n%8X RuleMaster - entry collectTaxes\n",(int) self);)

   lifeTaxRate   = [classifierParm getLifeTaxRate];
   bidTaxRate    = [classifierParm getBidTaxRate];

   // first let's collect lifeTax

   numberOfRules = [ruleList getCount];
   for (i=0;i<numberOfRules;i++)
   {

      rule = [ruleList atOffset: i];
      [rule payTaxOf: lifeTaxRate to: treasury];

   }

   // then matching rules have to pay bid tax, remember that the list
   // has been divided between match and winner

   numberOfRules = [matchList getCount];
   for (i=0;i<numberOfRules;i++)
   {

      rule = [matchList atOffset: i];
      [rule payTaxOf: bidTaxRate to: treasury];

   }

   numberOfRules = [winnerList getCount];
   for (i=0;i<numberOfRules;i++)
   {

      rule = [winnerList atOffset: i];
      [rule payTaxOf: bidTaxRate to: treasury];

   }

TRACE5(printf("%8X RuleMaster - exit collectTaxes %8X\n\n",
              (int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------

- fire
{

   int s;
   int i,numberOfWinners;
   Rule    * rule;
   char    * text;
   Messag * message;

TRACE5(printf("\n%8X RuleMaster - entry fire\n",(int) self);)

   s = [dataWarehouse getSelectionCounter];

   [messageList forEach: M(drop)];
   [messageList removeAll];

   numberOfWinners = [winnerList getCount];

   for (i=0;i<numberOfWinners;i++)
   {

      rule = [winnerList atOffset: i];
      text = [rule payAndFire];

      message = [Messag createBegin: [self getZone]];
      [message setText: text length: geneLength owner: rule
                  dump: dump];
      message = [message createEnd];

      [messageList addLast: message];

   }

TRACE5(printf("%8X RuleMaster - exit fire %8X\n\n",
              (int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------

- choose
{

   int i,numberOfMatches;
   double maxSupport=0,effectorSupport;
   Effector * effector;

TRACE5(printf("\n%8X RuleMaster - entry choose\n",(int) self);)

   suggestion      = -1;
   numberOfMatches = [matchList getCount];

   for (i=0;i<numberOfMatches;i++)
   {

      effector = [matchList atOffset: i];
      effectorSupport = [effector getSupport];
      if (effectorSupport > maxSupport)
      {

         maxSupport = effectorSupport;
         activeEffector = effector;

      }

      suggestion = [effector getSuggestion];

   }

TRACE5(printf("%8X RuleMaster - exit choose %8X\n\n",
              (int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------

- setReward: (double) rV to: (DataWarehouse *) dW
{

   Effector * effector;

TRACE5(printf("\n%8X RuleMaster - entry setReward: %f\n",(int) self,rV);)
TRACE5(printf("                                  for: %8X\n",(int) dW);)

   dataWarehouse = dW;

   treasury      = [dataWarehouse getTreasury];
   effector      = [dataWarehouse getActiveEffector];
   effectorList  = [dataWarehouse getEffectorList];

   if(rV == 0) [dataWarehouse addError];

   [treasury pay: rV];

   [effector payToPartners: (double) rV];

TRACE5(printf("%8X RuleMaster - exit setReward: %8X\n\n",
              (int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------
@end
