// DataWarehouse.h
//--------------------------------------------------------------------

#import <objectbase/SwarmObject.h>
#import <collections.h>
#import <random.h>
#import <math.h>
#import "Trace.h"
#import "Rule.h"
#import "Message.h"
#import "Effector.h"
#import "ClassifierParm.h"

//--------------------------------------------------------------------

@interface DataWarehouse: SwarmObject
{

   char             eyeCatcher[4];

   id <InFile>      ruleSet;
   ClassifierParm * classifierParm;
   Effector       * activeEffector;
   Treasury       * treasury;

   id ruleList,effectorList,messageList;
   id matchList,winnerList,workList;

   int selectionCounter,evolutionCounter,errorCounter,
       coverDetectorCounter,coverEffectorCounter,selAfterEvol;

   int numberOfRules,numberOfEffectors,geneLength,effectorsFlag;

   char work[512];

}

//--------------------------------------------------------------------

-          createEnd;

-          setClassifierParm:    (ClassifierParm *) pr;

-          setActiveEffector:    (Effector *) aE;

- (id)               getRuleList;
- (id)               getEffectorList;
- (id)               getMessageList;
- (id)               getMatchList;
- (id)               getWinnerList;
- (id)               getWorkList;
- (Treasury       *) getTreasury;
- (Effector       *) getActiveEffector;
- (ClassifierParm *) getClassifierParm;
- (int)              getErrorCounter;
- (int)              getSelectionCounter;
- (int)              getSelAfterEvol;

-          setAtRandom;
-          loadFromFile: (char *) rF;
-          addSelection;
-          addEvolution;
-          addError;
-          addCoverDetector;
-          addCoverEffector;
-          print;

//--------------------------------------------------------------------
@end
