// ClassifierParm.m
//--------------------------------------------------------------------

#import "ClassifierParm.h"

@implementation ClassifierParm

//--------------------------------------------------------------------

- createEnd
{

   id obj;

TRACE7(printf("\n%8X ClassifierParm - entry createEnd\n",(int) self);)

   eyeCatcher[0]='C';
   eyeCatcher[1]='P';
   eyeCatcher[2]='R';
   eyeCatcher[3]='M';

   //General parameters

   numberOfRules       = 32;
   numberOfEffectors   = 16;
   geneLength          = 4;
   maxNumberOfMessages =  1;
   effectorsFlag       =  0;
   wildCardRate        =  0.2;
   confidence          =  0.001;
   initialStrength     = 10.0;

   //Parameters to handle flow of strength

   bidTaxRate          = 0.1;
   lifeTaxRate         = 0.0;
   bidRatio            = 0.1;
   linearBid1          = 0.25;
   linearBid2          = 0.125;
   effectiveLinearBid1 = 0.25;
   effectiveLinearBid2 = 0.125;
   bidSigma            = 0.075;
   bidMu               = 0.0;

   //Parameters to handle genetic manipulation

   evolutionRate       = 0.2;
   turnoverRate        = 0.2;
   crossoverRate       = 1.0;
   mutationRate        = 0.02;
   crowdingRate        = 0.2;
   crowdingFactor      = 0.2;

   obj = [super createEnd];

TRACE7(printf("%8X ClassifierParm - exit createEnd %8X\n\n",
       (int) self,(int) obj);)

   return obj;

}

//--------------------------------------------------------------------

- (int)   getNumberOfRules
{

TRACE7(printf("\n%8X ClassifierParm - entry getNumberOfRules\n",(int) self);)
TRACE7(printf("%8X ClassifierParm - exit getNumberOfRules %d\n\n",
                 (int) self,numberOfRules);)

   return numberOfRules;

}

//--------------------------------------------------------------------

- (int)   getNumberOfEffectors
{

TRACE7(printf("\n%8X ClassifierParm - entry getNumberOfEffectors\n",
       (int) self);)
TRACE7(printf("%8X ClassifierParm - exit getNumberOfEffectors %d\n\n",
                 (int) self,numberOfEffectors);)

   return numberOfEffectors;

}

//--------------------------------------------------------------------

- (int)   getGeneLength
{

TRACE7(printf("\n%8X ClassifierParm - entry getGeneLength\n",
       (int) self);)
TRACE7(printf("%8X ClassifierParm - exit getGeneLength %d\n\n",
                 (int) self,geneLength);)

   return geneLength;

}

//--------------------------------------------------------------------

- (int)   getMaxNumberOfMessages
{

TRACE7(printf("\n%8X ClassifierParm - entry getMaxNumberOfMessages\n",
                 (int) self);)
TRACE7(printf("%8X ClassifierParm - exit getMaxNumberOfMessages %d\n\n",
                 (int) self,maxNumberOfMessages);)

   return maxNumberOfMessages;

}

//--------------------------------------------------------------------

- (int)   getEffectorsFlag
{

TRACE7(printf("\n%8X ClassifierParm - entry getEffectorsFlag\n",
                 (int) self);)
TRACE7(printf("%8X ClassifierParm - exit getEffectorsFlag %d\n\n",
                 (int) self,effectorsFlag);)

   return effectorsFlag;

}

//--------------------------------------------------------------------

- (float) getWildCardRate
{

TRACE7(printf("\n%8X ClassifierParm - entry getWildCardRate\n",(int) self);)
TRACE7(printf("%8X ClassifierParm - exit getWildCardRate %f\n\n",
              (int) self,wildCardRate);)

   return wildCardRate;

}

//--------------------------------------------------------------------

- (float) getConfidence
{

TRACE7(printf("\n%8X ClassifierParm - entry getConfidence\n",(int) self);)
TRACE7(printf("%8X ClassifierParm - entry getConfidence %f\n",
                 (int) self,confidence);)

   return confidence;

}

//--------------------------------------------------------------------

- (float) getInitialStrength
{

TRACE7(printf("\n%8X ClassifierParm - entry getInitialStrength\n",
       (int) self);)
TRACE7(printf("%8X ClassifierParm - entry getInitialStrength %f\n",
                 (int) self,initialStrength);)

   return initialStrength;

}

//--------------------------------------------------------------------

- (float) getBidTaxRate
{

TRACE7(printf("\n%8X ClassifierParm - entry getBidTaxRate\n",(int) self);)
TRACE7(printf("%8X ClassifierParm - exit getBidTaxRate %f\n\n",
              (int) self,bidTaxRate);)

   return bidTaxRate;

}

//--------------------------------------------------------------------

- (float) getLifeTaxRate
{

TRACE7(printf("\n%8X ClassifierParm - entry getLifeTaxRate\n",(int) self);)
TRACE7(printf("%8X ClassifierParm - exit getLifeTaxRate %f\n\n",
              (int) self,lifeTaxRate);)

   return lifeTaxRate;

}

//--------------------------------------------------------------------

- (float) getBidRatio
{

TRACE7(printf("\n%8X ClassifierParm - entry getBidRatio\n",(int) self);)
TRACE7(printf("%8X ClassifierParm - exit getBidRatio %f\n\n",
              (int) self,bidRatio);)

   return bidRatio;

}

//--------------------------------------------------------------------

- (float) getLinearBid1
{

TRACE7(printf("\n%8X ClassifierParm - entry getLinearBid1\n",(int) self);)
TRACE7(printf("%8X ClassifierParm - exit getLinearBid1 %f\n\n",
              (int) self,linearBid1);)

   return linearBid1;

}

//--------------------------------------------------------------------

- (float) getLinearBid2
{

TRACE7(printf("\n%8X ClassifierParm - entry getLinearBid2\n",(int) self);)
TRACE7(printf("%8X ClassifierParm - exit getLinearBid2 %f\n\n",
              (int) self,linearBid2);)

   return linearBid2;

}

//--------------------------------------------------------------------

- (float) getEffectiveLinearBid1
{

TRACE7(printf("\n%8X ClassifierParm - entry getEffectiveLinearBid1\n",
              (int) self);)
TRACE7(printf("%8X ClassifierParm - exit getEffectiveLinearBid1 %f\n\n",
              (int) self,effectiveLinearBid1);)

   return effectiveLinearBid1;

}

//--------------------------------------------------------------------

- (float) getEffectiveLinearBid2
{

TRACE7(printf("\n%8X ClassifierParm - entry getEffectiveLinearBid2\n",
              (int) self);)
TRACE7(printf("%8X ClassifierParm - exit getEffectiveLinearBid2 %f\n\n",
              (int) self,effectiveLinearBid2);)

   return effectiveLinearBid2;

}

//--------------------------------------------------------------------

- (float) getBidSigma
{

TRACE7(printf("\n%8X ClassifierParm - entry getBidSigma\n",(int) self);)
TRACE7(printf("%8X ClassifierParm - exit getBidSigma %f\n\n",
                 (int) self,bidSigma);)

   return bidSigma;

}

//--------------------------------------------------------------------

- (float) getBidMu
{

TRACE7(printf("\n%8X ClassifierParm - entry getBidMu\n",(int) self);)
TRACE7(printf("%8X ClassifierParm - entry getBidMu %f\n",
                 (int) self,bidMu);)

   return bidMu;

}

//--------------------------------------------------------------------

- (float) getEvolutionRate
{

TRACE7(printf("\n%8X ClassifierParm - entry getEvolutionRate\n",(int) self);)
TRACE7(printf("%8X ClassifierParm - entry getEvolutionRate %f\n",
                 (int) self,evolutionRate);)

   return evolutionRate;

}

//--------------------------------------------------------------------

- (float) getTurnoverRate
{

TRACE7(printf("\n%8X ClassifierParm - entry getTurnoverRate\n",(int) self);)
TRACE7(printf("%8X ClassifierParm - entry getTurnoverRate %f\n",
                 (int) self,turnoverRate);)

   return turnoverRate;

}

//--------------------------------------------------------------------

- (float) getCrossoverRate
{

TRACE7(printf("\n%8X ClassifierParm - entry getCrossoverRate\n",(int) self);)
TRACE7(printf("%8X ClassifierParm - entry getCrossoverRate %f\n",
                 (int) self,crossoverRate);)

   return crossoverRate;

}

//--------------------------------------------------------------------

- (float) getMutationRate
{

TRACE7(printf("\n%8X ClassifierParm - entry getMutationRate\n",(int) self);)
TRACE7(printf("%8X ClassifierParm - entry getMutationRate %f\n",
              (int) self,mutationRate);)

   return mutationRate;

}

//--------------------------------------------------------------------

- (float) getCrowdingRate
{

TRACE7(printf("\n%8X ClassifierParm - entry getCrowdingRate\n",(int) self);)
TRACE7(printf("%8X ClassifierParm - entry getCrowdingRate %f\n",
              (int) self,crowdingRate);)

   return crowdingRate;

}

//--------------------------------------------------------------------

- (float) getCrowdingFactor
{

TRACE7(printf("\n%8X ClassifierParm - entry getCrowdingFactor\n",
              (int) self);)
TRACE7(printf("%8X ClassifierParm - entry getCrowdingFactor %f\n",
              (int) self,crowdingFactor);)

   return crowdingFactor;

}

//--------------------------------------------------------------------

- setNumberOfRules: (int) nR
{

TRACE7(printf("\n%8X ClassifierParm - entry setNumberOfRules: %d\n",
              (int) self,nR);)

   numberOfRules = nR;

TRACE7(printf("%8X ClassifierParm - exit setNumberOfRules %8X\n\n",
                 (int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------

- setNumberOfEffectors: (int) nO
{

TRACE7(printf("\n%8X ClassifierParm - entry setNumberOfEffs: %d\n",
       (int) self,nO);)

   numberOfEffectors = nO;

TRACE7(printf("%8X ClassifierParm - exit setNumberOfEffs %8X\n\n",
                 (int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------

- setGeneLength: (int) gL
{

TRACE7(printf("\n%8X ClassifierParm - entry setGeneLength: %d\n",
       (int) self,gL);)

   geneLength = gL;

TRACE7(printf("%8X ClassifierParm - exit setGeneLength %8X\n\n",
                 (int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------

- setMaxNumberOfMessages: (int) mM
{

TRACE7(printf("\n%8X ClassifierParm - entry getMaxNumOfMessages %d\n",
                 (int) self,mM);)

   maxNumberOfMessages = mM;

TRACE7(printf("%8X ClassifierParm - exit getMaxNumOfMessages %8X\n\n",
                 (int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------

- setEffectorsFlag: (int) eF
{

TRACE7(printf("\n%8X ClassifierParm - entry setEffectorsFlag: %d\n",
                 (int) self,eF);)

   effectorsFlag = eF;

TRACE7(printf("%8X ClassifierParm - exit setEffectorsFlag %8X\n\n",
                 (int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------

- print
{

   printf("=====> Parameter set\n");

   printf("numberOfRules       = %d\n",numberOfRules);
   printf("numberOfEffectors   = %d\n",numberOfEffectors);
   printf("geneLength          = %d\n",geneLength);
   printf("maxNumberOfMessages = %d\n",maxNumberOfMessages);
   printf("effectorsFlag       = %d\n",effectorsFlag);
   printf("wildCardRate        = %f\n",wildCardRate);
   printf("confidence          = %f\n",confidence);
   printf("initialStrength     = %f\n",initialStrength);

   printf("bidTaxRate          = %f\n",bidTaxRate);
   printf("lifeTaxRate         = %f\n",lifeTaxRate);
   printf("bidRatio            = %f\n",bidRatio);
   printf("linearBid1          = %f\n",linearBid1);
   printf("linearBid2          = %f\n",linearBid2);
   printf("effectivelinearBid1 = %f\n",effectiveLinearBid1);
   printf("effectivelinearBid2 = %f\n",effectiveLinearBid2);
   printf("bidSigma            = %f\n",bidSigma);
   printf("bidMu               = %f\n",bidMu);

   printf("evolutionRate       = %f\n",evolutionRate);
   printf("turnoverRate        = %f\n",turnoverRate);
   printf("crossoverRate       = %f\n",crossoverRate);
   printf("mutationRate        = %f\n",mutationRate);
   printf("crowdingRate        = %f\n",crowdingRate);
   printf("crowdingFactor      = %f\n",crowdingFactor);

   return self;

}

//--------------------------------------------------------------------

- loadFromFile: (char *) pF
{

   float fV;
   int   iV;

TRACE7(printf("\n%8X ClassifierParm - entry loadFromFile: %8X\n",
              (int) self,(int) pF);)

   parmSet = [InFile create: [self getZone] withName: pF];
   if (parmSet == nil) {printf("P04 - Parm file not found\n");exit(0);}

   if (0 != [parmSet getInt:   &iV]) numberOfRules       = iV;
   if (0 != [parmSet getInt:   &iV]) numberOfEffectors   = iV;
   if (0 != [parmSet getInt:   &iV]) geneLength          = iV;
   if (0 != [parmSet getInt:   &iV]) maxNumberOfMessages = iV;
   if (0 != [parmSet getInt:   &iV]) effectorsFlag       = iV;
   if (0 != [parmSet getFloat: &fV]) wildCardRate        = fV;
   if (0 != [parmSet getFloat: &fV]) confidence          = fV;
   if (0 != [parmSet getFloat: &fV]) initialStrength     = fV;

   if (0 != [parmSet getFloat: &fV]) bidTaxRate          = fV;
   if (0 != [parmSet getFloat: &fV]) lifeTaxRate         = fV;
   if (0 != [parmSet getFloat: &fV]) bidRatio            = fV;
   if (0 != [parmSet getFloat: &fV]) linearBid1          = fV;
   if (0 != [parmSet getFloat: &fV]) linearBid2          = fV;
   if (0 != [parmSet getFloat: &fV]) effectiveLinearBid1 = fV;
   if (0 != [parmSet getFloat: &fV]) effectiveLinearBid2 = fV;
   if (0 != [parmSet getFloat: &fV]) bidSigma            = fV;
   if (0 != [parmSet getFloat: &fV]) bidMu               = fV;

   if (0 != [parmSet getFloat: &fV]) evolutionRate       = fV;
   if (0 != [parmSet getFloat: &fV]) turnoverRate        = fV;
   if (0 != [parmSet getFloat: &fV]) crossoverRate       = fV;
   if (0 != [parmSet getFloat: &fV]) mutationRate        = fV;
   if (0 != [parmSet getFloat: &fV]) crowdingRate        = fV;
   if (0 != [parmSet getFloat: &fV]) crowdingFactor      = fV;

   [parmSet drop];

TRACE7(printf("%8X ClassifierParm - exit loadFromFile %8X\n\n",
              (int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------
@end
