// RuleMaster.h
//--------------------------------------------------------------------

#import <objectbase/SwarmObject.h>
#import <collections.h>
#import <random.h>
#import "RuleMaker.h"
#import "DataWarehouse.h"
#import "Rule.h"
#import "Message.h"
#import "Effector.h"
#import "Trace.h"
#import "Dump.h"
#import "Shuffler.h"
#import "ClassifierParm.h"

//--------------------------------------------------------------------

@interface RuleMaster: SwarmObject
{
   char             eyeCatcher[4];
   id  ruleList,messageList,matchList,winnerList;
   id  effectorList,workList;
   RuleMaker      * ruleMaker;
   DataWarehouse  * dataWarehouse;
   id               interface;
   ClassifierParm * classifierParm;
   Treasury       * treasury;
   Dump           * dump;
   Shuffler       * shuffler;
   Rule           * ruleWithBestMatch;
   Rule           * ruleWithBestAction;
   Messag         * bestMessage;
   Effector       * highMatchEffector;
   Effector       * activeEffector;
   char * eventsMap;
   char * eventList;
   float bidRatio,lBid1,lBid2,eLBid1,eLBid2,bidSigma,bidMu,confidence;
   float evolutionRate;
   int geneLength,suggestion,bestMatch,errorCounter,selAfterEvol;
}

//--------------------------------------------------------------------

// public methods

-       createEnd;
-       setRuleMaker:     (RuleMaker *)  rM;
-       applyRuleTo: (DataWarehouse *) dW with: (id) it;
-       setReward: (double) rV to: (DataWarehouse *) dW;
-       setDump: (Dump *) du;
-       setShuffler: (Shuffler *) sh;

//--------------------------------------------------------------------
// internal usage methods

- keepData;
- detect;
- matchRule;
- coverDetector;
- matchEffector;
- coverEffector;
- doAnAuction;
- collectTaxes;
- fire;
- choose;

//--------------------------------------------------------------------
@end
