// RuleMaker.m
//--------------------------------------------------------------------

#import "RuleMaker.h"

@implementation RuleMaker

//--------------------------------------------------------------------

- createEnd
{

   id obj;

TRACE6(printf("\n%8X RuleMaker - entry createEnd\n",(int) self);)

   eyeCatcher[0]='R';
   eyeCatcher[1]='M';
   eyeCatcher[2]='K';
   eyeCatcher[3]='R';
   obj = [super createEnd];

TRACE6(printf("%8X RuleMaker - exit createEnd %8X\n\n",
              (int) self,(int) obj);)

   return obj;

}

//--------------------------------------------------------------------

- setDump: (Dump *) du
{

TRACE6(printf("\n%8X RuleMaker - entry setDump: %8X\n",
              (int) self,(int) du);)

   dump = du;

TRACE6(printf("%8X RuleMaker - exit setDump %8X\n\n",
              (int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------

- setShuffler: (Shuffler *) sh
{

TRACE6(printf("\n%8X RuleMaker - entry setShuffler: %8X\n",
              (int) self,(int) sh);)

   shuffler = sh;

TRACE6(printf("%8X RuleMaker - exit setShuffler %8X\n\n",
              (int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------

- evolveDataWarehouse: (DataWarehouse *) dW
{

   int i;
   double averageStrength;

TRACE6(printf("\n%8X RuleMaker - entry evolveDataWarehouse: %8X\n",
                 (int) self,(int) dW);)

   dataWarehouse = dW;

   [self keepData];

   for(i=0;i<couplesToSelect;i++)
   {

      child1  = [Rule createBegin: [self getZone]];
      child1  = [child1 createEnd];
      [child1 setDump: dump];

      child2  = [Rule createBegin: [self getZone]];
      child2  = [child2 createEnd];
      [child2 setDump: dump];

      do
      {

         parent1 = (Rule *) self;
         parent1 = [self selectBest];
         parent2 = [self selectBest];

         [self crossAndMutate];

      } while ([self verify] != 0);

      averageStrength = ([parent1 getStrength] +
                        [parent2 getStrength]   ) /2;

      [child1 setLength: geneLength];
      [child2 setLength: geneLength];
      [child1 setStrength: averageStrength];
      [child2 setStrength: averageStrength];
      [child1 setCondition: &work1[0]];
      [child1 setAction: &work1[geneLength]];
      [child2 setCondition: &work2[0]];
      [child2 setAction: &work2[geneLength]];

      [self removeWorstMatching: child1];
      [self removeWorstMatching: child2];

      [ruleList addLast: child1];
      numberOfRules++;

      [ruleList addLast: child2];
      numberOfRules++;

      totalStrength = totalStrength + averageStrength * 2;

   }



TRACE6(printf("%8X RuleMaker - exit evolveDataWarehouse: %8X\n\n",
              (int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------

- keepData
{

   int i;

TRACE6(printf("\n%8X RuleMaker - entry keepData\n",(int) self);)

   classifierParm   = [dataWarehouse getClassifierParm];
   treasury         = (id) [dataWarehouse getTreasury];

   ruleList         = [dataWarehouse getRuleList];
   messageList      = [dataWarehouse getMessageList];

   geneLength       = [classifierParm getGeneLength];
   effectorsFlag    = [classifierParm getEffectorsFlag];
   wildCardRate     = [classifierParm getWildCardRate];
   turnoverRate     = [classifierParm getTurnoverRate];
   crossoverRate    = [classifierParm getCrossoverRate];
   mutationRate     = [classifierParm getMutationRate];
   crowdingRate     = [classifierParm getCrowdingRate];
   crowdingFactor   = [classifierParm getCrowdingFactor];

   numberOfRules    = [ruleList getCount];
   numberOfMessages = [messageList getCount];

   totalStrength  = 0;
   for (i=0;i<numberOfRules;i++)
      totalStrength = totalStrength +
                      [[ruleList atOffset: i] getStrength];

   couplesToSelect = (numberOfRules*turnoverRate*0.5);
   if (couplesToSelect < 1) couplesToSelect = 1;

TRACE6(printf("%8X RuleMaker - exit keepData %8X\n\n",
              (int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------

- (Rule *) selectBest
{

   int i=0;
   double randomStrength,sumStrength=0,s=0;
   Rule * rule;

TRACE6(printf("\n%8X RuleMaker - entry selectBest\n",(int) self);)

   //rows 208 and 216
   //are been written to avoid self reproduction of the same rule
   //crossing with itself.

   if (parent1 != (Rule *) self) s = [parent1 getStrength];
   randomStrength =
      [uniformDblRand getDoubleWithMin: 0 withMax: totalStrength-s];

   [shuffler shuffle: ruleList];
   do
   {

      rule = [ruleList atOffset: i];
      if (rule != parent1)
         sumStrength = sumStrength + [rule getStrength];
      i++;

   } while (sumStrength < randomStrength);

TRACE6(printf("%8X RuleMaker - exit selectBest %8X\n",
               (int) self,(int) rule);)

   return rule;

}

//--------------------------------------------------------------------

- crossAndMutate
{

   int i,j,xC=0,xA=0;
   char * string1;
   char * string2;
   char * string3;
   char * string4;
   char  allele[4];
   char  mutantAllele[4];

TRACE6(printf("\n%8X RuleMaker - entry crossAndMutate\n",(int) self);)

   string1 = [parent1 getCondition];
   string2 = [parent2 getCondition];
   string3 = [parent1 getAction];
   string4 = [parent2 getAction];

   if ([uniformDblRand getDoubleWithMin: 0 withMax: 1]
       < crossoverRate)
   {

      xC = [uniformIntRand getIntegerWithMin: 1 withMax: geneLength];
      xA = [uniformIntRand getIntegerWithMin: 1 withMax: geneLength];

   }

   for(i=0;i<geneLength;i++)
   {

      allele[0] = mutantAllele[0] = string1[i];
      allele[1] = mutantAllele[1] = string2[i];
      allele[2] = mutantAllele[2] = string3[i];
      allele[3] = mutantAllele[3] = string4[i];

      for(j=0;j<4;j++)
      {

         if ([uniformDblRand getDoubleWithMin: 0 withMax: 1]
             < mutationRate)
         {

            mutantAllele[j] = '#';
            if (allele[j] == '#') mutantAllele[j] = '0';
            if (allele[j] == '0') mutantAllele[j] = '1';
            
         }

      }

      if (i<xC)
      {

         work1[i] = mutantAllele[1];
         work2[i] = mutantAllele[0];

      }
      else
      {

         work1[i] = mutantAllele[0];
         work2[i] = mutantAllele[1];

      }

      if (effectorsFlag == 0)
      {

         if (i<xA)
         {

            work1[i+geneLength] = mutantAllele[3];
            work2[i+geneLength] = mutantAllele[2];

         }
         else
         {

            work1[i+geneLength] = mutantAllele[2];
            work2[i+geneLength] = mutantAllele[3];

         }

      }

   }

   if (effectorsFlag == 1)
   {

      for(i=0;i<geneLength;i++)
      {

         work1[i+geneLength] = string4[i];
         work2[i+geneLength] = string3[i];

      }

   }

TRACE6(printf("%8X RuleMaker - exit crossAndMutate %8X\n\n",
              (int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------

- removeWorstMatching: (Rule *) ch
{

   int i,j,k,cR,cF,maxMatch=-1,match;
   double worstStrength,aRuleStrength;
   Rule * aRule;
   Messag * message;
   Rule * worstRule;
   Rule * worstAndSimilarRule=nil;
   char * childCondition;
   char * childAction;
   char * worstCondition;
   char * worstAction=(char *)' ';

TRACE6(printf("\n%8X RuleMaker - entry removeWorstMatching: %8X\n",
              (int) self,(int) ch);)

   childCondition = [ch getCondition];
   childAction    = [ch getAction];

   cF = numberOfRules * crowdingFactor;
   cR = numberOfRules * crowdingRate;
   if (cF < 1) cF = 1;
   if (cR < 1) cR = 1;

   for(i=0;i<cF;i++)
   {

      j=[uniformIntRand getIntegerWithMin: 0 withMax: numberOfRules-1];
      worstRule     = [ruleList atOffset: j];
      worstStrength = [worstRule getStrength];

      for(k=0;k<cR;k++)
      {

         j =
        [uniformIntRand getIntegerWithMin: 0 withMax: numberOfRules-1];
         aRule         = [ruleList atOffset: j];
         aRuleStrength = [aRule getStrength];

         if (aRuleStrength < worstStrength)
         {

            worstRule     = aRule;
            worstStrength = aRuleStrength;

         }

      }

      worstCondition = [worstRule getCondition];
      worstAction    = [worstRule getAction];

      match = 0;
      for(j=0;j<geneLength;j++)
      {

         if (worstCondition[j] == childCondition[j]) match++;
         if (worstAction[j]    == childAction[j])    match++;

      }

      if (match > maxMatch)
      {

         worstAndSimilarRule = worstRule;
         maxMatch            = match;

      }

   }

   totalStrength = totalStrength -
                   [worstAndSimilarRule getStrength];

   [ruleList remove: worstAndSimilarRule];

   if (effectorsFlag == 1)
   {

      worstAction = [worstAndSimilarRule getAction];
      for(j=0;j<geneLength;j++) childAction[j] = worstAction[j];

   }

//If we are dropping a Rule that have an own message in current
//messageList we change the owner of the message to avoid storage
//violation if an other rule, matching this messages, will try to
//pay it's owner. If the rule has been dropped her reward will be
//cached by treasury.

   for(i=0;i<numberOfMessages;i++)
   {

      message = [messageList atOffset: i];
      if ([message getOwner] == (id) worstAndSimilarRule)
         [message setOwner: treasury];

   }

   [worstAndSimilarRule drop];
   numberOfRules--;

TRACE6(printf("%8X RuleMaker - exit removeWorstMatching %8X\n\n",
              (int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------

- (int) verify
{

   int i,j,match1=0,match2;
   Rule * aRule;
   char * condition;
   char * action;

TRACE6(printf("\n%8X RuleMaker - entry verify\n",
              (int) self);)

   for (i=0;i<geneLength*2;i++) if(work1[i] == work2[i]) match1++;
   if (match1 == geneLength*2)
   {

TRACE6(printf("%8X RuleMaker - exit verify 8\n\n",
              (int) self);)
      return 8;

   }

   for(i=0;i<numberOfRules;i++)
   {

      aRule = [ruleList atOffset: i];
      condition = [aRule getCondition];
      action    = [aRule getAction];
      match1 = match2 = 0;

      for (j=0;j<geneLength;j++)
      {

         if(work1[j] == condition[j]) match1++;
         if(work2[j] == condition[j]) match2++;
         if(work1[j+geneLength] == action[j]) match1++;
         if(work2[j+geneLength] == action[j]) match2++;

      }

      if ((match1 == geneLength*2) || (match2 == geneLength*2))
      {

TRACE6(printf("%8X RuleMaker - exit verify 4\n\n",
              (int) self);)
         return 4;

      }

   }

TRACE6(printf("%8X RuleMaker - exit verify 0\n\n",
              (int) self);)

   return 0;

}

//--------------------------------------------------------------------
@end
