// RuleMaker.h
//--------------------------------------------------------------------

#import <objectbase/SwarmObject.h>
#import <collections.h>
#import <random.h>
#import "Trace.h"
#import "Dump.h"
#import "Shuffler.h"
#import "DataWarehouse.h"
#import "ClassifierParm.h"
#import "Rule.h"
#import "Message.h"

@interface RuleMaker: SwarmObject

//--------------------------------------------------------------------

{

   char             eyeCatcher[4];
   DataWarehouse  * dataWarehouse;
   ClassifierParm * classifierParm;
   Dump           * dump;
   Shuffler       * shuffler;
   id ruleList,messageList,treasury;
   int geneLength,numberOfRules,couplesToSelect,effectorsFlag,
       numberOfMessages;
   float wildCardRate,turnoverRate,crossoverRate,mutationRate,
         crowdingRate,crowdingFactor;
   double totalStrength;
   char   work1[512];
   char   work2[512];
   Rule * parent1;
   Rule * parent2;
   Rule * child1;
   Rule * child2;

}

//--------------------------------------------------------------------

// public methods

- createEnd;
- evolveDataWarehouse:  (DataWarehouse *) dW;
- setDump:  (Dump *) du;
- setShuffler:  (Shuffler *) sh;

//--------------------------------------------------------------------

// internal usage methods

- keepData;
- (Rule *) selectBest;
- removeWorstMatching: (Rule *) ch;
- crossAndMutate;
- (int) verify;

//--------------------------------------------------------------------
@end
