// Rule.m
//-------------------------------------------------------------------

#import"Rule.h"

@implementation Rule

//-------------------------------------------------------------------

- createEnd
{

   id obj;

TRACE8 (printf("\n%8X Rule - entry createEnd\n",(int) self);)

   eyeCatcher[0]= 'R';
   eyeCatcher[1]= 'U';
   eyeCatcher[2]= 'L';
   eyeCatcher[3]= 'E';
   partnerList  = [List create: [self getZone]];

   obj = [super createEnd];

TRACE8 (printf("%8X Rule - exit createEnd %8X\n\n",
               (int) self,(int) obj);)

   return obj;

}

//-------------------------------------------------------------------

- (void) drop
{

TRACE8 (printf("\n%8X Rule - entry drop\n",(int) self);)

   [partnerList drop];

TRACE8 (printf("%8X Rule - exit drop\n\n",(int) self);)

   [super drop];

   return;

}

//-------------------------------------------------------------------

- setCondition: (char *) aS
{

   int i;

TRACE8 (printf("\n%8X Rule - entry setCondition: %8X\n",
               (int) self,(int) aS);)
TRACE8 ([dump dumpFromAddress: (id) aS forLength: length];)

   specificity = 0;

   for(i=0;i<length;i++)
   {

      condition[i] = aS[i];
      if (aS[i] != '#') specificity ++;

   }

TRACE8 (printf("%8X Rule - exit setCondition %8X\n\n",
               (int) self,(int) self);)

   return self;

}

//-------------------------------------------------------------------

- setAction: (char *) aS
{

   int i;

TRACE8 (printf("\n%8X Rule - entry setAction: %8X\n",
               (int) self,(int) aS);)
TRACE8 ([dump dumpFromAddress: (id) aS forLength: length];)

   for(i=0;i<length;i++)
   {

      action[i] = aS[i];
      if (aS[i] != '#') specificity ++;

   }

   specificity = specificity / (length * 2);

TRACE8 (printf("%8X Rule - exit setCondition %8X\n\n",
               (int) self,(int) self);)

   return self;

}

//-------------------------------------------------------------------

- setLength: (int) ll
{

TRACE8 (printf("\n%8X Rule - entry setLength: %d\n",(int) self,ll);)

   length      = ll;

TRACE8 (printf("%8X Rule - exit setLength %8X\n\n",
               (int) self,(int) self);)

   return self;

}

//-------------------------------------------------------------------

- setStrength: (double) ss
{

//   int i;

TRACE8 (printf("\n%8X Rule - entry setStrength: %f\n",(int) self,ss);)

   strength = ss;

TRACE8 (printf("%8X Rule - exit setStrength %8X\n\n",
               (int) self,(int) self);)

   return self;

}

//-------------------------------------------------------------------

- setDump: (Dump *) du
{

TRACE8 (printf("\n%8X Rule - entry setDump: %8X\n",
               (int) self,(int) du);)

   dump = du;

TRACE8 (printf("%8X Rule - exit setDump %8X\n\n",
               (int) self,(int) self);)

   return self;

}

//-------------------------------------------------------------------

- (char *) getCondition
{

TRACE8 (printf("\n%8X Rule - entry getCondition\n",(int) self);)
TRACE8 (printf("%8X Rule - exit getCondition %8X\n\n",
                  (int) self,(int) &condition[0]);)

   return &condition[0];

}

//-------------------------------------------------------------------

- (char *) getAction
{

TRACE8 (printf("\n%8X Rule - entry getAction\n",(int) self);)
TRACE8 (printf("%8X Rule - exit getAction %8X\n\n",
               (int) self,(int) &action[0]);)

   return &action[0];

}

//-------------------------------------------------------------------

- (double) getStrength
{

TRACE8 (printf("\n%8X Rule - entry getStrength\n",(int) self);)
TRACE8 (printf("%8X Rule - exit getStrength %f\n\n",
               (int) self,strength);)

   return strength;

}

//-------------------------------------------------------------------

- (double) getEBid
{

TRACE8 (printf("\n%8X Rule - entry getEBid\n",(int) self);)
TRACE8 (printf("%8X Rule - exit getEBid %f\n\n",(int) self,eBid);)

   return eBid;

}

//-------------------------------------------------------------------

- (int) matchMessage: (Messag *) me
{

   int i=-1;
   int match=0;
   char * string;

TRACE8 (printf("\n%8X Rule - matchMessage: %8X\n",(int) self,(int) me);)

   string = [me getText];

   for(i=0;i<length;i++) if((condition[i] == '#') ||
                            (string[i]    == '#'  ) ||
                            (condition[i] == string[i])) match++;

   if (match == length) [partnerList addLast: [me getOwner]];

TRACE8 (printf("%8X Rule - exit getMatchMessage %d\n\n",(int) self,match);)

   return match;

}

//-------------------------------------------------------------------

- resetPartnerList
{

TRACE8 (printf("\n%8X Rule - entry resetPartnerList\n",(int) self);)

   [partnerList removeAll];

TRACE8 (printf("%8X Rule - exit resetPartnerList %8X\n\n",
               (int) self,(int) self);)

   return self;

}

//-------------------------------------------------------------------

- modifyConditionTo: (char *) aS
{

   int i;

TRACE8 (printf("\n%8X Rule - entry modifyConditionTo: %8X\n",
               (int) self,(int) aS);)

   for(i=0;i<length;i++)
      if(condition[i] != '#') condition[i] = aS[i];

TRACE8 (printf("%8X Rule - exit modifyCondition %8X\n\n",
               (int) self,(int) self);)

   return self;

}

//-------------------------------------------------------------------

- modifyActionTo: (char *) aS
{

   int i;

TRACE8 (printf("\n%8X Rule - entry modifyActionTo: %8X\n",
               (int) self,(int) aS);)

   for(i=0;i<length;i++)
      if(action[i] != '#') action[i] = aS[i];

TRACE8 (printf("%8X Rule - exit modifyAction %8X\n\n",
               (int) self,(int) self);)

   return self;

}

//-------------------------------------------------------------------

- bidWithRatio: (float) bR  lBid1: (float) l1 lBid2:    (float) l2
        eLBid1: (float) e1 eLBid2: (float) e2 bidSigma: (float) bS
         bidMu: (float) bM
{

TRACE8 (printf("\n%8X Rule - entry bidWithRatio: %f\n",(int) self,bR);)
TRACE8 (printf("                             lbid1: %f\n",l1);)
TRACE8 (printf("                             lbid2: %f\n",l2);)
TRACE8 (printf("                            eLbid1: %f\n",e1);)
TRACE8 (printf("                            eLbid1: %f\n",e2);)
TRACE8 (printf("                          bidSigma: %f\n",bS);)
TRACE8 (printf("                             bidMu: %f\n",bM);)

   bid  = bR * (l1 + l2 * specificity) * strength;

   eBid = bR * (e1 + e2 * specificity) * strength +
          [uniformDblRand getDoubleWithMin: 0 withMax: 1] * bS + bM;

TRACE8 (printf("%8X Rule - exit bidWithRatio %8X\n\n",
               (int) self,(int) self);)

   return self;

}

//-------------------------------------------------------------------

- payTaxOf: (float) tR to: (Treasury *) tr
{

   double tax;
TRACE8 (printf("\n%8X Rule - entry payTaxOf: %f\n",(int) self,tR);)
TRACE8 (printf("                            to: %8X\n",(int) tr);)

   tax      = strength * tR;
   strength = strength - tax;

   [tr cash: tax];

TRACE8 (printf("%8X Rule - exit payTaxOf %8X\n\n",(int) self,(int) self);)

   return self;

}


//-------------------------------------------------------------------

- (char *) payAndFire
{

   int    i,numberOfPartners;
   double amount;

TRACE8 (printf("\n%8X Rule - entry payAndFire\n",(int) self);)

   numberOfPartners = [partnerList getCount];
   amount           = bid / numberOfPartners;

   for(i=0;i<numberOfPartners;i++)
      [[partnerList atOffset: i] cash: amount];

   strength = strength - bid;

TRACE8 (printf("%8X Rule - exit payAndFire %8X\n\n",
               (int) self,(int) &action[0]);)

   return &action[0];

}

//-------------------------------------------------------------------

- cash: (double) rw
{

TRACE8 (printf("\n%8X Rule - entry cash: %f\n",(int) self,rw);)

   strength = strength + rw;

TRACE8 (printf("%8X Rule - exit cash %8X\n\n",(int) self,(int) self);)

   return self;

}

//-------------------------------------------------------------------

- print
{

   int i,j;
       
   printf("%8X strength: %f specificity %f\n",
          (int) self,strength,specificity);

   for(i=0;i<length;i++) printf("%c",condition[i]);
   printf("\n");
   for(i=0;i<length;i++) printf("%c",action[i]);
   printf("\n");

   j = [partnerList getCount];
   printf("My partnerList contains %d entries for:\n",j);
   for(i=0;i<j;i++) printf("%8X\n",(int) [partnerList atOffset: i]);

   return self;

}

//-------------------------------------------------------------------
@end
