// DataWarehouse.m
//--------------------------------------------------------------------

#import "DataWarehouse.h"

@implementation DataWarehouse

//--------------------------------------------------------------------

- createEnd
{

   id     obj;

TRACE4 (printf("\n%8X DataWarehouse - entry createEnd\n",(int) self);)

   eyeCatcher[0]    = 'D';
   eyeCatcher[1]    = 'W';
   eyeCatcher[2]    = 'H';
   eyeCatcher[3]    = 'S';

   errorCounter     = 0;
   selectionCounter = 0;
   evolutionCounter = 0;
   coverDetectorCounter = 0;
   coverEffectorCounter = 0;
   selAfterEvol = 0;

   numberOfRules     = [classifierParm getNumberOfRules];
   numberOfEffectors = [classifierParm getNumberOfEffectors];
   geneLength        = [classifierParm getGeneLength];
   effectorsFlag     = [classifierParm getEffectorsFlag];

   ruleList         = [List create: [self getZone]];
   effectorList     = [List create: [self getZone]];
   messageList      = [List create: [self getZone]];
   matchList        = [List create: [self getZone]];
   winnerList       = [List create: [self getZone]];
   workList         = [List create: [self getZone]];

   treasury         = [Treasury createBegin: [self getZone]];
   treasury         = [treasury createEnd];

   obj              = [super createEnd];

TRACE4 (printf("%8X DataWarehouse exit - createEnd %8X\n\n",
                 (int) self,(int) obj);)

   return obj;

}

//--------------------------------------------------------------------

- setClassifierParm: (ClassifierParm *) pr
{

TRACE4(printf("\n%8X DataWareHouse - entry setClassifierParm: %8X\n",
              (int) self,(int) pr);)

   classifierParm = pr;

TRACE4(printf("%8X DataWareHouse - exit setClassifierParm %8X\n\n",
              (int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------

- setActiveEffector: (Effector *) aE;
{

TRACE4(printf("\n%8X DataWareHouse - entry setActiveEffector: %8X\n",
              (int) self,(int) aE);)

   activeEffector = aE;

TRACE4(printf("%8X DataWareHouse - exit setActiveEffector %8X\n\n",
              (int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------

- (id) getRuleList
{

TRACE4(printf("\n%8X DataWareHouse - entry getRuleList\n",(int) self);)
TRACE4(printf("%8X DataWareHouse - exit getRuleList %8X\n\n",
              (int) self,(int) ruleList);)

   return ruleList;

}

//--------------------------------------------------------------------

- (id) getEffectorList
{

TRACE4(printf("\n%8X DataWareHouse - entry getEffectorList\n",(int) self);)
TRACE4(printf("%8X DataWareHouse - exit getEffectorList %8X\n\n",
              (int) self,(int) effectorList);)

   return effectorList;

}

//--------------------------------------------------------------------

- (id) getMessageList
{

TRACE4(printf("\n%8X DataWareHouse - entry getMessageList\n",(int) self);)
TRACE4(printf("%8X DataWareHouse - exit getMessageList %8X\n\n",
              (int) self,(int) messageList);)

   return messageList;

}

//--------------------------------------------------------------------

- (id) getMatchList
{

TRACE4(printf("\n%8X DataWareHouse - entry getMatchList\n",(int) self);)
TRACE4(printf("%8X DataWareHouse - exit getMatchList %8X\n\n",
              (int) self,(int) matchList);)


   return matchList;

}

//--------------------------------------------------------------------

- (id) getWinnerList
{

TRACE4(printf("\n%8X DataWareHouse - entry getWinnerList\n",(int) self);)
TRACE4(printf("%8X DataWareHouse - exit getWinnerList %8X\n\n",
              (int) self,(int) winnerList);)

   return winnerList;

}

//--------------------------------------------------------------------

- (id) getWorkList
{

TRACE4(printf("\n%8X DataWareHouse - entry getWorkList\n",(int) self);)
TRACE4(printf("%8X DataWareHouse - exit getWorkList %8X\n\n",
              (int) self,(int) workList);)

   return workList;

}

//--------------------------------------------------------------------

- (Treasury *) getTreasury
{

TRACE4(printf("\n%8X DataWareHouse - entry getTreasury\n",(int) self);)
TRACE4(printf("%8X DataWareHouse - exit getTreasury %8X\n\n",
              (int) self,(int) treasury);)

   return treasury;

}

//--------------------------------------------------------------------

- (Effector *) getActiveEffector
{

TRACE4(printf("\n%8X DataWareHouse - entry getActiveEffector\n",(int) self);)
TRACE4(printf("%8X DataWareHouse - exit getActiveEffector %8X\n\n",
              (int) self,(int) activeEffector);)

   return activeEffector;

}

//--------------------------------------------------------------------

- (ClassifierParm *) getClassifierParm
{

TRACE4(printf("\n%8X DataWareHouse - entry getClassifierParm\n",
              (int) self);)
TRACE4(printf("%8X DataWareHouse - exit getClassifierParm %8X\n\n",
              (int) self,(int) classifierParm);)

   return classifierParm;

}

//--------------------------------------------------------------------

- (int) getErrorCounter
{

TRACE4(printf("\n%8X DataWareHouse - entry getErrorCounter\n",(int) self);)
TRACE4(printf("%8X DataWareHouse - exit getErrorCounter %d\n\n",
              (int) self,errorCounter);)

   return  errorCounter;

}

//--------------------------------------------------------------------

- (int) getSelectionCounter;
{

TRACE4(printf("\n%8X DataWareHouse - entry getSelectionCounter\n",
              (int) self);)
TRACE4(printf("%8X DataWareHouse - exit getSelectionCounter %d\n\n",
              (int) self,selectionCounter);)

   return  selectionCounter;

}

//--------------------------------------------------------------------

- (int) getSelAfterEvol;
{

TRACE4(printf("\n%8X DataWareHouse - entry getSelAfterEvol\n",
              (int) self);)
TRACE4(printf("%8X DataWareHouse - exit getSelAfterEvol %d\n\n",
              (int) self,selAfterEvol);)

   return  selAfterEvol;

}

//--------------------------------------------------------------------
//Here we create lot of rules and a set of effector. Each rule own
//two geni: a condition set at random and an action part that can
//also be set at random other with the same value of a condition part
//of an effector picked at random.
//Effectors have an action part and a suggestion; action part is made
//translating the suggestion (is a number) in binary form.

- setAtRandom
{

   Rule     * aRule;
   Effector * anEffector;
   char     * string;
   float      w1,w2,w3,wildCardRate,initialStrength;
   int        i,j,k=-1,m;

TRACE4 (printf("\n%8X DataWarehouse - entry setAtRandom\n",(int) self);)

   wildCardRate      = [classifierParm getWildCardRate];
   initialStrength   = [classifierParm getInitialStrength];

   // effectors

   for(i=0;i<numberOfEffectors;i++)
   {

      w1 = (double) i;
      w2 = (double) geneLength;

      for(j=0;j<geneLength;j++)
      {

         w2--;
         w3 = pow(2,w2);
         if (w1 >= w3) {work[j] = '1';w1 = w1 - w3;}
         else work[j] = '0';

      }

      anEffector = [Effector createBegin: [self getZone]];
      [anEffector setLength: geneLength];
      [anEffector setBody: &work[0]];
      [anEffector setSuggestion: i];
      anEffector = [anEffector createEnd];

      [effectorList addLast: anEffector];

   }

   // rules

   if(effectorsFlag == 1) m = geneLength;
   else m = geneLength*2;

   for(i=0;i<numberOfRules;i++)
   {

      for(j=0;j<m;j++)
      {

         work[j] = '0';
         if ([uniformIntRand getIntegerWithMin: 0 withMax: 1] == 1)
            work[j] = '1';

         if ([uniformDblRand getDoubleWithMin: 0 withMax: 1] <
             wildCardRate) work[j] = '#';

      }

      if (effectorsFlag == 1)
      {

         k++;
         if (k >= numberOfEffectors) k = 0;
         anEffector = [effectorList atOffset: k];
         string     = [anEffector getBody];

         for(j=0;j<geneLength;j++) work[j+geneLength] = string[j];

      }

      aRule = [Rule createBegin: [self getZone]];
      [aRule setLength: geneLength];
      [aRule setCondition: &work[0]];
      [aRule setAction: &work[geneLength]];
      [aRule setStrength: initialStrength];
      aRule = [aRule createEnd];

      [ruleList addLast: aRule];

   }

TRACE4 (printf("%8X DataWarehouse exit - setAtRandom %8X\n\n",
                  (int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------

- loadFromFile: (char *) rF
{

   double   dV;
   float    fV;
   int      iV,i,j;
   char     cV;
   Rule *   rule;
   Effector * effector;

TRACE4(printf("\n%8X DataWarehouse - entry loadFromFile: %8X\n",
              (int) self,(int) rF);)

   ruleSet = [InFile create: [self getZone] withName: rF];
   if (ruleSet == nil) {printf("D04 - Rule file not found\n");exit(0);}

   for(i=0;i<numberOfRules;i++)
   {

      for(j=0;j<geneLength*2;j++)
      {

         [ruleSet getChar: &cV];
         work[j] = cV;

      }

      [ruleSet getFloat: &fV];
      [ruleSet getChar: &cV];
      dV   = fV;

      rule = [Rule createBegin: [self getZone]];
      [rule setLength: geneLength];
      [rule setCondition: &work[0]];
      [rule setAction: &work[geneLength]];
      [rule setStrength: dV];
      rule = [rule createEnd];

      [ruleList addLast: rule];

   }

   for(i=0;i<numberOfEffectors;i++)
   {

      for(j=0;j<geneLength;j++)
      {

         [ruleSet getChar: &cV];
         work[j] = cV;

      }

      [ruleSet getInt: &iV];
      [ruleSet getChar: &cV];

      effector = [Effector createBegin: [self getZone]];
      [effector setLength: geneLength];
      [effector setBody: &work[0]];
      [effector setSuggestion: i];
      effector = [effector createEnd];

      [effectorList addLast: effector];

   }

   [ruleSet drop];


TRACE4(printf("%8X ClassifierParm - exit loadFromFile %8X\n\n",
              (int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------

- addSelection
{

TRACE4(printf("\n%8X DataWareHouse - entry addSelection\n",(int) self);)

   selectionCounter++;
   selAfterEvol++;

TRACE4(printf("%8X DataWareHouse - exit addSelection %8X\n\n",
              (int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------

- addEvolution
{

TRACE4(printf("\n%8X DataWareHouse - entry addEvolution\n",(int) self);)

   evolutionCounter++;
   errorCounter = 0;
   selAfterEvol = 0;

TRACE4(printf("%8X DataWareHouse - exit addEvolution %8X\n\n",
              (int) self,(int) self);)

   return self;

}

//--------------------------------------------------------------------

-  addError;
{

TRACE4(printf("\n%8X DataWareHouse - entry addError\n",
              (int) self);)

   errorCounter++;

TRACE4(printf("%8X DataWareHouse - exit addError %8X\n\n",
              (int) self,(int) self);)

   return  self;

}

//--------------------------------------------------------------------

-  addCoverDetector;
{

TRACE4(printf("\n%8X DataWareHouse - entry addCoverDetector\n",
              (int) self);)

   coverDetectorCounter++;

TRACE4(printf("%8X DataWareHouse - exit addCoverDetector %8X\n\n",
              (int) self,(int) self);)

   return  self;

}

//--------------------------------------------------------------------

-  addCoverEffector;
{

TRACE4(printf("\n%8X DataWareHouse - entry addCoverEffector\n",
              (int) self);)

   coverEffectorCounter++;

TRACE4(printf("%8X DataWareHouse - exit addCoverEffector %8X\n\n",
              (int) self,(int) self);)

   return  self;

}

//--------------------------------------------------------------------

- print
{

   printf("\n%8X - DataWarehouse cointains following data:\n",(int) self);

   printf("%8X - RuleList contains %d rules:\n",
          (int) ruleList,[ruleList getCount]);
   [ruleList forEach: M(print)];
   printf("\n");

   printf("%8X - EffectorList contains %d effectors:\n",
          (int) effectorList,[effectorList getCount]);
   [effectorList forEach: M(print)];
   printf("\n");

   printf("%8X - MessageList contains %d messages:\n",
          (int) messageList,[messageList getCount]);
   [messageList forEach: M(print)];
   printf("\n");

   printf("%8X - MatchList contains %d rules:\n",
          (int) matchList,[matchList getCount]);
   [matchList forEach: M(print)];
   printf("\n");

   printf("%8X - WinnerList contains %d rules:\n",
          (int) winnerList,[winnerList getCount]);
   [winnerList forEach: M(print)];
   printf("\n");

   printf("%8X - WorkList contains %d rules:\n",
          (int) workList,[workList getCount]);
   [workList forEach: M(print)];
   printf("\n");

   printf("%8X - Treasury balance:\n",(int) treasury);
   [treasury print];
   printf("\n");

   printf("current active effector is: \n");
   [activeEffector print];
   printf("\n");

   printf("Statistics:\n");
   printf("Rule's selection has been performed %d times\n",
          selectionCounter);
   printf("CoverDetector has been applied %d times\n",
          coverDetectorCounter);
   printf("CoverEffector has been applied %d times\n",
          coverEffectorCounter);
   printf("Rule's genetic evolution has been performed %d times\n",
          evolutionCounter);

   return self;

}

//--------------------------------------------------------------------
@end
