// Adapted from Heatbugs, which has Copyright (C) 1996-1999 Santa Fe Institute.
// This adaptation is copyright 1999 Paul E. Johnson.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

#import "BatchSwarm.h"
#import "ModelSwarm.h"
#import <simtools.h> // ObjectLoader
#import <analysis.h> // EZGraph
#import <gui.h>
#import <collections.h>
#import "Citizen.h"

#include <misc.h> // printf

@implementation BatchSwarm


+ createBegin:  aZone 
{
  BatchSwarm *obj;

  // Superclass createBegin to allocate ourselves.
  obj = [super createBegin: aZone];

  // Fill in the relevant parameters.
  obj->loggingFrequency = 1;
  obj->experimentDuration = 3000;

  return obj;
}

- buildObjects
{
  int i;
 

 [super buildObjects];

  modelSwarm = [ModelSwarm create: self];

  [modelSwarm buildObjects];
  [ModelSwarm setObserver: self];
  
  deadSteps=0;

  batchColormap = [BatchColormap create: self];

  // Colours [0,64) are assigned to the range Red [0, 1), for heat display.

  for (i = 0; i < 64; i++)
    [batchColormap setColor: i ToRed: (double)i / 63.0 Green: 0 Blue: 0];

  // Colour 64 is set to green, to display heatbugs

  [batchColormap setColor: 64 ToName: "green"];

  // Colour 65 is set to white, used in this case below on probed heatbug.

  [batchColormap setColor: 65 ToName: "white"];

  for(i=66; i < 166; i++)
    [batchColormap setColor: i  ToRed: 0  Green: (double)(i-66) / 100.0 Blue: 0.4];


  [batchColormap setColor: 255 ToRed: 1 Green: 1 Blue: 0];
  // Now go in to the heatbugs in the model and set their colours to green (64)

  rasterList= [List create: self];
  featureDisplayList = [List create: self];

  //printf("Citizen says num features is %d \n \n",[Citizen getNumFeatures]);

 for(i=0; i<[Citizen getNumFeatures] ; i++)
 {
  char rasterName[20];

  sprintf(rasterName,"feature%02d",i);
    worldRaster = [BatchRaster createBegin: self];
    worldRaster = [worldRaster createEnd];
    [worldRaster setColormap: batchColormap];
 
    [worldRaster setWidth: [[modelSwarm getPositionGrid] getSizeX]
	       Height: [[modelSwarm getPositionGrid] getSizeY]];
    [worldRaster pack];				  // draw the window.
    [rasterList addLast: worldRaster];

  // Now create a Value2dDisplay: this is a special object that will
  // display arbitrary 2d value arrays on a given Raster widget.
  
//      featureDisplay = [Object2dDisplay createBegin: self];
//      [featureDisplay setDisplayWidget: worldRaster];
//      [featureDisplay setDiscrete2dToDisplay: [modelSwarm getPositionGrid]];
//      [featureDisplay setObjectCollection: [modelSwarm getCitizenList] ];
     
//      [featureDisplay setDisplayMessage: M(drawSelfOn:)];

//      featureDisplay = [featureDisplay createEnd];
//      [featureDisplayList addLast: featureDisplay];
}

  return self;
}  

- buildActions 
{
  [super buildActions];
  
  // First, let our model swarm build its own schedule.

  [modelSwarm buildActions];
  
  stopSchedule = [Schedule createBegin: self];
  [stopSchedule setRepeatInterval: 1];
  stopSchedule = [stopSchedule createEnd];

  [stopSchedule at: 0
                createActionTo: self 
                message: M(checkToStop)];
  
  [stopSchedule at: 0 createActionTo: self message: M(peep)];

  [stopSchedule at: 0 createActionTo: self message: M(writeRasters)];

  return self;
}  



// activateIn: - get the Swarm ready to run.
- activateIn:  swarmContext 
{
  // First, activate ourselves (just pass along the context).
  [super activateIn: swarmContext];
  
  // We need to activate the model swarm.
  [modelSwarm activateIn: self];
  
  // Now activate our schedules in ourselves. Note that we just activate
  // both schedules: the activity library will merge them properly.
  [stopSchedule activateIn: self];
   
  // Activate returns the swarm activity - the thing that's ready to run.
  return [self getActivity];
}

// the HeatbugObserverSwarm had a go method inherited from GUISwarm,
// but we have to define our own here. It's pretty simple. There's also
// a friendly message printed out here just in case someone is confused
// when they run heatbugs and see no graphics.

- go 
{
  printf ("You typed -b so we're running without graphics.\n");

  printf ("The program is running for a maximum of %d timesteps.\n",experimentDuration) ;
 
  printf (" timesteps .\n")
          ;
  
  [[self getActivity] run];
  return [[self getActivity] getStatus];
}

// And the termination method. When this fires we just terminate everything
// that's running and close our output file(s) by dropping the EZGraph which
// "owns" the sequence(s) we are logging.
- checkToStop
{
  int changes;
  if((changes=[modelSwarm getNumberOfChangesThisStep])==0)
  ++deadSteps;
  if(changes > 0)
    deadSteps = 0;
  if((deadSteps > 5)|| (getCurrentTime() > 3000)) { [self stopRunning]; return self;}
  else 
    return self;
}

-peep
{
  printf("peep %d",getCurrentTime());
  return self;
}

- stopRunning 
{
  [getTopLevelActivity() terminate]; // Terminate the simulation.

  if(loggingFrequency)
    [unhappyGraph drop] ;              // Close the output file.

  return self;
}




- drawFeature: (int) f PointX: (int) posX Y: (int) posY Color: (int) type {
   
  id drawingRaster= [rasterList atOffset: f];
//  [drawingRaster fillRectangleX0: posX
//                Y0: posY
//                X1: posX+1
//                Y1: posY+1
//                Color: type];
  //can use above to make things look bigger. Hmmm!


  [drawingRaster drawRasterPointX: posX Y: posY Color: type];
   return self;
}

- writeRasters
{
  int j;
  id rasterObject;
  
  for(j=0; j< [Citizen getNumFeatures] ; j++)
    {
    char filename[256];

    
    sprintf(filename, "m%dt%06d.ppm", j, getCurrentTime());
    rasterObject=[rasterList atOffset: j ];
    [rasterObject  writeSelfToFile: filename];
   }
 return self;
  
}


@end
