#import "MyObject.h"
#import <random.h>

@implementation MyObject

- setWorld: (id <Grid2d>)w
{
  if (world != nil) {
      [InvalidArgument raiseEvent:
          "You can only set the world of a ant at creation time\n"];
  }
  world = w;
  return self;
}

- createEnd
{
  if (world == nil)
    [InvalidCombination raiseEvent: "Ant was created without a world.\n"];

  worldXSize = [world getSizeX];
  worldYSize = [world getSizeY];
  setFlag = 1;
  return self;
}

- setMyZone: (int)value
{
  myZone = value;
  return self;
}

- unset
{
  setFlag = 0;
  return self;
}

- (int)getMyZone
{
  return myZone;
}

- (int)getFlag
{
  return setFlag;
}

- setX: (int)inX Y: (int)inY
{
  myX = inX;
  myY = inY;
  [world putObject: self atX: inX Y: inY];
  return self;
}

- (int)getX
{
  return myX;
}

- (int)getY
{
  return myY;
}

- setObjectColor: (Color)c;
{
  objectColor = c;
  return self;
}

- setZoneColor: (Color)c;
{
  zoneColor = c;
  return self;
}

- drawSelfOn: (id <Raster>)r
{
  [r drawPointX: myX Y: myY Color: objectColor];
  //[r fillRectangleX0: myX-1 Y0: myY-1 X1: myX+1 Y1: myY+1 Color: objectColor];
  if (setFlag) 
    [r ellipseX0: myX-myZone Y0: myY-myZone X1: myX+myZone Y1: myY+myZone Width: 1 Color: zoneColor]; 
  return self;
}

@end
