#import "ArmyAnt.h"
#import <random.h>
#include <math.h>

// stany mrwki
#define LOOKING_FOR 1
#define GOING_TO 2
#define CARRING_MASTER 3
#define CARRING_SLAVE 4

@implementation ArmyAnt

- setWorld: (id <Grid2d>)w
{
  if (world != nil) {
      [InvalidArgument raiseEvent:
          "You can only set the world of a ant at creation time\n"];
  }
  world = w;
  return self;
}

- createEnd
{
  if (world == nil)
    [InvalidCombination raiseEvent: "Ant was created without a world.\n"];

  worldXSize = [world getSizeX];
  worldYSize = [world getSizeY];
  // potrzebne przy unikaniu cofania si
  lastX = -1;
  lastY = -1;
  currentActivity = LOOKING_FOR;
  team = [List create: [self getZone]];
  return self;
}

- setMyZone: (int)value
{
  myZone = value;
  return self;
}

- setCallZone: (int)value
{
  callZone = value;
  return self;
}

- setObjectList: (id <List>)list
{
  objectList = list;
  return self;
}

- setAAntList: (id <List>)list
{
  aantList = list;
  return self;
}

- setX: (int)inX Y: (int)inY
{
  myX = inX;
  myY = inY;
  [world putObject: self atX: inX Y: inY];
  return self;
}

- setGoingWeight: (int)value
{
  goingWeight = value;
  return self;
}

- setCallWeight: (int)value
{
  callWeight = value;
  return self;
}

- setTeamSize: (int)size
{
  teamSize = size;
  return self;
}

- setDumpSize: (int) size
{
  dumpSize = size;
  return self;
}

- setDumpX: (int) x
{
  dumpX = x;
  return self;
}

- setDumpY: (int) y
{
  dumpY = y;
  return self;
}

- setAvoidLastStep: (int) flag
{
  avoidLastStepFlag = flag;
  return self;
}

- setImmediatelyCall: (int) flag
{
  immediatelyCall = flag;
  return self;
}

- (int)getX
{
  return myX;
}

- (int)getY
{
  return myY;
}

/**
 * Metoda wykorzystywana przez wykres
 *
 * @return 1 - mrwka pracuje
 *         0 - mrwka poszukuje przedmiotu
 */
- (int)atWork 
{
  if (currentActivity == CARRING_MASTER ||
      currentActivity == CARRING_SLAVE  ||
      currentActivity == GOING_TO)
    return 1;
  return 0;
}

/**
 * Wyszukanie wolnego przedmiotu
 */
- (int)seekObject 
{
  int index; // zmienna robocza wykorzystywana przy iteracji
  // najkrtszy dystans midzy mrwk a odnalezionym przedmiotem
  int shortestDistance = 10000; 

  // wyzerowanie zmiennych przechowujcych dane o odnalezionym przedmiocie
  // (mog by one jeszcze ustawione na ostatnio odnaleziony przedmiot)
  myObject = nil;
  objectX = -1;
  objectY = -1;

  // sprawdzamy wszystkie obiekty znajdujce si w wiecie
  // czy nie znajduj si one w naszej strefie zainteresowa ?
  for(index = 0; index < [objectList getCount]; index++) {
    MyObject * stObj;
    // zmienne przechowujce odlego sprawdzanego przedmiotu
    // od mrwki
    int hDistance; // dystans w poziomie (o X)
    int vDistance; // dystans w pionie (o Y)
    int distance; // dystans bezwzgldny (wektor)

    stObj = [objectList atOffset: (unsigned)index];
    // sprawdzam czy obiekt nie jest w fazie przenoszenia 
    // przez inny team
    if ([stObj getFlag] == 0) continue;
    hDistance = [stObj getX] - myX;
    vDistance = [stObj getY] - myY;
    // obliczam dystans bezwzgldny
    distance = (int)sqrt(hDistance * hDistance + vDistance * vDistance);
    // jeeli cakowity dystans jest mniejszy lub rwny sumie 
    // mojego promienia wykrywania i promienia detekcji
    // obiektu to przedmiot zosta odnaleziony
    if (distance <= myZone + [stObj getMyZone] &&
        (myObject == nil || shortestDistance > distance)) {
      myObject = stObj;
      shortestDistance = distance;
    }
  }

  // jeeli jaki przedmiot zosta odnaleziony to inicjujemy
  // pozostae zmienne opisujce go
  if (myObject != nil) {
    objectX = [myObject getX];
    objectY = [myObject getY];
    return 1;
  }
  else return 0;
}

/**
 * Losowy ruch mrwki
 */
- randomMove
{
  int location; // numer kierunku wiata (od 1 do 8)
  int i; // pomocnicza zmienna (do iteracji)
  // nowa pozycja
  int newX = 0, newY = 0;
  // efekt prb ruchu; jeeli po sprawdzeniu moliwoci ruchu
  // we wszystkich omiu kierunkach wiata okae si, e mrwka 
  // jest zablokowana ta zmienna musi by ustawiona na 1
  int stop = 1;

  // losujemy kierunek wiata od ktrego zaczniemy analiz
  location = [uniformIntRand getIntegerWithMin: 1L withMax: 8L];
  // przejcie po wszystkich omiu kierunkach wiata
  for( i = 0; i < 8; i++) {
    switch (location) {
    case 1:  
      newX = myX - 1; newY = myY - 1;   // NW
      break;  
    case 2:
      newX = myX ; newY = myY - 1;    // N
      break;  
    case 3:
      newX = myX + 1 ; newY = myY - 1;  // NE
      break;  
    case 4:
      newX = myX - 1 ; newY = myY;    // W
      break;  
    case 5:
      newX = myX + 1 ; newY = myY;    // E
      break;  
    case 6:
      newX = myX - 1 ; newY = myY + 1;  // SW
      break;  
    case 7:
      newX = myX ; newY = myY + 1;    // S
      break;  
    case 8:
      newX = myX + 1 ; newY = myY + 1;  // SE
    default:
      break;
    }

    // ruch w sprawdzanym kierunku nie jest dozwolony gdy :
    // 1 - nowa pozycja mrwki wychodzi poza obszar wiata
    // 2 - flaga unikania ostatniej pozycji jest ustawiona i mrwka wanie chce si cofn
    // 3 - co si znajduje w sprawdzanym miejscu    
    if ( newX < 0 || newX > worldXSize ||
         newY < 0 || newY > worldYSize ||
         ( avoidLastStepFlag && newX == lastX && newY == lastY) ||
        [world getObjectAtX: newX Y: newY] != nil) 
      // nie moemy si ruszy w tym kierunku wic sprawdzimy inny kierunek
      location = (location % 8) + 1;
    else {
      // OK ruszamy si w tym kierunku
      stop = 0;
      break;
    }
  }

  // jeeli moemy si gdzie ruszy to si przesuwamy
  if (!stop) {
    // usuwamy siebie z zajmowanej pozycji
    [world putObject: nil atX: myX Y: myY];

    // potrzebne przy unikaniu cofania si
    lastX = myX;
    lastY = myY;

    // ustawiamy siebie na nowej pozycji
    myX = newX;
    myY = newY;
    [world putObject: self atX: newX Y: newY];
  }

  return self;
}

/**
 * Sprawdzenie czy przedmiot jest jeszcze na swoim miejscu
 * Sprawdzenie potrzebne jest w chwili gdy podamy do wyszukanego 
 * przedmiotu. Zanim do niego dotrzemy jakie inne mrwki mogy 
 * go ju zabra.
 */
- (int)isItOnPlace 
{
  int nRet;
  if ([myObject getX] != objectX ||
      [myObject getY] != objectY)  nRet = 0;
  else nRet = 1;
  return nRet;
}

/**
 * Woanie mrwek bdcych w zasigu do wyszukanego przedmiotu
 */
- callAllAAnts 
{
  int index = 0; // zmienna pomocnicza
  // zanim zawoamy mrwk musimy 
  // sprawdzi czy jest w zasigu nawoywania
  for(index = 0; index < [aantList getCount]; index++) {
    ArmyAnt * stAnt;
    // zmienne przechowujce odlego sprawdzanej mrwki
    // od mrwki nawoujcej
    int hDistance; // dystans w poziomie (o X)
    int vDistance; // dystans w pionie (o Y)
    int distance; // dystans bezwzgldny (wektor)

    stAnt = [aantList atOffset: (unsigned)index];
    hDistance = [stAnt getX] - myX;
    vDistance = [stAnt getY] - myY;
    distance = (int)sqrt(hDistance * hDistance + vDistance * vDistance);
    // jeeli cakowity dystans jest mniejszy lub rwny od moich 
    // moliwoci nawoywania to woamy mrwk
    if (distance <= callZone) [stAnt call: myObject];
  }
  // zmienna wykorzystywana przez metod rysujc
  // jeeli jest ustawiona to rysowany bdzie obszar nawoywania
  callFlag = 1;

  return self;
}

/**
 * Sprawdzenie czy jestem ju przy wyszukanym przedmiocie
 * Funkcja wykorzystywana w etapie podania do przedmiotu
 */
- (int)checkIfIAmOnPlace
{
  if (myX >= objectX - 1 && myX <= objectX + 1 &&
      myY >= objectY - 1 && myY <= objectY + 1) return 1;
  else return 0;
}

/**
 * Ruch w kierunku wyszukanego przedmiotu
 * Metoda sprawdza moliwo ruchu mrwki we wszystkich omiu kierunkach
 * wiata i wybiera ten, ktry najbardziej skraca jej odlego od 
 * przedmiotu.
 */
- myMove
{
  // numer kierunku wiata (od 1 do 8)
  int location = 1;
  // zmienna pomocnicza przy iteracji
  int i;
  // nowa pozycja mrwki (sprawdzana)
  int newX = 0, newY = 0;
  // najlepsza dotd wybrana nowa pozycja mrwki
  int bestX = 0, bestY = 0;
  // najwiksza wybrana odlego o ktr zmieni si 
  // pooenie mrwki w stosunku do przedmiotu
  double  bestWeight = -100;
  // sprawdzana odlego o ktr zmieni si 
  // pooenie mrwki w stosunku do przedmiotu
  double weight = 0;

  // sprawdzamy wszystkie osiem kierunkw wiata
  for( i = 0; i < 8; i++) {
    switch (location) {
    case 1:  
      newX = myX - 1; newY = myY - 1;   // NW
      break;  
    case 2:
      newX = myX ; newY = myY - 1;    // N
      break;  
    case 3:
      newX = myX + 1 ; newY = myY - 1;  // NE
      break;  
    case 4:
      newX = myX - 1 ; newY = myY;    // W
      break;  
    case 5:
      newX = myX + 1 ; newY = myY;    // E
      break;  
    case 6:
      newX = myX - 1 ; newY = myY + 1;  // SW
      break;  
    case 7:
      newX = myX ; newY = myY + 1;    // S
      break;  
    case 8:
      newX = myX + 1 ; newY = myY + 1;  // SE
    default:
      break;
    }

    // obliczamy odlego o jak zmieni si dystans dzielcy mrwk od przedmiotu
    // jeeli przesunie si ona w sprawdzanym kierunku

    weight = sqrt(((objectY - myY)*(objectY - myY)) + ((objectX - myX)*(objectX - myX))) -
      sqrt(((objectX - newX)*(objectX - newX)) + ((objectY - newY)*(objectY - newY)));

    //    weight = (abs(objectY - myY) - abs(objectY - newY)) +
    //      (abs(objectX - myX) - abs(objectX - newX));

    location = (location % 8) + 1;

    // ruch w sprawdzanym kierunku nie jest dozwolony gdy :
    // 1 - nowa pozycja mrwki wychodzi poza obszar wiata
    // 2 - flaga unikania ostatniej pozycji jest ustawiona i mrwka wanie chce si cofn
    // 3 - co si znajduje w sprawdzanym miejscu    
    if ( newX < 0 || newX > worldXSize ||
         newY < 0 || newY > worldYSize ||
         ( avoidLastStepFlag && newX == lastX && newY == lastY) ||
         [world getObjectAtX: newX Y: newY] != nil) continue;
    // jeeli ruch jest moliwy to sprawdzamy jakie korzyci on nam przyniesie
    if (weight > bestWeight) {
      // jest to najlepszy rozpatrywany do tej pory ruch
      // zapamitujemy jego koordynaty
      bestX = newX;
      bestY = newY;
      bestWeight = weight;
    }
  }

  // jeeli zdecydowalimy si na jaki ruch 
  // to go wykonujemy
  if (bestWeight != -100) {
    // usuwamy siebie z zajmowanej pozycji
    [world putObject: nil atX: myX Y: myY];

    // potrzebne przy unikaniu cofania si
    lastX = myX;
    lastY = myY;

    // ustawiamy siebie na nowej pozycji
    myX = bestX;
    myY = bestY;
    [world putObject: self atX: myX Y: myY];
  }

  return self;  
}

/**
 * Sprawdzenie kolejnoci przybycia mrwki do przedmiotu.
 * Metoda pyta si wszystkie mrwki bdce w jej zasigu komunikacji
 * czy s ju obecne przy przedmiocie do ktrego ona podaa. Zlicza 
 * te mrwki i zwraca ich sum. Dodatkowo, jeeli mrwka przybya do przedmiotu
 * jako kolejna w teamie (nie pierwsza ale zmiecia si jeszcze w grupie) to
 * nastpuje jej rejestracja u lidera grupy.
 */
- (int)myPosition
{
  // zmienna pomocnicza (iteracja)
  int index = 0;
  // licznik mrwek bdcych przy przedmiocie inicjujemy jedynk
  // poniewa siebie te musimy zliczy
  int count = 1;

  for(index = 0; index < [aantList getCount]; index++) {
    ArmyAnt * stAnt;
    // zmienne przechowujce odlego sprawdzanej mrwki
    // od mrwki nawoujcej
    int hDistance; // dystans w poziomie (o X)
    int vDistance; // dystans w pionie (o Y)
    int distance; // dystans bezwzgldny (wektor)

    stAnt = [aantList atOffset: (unsigned)index];
    hDistance = [stAnt getX] - myX;
    vDistance = [stAnt getY] - myY;
    distance = (int)sqrt(hDistance * hDistance + vDistance * vDistance);
    // jeeli mrwka jest w zasigu to j odpytujemy
    if (distance <= callZone) count += [stAnt areYouOnPlace: myObject sender: self];
  }

  return count;
}

/**
 * Wygaszenie wyszukanego przedmiotu
 * Od tego momentu inne mrwki nie bd go widziay, to znaczy
 * nie bd go wykryway jako przedmiotu do przeniesienia,
 * ale bd go wykryway jako przeszkoda w poruszaniu si.
 */
- unsetObject
{
  // obiekt musi wiedzie e jest wygaszony
  [myObject unset];
  return self;
}

/**
 * Sprawdzenie czy przesuwany przedmiot jest ju w magazymie
 */
- (int)checkObjectOnPlace
{
  if (objectX > dumpX && objectX < dumpX + dumpSize &&
      objectY > dumpY && objectY < dumpY + dumpSize)
    return 1;
  else return 0;
}

/**
 * Zwolnienie wszystkich towarzyszy przesuwajcych przedmiot
 * Lider zwalnia towarzyszy, gdy przedmiot znajdzie si w mietniku
 */
- freeCompanionship
{
  [team forEach: M(free)];
  // czycimy list wsptowarzyszy
  team = [List create: [self getZone]];
  return self;
}

/**
 * Przesunicie przedmiotu w kierunku mietnika
 */
- objectMove
{
  // rodkowy punkt mietnika, wedug ktrego bdziemy oblicza najlepszy ruch
  int dumpCenterX, dumpCenterY;
  // wartoci przesuni dla kadej mrwki w team-ie i przenoszonego przedmiotu
  int moveX = 0, moveY = 0;
  // zmienne pomocnicza (iteracja)
  int i, k;
  // flaga okrelajca kopoty z przesuniciem
  int trouble = 0;
  // sprawdzana odlego o ktr zmieni si 
  // pooenie przedmiotu w stosunku do rodka mietnika
  double weight = -100;
  // najwiksza wybrana odlego o ktr zmieni si 
  // pooenie przedmiotu w stosunku do rodka mietnika
  double bestWeight = -100;
  // najlepsze wybrane przesunicie
  int bestMoveX = 0, bestMoveY = 0;
  // numer kierunku wiata (od 1 do 8)
  int location = 1;

  // obliczamy rodek mietnika 
  // wedug niego bdziemy obliczali przesunicie przedmiotu
  dumpCenterX = dumpX + (int)(dumpSize / 2);
  dumpCenterY = dumpY + (int)(dumpSize / 2);

  // sprawdzamy wszystkie moliwe ruchy (we wszystkich omiu kierunkach
  // wiata) i wybieramy najlepszy z moliwych do wykonania
  for( k = 0; k < 8; k++) {
    switch (location) {
    case 1:  
      moveX = -1; moveY = -1;   // NW
      break;  
    case 2:
      moveX = 0 ; moveY = -1;    // N
      break;  
    case 3:
      moveX = 1 ; moveY = -1;  // NE
      break;  
    case 4:
      moveX = -1 ; moveY = 0;    // W
      break;  
    case 5:
      moveX = 1 ; moveY = 0;    // E
      break;  
    case 6:
      moveX = -1 ; moveY =  1;  // SW
      break;  
    case 7:
      moveX = 0; moveY = 1;    // S
      break;  
    case 8:
      moveX = 1 ; moveY = 1;  // SE
    default:
      break;
    }

    // obliczamy korzyci jakie da nam sprawdzany ruch
    weight = 
      sqrt(((dumpCenterY - objectY)*(dumpCenterY - objectY)) + 
           ((dumpCenterX - objectX)*(dumpCenterX - objectX))) -
      sqrt(((dumpCenterX - (objectX + moveX))*(dumpCenterX - (objectX + moveX))) + 
           ((dumpCenterY - (objectY + moveY))*(dumpCenterY - (objectY + moveY))));

    // sprawdzamy czy ruch w danym kierunku jest moliwy 
    // tzn. czy nie stoi co na przeszkodzie
    trouble = 0;
    // sprawdzamy ruch kadej mrwki w zespole i 
    // dodatkowo w ostatnim przejciu ptli  dokonamy sprawdzenia 
    // ruchy przedmiotu
    for( i = 0; i < [team getCount] + 1; i++) {
      ArmyAnt * stAnt;
      int newX, newY, j, go = 0;

      if (i == [team getCount]) {
        // na koniec sprawdzam ruch obiektu
        newX = objectX + moveX;
        newY = objectY + moveY;
      }
      else { // sprawdzamy ruch mrwki
        stAnt = [team atOffset: (unsigned)i];
        newX = [stAnt getX] + moveX;
        newY = [stAnt getY] + moveY;
      }

      // jeeli nowa pozycja tego co sprawdzamy
      // pokrywa si z aktualn pozycj przesuwanego przedmiotu
      // to taki ruch moemy dokona poniewa przedmiot 
      // zostanie przesunity na now pozycj
      if (objectX == newX && objectY == newY) continue;
      // jeeli nowa pozycja tego co sprawdzamy
      // pokrywa si z aktualn pozycj ktrego towarzysza z zespou
      // to taki ruch moemy dokona poniewa ten towarzysz
      // przesunie si na inn pozycj
      for( j = 0; j < [team getCount]; j++) {
        // porwnujemy now pozycj sprawdzanego czego z aktualnymi pozycjami 
        // wszystkich towarzyszy
        ArmyAnt* stAnotherAnt = nil;
        stAnotherAnt = [team atOffset: (unsigned)j];
        if (newX == [stAnotherAnt getX] && 
            newY == [stAnotherAnt getY]) {
          go = 1;
          break;
        }
      }
      // jeeli na pewno moemy dokona ruch to 
      // przechodzimy do  nastpnego sprawdzenia
      if (go) continue;

      // poniewa wiemy e to co sprawdzamy dokona ruch na pole nie
      // zajmowane aktualnie przez adnego czonka zespou lub prznoszony 
      // przedmiot wic naley dokadnie przyjrze si temu ruchowi

      // ruch nie wolno wykona gdy:
      // 1) wychodzi poza wiat
      // 2) wchodzi na pole zajmowane ju przez co innego
      if ( newX < 0 || newX > worldXSize ||
           newY < 0 || newY > worldYSize ||
           [world getObjectAtX: newX Y: newY] != nil) {
        trouble = 1;
        break;
      }
    }

    // nastpny sprawdzany kierunek
    location = (location % 8) + 1;
    if (!trouble && weight > bestWeight) {
      // jest to najlepszy rozpatrywany do tej pory ruch
      // zapamitujemy jego koordynaty
      bestMoveX = moveX;
      bestMoveY = moveY;
      bestWeight = weight;
    }
  }

  // jeeli wybralimy jaki ruch to go dokonujemy
  if (bestWeight != -100) {
    // usuwamy przedmiot z aktualnego miejsca
    [world putObject: nil atX: objectX Y: objectY];
    objectX = objectX + bestMoveX;
    objectY = objectY + bestMoveY;
    // usuwamy wszystkie mrwki z ich aktualnych miejsc
    for( i = 0; i < [team getCount]; i++) {
      int currentX ,currentY;
      ArmyAnt * stAnt;
      stAnt = [team atOffset: (unsigned)i];

      currentX = [stAnt getX];
      currentY = [stAnt getY];
      [world putObject: nil atX: currentX  Y: currentY];
    }

    // przesuwamy przedmiot na nowe miejsce
    [myObject setX: objectX Y: objectY];
    // przesuwamy mrwki z zespou na nowe miejsca
    for( i = 0; i < [team getCount]; i++) {
      int currentX ,currentY;
      ArmyAnt * stAnt;
      stAnt = [team atOffset: (unsigned)i];

      currentX = [stAnt getX];
      currentY = [stAnt getY];
      [stAnt setX: currentX + bestMoveX Y: currentY + bestMoveY];
    }
  }
  return self;
}

/**
 * Nawoywanie do odnalezionego przedmiotu
 * Metoda umoliwia powiadomienie mrwki o odnalezieniu przez kogo
 * przedmiotu.
 */
- call: (MyObject*)nearObject
{
  // mrwka przyjmuje wiadomo tzn. zainteresuje sie przedmiotem
  // jeeli jest w fazie szukania lub jest w fazie podania 
  // ale priorytet nawoywania jest wyszy
  if ((currentActivity == GOING_TO  &&  
       goingWeight < callWeight && 
       myObject != nearObject) ||
      currentActivity == LOOKING_FOR) {
       
    currentActivity = GOING_TO;
    myObject = nearObject;
    objectX = [nearObject getX];
    objectY = [nearObject getY];
    if (immediatelyCall == 1) [self callAllAAnts];
  }

  return self;
}

/**
 * Pytanie - czy jeste ju przy przedmiocie
 * Metoda umoliwia zapytanie mrwki o to czy jest w grupie
 * przesuwajcej (lub majcej przesuwa) podany przedmiot.
 * Jeeli pytana mrwka jest liderem to jednoczenie rejestruje 
 * pytajcego do grupy.
 * 
 * @param stObj przedmiot
 * @param aant pytajcy
 */
- (int)areYouOnPlace: (MyObject*)stObj sender:(ArmyAnt*)aant
{
  int nRet = 0;

  // sprawdzamy czy przedmiot ktrym ja jestem zainteresowany to ten
  // sam przedmiot o ktrego pytaj
  if (stObj == myObject) {
    // sprawdzam czy jestem liderem (co oznacza jednoczene
    // e jestem przy przedmiocie)
    if (currentActivity == CARRING_MASTER) {
      // dodajemy pytajcego do zespou
      // [team addLast: aant];
      if ( [team getCount] < teamSize) 
	[team addLast: aant];
      // jeeli zesp wanie zosta zamknity to
      // rozsyam wiadomo do wszystkich mrwek podajcych do 
      // przedmiotu (i bdcych w zasigu eby szukay innego przedmiotu)
      if([team getCount] == teamSize) {
        int i;
        for(i = 0; i < [aantList getCount]; i++) {
          ArmyAnt * stAnt;
          int hDistance, vDistance, distance;

          stAnt = [aantList atOffset: (unsigned)i];
          hDistance = [stAnt getX] - myX;
          vDistance = [stAnt getY] - myY;
          distance = (int)sqrt(hDistance * hDistance + vDistance * vDistance);
          // jeeli mrwka jest w zasigu to mwimy jej - daj se na luz
          if (distance <= callZone) [stAnt enough: myObject];
        }
      }
      nRet = 1;
    }
    // sprawdzam czy nie jestem sug (co oznacza jednoczenie
    // e jestem przy przedmiocie)
    else if (currentActivity == CARRING_SLAVE)
      nRet = 1;
  }
  return nRet;
}

/**
 * Metoda umoliwa powiadomienie mrwki o fakcie zamknicia zespou
 * przy przedmiocie.
 */
- enough: (MyObject*) stObj
{
  // jeeli to ten sam przedmiot do ktrego podam  
  // to musz sobie poszuka innego (bo tam ju zebra
  // si zesp)
  if (stObj == myObject && currentActivity == GOING_TO) {
    currentActivity = LOOKING_FOR;
  }
  return self;
}

/**
 * Zwalnia agenta z teamu
 * Metoda umoliwia liderowi zespou powiadomienie mrwki e jest wolna
 * i moe poszuka sobie innego przedmiotu.
 */
- free
{
  currentActivity = LOOKING_FOR;
  return self;
}

/*
 * Metoda spina ca logik pracy mrwki.
 */
- step
{
  int myPosition;
  // flaga wykorzystywana przy rysowaniu strafy nawoywania
  callFlag = 0;

  // w zalenoci od biecego stanu warunkujemy zachowanie agenta
  switch(currentActivity) {
    case LOOKING_FOR : 
      // wyszukujemy przedmiot
      if (![self seekObject]) {
        // jeeli przedmiot nie zosta zlokalizowany
        // wykonujemy losowy ruch
        [self randomMove];
        // i koczymy
        break;
      }
      // przedmiot zosta znaleziony
      // zmieniamy stan agenta
      currentActivity = GOING_TO;
    case GOING_TO : 
      // sprawdzamy czy przedmiot jest jeszcze na 
      // swoim miejscu (moe ju jakie mrwki go zabray)
      if (![self isItOnPlace]) {
        // nie? oj to musimy poszuka sobie innego
        currentActivity = LOOKING_FOR;
        break;
      }
      // ok jest na miejscu
      // woamy wszystkich agentw bdcych w zasigu
      [self callAllAAnts];
      // sprawdzamy czy przypadkiem nie jestemy ju na
      // miejscu (przy przedmiocie)
      if (![self checkIfIAmOnPlace]) {
        // jeeli nie to wykonujemy ruch
        // w kierunku przedmiotu
        [self myMove];
        // i koczymy
        break;
      }
      // jestemy na miejscu 
      // sprawdzamy jako ktrzy brzybylimy do przedmiotu
      myPosition = [self myPosition];
      if (myPosition > 1 && myPosition < teamSize) {
        // zaapalimy si do teamu ale nie bedziemy jego przywdc
        currentActivity = CARRING_SLAVE;
        // czekamy na rozkazy
        break;
      }
      else if (myPosition == teamSize) {
        // zaapalimy si do teamu ale nie bedziemy
        // jego przywdc
        currentActivity = CARRING_SLAVE;
        // poniewa zamykamy team to wygaszamy przedmiot aby inne mrwki 
        // ju go nie mogy znale (skoro zebra si team koo przedmiotu
        //  to nie ley on ju w sferze zainteresowa  szukajcych mrwek)
        [self unsetObject];
        // czekamy na rozkazy
        break;
      }
      else if (myPosition > teamSize) {
        // nie zaapalimy si nawet do teamu musimy poszuka innego przedmiotu
        currentActivity = LOOKING_FOR;
        break;
      }
      // jestemy pierwsi
      // zmieniamy stan agenta
      currentActivity = CARRING_MASTER;
      [team addLast: self];
    case CARRING_MASTER :
      // potrzebne przy unikaniu cofania si
      lastX = -1;
      lastY = -1;
      // sprawdzam czy przesuwany przedmiot nie jest ju w mietniku
      if ([self checkObjectOnPlace]) {
        [self unsetObject];
        // usuwamy obiekt z listy obiektw poza mietnikem
        [objectList remove: myObject];
        // jeli tak to zostawiamy go 
        currentActivity = LOOKING_FOR;
        // zwalniamy wszystkich towarzyszy
        [self freeCompanionship];
        // przedmiot zaniesiony do magazynu jest przejmowany
        // przez jego obsug i nie jest wicej problemem
        // podczas poruszania si mrwek 
        [world putObject: nil atX: objectX Y: objectY];

        // i szukamy innego przedmiotu
        break;
      }
      // aby przesun przedmiot musi zebra si odpowiedni team
      if (!([team getCount] == teamSize)) {
        // woamy wszystkich agentw bdcych w zasigu
        [self callAllAAnts];
        break;
      }
      // przesuwamy przedmiot - przy przesuwaniu dokonywane jest
      // sprawdzenie czy mona wykona ruch, bo moe si zdarzy e co bdzie stao nam 
      // na drodze i bdziemy musieli poczeka
      [self objectMove];
      break;
    case CARRING_SLAVE :
      // potrzebne przy unikaniu cofania si
      lastX = -1;
      lastY = -1;
      // czekamy na rozkazy
      break;
  }

  return self;
}

- setAAntColor: (Color)c;
{
  aantColor = c;
  return self;
}
- setZoneColor: (Color)c;
{
  zoneColor = c;
  return self;
}
- setCallZoneColor: (Color)c;
{
  callZoneColor = c;
  return self;
}

- drawSelfOn: (id <Raster>)r
{
  [r drawPointX: myX Y: myY Color: aantColor];
  //[r fillRectangleX0: myX-1 Y0: myY-1 X1: myX+1 Y1: myY+1 Color: aantColor];
  if (currentActivity == LOOKING_FOR)
    [r ellipseX0: myX-myZone Y0: myY-myZone X1: myX+myZone Y1: myY + myZone Width: 1 Color: zoneColor]; 
  else if (callFlag)
    [r ellipseX0: myX-callZone Y0: myY-callZone X1: myX+callZone Y1: myY+callZone Width: 1 Color: callZoneColor]; 
  return self;
}

@end
