#import "AAntObserverSwarm.h"
#import "AAntModelSwarm.h"
#import <collections.h>
#import <objectbase.h>
#import <analysis.h>
#import <gui.h>

#define ZOOM 3 

@implementation AAntObserverSwarm

+ createBegin: aZone
{
  AAntObserverSwarm *obj;
  id <CustomProbeMap> probeMap;
  
  obj = [super createBegin: aZone];

  obj->displayFrequency = 1;
  obj->stepCount = 0;
  obj->realStepCount = 0;
  obj->objectCount = 0;
  probeMap = [CustomProbeMap create: aZone
              forClass: [self class]
              withIdentifiers: "displayFrequency", "stepCount", "objectCount", 
              ":", NULL];
  
  [probeLibrary setProbeMap: probeMap For: [self class]];
  return obj;
}

- createEnd
{
  return [super createEnd];
}

/**
 * Wywoywana w chwili zabicia planszy.
 */
- worldRasterDeath : caller
{
  [worldRaster drop];
  worldRaster = nil;

  return self;
}

/**
 * Wywoywana w chwili zabicia wykresu.
 */
- workGraphDeath : caller
{
  [workGraph drop];
  workGraph = nil;
  return self;
}

- buildObjects
{
  [super buildObjects];
  
  aantModelSwarm = [AAntModelSwarm create: self];

  CREATE_ARCHIVED_PROBE_DISPLAY (aantModelSwarm);
  CREATE_ARCHIVED_PROBE_DISPLAY (self);
  
  [controlPanel setStateStopped];

  [aantModelSwarm buildObjects];

  colormap = [Colormap create: self];
  [colormap setColor: 0 ToName: "green"]; // kolor mrwek
  [colormap setColor: 1 ToName: "white"]; // kolor strefy czucia mrwki
  [colormap setColor: 2 ToName: "red"]; // kolor strefy nawoywania mrwek
  [colormap setColor: 3 ToName: "blue"]; // kolor obiektw
  [colormap setColor: 4 ToName: "yellow"]; // kolor strefy wykrywania obiektw
  [colormap setColor: 5 ToName: "red"]; // kolor magazynu

  [[aantModelSwarm getAAntList] forEach: M(setAAntColor:) : (id) 0];
  [[aantModelSwarm getAAntList] forEach: M(setZoneColor:) : (id) 1];
  [[aantModelSwarm getAAntList] forEach: M(setCallZoneColor:) : (id) 2];
  [[aantModelSwarm getObjectList] forEach: M(setObjectColor:) : (id) 3];
  [[aantModelSwarm getObjectList] forEach: M(setZoneColor:) : (id) 4];
  [aantModelSwarm setDumpColor: 5];
  
  worldRaster = [ZoomRaster createBegin: self];
  worldRaster = [worldRaster createEnd];
  [worldRaster enableDestroyNotification: self
               notificationMethod: @selector (worldRasterDeath:)];
  [worldRaster setColormap: colormap];
  [worldRaster setZoomFactor: ZOOM];
  [worldRaster setWidth: [[aantModelSwarm getWorld] getSizeX]
	       Height: [[aantModelSwarm getWorld] getSizeY]];
  [worldRaster setWindowTitle: "World"];
  [worldRaster pack];

  worldDisplay = 
    [Object2dDisplay create: self
                     setDisplayWidget: worldRaster
                     setDiscrete2dToDisplay: [aantModelSwarm getWorld]
                     setDisplayMessage: M(drawSelfOn:)];

  // w celu optymalizacyjnym ustawiamy stos wszystkich elementw
  // wiata do rysowania    
  [worldDisplay setObjectCollection: [aantModelSwarm getCompleteList]];

  // potrzebne dla przekazywania akcji kliku do elemntw wiata
  [worldRaster setButton: ButtonRight
               Client: worldDisplay
               Message: M(makeProbeAtX:Y:)];

  workGraph = 
    [EZGraph create: self
             setTitle: "Work process"
             setAxisLabelsX: "time" Y: "activity"
             setWindowGeometryRecordName: "workGraph"];
  [workGraph setRangesYMin: 0 Max: 1];
  
  [workGraph enableDestroyNotification: self
                notificationMethod: @selector (workGraphDeath:)];

  [workGraph createSequence: "activity"
   withFeedFrom: aantModelSwarm 
   andSelector: M(getAverageActivity)];

  return self;
}  

- _update_
{
  objectCount = [[aantModelSwarm getObjectList] getCount];
  if (worldRaster) {
    [worldRaster erase];
    //[worldRaster setZoomFactor: ZOOM];
    [aantModelSwarm drawDump: worldRaster];
    [worldDisplay display];
    [worldRaster drawSelf];
    [actionCache doTkEvents];
  }
  realStepCount++;
  stepCount = realStepCount;
  if (workGraph) [workGraph step];
  if (objectCount == 0) {
    [probeDisplayManager update];
    [controlPanel setStateStopped];
  }
  return self;
}

- buildActions
{
  [super buildActions];
  
  [aantModelSwarm buildActions];
  displayActions = [ActionGroup create: self];
  [displayActions createActionTo: self message: M(_update_)];
  [displayActions createActionTo: probeDisplayManager message: M(update)];
  [displayActions createActionTo: actionCache message: M(doTkEvents)];
  displaySchedule = [Schedule create: self setRepeatInterval: displayFrequency];
  [displaySchedule at: 0 createAction: displayActions];
  
  return self;
}  

- activateIn:  swarmContext
{
  [super activateIn: swarmContext];
  [aantModelSwarm activateIn: self];
  [displaySchedule activateIn: self];
  return [self getActivity];
}
@end
