#import "AAntModelSwarm.h"
#import <random.h>
#import <space.h>
#import <activity.h>

@implementation AAntModelSwarm

- getCompleteList
{
  return completeList;
}

- getAAntList
{
  return aantList;
}

- getObjectList
{
  return objectList;
}

- (id <Grid2d>)getWorld
{
  return world;
}

- setDumpColor: (Color)c;
{
  dumpColor = c;
  return self;
}

- (void)syncUpdateMe
{
  if (actionForEach)
    [actionForEach setDefaultOrder: (id <Symbol>) Randomized];
}

+ createBegin: aZone
{
  AAntModelSwarm *obj;
  id <CustomProbeMap> probeMap;

  obj = [super createBegin: aZone];

  obj->numAAnts = 10; // liczba mrwek
  obj->aantDetectZone = 50; // promie strefy czucia mrwek
  obj->aantCallZone = 70; // strefa nawoywania mrwek
  obj->minAAntNum = 3; // minimalna liczba mrwek potrzebna do przesunicia adunku

  obj->numObjects = 7; // liczba przedmiotw
  obj->objectZone = 30; // promie strefy wykrywania przedmiotw

  obj->worldXSize = 200; 
  obj->worldYSize = 150; // rozmiar wiata

  obj->dumpSize = 20; // rozmiar boku kwadratu - mietnika
  obj->dumpX = 6;
  obj->dumpY = 6; // miejsce mietnika

  obj->callPriority = 1; // waga wanoci sygnau nawoywa
  obj->goingToObjectPriority = 2; // waga wanoci podania do przedmiotu

  obj->avoidLastStepFlag = 1; // jaeli jest ustawiona zabrania mrwce cofania si
  obj->immediatelyCall = 1; // jeeli jest ustawiona mrwki powiadomione o przedmiocie natychmiast
                            // woaj inne (bez czekania na swoj kolejk)

  obj->antActivity = 0;
  obj->allSteps = 0;

  probeMap = 
    [CustomProbeMap create: aZone 
     forClass: [self class]
     withIdentifiers:  "numAAnts", "aantDetectZone",
     "aantCallZone", "minAAntNum", "numObjects", "objectZone",
     "worldXSize", "worldYSize",
     "dumpSize", "dumpX", "dumpY", "callPriority",
     "goingToObjectPriority", "avoidLastStepFlag",  
     "immediatelyCall", ":", NULL]; 

  [probeLibrary setProbeMap: probeMap For: [self class]];
  return obj;
}

- createEnd
{
  return [super createEnd];
}

- buildObjects
{
  int i, newX, newY;

  [super buildObjects];
  
  world = [Grid2d create: self setSizeX: worldXSize Y: worldYSize];
  completeList = [List create: self];

  // tworzymy przedmioty
  objectList = [List create: self];
  for (i = 0; i < numObjects; i++) {
    MyObject * object;

    object = [MyObject createBegin: self];
    [object setWorld: world];
    object = [object createEnd];
    [objectList addLast: object];
    [completeList addLast: object];
      
    [object setMyZone: objectZone];
    do {
      newX = [uniformIntRand getIntegerWithMin: 2L withMax: (worldXSize-3)];
      newY = [uniformIntRand getIntegerWithMin: 2L withMax: (worldYSize-3)];
    }
    while([world getObjectAtX: newX Y: newY] != nil || 
          (dumpX <= newX && newX <= dumpX + dumpSize &&
           dumpY <= newY && newY <= dumpY + dumpSize));
    [object setX: newX Y: newY];
  }
  // tworzymy mrwki
  aantList = [List create: self];
  for (i = 0; i < numAAnts; i++) {
    ArmyAnt * aant;

    aant = [ArmyAnt createBegin: self];
    [aant setWorld: world];
    aant = [aant createEnd];
    [aantList addLast: aant];
    [completeList addLast: aant];
      
    [aant setMyZone: aantDetectZone];
    [aant setCallZone: aantCallZone];
      
    do {
      newX = [uniformIntRand getIntegerWithMin: 0L withMax: (worldXSize-1)];
      newY = [uniformIntRand getIntegerWithMin: 0L withMax: (worldYSize-1)];
    }
    while([world getObjectAtX: newX Y: newY] != nil);
    [aant setX: newX Y: newY];

    [aant setGoingWeight: (int)goingToObjectPriority];
    [aant setCallWeight: (int)callPriority];
    [aant setObjectList: objectList];
    [aant setTeamSize: minAAntNum];
    [aant setDumpSize: (int)dumpSize];
    [aant setDumpX: (int)dumpX];
    [aant setDumpY: (int)dumpY];
    [aant setAvoidLastStep: (int)avoidLastStepFlag];
    [aant setImmediatelyCall: (int)immediatelyCall];
  }
  for(i = 0; i < [aantList getCount]; i++) {
    ArmyAnt * aant;

    aant = [aantList atOffset: (unsigned)i];
    [aant setAAntList: aantList];
  }
  
  return self;
}

- drawDump: (id <ZoomRaster>) raster
{
  [raster fillRectangleX0: dumpX Y0: dumpY X1: dumpX + dumpSize Y1: dumpY + dumpSize Color: dumpColor];
  return self;
}

- buildActions
{
  [super buildActions];
  
  modelActions = [ActionGroup create: self];

  actionForEach =
    [modelActions createActionForEach: aantList message: M(step)];

  modelSchedule = [Schedule create: self setRepeatInterval: 1];
  [modelSchedule at: 0 createAction: modelActions];

  return self;
}

// Now set up the model's activation. swarmContext indicates where
// we're being started in - typically, this model is run as a subswarm
// of an observer swarm.

- activateIn: swarmContext
{
  [super activateIn: swarmContext];
  [modelSchedule activateIn: self];
  return [self getActivity];
}

- (double)getAverageActivity
{
  int index = 0;
  int allAntAtWork = 0;
  for(index = 0; index < [aantList getCount]; index++) {
    ArmyAnt * stAnt;
    stAnt = [aantList atOffset: (unsigned)index];

    allAntAtWork += [stAnt atWork];
  }

  antActivity += (double)allAntAtWork/(double)index;
  allSteps++;

  return (double)antActivity / (double)allSteps;
}

@end









