// Copyright James Marshall 2003. Freely distributable under the GNU General Public Licence

package buffon;

import swarm.objectbase.SwarmImpl;
import swarm.activity.Schedule;
import swarm.activity.ScheduleImpl;
import swarm.activity.Activity;
import swarm.space.Discrete2d;
import swarm.space.Discrete2dImpl;
import swarm.defobj.Zone;
import swarm.objectbase.Swarm;
import swarm.Selector;
import java.lang.RuntimeException;
import buffon.Ant;

/** The world swarm class */
class WorldSwarm extends SwarmImpl
{
	/** The world swarm's schedule */
	private swarm.activity.Schedule mSchedule;
	/** The nest representation */
	private Discrete2d mNest;
	/** The horizontal size of the nest in cells */
	private int mNestXSize;
	/** The vertical size of the nest in cells */
	private int mNestYSize;
	/** The ant */
	private Ant mAnt;

	/**
     * Gets the arousal level of the ant
     *
     * @return arousal level of the ant
     *
     */
	public int getAntsArousalLevel()
	{
		return mAnt.getArousalLevel();
	}

	/**
     * Returns the nest
     *
     * @return nest
     *
     */
	public Discrete2d getNest()
	{
		return mNest;
	}

	/**
     * Initialise a new nest
     *
     * @return void
     *
     */
	public void newNest(int nestXSize, int nestYSize)
	{
		int l1;

		mNestXSize = nestXSize;
		mNestYSize = nestYSize;
		if (mNest != null)
		{
			mNest.drop();
		}
		mNest = new Discrete2dImpl(this.getZone(), mNestXSize, mNestYSize);
		mNest.fastFillWithValue(0);
		for (l1 = 0; l1 < mNestXSize; l1++)
		{
			// north wall
			mNest.putValue$atX$Y(-1, l1, 0);
			// south wall
			mNest.putValue$atX$Y(-1, l1, mNestYSize - 1);
		}
		for (l1 = 0; l1 < mNestYSize; l1++)
		{
			// west wall
			mNest.putValue$atX$Y(-1, 0, l1);
			// east wall
			mNest.putValue$atX$Y(-1, mNestXSize - 1, l1);
		}
	}

	/**
     * Sets the ant to explore the nest
     *
     * @param ant
     *
     * @return void
     *
     */
	public void setAnt(Ant ant)
	{
		mAnt = ant;
	}

	/**
     * Resets the ant to the entrance of the nest, resets the ant's arousal level and turns pheremone laying on/off
     *
     * @param ant should deposit pheremone?
     *
     * @return void
     *
     */
	public void resetAnt(boolean depositPheremone)
	{
		mAnt.reset(mNestXSize / 2, mNestYSize - 2, depositPheremone);
	}

	/**
     * Updates the state of the world
     *
     * @return void
     *
     */
	public void updateState()
	{
		mAnt.move();
	}

	/**
	 * Activates the world swarm
	 *
	 * @param swarmContext
	 *
	 * @return world swarm's activity
	 */
	public Activity activateIn(Swarm swarmContext)
	{
		super.activateIn(swarmContext);
		mSchedule.activateIn(this);

		return getActivity();
	}

	/**
     * Builds the world swarm's objects
     *
     * @return this
     *
     */
	public Object buildObjects()
	{
		int l1;

		// set up nest
		newNest(mNestXSize, mNestYSize);

		return this;
	}

	/**
     * Builds the world swarm's actions
     *
     * @return this
     *
     * @throws RuntimeException if action could not be created
     *
     */
	public Object buildActions()
	{
		mSchedule = new ScheduleImpl(this.getZone(), 1);
		try
		{
			mSchedule.at$createActionTo$message(0, this, new Selector(this.getClass(), "updateState", false));
		}
		catch (Exception exception)
		{
			throw new RuntimeException("Could not create action (" + exception.toString() + ")");
		}

		return this;
	}

	/**
     * WorldSwarm constructor
     *
     * @param zone to create the world swarm in
     *
     * @return void
     *
     */
	public WorldSwarm(Zone zone, int nestXSize, int nestYSize)
	{
		super(zone);
		mNest = null;
		mAnt = null;
		mNestXSize = nestXSize;
		mNestYSize = nestYSize;
	}
}
