// Copyright James Marshall 2003. Freely distributable under the GNU General Public Licence

package buffon;

import swarm.simtoolsgui.GUISwarmImpl;
import swarm.activity.Schedule;
import swarm.activity.ScheduleImpl;
import swarm.activity.Activity;
import swarm.defobj.Zone;
import swarm.Selector;
import swarm.objectbase.Swarm;
import swarm.analysis.EZGraph;
import swarm.analysis.EZGraphImpl;
import swarm.gui.Colormap;
import swarm.gui.ColormapImpl;
import swarm.gui.ZoomRaster;
import swarm.gui.ZoomRasterImpl;
import swarm.space.Value2dDisplay;
import swarm.space.Value2dDisplayImpl;
import swarm.random.UniformIntegerDist;
import swarm.random.UniformIntegerDistImpl;
import swarm.Globals;
import buffon.Ant;
import buffon.WorldSwarm;

/** The observer swarm class */
class ObserverSwarm extends GUISwarmImpl
{
	/** The display schedule */
	private swarm.activity.Schedule mDisplaySchedule;
	/** The world swarm */
	private WorldSwarm mWorldSwarm;
	/** The observer's random number generator */
	private UniformIntegerDist mRandomGenerator;
	/** The graph for displaying the ant's arousal level */
	private EZGraph mArousalGraph;
	/** The raster for displaying the nest */
	private ZoomRaster mRaster;
	/** The colormap for the raster */
	private Colormap mColormap;
	/** The values that the raster displays */
	private Value2dDisplay mValueDisplay;

	/**
	 * Activates the observer swarm
	 *
	 * @param swarmContext
	 *
	 * @return world swarm's activity
	 */
	public Activity activateIn(Swarm swarmContext)
	{
		super.activateIn(swarmContext);
		mWorldSwarm.activateIn(this);
		mDisplaySchedule.activateIn(this);

		return getActivity();
	}

	/**
     * Builds the observer swarm's objects
     *
     * @return this
     *
     * @throw RuntimeException if action could not be created
     *
     */
	public Object buildObjects()
	{
		super.buildObjects();

		Ant ant;
		mWorldSwarm = new WorldSwarm(this.getZone(), 50, 50);
		mWorldSwarm.buildObjects();
		mRandomGenerator = new UniformIntegerDistImpl(Globals.env.globalZone);
		ant = new Ant(mWorldSwarm, true, 5, 1000, 1000, mRandomGenerator);
		mWorldSwarm.setAnt(ant);
		mWorldSwarm.resetAnt(true);
		mArousalGraph = new EZGraphImpl(this.getZone(), "Ant's arousal level", "Time", "Arousal", "arousalGraph");
		try
		{
			mArousalGraph.createSequence$withFeedFrom$andSelector("scout", mWorldSwarm, new Selector(mWorldSwarm.getClass(), "getAntsArousalLevel", false));
		}
		catch (Exception exception)
		{
			throw new RuntimeException("Could not create action (" + exception.toString() + ")");
		}
		mColormap = new ColormapImpl(this.getZone());
		mColormap.setColor$ToName((byte) 0, "green"); // nest wall
		mColormap.setColor$ToName((byte) 1, "black"); // empty space
		mColormap.setColor$ToName((byte) 2, "blue"); // ant
		mColormap.setColor$ToName((byte) 3, "yellow"); // pheremone
		mRaster = new ZoomRasterImpl(this.getZone(), "Nest");
		mRaster.setColormap(mColormap);
		mRaster.setZoomFactor(4);
		mRaster.setWidth$Height(mWorldSwarm.getNest().getSizeX(), mWorldSwarm.getNest().getSizeY());
		mRaster.pack();
		mValueDisplay = new Value2dDisplayImpl(this.getZone(), mRaster, mColormap, mWorldSwarm.getNest());
		mValueDisplay.setDisplayMappingM$C(1, 1);
		mValueDisplay.display();
		mRaster.drawSelf();

		return this;
	}

	/**
     * Builds the observer swarm's actions
     *
     * @return this
     *
     * @throws RuntimeException if cannot create action
     *
     */
	public Object buildActions()
	{
		mWorldSwarm.buildActions();
		mDisplaySchedule = new ScheduleImpl(getZone(), 1);
		try
		{
			mDisplaySchedule.at$createActionTo$message(0, getActionCache(), new Selector(getActionCache().getClass(), "doTkEvents", true));
			mDisplaySchedule.at$createActionTo$message(0, mArousalGraph, new Selector(mArousalGraph.getClass(), "step", true));
			mDisplaySchedule.at$createActionTo$message(0, mValueDisplay, new Selector(mValueDisplay.getClass(), "display", true));
			mDisplaySchedule.at$createActionTo$message(0, mRaster, new Selector(mRaster.getClass(), "drawSelf", true));
		}
		catch (Exception exception)
		{
			throw new RuntimeException("Could not create action (" + exception.toString() + ")");
		}

		return this;
	}

	/**
     * ObserverSwarm constructor
     *
     * @param zone to create the ObserverSwarm in
     *
     * @return void
     *
     */
	public ObserverSwarm(Zone zone)
	{
		super(zone);
		mDisplaySchedule = null;
		mWorldSwarm = null;
		mRandomGenerator = null;
		mArousalGraph = null;
		mRaster = null;
		mColormap = null;
		mValueDisplay = null;
	}
}
