#!/usr/bin/python -O
# -*- coding: iso-8859-15 -*-

##    Copyright 2012, Momme Winkelnkemper <specmate@posteo.de>
##
##    This file is part of SpecMate.
##
##    SpecMate is free software: you can redistribute it and/or modify
##    it under the terms of the GNU General Public License as published by
##    the Free Software Foundation, either version 3 of the License, or
##    (at your option) any later version.
##
##    Specmate is distributed in the hope that it will be useful,
##    but WITHOUT ANY WARRANTY; without even the implied warranty of
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##    GNU General Public License for more details.
##
##    You should have received a copy of the GNU General Public License
##    along with SpecMate.  If not, see <http://www.gnu.org/licenses/>.

"""
This Module implements the Add/Edit Baseline popup windows of the "SpecMate" application.
"""

#----------------------------------------------------------------------------
# packages to import
#----------------------------------------------------------------------------
import sys,os
import copy
import time
try:
	import wx#,wxmpl
except:
	print "Please install wxPython"# and wxmpl packages!"
	sys.exit(1)
try:
	import numpy as na
except:
	print "Please install numpy!"
	sys.exit(1)
#try:
#	from matplotlib.backends.backend_wx import NavigationToolbar2Wx
#except:
#	print "Please install matplotlib package!"
#	sys.exit(1)

from specmate_datasets import specmate_singleDataset
from BGWindow_template import BGWindow_template 
#from specmate_menubar import specmate_menubar
#from specmate_globals import *
#from specmate_settings import *
#----------------------------------------------------------------------------
#----------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
# begin class "specmate_editPointsWindow"
#-----------------------------------------------------------------------------------------
class specmate_createBGWindow(BGWindow_template):
	"""
	Implements "popup" window to select a Background point set.
	"""

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onOK(self,event):
		"""
		Event Handler: OK Buttton
		Free resources and return to main window
		"""
		self.parent.mouseClickReceiver='None'
		self.parent.backend.unlock('background')
		self.Destroy()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------


	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onCancel(self,event):
		"""
		Event Handler: Cancel Buttton
		Free resources, restore backup, and return to main window
		"""
		self.parent.mouseClickReceiver='None'
		self.parent.backend.restoreDataBackup()
		self.parent.backend.unlock('background')
		self.Destroy()
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def _onInterpChoice(self,event):
		self.callback(na.array(self.points),self.interpTypes[self.interpChoice.GetSelection()])
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------


	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def receiver(self,x,y):
		"""
		Receiver function for mouse clicks in the canvas. To be called be the parent window
		@param x: x-coordinate of the mouse click
		@type x: float
		@param y: y-coordinate of the mouse click
		@type y: float
		"""
		if self.removeToggleButton.GetValue()==False:
			self.points.append([x,y])
			self.callback(na.array(self.points),self.interpTypes[self.interpChoice.GetSelection()])
		elif len(self.points)>0:
			points=na.array(self.points)
			dist_x=(na.abs(points[:,0]-x))
			dist_y=(na.abs(points[:,1]-y))
			idx=dist_x.argmin()
			idy=dist_y.argmin()
			print idx,idy
			if ((dist_x[idx]+dist_y[idx])<(dist_x[idy]+dist_y[idy])):
				self.points.pop(idx)
			else:
				self.points.pop(idy)
			self.callback(na.array(self.points),self.interpTypes[self.interpChoice.GetSelection()])
	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------

	#--------------------------------------------------------------------------------
	#--------------------------------------------------------------------------------
	def __init__(self,parent,id,title, **kwds):
		"""
		Constructor: ...
		@param parent: pointer to the parent window
		@type parent: specmate_MainWindow
		"""
		BGWindow_template.__init__(self,parent,id,title, style=wx.DEFAULT_FRAME_STYLE | wx.STAY_ON_TOP|wx.TAB_TRAVERSAL, **kwds)
		self.parent=parent
		self.callback=self.parent.backend.setBackground
		self.points=list(self.parent.backend.background.data)
		self.parent.mouseClickReceiver=self.receiver
		self.interpTypes=self.parent.backend.background.interpTypes
		self.parent.backend.lock('background')
		#.....
		self.interpChoice.Delete(0)
		for each in self.interpTypes:
			self.interpChoice.Append(each)
		self.interpChoice.SetStringSelection(self.parent.backend.background.interpType)
		#......
		self.Bind(wx.EVT_CLOSE,self._onCancel)
		self.SetTitle(title+' <'+self.parent.backend.specData.name+'>')
		self.Show()
#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------

