#!/usr/bin/python -O
# -*- coding: iso-8859-15 -*-

##    Copyright 2012, Momme Winkelnkemper <specmate@posteo.de>
##
##    This file is part of SpecMate.
##
##    SpecMate is free software: you can redistribute it and/or modify
##    it under the terms of the GNU General Public License as published by
##    the Free Software Foundation, either version 3 of the License, or
##    (at your option) any later version.
##
##    Specmate is distributed in the hope that it will be useful,
##    but WITHOUT ANY WARRANTY; without even the implied warranty of
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##    GNU General Public License for more details.
##
##    You should have received a copy of the GNU General Public License
##    along with SpecMate.  If not, see <http://www.gnu.org/licenses/>.

"""
This Module implements the main routine of the "SpecMate" application.
lalalla
"""

#----------------------------------------------------------------------------
# packages to import
#----------------------------------------------------------------------------
import sys,os

try:
	import wx
except:
	print "Please install wxPython!"
	sys.exit(1)

from specmate_globals import appName
from specmate_frontend import MainWindow
from specmate_backend import specmate_backend
#----------------------------------------------------------------------------
#----------------------------------------------------------------------------


#-----------------------------------------------------------------------------------------
#main routine
#-----------------------------------------------------------------------------------------
def specmateMain(argv):
	"""
	Main routine: starts specmate_backend and frontend.
	@param argv: list of arguments.
	@type argv: list of strings
	"""
	backend=specmate_backend(argv)
	app = wx.App()
	mainFrame = MainWindow(None,-1,appName,backend)
	mainFrame.Show()
	app.MainLoop()
#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
if __name__=='__main__':
	specmateMain(sys.argv)
