# -*- coding: utf-8 -*-

#  import.py, Importing a SCORM archive

#  Copyright (C) 2007 Free Software Foundation Europe e.V.

#  This file is part of the SELF Project, a project administered by the
#  SELF Consortium, for which FSFE acts as copyright holder.

#  The SELF Consortium are:
#    Internet Society Nederland
#    Universitat Oberta de Catalunya
#    Free Software Foundation Europe
#    University of Gothenburg
#    Internet Society Bulgaria
#    Fundacion Via Libre
#    Homi Bhabha Centre for Science Education

#  A complete list of authors can be found in the file AUTHORS.

#  This program is Free Software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of the
#  License, or (at your option) any later version.

#  This program is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
#  General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
#  02110-1301, USA.

#  The licensor of <Program Name> is the Free Software Foundation Europe
#  (FSFE), Fiduciary Program, Sumatrastrasse 25, 8006 Zurich,
#  Switzerland, email:ftf@fsfeurope.org.

__author__ = """Divya <divyas15@gmail.com>, Prasanta Kumar Baruah <prasanta.baruah@gmail.com>"""
__docformat__ = 'plaintext'

from Products.selfApp.genericTable import *      # for nid to ssid conversion
from Products.selfApp.Extensions.parsing import LO_instance, import_file
from Products.selfApp.Extensions.file_codec import fun_id
from Products.selfApp.Extensions.newparse import LOMparse
from Products.selfApp.Extensions.file_check import URLCheck
import os, sys, pdb
from xml.sax import make_parser
from xml.sax.handler import ContentHandler
import shutil
import string
import time
import cPickle

# Unzip the SCORM archive and populates the gnowsys database. Takes
# the archive name as the parameter. But before that make sure that
# the SCORM schema is made.

def importFromArchive(self, fpath, colid):
    """
    Collects the environment variables.
    
    Calls the LOMparse class of newparse module to collect LOM info
    Calls the LO_instance and import_file class of parsing module to collect LOs & their content
    Dump LOs to gnowsys & plone
    """
    
    username = self.REQUEST['AUTHENTICATED_USER']
    username = str(username)
    uid = self.gnowql.getUserIdfromUsername(username)
    uid = str(uid)
    inspath = self.portal_url()
    splitpath = inspath.split('/')
    instance_name = str(splitpath[-1])

    instance_name = self.REQUEST['BASE2']
    newpath = instance_name+'/'
    sample = fpath
#    sample = REQUEST['filename']
 

    #Check for ZIP format
    if fpath[-4:] == '.zip':
        pass
    else:
        return '0'
#     filecont = sample.read()

#     #Check for the SCORMImport directory in var & create
#     if os.path.exists(CLIENT_HOME+'/SCORMImport'):
#         pass
#     else:
#         os.system('mkdir '+CLIENT_HOME+'/SCORMImport')

#     #Store the SCORM file in var
#     f = open(CLIENT_HOME+'/SCORMImport/'+sample.filename, 'w')
#     f.write(filecont)
#     f.close()

    #Check for the existence & create user's folder in tmp
    if os.path.exists('/tmp/'+username):
        os.system('rm -rf /tmp/'+username+'/*')
    else:
        os.system('mkdir /tmp/' + username)

#     #Extract SCORM file in user folder
#     extractpath = '/tmp/' + username + '/sample.zip'

#     print extractpath

#     fp1 = open(extractpath, 'w')
#     fp1.write(filecont)

#     print "destination zip is created by", username

#     fp1.close()
    
    os.system('unzip -x ' + fpath + ' -d /tmp/' + username)

    #Take the count of respective LO in the existing DB
    for metadata in ['Courses', 'Content', 'Glossary', 'FaqTopics', 'FaqEntries', 'Links']:
        try:
            item_ssid = self.gnowql.getlatestVersion(metadata)

            item_info_dict = self.gnowql.getinfoFromSSID(item_ssid,'gbobjecttypes')
            no_of_item = item_info_dict['instances']
            
            if no_of_item == None:
                if metadata == 'Courses':
                    Courses_counter = 2
                elif metadata == 'Content':
                    Content_counter = 2
                elif metadata == 'Glossary':
                    Glossary_counter = 2
                elif metadata == 'FaqTopics':
                    FaqTopics_counter = 2
                elif metadata == 'FaqEntries':
                    FaqEntries_counter = 2
                elif metadata == 'Links':
                    Links_counter = 2
            else:
                if metadata == 'Courses':
                    Courses_counter = len(no_of_item) + 2
                elif metadata == 'Content':
                    Content_counter = len(no_of_item) + 2
                elif metadata == 'Glossary':
                    Glossary_counter = len(no_of_item) + 2
                elif metadata == 'FaqTopics':
                    FaqTopics_counter = len(no_of_item) + 2
                elif metadata == 'FaqEntries':
                    FaqEntries_counter = len(no_of_item) + 2
                elif metadata == 'Links':
                    Links_counter = len(no_of_item) + 2
        except:
            if metadata == 'Courses':
                Courses_counter = 2
            elif metadata == 'Content':
                Content_counter = 2
            elif metadata == 'Glossary':
                Glossary_counter = 2
            elif metadata == 'FaqTopics':
                FaqTopics_counter = 2
            elif metadata == 'FaqEntries':
                FaqEntries_counter = 2
            elif metadata == 'Links':
                Links_counter = 2
        
    
    print "success"
    #Initialize parser
    parser = make_parser()
    #parse and collect LOM info
    #curHandler = LOMparse()
    #parser.setContentHandler(curHandler)
    #parser.parse(open('/tmp/'+username+'/imsmanifest.xml'))
    #LOM_object = curHandler.LOMCollection()
    #print LOM_object
    curHandler = LO_instance( username, Courses_counter, Content_counter, Glossary_counter, FaqTopics_counter, FaqEntries_counter, Links_counter)
    
    parser.setContentHandler(curHandler)

    #Check for the presence of manifest file in the archieve and hence SCORM validity
    if os.path.exists('/tmp/' + username + '/imsmanifest.xml'):
        #Convert the encoding of manifest file to UTF-8
        os.system('iconv -f ISO-8859-15 -t UTF-8 /tmp/'+ username+ '/imsmanifest.xml > /tmp/'+username+'/try.xml; rm -f /tmp/' + username + '/imsmanifest.xml; mv /tmp/' + username + '/try.xml /tmp/' + username + '/imsmanifest.xml')

        #parse and collect organizations information
        parser.parse(open('/tmp/' + username + '/imsmanifest.xml'))
        gnowsys_schema = curHandler.gnowsysLO()
        
        seq_coll = curHandler.seqinfo()
        nav_coll = curHandler.navinfo()

        res = curHandler.value()
        print res

        #parse and collect resources info
        curHandler = import_file(res, username, CLIENT_HOME, instance_name)
        parser.setContentHandler(curHandler)
        parser.parse(open('/tmp/' + username + '/imsmanifest.xml'))
        plonefiles = curHandler.plonedata()
        filesList = curHandler.newFileList()
        print filesList
        #return
        #return plonefiles
#         for i in gnowsys_schema[1]:
#             for p in plonefiles:
#                 if i[0] == p[0]:
#                     i.append(p[1])
#                 else:
#                     pass

#        return gnowsys_schema
        #Add LOs to gnowsys
#        return gnowsys_schema[1]
        print "plonefiles: %s" % plonefiles
        print "gnowsys_schema[1]:  %s" % gnowsys_schema[1]
        
        content_file_name = ''
        for sco in gnowsys_schema[1]:
            for p in plonefiles:
                if sco[0] == p[0]:
                    content_file_name = p[1]
                    f = open(p[1], 'r')
                    ccontent = f.read()
                    f.close()
                    # VERY IMPORTANT BREAK!
                    break
                else:
                    ccontent = ''
            print 'Adding: %s\nContent: %s' % ( sco[0], ccontent )

            dictParameters = {
                'nid':sco[0],
                'uid':uid,
                'status':'Public',
                'content':ccontent,
                'title':[sco[1]],
                'description':'',
                'instanceof':[sco[2]]
                }

            try:
                self.gnowql.manageAddObject( dictParameters )

            except:
                os.system('iconv -f ISO-8859-15 -t UTF-8 '+ content_file_name+ ' > /tmp/'+username+'/try.html; rm -f ' + content_file_name + '; mv /tmp/' + username + '/try.html ' + content_file_name)
                f = open(content_file_name, 'r')
                ccontent = f.read()
                f.close()
                dictParameters['content'] = ccontent
                self.gnowql.manageAddObject( dictParameters )
  
            lang_ssid = self.gnowql.getlatestVersion('english')

            if sco[2] == 'Courses':
                ssid_item = self.gnowql.getlatestVersion(sco[0])

                dictParameters = {
                    'uid':uid,
                    'status':'Public',
                    'subject1':ssid_item,
                    'subject2':str(lang_ssid),
                    'relationtypes':'encodedin'
                    }

                self.gnowql.manageAddRelation(dictParameters)

                dictParameters = {
                    'uid':uid,
                    'status':'Public',
                    'subject1':ssid_item,
                    'subject2':colid,
                    'relationtypes':'belongsto'
                    }


                self.gnowql.manageAddRelation(dictParameters)

            elif sco[2] in ['Content', 'Glossary', 'FaqTopics']:
                ssid_item1 = self.gnowql.getlatestVersion(gnowsys_schema[0])
                ssid_item2 = self.gnowql.getlatestVersion(sco[0])

                dictParameters = {
                    'uid':uid,
                    'status':'Public',
                    'subject1':ssid_item2,
                    'subject2':str(lang_ssid),
                    'relationtypes':'encodedin'
                    }

                self.gnowql.manageAddRelation(dictParameters)

                dictParameters = {
                    'uid':uid,
                    'status':'Public',
                    'subject1':ssid_item1,
                    'subject2':ssid_item2,
                    'relationtypes':'haspart'
                    }


                print gnowsys_schema[0]
                sco_ele =  sco[0]
                self.gnowql.manageAddRelation(dictParameters)

            elif sco[2] in ['FaqEntries', 'Links']:
                ssid_item1 = self.gnowql.getlatestVersion(sco[4])
                ssid_item2 = self.gnowql.getlatestVersion(sco[0])

                dictParameters = {
                    'uid':uid,
                    'status':'Public',
                    'subject1':ssid_item2,
                    'subject2':str(lang_ssid),
                    'relationtypes':'encodedin'
                    }

                self.gnowql.manageAddRelation(dictParameters)

                dictParameters = {
                    'uid':uid,
                    'status':'Public',
                    'subject1':ssid_item1,
                    'subject2':ssid_item2,
                    'relationtypes':'references'
                    }


                self.gnowql.manageAddRelation(dictParameters)

                
        
#         con = self.restrictedTraverse('kb/data/attribute/'+ gnowsys_schema[0][0] + '/' + gnowsys_schema[0][1] + '/' +  gnowsys_schema[0] + '.CourseStructure')

        ssid_item = self.gnowql.getlatestVersion(gnowsys_schema[0])
        #ssid_item = self.gnowql.getlatestVersion(sco[0])
        preuri = self.gnowql.geturifromssid( ssid_item , 'gbobjects' )
        finaluri = preuri + '/' + str( ssid_item ) + '_' + 'CourseStructure'
        #return finaluri
        FILE=open(finaluri,'w')

        # TODO:convert all nids to ssids
        print "gnowsys_schema[2]: %s" % gnowsys_schema[2]

        # First find all the unique nids from the structure
        uniqueNids = []
        for pair in gnowsys_schema[2]:
            if pair[0] == '0' or pair[1] == '0':
                continue

            if pair[0] not in uniqueNids:
                uniqueNids.append( pair[0] )

            if pair[1] not in uniqueNids:
                uniqueNids.append( pair[1] )

        print "unique nids: %s" % uniqueNids

        # convert all nids to ssids at one go
        dictSSIDs = self.gnowql.getAllLatestSSIDsFromNids( uniqueNids )

        # now, overwrite gnowsys_schema[2], replacing each 
        # pair of nids with ssids
        temp_schema = []
        for pair in gnowsys_schema[2]:
            newpair = []
            newpair.append( str( int( dictSSIDs[ pair[0] ] ) ) )

            if pair[1] == '0':
                newpair.append( '0' )
            else:
                newpair.append( str( int( dictSSIDs[ pair[1] ] ) ) )

            temp_schema.append( newpair )

        print "new gnowsys_schema[2]: %s" % temp_schema
        gnowsys_schema[2] = temp_schema
        
        cPickle.dump( gnowsys_schema[2], FILE )
        FILE.close()

        
        uniqueNids = []
        for pair in filesList:
            if len(pair[2]) <> 0:
                if pair[0] not in uniqueNids:
                    uniqueNids.append( pair[0] )

        print "unique nids2: %s" % uniqueNids

        # convert all nids to ssids at one go
        if len(uniqueNids) > 0:
            dictSSIDs = self.gnowql.getAllLatestSSIDsFromNids( uniqueNids )
            print 'dictSSIDs: %s' % dictSSIDs

            resInfo = self.gnowql.getAllSSIDCols( dictSSIDs.values(), [ 'nid', 'uri' ], 'gbobjects' )
            print 'resInfo: %s' % resInfo

        # copy all the files to the correct locations
        for f_i in filesList:
            if len(f_i[2]) <> 0:
                print f_i[0]
                
                item_path = f_i[1].split('/')
                path_len = len(item_path)
                for f_ in f_i[2]:
                    maintain_path = resInfo[dictSSIDs[f_i[0]]]['uri'] + '/'
                    file_hrefpath = '/tmp/' + username + '/' +f_.replace('%20', ' ')
                    FilePath = ''
                    #self.file_href = f_
                    rel_file = f_
                    rel_file = rel_file.split('/')
                    rel = rel_file[-1]
                    size = len(rel_file)
                    for i in range(size-1):
		    
                        if i<=(path_len-1) and item_path[i] == rel_file[i]:
			    pass
                        else:
			    #self.count = self.count + 1
			    
			    if os.path.exists(maintain_path+rel_file[i].replace('%20', ' ')):
				   maintain_path = maintain_path + rel_file[i].replace('%20', ' ')+'/'
				   
			    else:
				   os.system('mkdir "'+maintain_path+rel_file[i].replace('%20', ' ')+'"')
				   maintain_path = maintain_path + rel_file[i].replace('%20', ' ')+'/'
			    FilePath = FilePath + rel_file[i].replace('%20', ' ')+'/'
                    if path_len:
                        if item_path[-1] == rel:
			    pass
                        else:
			    if rel[(len(rel)-4):] == 'html':
				    os.chmod(file_hrefpath, 0644)
			    	    URLCheck(self.file_hrefpath)
			    #self.list_of_files.append(self.file_href)
			    os.system('cp "' + file_hrefpath + '" "' + maintain_path + rel+'"')
                            #copy(file_hrefpath, maintain_path+rel)
			    FilePath = FilePath + rel
                    else:
                        if rel[(len(rel)-4):] == 'html':
			    os.chmod(file_hrefpath, 0644)
			    URLCheck(self.file_hrefpath)
                        #self.list_of_files.append(self.file_href)
                        os.system('cp "' + file_hrefpath + '" "' + maintain_path + rel+'"')
                        #copy(file_hrefpath, maintain_path+rel)
                        FilePath = FilePath + rel
        print "Files Copied"
                

#         for i in filesList:
#             if len(i[2]) <> 0:
#                 self.gnowql.getinfoFromSSID( ssidofot ,'gbobjecttypes')['attributetypes']
                
        #self.pickleCourse( str(ssid_item), gnowsys_schema[2] )
    
#         con.setAttributeValue(gnowsys_schema[2])
#        plone_obj = curHandler.ploneLO()
#        print plone_obj
        #Add LOs to plone
        #         for obj in plone_obj:
        #             try:
        #                 con = self.restrictedTraverse('Members/'+username)
        #                 con.invokeFactory('learningObject', obj[0])
        #                 new_con = self.restrictedTraverse('Members/'+username+'/'+obj[0])
        #                 new_con.setTitle(obj[1])
        #                 new_con.reindexObject()
        #             except:
        #                 print "Couldn't add to plone"
        #        res = curHandler.value()
        #        print res

        #parse and collect resources info
        #         curHandler = import_file(res, username, CLIENT_HOME, plone_instance)
        #         parser.setContentHandler(curHandler)
        #         parser.parse(open('/tmp/' + username + '/imsmanifest.xml'))
        #         plonefiles = curHandler.plonedata()
        #         for i in gnowsys_schema[1]:
        #             for p in plonefiles:
        #                 if i[0] == p[0]:
        #                     i.append(p[1])
        #add contents to LOs
        #         for LO_f in plonefiles:
        #             try:
        #                 new_con = self.restrictedTraverse('Members/'+username+'/'+LO_f[0])
        #                 f = open(LO_f[1], 'r')
        #                 ccontent = f.read()
        #                 f.close()
        #                 new_con.setBody(ccontent)
        #             except:
        #                 print "Invalid HTML file"
        HashrefList = curHandler.HashrefList()
        
        #Set the list of all associated files with each LO to its respective Hashref attribute
        #         for LO_href in HashrefList:
        #             new_con = self.restrictedTraverse('kb/data/attribute/'+LO_href[0][0] + '/' + LO_href[0][1] + '/' + LO_href[0] + '.Hashref')
        #             new_con.setAttributeValue(LO_href[1])
        revised_HashrefList = curHandler.RevisedHashrefList()

#         new_Hasreference =[]
#         #In case of presence of 'dependency' tag, Hashref attribute of respective LO to be updated 
#         if len(revised_HashrefList[0]) <> 0:
#             for i in revised_HashrefList[0]:
#                 for j in range(len(i)):
#                     if j == 0:
#                         content_name = i[j]
#                         for obj,ref in zip(revised_HashrefList[1][0], revised_HashrefList[1][1]):
#                             if content_name == ref:
#                                 content_ID = obj
#                     elif j == 1:
#                         pass
#                     else:
#                         for dep in revised_HashrefList[2]:
#                             if i[j] == dep[0]:
#                                 new_Hasreference.append([content_ID])
#                                 #all_files = self.kb.getNeighbourhood(content_ID+'.Hashref', 'attribute', ['value'])[0]
#                                 for file_no in range(len(dep)):
#                                     if file_no == 0:
#                                         pass
#                                     else:
#                                         new_Hasreference[-1].append(dep[file_no])
#                                         #all_files.append(dep[file_no])                                             
#                                hashing = '/'
#                                 for hash in range(self.kb.getProperty('hashLevel')):
#                                     hashing = hashing + content_ID[hash] + '/'
#                                 new_conpath =  'kb/data/attribute'+ hashing + content_ID + '.Hashref'
#                                 con = self.restrictedTraverse(new_conpath)
#                                 con.setAttributeValue(all_files)
#        return new_Hasreference
#         for v in HashrefList:
#             ssidofot = self.gnowql.getlatestVersion('Content')
#             ssid_ot = self.gnowql.getlatestVersion(v[0])
#             atlst = []
#             lstofDict =[]
#             atlst = self.gnowql.getinfoFromSSID( ssidofot ,'gbobjecttypes')['attributetypes']
#             for y in atlst:
#                 if self.gnowql.getinfoFromSSID( y ,'gbattributetypes')['nid'] == 'Hashref':

#                             dictParameters = {
#                                 'uid':uid,
#                                 'status':'Public',
#                                 'instanceof':[y],
#                                 'value':v[1],
#                                 'subject':[ssid_ot]
#                                 }
#                             lstofDict.append(dictParameters)
        
#             self.gnowql.manageAddAttribute( lstofDict )

        os.system('rm -fr /tmp/' + username)
        return '1'
#         return REQUEST.RESPONSE.redirect( newpath +'success')
    else:
        return '0'
        #If gip archive does not contain the imsmanifest file
        
#         print "Invalid Scorm File"
#         return REQUEST.RESPONSE.redirect( newpath +'errmsg')
    os.system('rm -fr /tmp/' + username)
    
    

    
    

