#######################################################################
#  This file is part of GNOWSYS: Gnowledge Networking and
#  Organizing System.
#
#  GNOWSYS is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 3 of
#  the License, or (at your option) any later version.
#
#  GNOWSYS is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public
#  License along with GNOWSYS (gpl.txt); if not, write to the
#  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
#  Boston, MA  02110-1301  USA59 Temple Place, Suite 330,
#
######################################################################
# Contributor: "Dinesh Joshi" <dinesh.joshi@yahoo.com>

import sys
import os
import time
import psycopg2
import psycopg2.extensions
import psycopg2.extras

from storageSpec import *
from pgtable import *
from datatypes import *
from genericTable import *
from dbConnect import *

def traverse( inp_list, op_list ):
    if isinstance( inp_list, list ):
        for l in inp_list:
            traverse( l, op_list )
    else:
        op_list.append( inp_list )
        return

def createStrFromBuffer( buff ):
    op = []
    traverse( buff, op )

    strSQL = ""
    for li in op:
        strSQL = strSQL + ( "%s" % li )

    return strSQL

def usage():
    print "GNOWSYS v1.0 database schema generator"
    print "USAGE:"
    print "-h, --help : print help"
    print "-s, --sql  : generate SQL dump"
    print "-g, --generate <params> : generate schema with the paramters"
    print "    params are: <database name>, <hostname or ip>, <username>, <password>"
	
	
def main():
    try:
        opts, args = getopt.getopt( sys.argv[1:], "hsg", [ "help", "sql", "generate" ] )
    except getopt.GetoptError:
        usage()
        sys.exit(2)
	
    for opt, arg in opts:
        if opt in ( "-h", "--help" ):
            usage()
            sys.exit()
        elif opt in ( "-s", "--sql" ):
            dictConn = {}
            dbobj = dbGenerator( 'newgb', dictConn )
            print dbobj.dumpSQL()
        elif opt in ( "-g", "--generate" ):
            dictConn = { 
                'dbname':args[0], 
                'host':args[1],
                'username':args[2], 
                'password':args[3], 
                }

            dbobj = dbGenerator( args[0], dictConn )
            t1 = time()
            dbobj.generate()
            t2 = time()
            print '%s took %0.3f seconds' % ( "Database creation", ( t2 - t1 ) )
        else:
            usage()
            sys.exit()
            
    source = "".join( args )

class dbGenerator:
    """
    This generates the database schema. If provided with the connection
    parameters, it will directly create the entire schema in the database
    server.
    """
    def __init__( self, dbName, connParams ):
        """
            connParams = { 
                'dbname':dbName, 
                'username':dbUName, 
                'password':dbPwd, 
                'host':dbHost, 
                }
        """
        self.connParams = connParams
        self.dbName = dbName

    def dumpSQL( self ):
        """
        Simply creates the SQL dump of the schema except the CREATE DATABASE statement
        """
        cur = ""
        buff1 = generateSQL()
        buff2 = createViews( cur )
        sql1 = createStrFromBuffer( buff1 )
        sql2 = createStrFromBuffer( buff2 )

        return( sql1 + sql2 )

    def generate( self ):
        """
        Does everything :)
        """
        sql = "CREATE DATABASE %s ENCODING = 'UTF8' TABLESPACE = pg_default TEMPLATE = template0;" % self.dbName

        self.connParams['dbname'] = 'postgres'
        conn = psycopg2.connect( "dbname=%(dbname)s user=%(username)s password=%(password)s host=%(host)s" % self.connParams )
        cur = conn.cursor( cursor_factory = psycopg2.extras.DictCursor )
        conn.set_isolation_level(0)
        cur.execute( sql )
        conn.commit()
        conn.close()

        self.connParams['dbname'] = self.dbName
        conn = psycopg2.connect( "dbname=%(dbname)s user=%(username)s password=%(password)s host=%(host)s" % self.connParams )
        cur = conn.cursor( cursor_factory = psycopg2.extras.DictCursor )
        cur.execute( self.dumpSQL() )

        # Create admin user
        utbl = tbl_gbusers( cur )
        un = 'admin'
        print "Creating default user %s" % ( un )
        uidadmin = utbl.insert( { 'nid':'admin', 'uid':0 }  )

        if uidadmin == 0:
            print "Admin already exists!"
            uidadmin = utbl.get_uid( 'admin' )
            if uidadmin != 0:
                print "Admin uid is %s" % uidadmin
            else:
                print "Error getting admin uid!"

        conn.commit()
        conn.close()


if __name__ == "__main__":
     main()
