# -*- coding: utf-8 -*-

#  SELF Platform: A distributed web application for collaborative
#  production of learning materials employing open standards.

#  Copyright (C) 2007, 2008 Free Software Foundation Europe e.V.

#  This file is part of the SELF Project, a project administered by the
#  SELF Consortium, for which FSFE acts as copyright holder.

#  The SELF Consortium are:
#    Internet Society Nederland
#    Universitat Oberta de Catalunya
#    Free Software Foundation Europe
#    University of Gothenburg
#    Internet Society Bulgaria
#    Fundacion Via Libre
#    Homi Bhabha Centre for Science Education

#  A complete list of authors can be found in the file AUTHORS.

#  This program is Free Software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License as
#  published by the Free Software Foundation; either version 2 of the
#  License, or (at your option) any later version.

#  This program is distributed in the hope that it will be useful, but
#  WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
#  General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
#  02110-1301, USA.

#  The licensor of SELF Platform is the Free Software Foundation
#  Europe (FSFE), Fiduciary Program, Sumatrastrasse 25, 8006 Zurich,
#  Switzerland, email:ftf@fsfeurope.org.

__docformat__ = 'plaintext'
# Contributor: "Dinesh Joshi" <dinesh.joshi@yahoo.com>


import sys
from gnowsysTable import *

class gnowsysDatatypes:
	"""
		Class to manage the datatypes tables
	"""
	def __init__( self, tblName, isPrefixes=0 ):
		
		# Should we add prefixes to the vid table?
		# 1 = yes
		# other = no
		#
		self.tblName = tblName
		self.isPrefixes = isPrefixes
		self.tablePrefix = "datatypes"
		self.lstTables = []
		
		# format is [ 'datatype name', 'description' ]
		self.datatypes = [ 
						[ 'int8',              '' ],
						[ 'bit',               '' ],
						[ 'varbit',            '' ],
						[ 'boolean',           '' ],
						[ 'box',               '' ],
						[ 'bytea',             '' ],
						[ 'varchar',           '' ],
						[ 'char',              '' ],
						[ 'cidr',              '' ],
						[ 'circle',            '' ],
						[ 'date',              '' ],
						[ 'float8',            '' ],
						[ 'inet',              '' ],
						[ 'int4',              '' ],
						[ 'interval',          '' ],
						[ 'line',              '' ],
						[ 'lseg',              '' ],
						[ 'macaddr',           '' ],
						[ 'money',             '' ],
						[ 'numeric',           '' ],
						[ 'path',              '' ],
						[ 'point',             '' ],
						[ 'polygon',           '' ],
						[ 'float4',            '' ],
						[ 'int2',              '' ],
						[ 'text',              '' ],
						[ 'time',              '' ],
						[ 'timestamptz',       '' ],
						[ 'abstime',           '' ],
						[ 'aclitem',           '' ],
						[ 'bpchar',            '' ],
						[ 'cid',               '' ],
						[ 'oid',               '' ],
						[ 'refcursor',         '' ],
						[ 'regclass',          '' ],
						[ 'regoper',           '' ],
						[ 'regoperator',       '' ],
						[ 'regproc',           '' ],
						[ 'regprocedure',      '' ],
						[ 'regtype',           '' ],
						[ 'reltime',           '' ],
						[ 'smgr',              '' ],
						[ 'tid',               '' ],
						[ 'timetz',            '' ],
						[ 'tinterval',         '' ],
						[ 'unknown',           '' ],
						[ 'xid',               '' ],
						[ 'int2vector',        '' ],
						[ 'name',              '' ],
						[ 'oidvector',         '' ],
						[ 'serial',            '' ],
						[ 'serial8',         '' ],
					]

	def getDataTypeTableName( self, datatype ):
		if datatype[ len( datatype ) - 2: ] != '[]':
			dt = datatype
			tmpTblName = self.tablePrefix + "_" + dt
			return tmpTblName
		else:
			# array datatype
			# except smgr and unknown from making array datatypes
			dt = datatype[ :len( datatype ) - 2 ]

			if dt == 'smgr' or dt == 'unknown':
				return -1

			tmpTblName = self.tablePrefix + "_" + dt + "_array"
			return tmpTblName
		

	def createTables( self ):		
		exceptionList = [ 'line',
				  'lseg',
				  'circle',
				  'point',
				  'box',
				  'path',
				  'polygon',
				  'aclitem',
				  'cid',
				  'refcursor',
				  'smgr',
				  'tid',
				  'unknown',
				  'xid',
				  ]
				  
		
		# generate the regular tables
		for dtl in self.datatypes:
			# simple datatype
			dt = dtl[0]
			tmpTblName = self.tablePrefix + "_" + dt
			
			# check the prefixes preference
			if self.isPrefixes == 1:
				tmpDTFldName = dt + "_" + 'vid'
			else:
				tmpDTFldName = 'vid'
			
			tmpDTFldType = 'serial8'
			
			tmpValueFldName = 'value'
			tmpValueFldType = dt

			constraint = 'NOT NULL UNIQUE'
			if dt in exceptionList:
				constraint = ""

			tmpTbl = gnowsysTable( tmpTblName )
			tmpTbl.addFields(
								[
									[ tmpDTFldName   ,    tmpDTFldType    , 'PRIMARY KEY' ],
									[ tmpValueFldName,    tmpValueFldType , constraint ]
								]
							)
			
			self.lstTables.append( tmpTbl )

			# array datatype
			
			# except smgr and unknown from making array datatypes
			if dt == 'smgr' or dt == 'unknown':
				continue
			
			tmpTblName = self.tablePrefix + "_" + dt + "_array"
			
			# check the prefixes preference
			if self.isPrefixes == 1:
				tmpDTFldName = dt + "_array_" + 'vid'
			else:
				tmpDTFldName = 'vid'
				
			tmpDTFldType = 'serial8'
			
			tmpValueFldName = 'value'
			tmpValueFldType = dt + "[]"

			tmpTbl = gnowsysTable( tmpTblName )
			tmpTbl.addFields( 
								[ 
									[ tmpDTFldName   ,    tmpDTFldType    , 'PRIMARY KEY' ],
									[ tmpValueFldName,    tmpValueFldType , constraint ]
								]
							)
			
			self.lstTables.append( tmpTbl )
	
	def populateMainTable( self ):
		strSQL = ""
		for dt in self.datatypes:
			query1 = "INSERT INTO %s ( datatypeid, datatypename, description ) VALUES( DEFAULT, '%s', '%s' );" % ( self.tblName, dt[0], dt[1] )
			query2 = "INSERT INTO %s ( datatypeid, datatypename, description ) VALUES( DEFAULT, '%s', '%s' );" % ( self.tblName, dt[0]+ "[]", "" )
			if dt[0] == 'smgr' or dt[0] == 'unknown':
				query2 = ""

			strSQL = strSQL + "\n" + query1 + "\n" + query2
		
		return strSQL

	
	def genSQL( self ):
		strSQL = ""
		for t in self.lstTables:
			strSQL = strSQL + t.genSQL()
		
		strSQL = strSQL + self.populateMainTable()
		return strSQL
	
	def genHTML( self ):
		strHTML = ""
		
		for ft in self.lstTables:
			strHTML = strHTML + ft.genHTML()
		
		return( strHTML )



if __name__ == '__main__':
	# Some test code
	# Generates both HTML as well as SQL code
	d = gnowsysDatatypes(1)
	d.createTables()
	
	print d.genHTML()
	print d.populateMainTable()
	print d.genSQL()
	
