# Copyright (C) 2009, 2010  Roman Zimbelmann <romanz@lavabit.com>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from ranger import relpath
import mimetypes
import os.path

class MimeTypeAware(object):
	mimetypes = {}
	def __init__(self):
		MimeTypeAware.__init__ = lambda _: None  # refuse multiple inits
		mimetypes.knownfiles.append(os.path.expanduser('~/.mime.types'))
		MimeTypeAware.mimetypes = mimetypes.MimeTypes()
		MimeTypeAware.mimetypes.read(relpath('data/mime.types'))
