// This file is part of the pdr/pdx project.
// Copyright (C) 2010 Torsten Mueller, Bern, Switzerland
//
// This program is free software: you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation, either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#include "common.h"

using namespace std;
using namespace boost;
using namespace boost::posix_time;
using namespace boost::gregorian;
using namespace boost::program_options;

#include "datatypes.h"

//=== Xception =============================================================
Xception::Xception (const string& message)
	: m_message(message)
{
}

Xception::Xception (const format& message)
	: m_message(message.str())
{
}

Xception::~Xception ()
{
}

const string& Xception::Message () const
{
	return m_message;
}

//=== Xarning ==============================================================
Xarning::Xarning (const string& message)
	: Xception(message)
{
}

Xarning::Xarning (const format& message)
	: Xception(message)
{
}

//=== Ratio ================================================================
Ratio::Ratio (double numerator, double denominator)
	: m_numerator(numerator)
	, m_denominator(denominator)
{
}
