// This file is part of the pdr/pdx project.
// Copyright (C) 2010 Torsten Mueller, Bern, Switzerland
//
// This program is free software: you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation, either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#include "../libpdrx/common.h"

using namespace std;
using namespace boost;
using namespace boost::posix_time;
using namespace boost::gregorian;
using namespace boost::program_options;

#include "../libpdrx/datatypes.h"
#include "../libpdrx/config.h"
#include "db_impl.h"

//=== Database (abstract base class) =======================================
Database::~Database ()
{
}

//=== DBFactory ============================================================
Database* DBFactory::Create (const Config& config) throw (Xception)
{
	const string& database_type = config.GetStringOption("database.type");
	if (database_type.empty())
		throw Xception("missing specification in configuration file: database.type");

	Database* pDatabase = NULL;
#ifdef USE_SQLITE
	if (database_type == "sqlite")
	{
		const string& database_connect = config.GetFilenameOption("database.connect");
		if (database_connect.empty())
			throw Xception("missing specification in configuration file: database.connect");
		pDatabase = new SQLiteDatabase(database_connect, config.GetBoolOption("verbose"));
	}
	else
#endif
#ifdef USE_MYSQL
	if (database_type == "mysql")
	{
		const string& database_connect = config.GetFilenameOption("database.connect");
		if (database_connect.empty())
			throw Xception("missing specification in configuration file: database.connect");
		pDatabase = new MySQLDatabase(database_connect, config.GetBoolOption("verbose"));
	}
	else
#endif
	throw Xception(format("invalid database.type specification in configuration file: %s") % database_type);

	try
	{
		pDatabase->Connect();
		return pDatabase;
	}
	catch (...)
	{
		delete pDatabase;
		throw;
	}
}
