/*
--             This file is part of the New World OS project
--                 Copyright (C) 2004-2007  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- $Log: types.h,v $
-- Revision 1.11  2007/08/09 23:47:44  jsedwards
-- Removed the junk to cope with the 64-bit filesystem junk on Linux.  Now
-- using the _FILE_OFFSET_BITS=64 thing instead.
--
-- Revision 1.10  2007/08/07 00:24:23  jsedwards
-- Add typedefs for bool8 and bool16.
--
-- Revision 1.9  2007/07/01 19:44:12  jsedwards
-- Upgrade to GPLv3.
--
-- Revision 1.8  2007/03/14 13:13:45  jsedwards
-- Kludged off_t and lseek for 32-bit Linux (why doesn't this work right in
-- the first place?).
--
-- Revision 1.7  2007/02/11 16:32:37  jsedwards
-- Added define for O_LARGEFILE when not on Linux.
--
-- Revision 1.6  2006/12/01 14:39:23  jsedwards
-- Fix the year in the copyright.
--
-- Revision 1.5  2006/11/11 12:01:07  jsedwards
-- Update e-mail address to something that works.
--
-- Revision 1.4  2006/10/26 01:51:29  jsedwards
-- Merged alpha_05_branch back into main trunk.
--
-- Revision 1.3.2.1  2006/10/17 12:41:06  jsedwards
-- Changed type of int32 and uint32 to signed int and unsigned int
-- respectively, because it turns out that signed and unsigned long
-- are 64 bits on 64 bit machines.
--
-- Revision 1.3  2005/12/10 15:03:36  jsedwards
-- Fixed header to say the GPL is in the LICENSE file instead of COPYING.
--
-- Revision 1.2  2005/11/26 15:08:07  jsedwards
-- Added include of <sys/types.h>.
--
-- Revision 1.1.1.1  2005/11/25 12:44:27  jsedwards
-- Copied from 'lab'.
--
-- Revision 1.10  2005/11/23 20:17:09  jsedwards
-- Added a 'bool' type.
--
-- Revision 1.9  2004/10/31 18:20:31  jsedwards
-- Moved object and time stamp stuff to 'objects.h' and 'time_stamp.h'.
--
-- Revision 1.8  2004/10/31 13:57:15  jsedwards
-- Added TimeStamp and ObjHeader definitions.
--
-- Revision 1.7  2004/10/20 13:39:34  jsedwards
-- Change to have a string as input to base32 conversion macro.
--
-- Revision 1.6  2004/10/20 12:11:26  jsedwards
-- Changed from doing 12 characters in macro to all 13 characters.
--
-- Revision 1.5  2004/10/19 14:41:50  jsedwards
-- Added Base 32 junk and started on code classes.
--
-- Revision 1.4  2004/10/18 13:48:24  jsedwards
-- Changed the definitions again.
--
-- Revision 1.3  2004/10/18 13:40:54  jsedwards
-- Added another comment and updated the defines.
--
-- Revision 1.2  2004/10/18 13:28:08  jsedwards
-- Changed comment, values are *NOT* updated.
--
-- Revision 1.1.1.1  2004/10/18 12:58:37  jsedwards
-- Initial import.
--
*/

#ifndef TYPES_H
#define TYPES_H


#include <sys/types.h>    /* define system types like size_t */

typedef signed char      int8;
typedef signed short     int16;
typedef signed int       int32;
typedef signed long long int64;

typedef unsigned char      uint8;
typedef unsigned short     uint16;
typedef unsigned int       uint32;
typedef unsigned long long uint64;

typedef enum { false = 0, true = 1 } bool;

typedef signed char bool8;
typedef signed short bool16;

#endif

