--
--             This file is part of the New World OS project
--                 Copyright (C) 2006-2007  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- $Log: nwos_source_file.e,v $
-- Revision 1.2  2007/07/01 19:44:14  jsedwards
-- Upgrade to GPLv3.
--
-- Revision 1.1  2007/04/14 02:24:19  jsedwards
-- Move Fine (Eiffel) files to next_gen directory.
--
-- Revision 1.7  2006/11/11 12:29:19  jsedwards
-- Update e-mail address to something that works.
--
-- Revision 1.6  2006/02/19 15:55:18  jsedwards
-- Changed the name of NWOS_HEADER to NWOS_OBJECT.
--
-- Revision 1.5  2006/02/18 20:35:23  jsedwards
-- Changed attributes to a routine that makes sure the object is loaded before
-- returning the value.
--
-- Revision 1.4  2006/02/18 15:37:06  jsedwards
-- Changed name of "storage" in NWOS_STRING class to "to_string" so it makes
-- more sense in the clients.
--
-- Revision 1.3  2006/02/15 14:28:52  jsedwards
-- Eliminated set_name and set_procurement routines and incorporated them
-- into the "make" routine.
--
-- Revision 1.2  2006/02/14 14:25:53  jsedwards
-- Removed extra class, still not ready for prime time.
--
-- Revision 1.1  2006/02/14 14:19:07  jsedwards
-- Initial version, untested.
--

class NWOS_SOURCE_FILE

inherit NWOS_OBJECT

creation make, make_unresolved


feature

   name: STRING is
      do
         load_if_not_already
         Result := name_obj.to_string
      ensure
         Result /= Void
      end

   procurement: NWOS_PROCUREMENT is
      do
         load_if_not_already
         Result := procurement_obj
      ensure
         Result /= Void
      end

   references: ARRAY[NWOS_OBJECT] is
      do
         load_if_not_already
         Result := references_obj
      ensure
         Result /= Void
      end


feature

   add_reference(ref: NWOS_OBJECT) is
      do
         references.add_last(ref)
      end


feature {NONE}

   make(path: STRING; procure: NWOS_PROCUREMENT) is
      do
         initialize_header(next_nwos_identifier)

         !!name_obj.copy_from_string(path)

         procurement_obj := procure
         procurement_obj.add_reference(Current)

         !!references_obj.with_capacity(8, 1)
      end

   write_body_to_stream(stream: BINARY_OUTPUT_STREAM) is
      require
         name_obj /= Void
         procurement_obj /= Void
      local
         i: INTEGER
      do
         name_obj.write_to_stream(stream)

         procurement_obj.class_definition.identifier.write_to_stream(stream)
         procurement_obj.identifier.write_to_stream(stream)

         from
            i := references_obj.lower
         until
            i > references_obj.upper
         loop
            references_obj.item(i).class_definition.identifier.write_to_stream(stream)
            references_obj.item(i).identifier.write_to_stream(stream)
            i := i + 1
         end

         Void_reference.write_to_stream(stream)
      end

   read_body_from_stream(stream: BINARY_INPUT_STREAM) is
      local
         obj: NWOS_OBJECT
         class_ref: NWOS_REFERENCE
         object_ref: NWOS_REFERENCE
      do
         !!name_obj.read_from_stream(stream)

std_output.put_string("NWOS_SOURCE_FILE.read_body_from_stream")
std_output.put_string("%N  name: ")
std_output.put_string(name_obj.to_string)
std_output.put_new_line

         !!class_ref.make_from_stream(stream)
         !!object_ref.make_from_stream(stream)
         procurement_obj ?= object_ref.get_object(class_ref)

         if procurement_obj = Void then
            std_error.put_string("NWOS_SOURCE_FILE.read_body_from_stream: procurement failed to load%N")
            die_with_code(exit_failure_code)
         end

         !!references_obj.with_capacity(8, 1)

         from
            !!class_ref.make_from_stream(stream)
         until
            class_ref.is_void
         loop
            !!object_ref.make_from_stream(stream)

std_output.put_string("NWOS_SOURCE_FILE.read_body_from_stream")
std_output.put_string("%N  class: ")
std_output.put_string(class_ref.to_string)
std_output.put_string("%N  object: ")
std_output.put_string(object_ref.to_string)
std_output.put_new_line

            obj := object_ref.get_object(class_ref)
            references_obj.add_last(obj)

            !!class_ref.make_from_stream(stream)
         end
      end


feature {NONE}  -- actual objects

   name_obj: NWOS_STRING

   procurement_obj: NWOS_PROCUREMENT

   references_obj: ARRAY[NWOS_OBJECT]


feature {NONE}  -- once again the kludgy class definition stuff

   class_revision: STRING is
      once
         !!Result.copy("$Revision: 1.2 $")
         Result.remove_prefix("$Revision: ")
         Result.remove_suffix(" $")
      end

   class_reference: NWOS_REFERENCE is
      do
         Result := Class_source_file_ref
      end

end

