--
--             This file is part of the New World OS project
--                 Copyright (C) 2006-2007  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- $Log: nwos_noun.e,v $
-- Revision 1.2  2007/07/01 19:44:13  jsedwards
-- Upgrade to GPLv3.
--
-- Revision 1.1  2007/04/14 02:24:16  jsedwards
-- Move Fine (Eiffel) files to next_gen directory.
--
-- Revision 1.7  2006/11/11 12:29:19  jsedwards
-- Update e-mail address to something that works.
--
-- Revision 1.6  2006/02/26 15:42:54  jsedwards
-- Removed the "spelling" attribute from nwos_word and added two spellings
-- here: "singular" and "plural".
--
-- Revision 1.5  2006/02/25 04:47:04  jsedwards
-- Added it's own "make" procedure to create the "is_a" feature.
--
-- Revision 1.4  2006/02/10 13:55:34  jsedwards
-- Changed "load" in creation clause to "make_unresolved".
--
-- Revision 1.3  2006/02/09 12:51:27  jsedwards
-- Changed to the new method of doing the class defintion stuff, with the
-- "class reference" and "class revision".
--
-- Revision 1.2  2006/02/08 14:21:10  jsedwards
-- Added "load" to creation clause and predefined reference to class
-- definition "make" call.
--
-- Revision 1.1  2006/02/05 16:15:19  jsedwards
-- Initial version.
--


class NWOS_NOUN

inherit NWOS_WORD
           redefine
              make,
              class_revision,
              class_reference
           end

creation make, make_unresolved


feature

   singular: NWOS_SPELLING is
      do
         load_if_not_already
         Result := singular_obj
      ensure
         Result /= Void
      end

   plural: NWOS_SPELLING is
      do
         load_if_not_already
         Result := plural_obj
      ensure
         Result /= Void
      end


feature {NONE}

   make(alphabet: NWOS_ALPHABET; sng, pl: NWOS_SPELLING) is
      do
         if Class_word_ref.has_object then
             class_def_obj ?= Class_word_ref.object
             if class_def_obj = Void then
                std_error.put_string("NWOS_NOUN.make class_definition is void%N")
                die_with_code(exit_failure_code)
             end
         else   -- this class hasn't been created yet
            !!class_def_obj.make(Class_word_ref, "NWOS_WORD", class_revision)
         end
         class_def_obj.add_reference(Current)

         precursor(alphabet, spell)
      end


feature {NONE}  -- actual storage

   singular_obj: like singular

   plural_obj: like plural


feature {NONE}  -- once again the kludgy class definition stuff

   class_revision: STRING is
      once
         !!Result.copy("$Revision: 1.2 $")
         Result.remove_prefix("$Revision: ")
         Result.remove_suffix(" $")
      end

   class_reference: NWOS_REFERENCE is
      do
         Result := Class_noun_ref
      end

end

