/*
--             This file is part of the New World OS project
--                Copyright (C) 2006-2007  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- $Log: old_multifile_objectify.h,v $
-- Revision 1.2  2007/07/01 19:44:12  jsedwards
-- Upgrade to GPLv3.
--
-- Revision 1.1  2006/12/05 12:42:02  jsedwards
-- Moved old_multifile_objectify files to attic.
--
-- Revision 1.3  2006/11/11 12:01:05  jsedwards
-- Update e-mail address to something that works.
--
-- Revision 1.2  2006/10/26 01:51:28  jsedwards
-- Merged alpha_05_branch back into main trunk.
--
-- Revision 1.1.2.2  2006/09/11 11:28:14  jsedwards
-- Removed structures for classes that didn't exist in Alpha 0005 version.
--
-- Revision 1.1.2.1  2006/09/10 20:45:28  jsedwards
-- Old definitions, structures, and routine declarations from the Alpha 0005
-- version (each object stored in a separate file).
--
*/

#ifndef OLD_MULTIFILE_OBJECTIFY_H
#define OLD_MULTIFILE_OBJECTIFY_H

#include "time_stamp.h"
#include "types.h"


#define FILE_BLOCK_SIZE 512


typedef union { uint8 id[4]; uint32 word; } ObjRef;


typedef struct {
    uint8     magic_number[4];            /*   4 */  /* nwos */
    uint8     version[4];                 /*   8 */  /* version of header 1-999 */
    uint8     header_chksum[4];           /*  12 */  /* CRC32 of header */
    uint8     data_chksum[4];             /*  16 */  /* CRC32 of data   */
    TimeStamp creation_time;              /*  24 */
    TimeStamp access_time;                /*  32 */  /* used when in memory for caching */
    ObjRef    class_definition;           /*  36 */
} CommonHeader;


typedef struct {
    ObjRef    clone_of;                   /*   4 */
    ObjRef    references;                 /*   8 */
    ObjRef    context;                    /*  12 */
    ObjRef    created_by_user;            /*  16 */
    ObjRef    created_by_app;             /*  20 */
    ObjRef    prev_version;               /*  24 */
    ObjRef    next_version;               /*  28 */
} ObjectHeader;


typedef struct {
    CommonHeader common;                  /*  36 */
    ObjectHeader object;                  /*  64 */
} EveryObject;

typedef struct {
    CommonHeader common_header;           /*  36 */
    ObjRef       references[0];
} ReferenceList;



/*
-- Predefined classes
*/


typedef struct {
    EveryObject header;
    ObjRef      name;
    uint8       count;
    ObjRef      feature[0];
} C_struct_class_definition;


typedef struct {
    EveryObject header;
    uint8       md5sum[16];
} C_struct_MD5sum;


typedef struct {
    EveryObject header;
    ObjRef      class_definition_class;
} C_struct_Root;


typedef struct {
    EveryObject header;
    ObjRef      character_set;
    uint8       count;
    uint8       storage[0];
} C_struct_Spelling;


typedef struct {
    EveryObject header;
    uint8       count;
    ObjRef      spelling[0];
} C_struct_Name;


typedef struct {
    EveryObject header;
    ObjRef      thing;
    ObjRef      language;
    ObjRef      spelling;
} C_struct_Word;


typedef struct {
    EveryObject header;
    ObjRef      abbr_of;
    ObjRef      language;
    ObjRef      spelling;
} C_struct_Abbreviation;


typedef struct {         /* this class should inherit from thing, if we had inheritance */
    EveryObject header;
    ObjRef      definition;
} C_struct_Language;


typedef struct {
    EveryObject header;
    ObjRef      name;
    ObjRef      date;
    ObjRef      capital;
    ObjRef      postal_code;
    uint8       number;
} C_struct_US_State;


typedef struct {               /* need inheritence for this to inherit from a general city */
    EveryObject header;
    ObjRef      name;
    ObjRef      state;
    ObjRef      country;
} C_struct_US_City;


typedef struct {
    EveryObject header;
    ObjRef      state;
    ObjRef      area;
    char        storage[3];
} C_struct_Area_Code;


typedef struct {
    EveryObject header;
    ObjRef      country;
    ObjRef      area_code;
    char        storage[7];
} C_struct_Phone_Number;


typedef struct {
    EveryObject header;
    ObjRef      residence;   /* entity this goes to */
    ObjRef      number;
} C_struct_Home_Phone;


typedef struct {
    EveryObject header;
    ObjRef      person;     /* entity this goes to */
    ObjRef      number;
} C_struct_Mobile_Phone;


typedef struct {
    EveryObject header;
    ObjRef      business;
    ObjRef      person;     /* entity this goes to */
    ObjRef      number;
    ObjRef      extension;
} C_struct_Work_Phone;


typedef struct {
    EveryObject header;
    uint8       count;
    char        storage[0];  /* leave room for things like 1,000,000 BC */
} C_struct_Year;


typedef struct {         /* this class should inherit from thing, if we had inheritance */
    EveryObject header;
    ObjRef      definition;
    char        storage[2];  /* 1-12 - note names should be found from references for different languages */
    uint8       minimum_days;
    uint8       maximum_days;
} C_struct_Month;


typedef struct {
    EveryObject header;
    ObjRef      year;
    ObjRef      month;
    uint8       day_of_month;
} C_struct_Date;


typedef struct {         /* this class should inherit from thing, if we had inheritance */
    EveryObject header;
    ObjRef      definition;
} C_struct_Gender;


typedef struct {
    EveryObject header;
    ObjRef      gender;
    ObjRef      title;        /* Dr. etc */
    ObjRef      first_name;
    ObjRef      middle_name;
    ObjRef      last_name;
    ObjRef      maiden_name;
    ObjRef      preferred_name;
    ObjRef      goes_by;
    ObjRef      nick_name;
    ObjRef      birth_date;
    ObjRef      birth_place;
    ObjRef      death_date;
    ObjRef      death_place;
    ObjRef      height;
    ObjRef      mailing_address;
} C_struct_Person;


typedef struct {
    EveryObject header;
    char        person;
    char        storage[9];
} C_struct_Social_Security_Number;



static inline bool is_void_reference(ObjRef* ref)
{
    int i;
    for (i = 0; i < sizeof(ref); i++) if (ref->id[i] != 0) return false;
    return true;
}


static inline bool is_same_object(ObjRef* ref1, ObjRef* ref2)
{
    int i;
    for (i = 0; i < sizeof(ObjRef); i++) if (ref1->id[i] != ref2->id[i]) return false;
    return true;
}


extern ObjRef old_class_definition_class_ref;
extern ObjRef old_reference_list_class_ref;

extern void old_initialize_objectify(uint8 bf_key[16], uint32 linear, uint32 serial);
extern void old_set_root_object(ObjRef* ref);

extern void old_seed_sequence(uint32 linear_seed, uint32 serial_seed);
extern uint32 old_next_sequence();
extern void old_get_key_from_password(uint8 key[], size_t key_size);

extern void old_ref_to_name(ObjRef* ref, char name[]);

extern size_t old_reference_list_size(ObjRef* ref);
extern void old_get_object_class(ObjRef* obj, ObjRef* object_class);

extern void old_read_object_from_disk(ObjRef* ref, void* object, size_t size);
extern void old_read_variable_sized_object_from_disk(ObjRef* ref, void* obj, size_t (*size_function)(void*));
extern void old_read_reference_list_from_disk(ObjRef* ref, ReferenceList* object, size_t size);

extern void old_remove_object(ObjRef* ref);

extern bool old_name_to_string(ObjRef* ref, char* string, size_t size);

#endif



