#ifdef __cplusplus
extern "C" {
#endif
/*
ANSI C code generated by:
--------------------------------------------------------------------
 Fine - Release 0.11x18 [alpha] (Sunday 01-Mar-2004)
  Copyright (C) 2001-2003 QRW Software - http://www.qrwsoftware.com
  J. Scott Edwards - sedwards@qrwsoftware.com
  http://fine.sourceforge.net
 Based upon SmallEiffel Release -0.76
  Copyright (C), 1994-2000 - LORIA - UHP - CRIN - INRIA - FRANCE
  Dominique COLNET and Suzanne COLLIN - colnet@loria.fr
  http://SmallEiffel.loria.fr
--------------------------------------------------------------------
*/
#ifdef __cplusplus
}
#endif
#include "convert_csv_to_c_structs.h"
#ifdef __cplusplus
extern "C" {
#endif

/*
  This file (fine/lib/runtime/base.c) is included for ALL modes of 
  compilation (-no_check, -system_check ... -all_check, -debug_check).
*/

/*
  The wrapper for `malloc' (generated C code is supposed to use 
  only `se_malloc' instead of direct `malloc').
*/
void* se_malloc(size_t size) {
  void *result = malloc(size);
  if (result == NULL) {
#ifdef SE_EXCEPTIONS
    internal_exception_handler(No_more_memory);
#elif SE_CHECK
    error0("No more memory.", NULL);
#else
  fprintf(SE_ERR,"No more memory.\n");
  se_print_run_time_stack();
  se_exit(EXIT_FAILURE);
#endif
  }
  return result;
}

/*
  The wrapper for `calloc' (generated C code is supposed to use 
  only `se_calloc' instead of direct `calloc').
*/
void* se_calloc(size_t nmemb, size_t size) {
  void *result = calloc(nmemb,size);
  if (result == NULL) {
#ifdef SE_EXCEPTIONS
    internal_exception_handler(No_more_memory);
#elif SE_CHECK
    error0("No more memory.", NULL);
#else
  fprintf(SE_ERR,"No more memory.\n");
  se_print_run_time_stack();
  se_exit(EXIT_FAILURE);
#endif
  }
  return result;
}

void se_exit(int exit_code)
{
#ifdef SE_DEBUGGER
  debugger();
#else
  exit(exit_code);
#endif
}

T6 se_is_reg(T8 path)
{
  int result = 0;
  struct stat buf;
  if (stat((char*)path, &buf) == 0) result = S_ISREG(buf.st_mode);
  return result;
}

T6 se_is_dir(T8 path)
{
  int result = 0;
  struct stat buf;
  if (stat((char*)path, &buf) == 0) result = S_ISDIR(buf.st_mode);
  return result;
}

T6 se_is_lnk(T8 path)
{
  int result = 0;
  struct stat buf;
  if (lstat((char*)path, &buf) == 0) result = S_ISLNK(buf.st_mode);
  return result;
}


int machine_is_little_endian()
{
  int word = 1;
  char *cptr = (char*) &word;
  return (int) *cptr;
}

/* $Revision: 1.4 $ */

T52 M52={52,0,NULL,NULL,NULL};


void se_prinT52(T52**o){
if(*o==NULL){
fprintf(SE_ERR,"Void");
return;
}
fprintf(SE_ERR,"STRING_POOL");
fprintf(SE_ERR,"#%p",*o);
fprintf(SE_ERR,"\n\t[ ");
fprintf(SE_ERR,"check_for_capacity_changes = ");
se_prinT6((&((*o)->_check_for_capacity_changes)));
fprintf(SE_ERR,"\n\t  ");
fprintf(SE_ERR,"available = ");
se_prinT0((T0**)(&((*o)->_available)));
fprintf(SE_ERR,"\n\t  ");
fprintf(SE_ERR,"on_loan = ");
se_prinT0((T0**)(&((*o)->_on_loan)));
fprintf(SE_ERR,"\n\t  ");
fprintf(SE_ERR,"num_alloc = ");
se_prinT0((T0**)(&((*o)->_num_alloc)));
fprintf(SE_ERR,"\n\t]");
}
T40 M40={40,NULL,0,0};


void se_prinT40(T40**o){
if(*o==NULL){
fprintf(SE_ERR,"Void");
return;
}
fprintf(SE_ERR,"FIXED_ARRAY[CLASS_DEFINITION]");
fprintf(SE_ERR,"#%p",*o);
fprintf(SE_ERR,"\n\t[ ");
fprintf(SE_ERR,"storage = ");
se_prinT42((&((*o)->_storage)));
fprintf(SE_ERR,"\n\t  ");
fprintf(SE_ERR,"capacity = ");
se_prinT2((&((*o)->_capacity)));
fprintf(SE_ERR,"\n\t  ");
fprintf(SE_ERR,"upper = ");
se_prinT2((&((*o)->_upper)));
fprintf(SE_ERR,"\n\t]");
}


void se_prinT8(T8*o){
 if (*o == NULL) {
   fputs("NULL",SE_ERR);
 }
 else {
   fprintf(SE_ERR,"POINTER#%p",*o);
 }
}


void se_prinT6(T6*o){
 fprintf(SE_ERR,(*o)?"True":"False");
}
T44 M44={44,NULL,0,0};


void se_prinT44(T44**o){
if(*o==NULL){
fprintf(SE_ERR,"Void");
return;
}
fprintf(SE_ERR,"FIXED_ARRAY[SPELLING]");
fprintf(SE_ERR,"#%p",*o);
fprintf(SE_ERR,"\n\t[ ");
fprintf(SE_ERR,"storage = ");
se_prinT46((&((*o)->_storage)));
fprintf(SE_ERR,"\n\t  ");
fprintf(SE_ERR,"capacity = ");
se_prinT2((&((*o)->_capacity)));
fprintf(SE_ERR,"\n\t  ");
fprintf(SE_ERR,"upper = ");
se_prinT2((&((*o)->_upper)));
fprintf(SE_ERR,"\n\t]");
}
T25 M25={25,0,NULL,NULL};


void se_prinT25(T25**o){
if(*o==NULL){
fprintf(SE_ERR,"Void");
return;
}
fprintf(SE_ERR,"NAME");
fprintf(SE_ERR,"#%p",*o);
fprintf(SE_ERR,"\n\t[ ");
fprintf(SE_ERR,"reference = ");
se_prinT17((&((*o)->_reference)));
fprintf(SE_ERR,"\n\t  ");
fprintf(SE_ERR,"spellings = ");
se_prinT0((T0**)(&((*o)->_spellings)));
fprintf(SE_ERR,"\n\t  ");
fprintf(SE_ERR,"name_string = ");
se_prinT7((EIF_STRING*)(&((*o)->_name_string)));
fprintf(SE_ERR,"\n\t]");
}


void se_prinT3(T3*o){
 if (*o == '\'') {
   fputs("'%''",SE_ERR);
 } else {
   fputc('\'',SE_ERR);
   se_puTchar(*o,SE_ERR);
   fputc('\'',SE_ERR);
 }
}


void se_prinT46(T46*o){
fprintf(SE_ERR,"NATIVE_ARRAY[SPELLING]");
fprintf(SE_ERR,"#%p",*o);
}
T32 M32={32,NULL,NULL};


void se_prinT32(T32**o){
if(*o==NULL){
fprintf(SE_ERR,"Void");
return;
}
fprintf(SE_ERR,"STD_FILE_WRITE");
fprintf(SE_ERR,"#%p",*o);
fprintf(SE_ERR,"\n\t[ ");
fprintf(SE_ERR,"path = ");
se_prinT7((EIF_STRING*)(&((*o)->_path)));
fprintf(SE_ERR,"\n\t  ");
fprintf(SE_ERR,"output_stream = ");
se_prinT8((&((*o)->_output_stream)));
fprintf(SE_ERR,"\n\t]");
}
T64 M64={64,NULL,0,0};


void se_prinT64(T64**o){
if(*o==NULL){
fprintf(SE_ERR,"Void");
return;
}
fprintf(SE_ERR,"FIXED_ARRAY[NAME]");
fprintf(SE_ERR,"#%p",*o);
fprintf(SE_ERR,"\n\t[ ");
fprintf(SE_ERR,"storage = ");
se_prinT66((&((*o)->_storage)));
fprintf(SE_ERR,"\n\t  ");
fprintf(SE_ERR,"capacity = ");
se_prinT2((&((*o)->_capacity)));
fprintf(SE_ERR,"\n\t  ");
fprintf(SE_ERR,"upper = ");
se_prinT2((&((*o)->_upper)));
fprintf(SE_ERR,"\n\t]");
}
T57 M57={57,NULL,0,0};


void se_prinT57(T57**o){
if(*o==NULL){
fprintf(SE_ERR,"Void");
return;
}
fprintf(SE_ERR,"FIXED_ARRAY[CIRCULAR_QUEUE[STRING]]");
fprintf(SE_ERR,"#%p",*o);
fprintf(SE_ERR,"\n\t[ ");
fprintf(SE_ERR,"storage = ");
se_prinT60((&((*o)->_storage)));
fprintf(SE_ERR,"\n\t  ");
fprintf(SE_ERR,"capacity = ");
se_prinT2((&((*o)->_capacity)));
fprintf(SE_ERR,"\n\t  ");
fprintf(SE_ERR,"upper = ");
se_prinT2((&((*o)->_upper)));
fprintf(SE_ERR,"\n\t]");
}


void se_prinT42(T42*o){
fprintf(SE_ERR,"NATIVE_ARRAY[CLASS_DEFINITION]");
fprintf(SE_ERR,"#%p",*o);
}
T67 M67={67,NULL,0,0};


void se_prinT67(T67**o){
if(*o==NULL){
fprintf(SE_ERR,"Void");
return;
}
fprintf(SE_ERR,"FIXED_ARRAY[STRING]");
fprintf(SE_ERR,"#%p",*o);
fprintf(SE_ERR,"\n\t[ ");
fprintf(SE_ERR,"storage = ");
se_prinT61((&((*o)->_storage)));
fprintf(SE_ERR,"\n\t  ");
fprintf(SE_ERR,"capacity = ");
se_prinT2((&((*o)->_capacity)));
fprintf(SE_ERR,"\n\t  ");
fprintf(SE_ERR,"upper = ");
se_prinT2((&((*o)->_upper)));
fprintf(SE_ERR,"\n\t]");
}


void se_prinT61(T61*o){
fprintf(SE_ERR,"NATIVE_ARRAY[STRING]");
fprintf(SE_ERR,"#%p",*o);
}


void se_prinT48(T48*o){
fprintf(SE_ERR,"NATIVE_ARRAY[FEATURE_DEFINITION]");
fprintf(SE_ERR,"#%p",*o);
}
T7 M7={7,NULL,0,0,0};


void se_prinT7(T7**o){
 if (*o == NULL) {
   fputs("Void",SE_ERR);
 }
 else {
   char* storage = (char*)(*o)->_storage;
   int count = (*o)->_count;
   int key = (*o)->_key;
   fprintf(SE_ERR,"STRING#%p\n",*o);
   fprintf(SE_ERR,"\t\t[ key = %d (%s)\n",
     key,(key==0)?"mutable":"immutable");
   fprintf(SE_ERR,"\t\t  capacity = %d\n",(*o)->_capacity);
   fprintf(SE_ERR,"\t\t  count = %d\n",count);
   fputs("\t\t  storage = \"",SE_ERR);
   if (se_longesTline(storage,count) <= 48)
     se_puTshortlines(SE_ERR,storage,count,"%\n\t\t            %");
   else
     se_puTlonglines(SE_ERR,storage,count,"%\n\t\t            %",48);
   fputs("\"\n\t\t]",SE_ERR);
 }
}
T62 M62={62,0,NULL,NULL,0};


void se_prinT62(T62**o){
if(*o==NULL){
fprintf(SE_ERR,"Void");
return;
}
fprintf(SE_ERR,"STD_FILE_READ");
fprintf(SE_ERR,"#%p",*o);
fprintf(SE_ERR,"\n\t[ ");
fprintf(SE_ERR,"push_back_flag = ");
se_prinT6((&((*o)->_push_back_flag)));
fprintf(SE_ERR,"\n\t  ");
fprintf(SE_ERR,"path = ");
se_prinT7((EIF_STRING*)(&((*o)->_path)));
fprintf(SE_ERR,"\n\t  ");
fprintf(SE_ERR,"input_stream = ");
se_prinT8((&((*o)->_input_stream)));
fprintf(SE_ERR,"\n\t  ");
fprintf(SE_ERR,"memory = ");
se_prinT2((&((*o)->_memory)));
fprintf(SE_ERR,"\n\t]");
}


void se_prinT9(T9*o){
fprintf(SE_ERR,"NATIVE_ARRAY[CHARACTER]");
fprintf(SE_ERR,"#%p",*o);
}


void se_prinT17(T17*o){
 fprintf(SE_ERR,"%u",*o);
}
T58 M58={58,NULL,0,0,0};


void se_prinT58(T58**o){
if(*o==NULL){
fprintf(SE_ERR,"Void");
return;
}
fprintf(SE_ERR,"CIRCULAR_QUEUE[STRING]");
fprintf(SE_ERR,"#%p",*o);
fprintf(SE_ERR,"\n\t[ ");
fprintf(SE_ERR,"storage = ");
se_prinT61((&((*o)->_storage)));
fprintf(SE_ERR,"\n\t  ");
fprintf(SE_ERR,"capacity = ");
se_prinT2((&((*o)->_capacity)));
fprintf(SE_ERR,"\n\t  ");
fprintf(SE_ERR,"upper = ");
se_prinT2((&((*o)->_upper)));
fprintf(SE_ERR,"\n\t  ");
fprintf(SE_ERR,"head = ");
se_prinT2((&((*o)->_head)));
fprintf(SE_ERR,"\n\t]");
}
T24 M24={24,0,NULL};


void se_prinT24(T24**o){
if(*o==NULL){
fprintf(SE_ERR,"Void");
return;
}
fprintf(SE_ERR,"SPELLING");
fprintf(SE_ERR,"#%p",*o);
fprintf(SE_ERR,"\n\t[ ");
fprintf(SE_ERR,"reference = ");
se_prinT17((&((*o)->_reference)));
fprintf(SE_ERR,"\n\t  ");
fprintf(SE_ERR,"spelling = ");
se_prinT7((EIF_STRING*)(&((*o)->_spelling)));
fprintf(SE_ERR,"\n\t]");
}
T22 M22={22,0,NULL,NULL};


void se_prinT22(T22**o){
if(*o==NULL){
fprintf(SE_ERR,"Void");
return;
}
fprintf(SE_ERR,"CLASS_DEFINITION");
fprintf(SE_ERR,"#%p",*o);
fprintf(SE_ERR,"\n\t[ ");
fprintf(SE_ERR,"reference = ");
se_prinT17((&((*o)->_reference)));
fprintf(SE_ERR,"\n\t  ");
fprintf(SE_ERR,"name = ");
se_prinT0((T0**)(&((*o)->_name)));
fprintf(SE_ERR,"\n\t  ");
fprintf(SE_ERR,"features = ");
se_prinT0((T0**)(&((*o)->_features)));
fprintf(SE_ERR,"\n\t]");
}
T53 M53={53,NULL,0,0};


void se_prinT53(T53**o){
if(*o==NULL){
fprintf(SE_ERR,"Void");
return;
}
fprintf(SE_ERR,"FIXED_ARRAY[INTEGER]");
fprintf(SE_ERR,"#%p",*o);
fprintf(SE_ERR,"\n\t[ ");
fprintf(SE_ERR,"storage = ");
se_prinT55((&((*o)->_storage)));
fprintf(SE_ERR,"\n\t  ");
fprintf(SE_ERR,"capacity = ");
se_prinT2((&((*o)->_capacity)));
fprintf(SE_ERR,"\n\t  ");
fprintf(SE_ERR,"upper = ");
se_prinT2((&((*o)->_upper)));
fprintf(SE_ERR,"\n\t]");
}


void se_prinT60(T60*o){
fprintf(SE_ERR,"NATIVE_ARRAY[CIRCULAR_QUEUE[STRING]]");
fprintf(SE_ERR,"#%p",*o);
}


void se_prinT2(T2*o){
 fprintf(SE_ERR,"%d",*o);
}
T18 M18={18,NULL};


void se_prinT18(T18**o){
if(*o==NULL){
fprintf(SE_ERR,"Void");
return;
}
fprintf(SE_ERR,"CONVERT_CSV_TO_C_STRUCTS");
fprintf(SE_ERR,"#%p",*o);
fprintf(SE_ERR,"\n\t[ ");
fprintf(SE_ERR,"out_file = ");
se_prinT0((T0**)(&((*o)->_out_file)));
fprintf(SE_ERR,"\n\t]");
}


void se_prinT66(T66*o){
fprintf(SE_ERR,"NATIVE_ARRAY[NAME]");
fprintf(SE_ERR,"#%p",*o);
}
T26 M26={26,0,0,NULL,0};


void se_prinT26(T26**o){
if(*o==NULL){
fprintf(SE_ERR,"Void");
return;
}
fprintf(SE_ERR,"FEATURE_DEFINITION");
fprintf(SE_ERR,"#%p",*o);
fprintf(SE_ERR,"\n\t[ ");
fprintf(SE_ERR,"reference = ");
se_prinT17((&((*o)->_reference)));
fprintf(SE_ERR,"\n\t  ");
fprintf(SE_ERR,"type = ");
se_prinT17((&((*o)->_type)));
fprintf(SE_ERR,"\n\t  ");
fprintf(SE_ERR,"name = ");
se_prinT0((T0**)(&((*o)->_name)));
fprintf(SE_ERR,"\n\t  ");
fprintf(SE_ERR,"number = ");
se_prinT2((&((*o)->_number)));
fprintf(SE_ERR,"\n\t]");
}


void se_prinT55(T55*o){
fprintf(SE_ERR,"NATIVE_ARRAY[INTEGER]");
fprintf(SE_ERR,"#%p",*o);
}
T43 M43={43,NULL,0,0};


void se_prinT43(T43**o){
if(*o==NULL){
fprintf(SE_ERR,"Void");
return;
}
fprintf(SE_ERR,"FIXED_ARRAY[FEATURE_DEFINITION]");
fprintf(SE_ERR,"#%p",*o);
fprintf(SE_ERR,"\n\t[ ");
fprintf(SE_ERR,"storage = ");
se_prinT48((&((*o)->_storage)));
fprintf(SE_ERR,"\n\t  ");
fprintf(SE_ERR,"capacity = ");
se_prinT2((&((*o)->_capacity)));
fprintf(SE_ERR,"\n\t  ");
fprintf(SE_ERR,"upper = ");
se_prinT2((&((*o)->_upper)));
fprintf(SE_ERR,"\n\t]");
}
T51 M51={51};


void se_prinT51(T51**o){
if(*o==NULL){
fprintf(SE_ERR,"Void");
return;
}
fprintf(SE_ERR,"STD_OUTPUT");
fprintf(SE_ERR,"#%p",*o);
}
T50 M50={50};


void se_prinT50(T50**o){
if(*o==NULL){
fprintf(SE_ERR,"Void");
return;
}
fprintf(SE_ERR,"STD_ERROR");
fprintf(SE_ERR,"#%p",*o);
}


/*
  This file (fine/lib/runtime/check.c) is automatically included 
  when `system_check' is true (ie. all modes except -no_check).
*/

/* 
   To print object into the trace-stack :
*/
void se_prinT0(T0** o) {
  if (*o == NULL) {
    fprintf(SE_ERR,"Void");
  }
  else {
    fprintf(SE_ERR,"#%p",(void*)*o);
  }
}


/* Special routines to assist in printing characters and strings. */
/* They are called by the se_prinTn routines, which are generated */
/* by the TYPE_CHARACTER and TYPE_STRING classes in the compiler. */

#include <ctype.h>  /* define isprint function */

/* returns number of characters that are output in a string for this char */
int se_counTchar(unsigned char c) {
  int n = 4;
  if (c == '\0' || strchr("\b\f\n\r\t\"%",c) != NULL) return 2;
  if (isprint(c)) return 1;
  if (c > 9) n++;
  if (c > 99) n++;
  return n;
}

/* Output a character in Eiffel format, it is called by the            */
/* se_prinT<character id> routine generated by the TYPE_CHARACTER      */
/* class and the se_puTshortlines and se_puTlonglines functions below. */
void se_puTchar(unsigned char c, FILE* stream) {
  switch (c) {
    case '\0': fputs("%U",stream); break;
    case '\b': fputs("%B",stream); break;
    case '\f': fputs("%F",stream); break;
    case '\n': fputs("%N",stream); break;
    case '\r': fputs("%R",stream); break;
    case '\t': fputs("%T",stream); break;
    case '%':  fputs("%%",stream); break;
    default:
      if (isprint(c)) {
	fputc(c, stream);
      }
      else {
	fprintf(stream,"%%/%u/",c);
      }
  }
}

/* This function returns number of characters that will be output for    */
/* the longest line in a string, it is called by the se_prinT<string id> */
/* routine generated by the TYPE_STRING class in the compiler.           */
int se_longesTline(char* storage, int count) {
  int len = 0;
  int max = 0;
  int nl = 0;
  char c;
  while (count--) {
    c = *storage++;
    len += se_counTchar(c);
    if (c == '\n' || c == '\r') {
      nl = 1;
    }
    else if (nl) {
      if (len > max) max = len;
      len = 0;
      nl = 0;
    }
  }
  if (len > max) max = len;
  return max;
}

/* Output a string in Eiffel format, where each line of the string is */
/* printed on it's own line, it is called by the se_prinT<string id>  */
/* routine generated by the TYPE_STRING class in the compiler.        */
void se_puTshortlines(FILE* stream, char *p, int count, char *nlstr) {
  int nl = 0;
  char c;
  while (count--) {
    c = *p++;
    if (c == '\n' || c == '\r') {
      nl = 1;
    }
    else if (nl) {
      fputs(nlstr,stream);  /* go to next line */
      nl = 0;
    }
    if (c == '"') {
      fputs("%\"", stream);
    }
    else {
      se_puTchar(c, stream);
    }
  }
}

/* Output a string in Eiffel format, where the string is       */
/* printed in a block, it is called by the se_prinT<string id> */
/* routine generated by the TYPE_STRING class in the compiler. */
void se_puTlonglines(FILE *stream, char *p, int count, char* nlstr, int max) {
  int n = max;
  char c;
  while (count--) {
    c = *p++;
    if (n < se_counTchar(c)) {
      fputs(nlstr,stream);  /* go to next line */
      n = max;
    }
    if (c == '"') {
      fputs("%\"", stream);
    }
    else {
      se_puTchar(c, stream);
    }
    n -= se_counTchar(c);
  }
}


EIF_INTEGER se_position2line(se_position position) {
  /* 
     Computes the line number using the given `position'.
  */
  if (position & 1) {
    return ((EIF_INTEGER)((position >> 1) & 0x7FFF));
  }
  else{
    return ((EIF_INTEGER)((position >> 8) & 0x1FFF));
  }
}

EIF_INTEGER se_position2column(se_position position) {
  /* 
     Computes the column number using the given `position'.
  */
  if (position & 1) {
    return 0; /* Not memorized. */
  }
  else{
    return ((EIF_INTEGER)((position >> 1) & 0x7F));
  }
}

EIF_INTEGER se_position2path_id(se_position position) {
  /* 
     Computes the file path id using the given `position'.
  */
  return ((EIF_INTEGER)((position & 1) ? 
			(position >> 17) : 
			(position >> 21)));
}

/*
  The upper most context (SmallEiffel Dump stack Top) :
*/
se_dump_stack* se_dst=NULL;

void se_print_run_time_stack(void) {
  /* GENERAL.print_run_time_stack */
  se_dump_stack* ds = NULL;
  se_dump_stack* ds2;
  int frame_count = 1;

  ds = se_dst;
  if (ds == NULL) {
    fprintf(SE_ERR,"Empty stack.\n");
    return ;
  }
  else {
    while (ds->caller != NULL) {
      ds = ds->caller;
      frame_count++;
    }
  }
  fprintf(SE_ERR,"%d frames in current stack.\n",frame_count);
  fprintf(SE_ERR,"=====  Bottom of run-time stack  =====\n");
  while (ds != NULL) {
    if (ds->fd != NULL) {
      se_print_one_frame(ds);
    }
    else {
      fprintf(SE_ERR,"External CECIL call.\n");
    }
    /* Next frame : */
    if (ds == se_dst) {
      ds = NULL;
    }
    else {
      ds2 = se_dst;
      while (ds2->caller != ds) {
	ds2 = ds2->caller;
      }
      ds = ds2;
    }
    if (--frame_count) {
      fprintf(SE_ERR,"======================================\n");
    }
  }
  fprintf(SE_ERR,"=====   Top of run-time stack    =====\n");
}

void se_print_one_frame(se_dump_stack* ds) {
  se_frame_descriptor* fd = ds->fd;
  int i = 0;
  int local_count = 0;
  char* local_format = fd->local_format;
  int expanded;
  int id;
  void** var;
  fprintf(SE_ERR,"%s\n",fd->name);
  if (fd->use_current) {
    fprintf(SE_ERR,"Current = ");
    i = 2;
    id = 0;
    while (local_format[i] != '%') {
      id = (id * 10) + (local_format[i] - '0');
      i++;
    }
    i++;
    (se_prinT[id])(ds->current);
    fprintf(SE_ERR,"\n");
  }
  while (local_count < fd->local_count) {
    while (local_format[i] != '%') {
      fprintf(SE_ERR,"%c",local_format[i]);
      i++;
    }
    i++;
    expanded = ((local_format[i++] == 'E')?1:0);
    fprintf(SE_ERR," = ");
    id = 0;
    while (local_format[i] != '%') {
      id = (id * 10) + (local_format[i] - '0');
      i++;
    }
    i++;
    var = (ds->locals)[local_count];
    if (expanded) {
      (se_prinT[id])((void**)(var));
    }
    else if (*var == NULL) {
      fprintf(SE_ERR,"Void");
    }
    else {
      (se_prinT[((T0*)(*var))->id])((void**)(var));
    }
    fprintf(SE_ERR,"\n");
    local_count++;
  }
  if (ds->p != 0) {
    fprintf(SE_ERR,"line %d ",se_position2line(ds->p));
    fflush(SE_ERR);
    fprintf(SE_ERR,"column %d ",se_position2column(ds->p));
    fflush(SE_ERR);
    fprintf(SE_ERR,"file %s \n",p[se_position2path_id(ds->p)]);
    fflush(SE_ERR);
  }
}

void se_core_dump(char*msg) {
  if (msg != NULL) {
    fprintf(SE_ERR,"%s\n",msg);
  }
#ifdef SE_EXCEPTIONS
  print_exception();
#endif
  se_print_run_time_stack();
  se_exit(EXIT_FAILURE);
}

int se_require_uppermost_flag;

/*
  Require Last Result :
*/
int se_require_last_result;

int se_rci(void*C) {
  /* Return 1 if class invariant must be checked for Current 
     before leaving the routine.
  */
  se_dump_stack*ds = se_dst;
  ds = ds->caller;
  if (ds != NULL) {
    se_frame_descriptor* fd = ds->fd;
    if (fd == NULL) {
      /* As for example when coming via CECIL. */
      return 0;
    }
    else {
      if (fd->use_current) {
	if (fd->local_format[1] == 'R') {
	  if (((void*)*(ds->current)) == C) {
	    return 0;
	  }
	}
      }
    }
  }
  return 1;
}

void error0(char*m,char*vv) {
  static char*f1="*** Error at Run Time *** : %s\n";
  static char*f2="*** Error at Run Time *** : %s\n";
  fprintf(SE_ERR,f1,m);
  if (vv!=NULL)
     fprintf(SE_ERR,f2,vv);
#ifdef SE_EXCEPTIONS
  print_exception();
#endif
  se_print_run_time_stack();
  fprintf(SE_ERR,f1,m);
  if (vv!=NULL)
     fprintf(SE_ERR,f2,vv);
  se_exit(EXIT_FAILURE);
}

void error1(char*m,se_position position) {
  int l = se_position2line(position);
  int c = se_position2column(position);
  int f = se_position2path_id(position);
  char* f1 = "Line : %d column %d in %s.\n";
  char* f2 = "*** Error at Run Time *** : %s\n";
  
  fprintf(SE_ERR,f1,l,c,p[f]);
  fprintf(SE_ERR,f2,m);
#ifdef SE_EXCEPTIONS
  print_exception();
#endif
  se_print_run_time_stack();
  fprintf(SE_ERR,f1,l,c,p[f]);
  fprintf(SE_ERR,f2,m);
  se_exit(EXIT_FAILURE);
}

void se_print_string(FILE*stream, EIF_STRING s) {
  /* To print some Eiffel STRING. */
  if (s == NULL) {
    fprintf(stream,"Void");
  }
  else {
    int count = s->_count;
    EIF_CHARACTER* storage = s->_storage;
    int i = 0;
    fprintf(stream,"\"");
    while (count != 0) {
      fprintf(stream,"%c",storage[i]);
      i++;
      count--;
    }
    fprintf(stream,"\"");
  }
}

void se_print_bad_target(FILE*stream, int id, T0* o, int l, int c, int f) {
  /* Print Bad Target Type Error Message. */
  if (l != 0) {
    fprintf(stream,"Line : %d column %d in %s.\n",l,c,p[f]);
  }
  fprintf(stream,"*** Error at Run Time *** :\n");
  fprintf(stream,"   Target is not valid (not the correct type).\n");
  fprintf(stream,"   Expected: ");
  se_print_string(stream,t[id]);
  fprintf(stream,", Actual: ");
  se_print_string(stream,t[o->id]);
  fprintf(stream,".\n");
}

void error2(T0*o, se_position position) {
  fprintf(SE_ERR,"Target Type ");
  se_print_string(SE_ERR,t[o->id]);
  fprintf(SE_ERR," is not valid.\n");
  error1("Bad target.",position);
}

T0* vc(void*o,se_position position) {
  /*
    VoidCheck for reference target.
  */
  if (o != NULL) {
    return ((T0*)o);
  }
  else {
#ifdef SE_EXCEPTIONS
    internal_exception_handler(Void_call_target);
#else
    error1("Call with a Void target.",position);
#endif
    return NULL;
  }
}

T0* ci(int id,void*o,se_position position) {
  /*
    Check Id for reference target.
  */
  vc(o,position);
  if (id == (((T0*)o)->id)) {
    return ((T0*)o);
  }
  else {
#ifdef SE_EXCEPTIONS
    internal_exception_handler(Routine_failure);
#else
    int l = se_position2line(position);
    int c = se_position2column(position);
    int f = se_position2path_id(position);

    se_print_bad_target(SE_ERR,id,(T0*)o,l,c,f);
    se_print_run_time_stack();
    se_print_bad_target(SE_ERR,id,(T0*)o,l,c,f);
    se_exit(EXIT_FAILURE);
#endif
  }
  return ((T0*)o);
}

void ac_req(int v,char*vv) {
  if (!v && se_require_uppermost_flag) {
#ifdef SE_EXCEPTIONS
    internal_exception_handler(Precondition);
#else
    error0("Require Assertion Violated.",vv);
#endif
  }
  se_require_last_result=se_require_last_result&&v;
}

void ac_ens(int v,char*vv) {
  if (!v) {
#ifdef SE_EXCEPTIONS
    internal_exception_handler(Postcondition);
#else
    error0("Ensure Assertion Violated.",vv);
#endif
  }
}

void ac_inv(int v,char*vv) {
  if (!v) {
#ifdef SE_EXCEPTIONS
    internal_exception_handler(Class_invariant);
#else
    error0("Class Invariant Violation.",vv);
#endif
  }
}

void ac_liv(int v,char*vv) {
  /* Assertion Check : Loop Invariant check. */
  if (!v) {
#ifdef SE_EXCEPTIONS
    internal_exception_handler(Loop_invariant);
#else
    error0("Loop Invariant Violation.",vv);
#endif
  }
}

int ac_lvc(int lc,int lv1,int lv2) {
  /* Assertion Check : Loop Variant check. */
  if (lc == 0) {
    if (lv2 < 0) {
#ifdef SE_EXCEPTIONS
      internal_exception_handler(Loop_variant);
#else
      se_print_run_time_stack();
      fprintf(SE_ERR,"Bad First Variant Value = %d\n",lv2);
      se_exit(EXIT_FAILURE);
#endif
    }
    else {
      return lv2;
    }
  }
  else if ((lv2 < 0) || (lv2 >= lv1)) {
#ifdef SE_EXCEPTIONS
    internal_exception_handler(Loop_variant);
#else
    se_print_run_time_stack();
    fprintf(SE_ERR,"Loop Body Count = %d (done)\n",lc);
    fprintf(SE_ERR,"New Variant = %d\n",lv2);
    fprintf(SE_ERR,"Previous Variant = %d\n",lv1);
    se_exit(EXIT_FAILURE);
#endif
  }
  return lv2;
}

void ac_civ(int v,char*vv) {
  if (!v) {
#ifdef SE_EXCEPTIONS
    internal_exception_handler(Check_instruction);
#else
    error0("Check Assertion Violated.",vv);
#endif
  }
}

void se_evobt(void*o,se_position position) {
  /*
    Error Void Or Bad Type.
  */
  if (!o) {
#ifdef SE_EXCEPTIONS
    internal_exception_handler(Void_call_target);
#else
    error1("Target is Void.",position);
#endif
  }
  else {
#ifdef SE_EXCEPTIONS
    internal_exception_handler(Void_call_target);
#else
    error2(((T0*)o),position);
#endif
  }
}

void sigrsp(int sig) {
  printf("Received signal %d (man signal).\n",sig);
  se_print_run_time_stack();
  se_exit(EXIT_FAILURE);
}

void se_gc_check_id(void*o,int id) {
  if (id != (((T0*)o)->id)) {
#ifdef SE_EXCEPTIONS
    internal_exception_handler(Routine_failure);
#else
    fprintf(SE_ERR,"System-validity error detected during GC cycle.\n");
    se_print_bad_target(SE_ERR,id,(T0*)o,0,0,0);
    se_print_run_time_stack();
    fprintf(SE_ERR,"System-validity error detected during GC cycle.\n");
    se_print_bad_target(SE_ERR,id,(T0*)o,0,0,0);
    se_exit(EXIT_FAILURE);
#endif
  }
}

/* $Revision: 1.4 $ */



/*
  This file (sys/runtime/trace.c) is automatically included when 
  `system_check' is true (ie. all modes except -no_check).
  This file comes after no_check.[hc] to implements the -trace flag.
*/


#ifdef SE_WEDIT
/* 
   Smooth interface with the Wedit debugger.
*/
#define MAXBREAKPOINTS 256
static int __BreakpointsList[MAXBREAKPOINTS];
void SE_CallDebugger(void) {
}

se_position se_trace(se_position p) {
  int l = se_position2line(p);
  int c = se_position2column(p);
  int f = se_position2path_id(p);
  int i,s;
  
  s = (f <<16)|l;
  for (i=0; i< MAXBREAKPOINTS;i++) {
    if (__BreakpointsList[i] == s) {
      SE_CallDebugger();
    }
    else if (__BreakpointsList[i] == 0)
      break;
  }
  return p;
}
#elif SE_TRACE
/*
  The SmallEiffel -trace is used, so the command line SmallEiffel 
  step-by-step se_trace function is defined.
*/
static FILE* se_trace_file = NULL;
static int se_write_trace_flag = 0;
static int se_trace_ready_flag = 0;
static int se_step_by_step_flag = 1;

int get_answer(void) {
  int result = 0;
  char c = getc(stdin);
  if (c != '\n') {
    result = c;
  }
  while (c != '\n') {
    c = getc(stdin);
  }
  return result;
}

static void sedb_help_command(void) {
  printf("SmallEiffel debugger.\n");
  printf("List of classes of commands:\n");
  printf("   (h) Help.\n");
  printf("   (s) Stack view.\n");
  printf("   (q) Quit.\n");
  printf("   Return to see the current Eiffel source line.");
  printf("   \n");
  printf("Please, feel free to debug or to complete this simple\n");
  printf("step-by-step debugger (see source file in\n");
  printf("\"fine/lib/runtime/trace.c\".\n");
}

static void sedb_show_source_line(int l,int c,int f) {
  static int f_memo = 0;
  if (p[f] == NULL) {
    printf("line %d column %d of ???\t\t",l,c);
  }
  else {
    FILE *file = fopen(p[f],"r");
    if (file != NULL) {
      int line = 1;
      int column = 1;
      char cc;
      while (line < l) {
	cc = fgetc(file);
	if (cc == '\n') {
	  line++;
	}
      }
      cc = fgetc(file);
      while (cc != '\n') {
	if (cc == '\t') {
	  printf("        ");
	  column+=7;
	}
	else {
	  fputc(cc,stdout);
	}
	cc = fgetc(file);
	column++;
      }
      while (column < 72) {
	fputc(' ',stdout);
	column++;
      }
      printf("l%dc%d ",l,c);
      if (f_memo != f) {
	printf(" %s ",p[f]);
      }
      f_memo = f;
      fclose(file);
    }
    else {
      printf("line %d column %d of %s\t\t",l,c,p[f]);
    }
  }
}

void se_trace(se_dump_stack*ds, se_position position) {
  if (se_trace_flag) {
    static char cmd_memo = 1;
    static char cmd;
    int l = se_position2line(position);
    int c = se_position2column(position);
    int f = se_position2path_id(position);
    ds->p = position;
    if (se_trace_ready_flag) {
      if (se_write_trace_flag) {
	fprintf(se_trace_file,"line %d column %d in %s\n",l,c,p[f]);
	fflush(se_trace_file);
      }
    next_command:
      if (se_step_by_step_flag) {
	if (cmd_memo != 0) {
	  printf("(sedb) ");
	}
	fflush(stdout);
	cmd = get_answer();
	cmd_memo = cmd;
	if ((cmd == 'h') || (cmd == 'H') || (cmd == '?')) {
	  sedb_help_command();
	  goto next_command;
	}
	else if ((cmd == 's') || (cmd == 'S')) {
	  se_print_run_time_stack();
	  goto next_command;
	}
	else if ((cmd == 'q') || (cmd == 'Q')) {
	  exit(EXIT_FAILURE);
	}
	else if (cmd == 0) {
	  sedb_show_source_line(l,c,f);
	}
	else {
	  printf("Unknown command.\nTtype H for help\n");
	  goto next_command;
	}
      }
    }
    else {
      se_trace_ready_flag = 1;
      printf("Write the execution trace in \"trace.se\" file (y/n) ? [n]");
      fflush(stdout);
      if (get_answer() == 'y') {
	se_write_trace_flag = 1;
	se_trace_file = fopen("trace.se","w");
      }
      printf("Step-by-step execution (y/n) ? [y]");
      fflush(stdout);
      if (get_answer() == 'n') {
	se_step_by_step_flag = 0;
      }
      else {
	sedb_help_command();
      }
    }
  }
}
#endif

/* $Revision: 1.4 $ */


/*
  This file (sys/runtime/exception.c) is automatically included 
  when exception handling is used somewhere in the live code.
*/

/*
  Miscellaneous Notes:
  We are currently using the old signal() system call instead of 
  the prefered sigaction() call.  
  
  On Linux systems at least, signal() is implemented by sigaction() 
  so it doesn't really matter.  Need to investigate this on other
  Unix systems.

  James Graves (ansible@xnet.com)
*/

/* 
   Top of the rescue context stack (or NULL if there is no current
   context) :
*/
struct rescue_context *rescue_context_top = NULL;

/* 
   Set to nonzero if the exception was internally generated, as with an
   assertion violation.  It is Os_signal (11) for an OS signal.
*/
int internal_exception_number;
int original_internal_exception_number;

/* 
   Set to nonzero if the exception was a signal (external).  It is 0
   for an internal exception.
*/
int signal_exception_number;

/*
   Used by some internal exceptions to print additional debugging
   information when the exception is not handled and a dump is done.
*/
char *additional_error_message;

static void critical_error_exit(void) {
/* This is called whenever a critical error in the SmallEiffel
   is encountered.  This kind of error cannot be handled by the
   exception handler.
   
   For instance, this routine is called if there is an error in the
   operation of the exception handler routines themselves.
*/
  fprintf(SE_ERR, "There was a critical error in the SmallEiffel runtime.\n");
  se_exit(EXIT_FAILURE);
}

void setup_signal_handler() {
/*
  Sets up the reception of signals.  If exception handling is enabled
  (by the existance of a rescue clause somewhere), then all OS signals
  now go to exception_handler instead of se_print_run_time_stack().
*/
#ifdef SIG_ERR
/* Check signal() call for errors.  Posix compliant systems should
   define SIG_ERR which is returned by signal() on an error. All Unix 
   signals are included except * for SIGKILL and SIGSTOP.  
   
   The other signals SmallEiffel traps for
   other OSs (like SIGBREAK) are not included here, but are below
   in the #else part, for non-Posix systems.
*/

#ifdef SIGHUP
   if ( SIG_ERR == signal( SIGHUP, signal_exception_handler ) ) 
      {
      fprintf(SE_ERR, "Error setting up signal handler for SIGHUP.\n");
      critical_error_exit();
      }
#endif
       
#ifdef SIGINT
   if ( SIG_ERR == signal( SIGINT, signal_exception_handler ) ) {
      fprintf(SE_ERR, "Error setting up signal handler for SIGINT.\n");
      critical_error_exit();
      }
#endif
       
#ifdef SIGQUIT
   if ( SIG_ERR == signal( SIGQUIT, signal_exception_handler ) ) {
      fprintf(SE_ERR, "Error setting up signal handler for SIGQUIT.\n");
      critical_error_exit();
      }
#endif
       
#ifdef SIGILL
   if ( SIG_ERR == signal( SIGILL, signal_exception_handler ) ) {
      fprintf(SE_ERR, "Error setting up signal handler for SIGILL.\n");
      critical_error_exit();
      }
#endif
       
#ifdef SIGTRAP
   if ( SIG_ERR == signal( SIGTRAP, signal_exception_handler ) ) {
      fprintf(SE_ERR, "Error setting up signal handler for SIGTRAP.\n");
      critical_error_exit();
      }
#endif
       
#ifdef SIGIOT
   if ( SIG_ERR == signal( SIGIOT, signal_exception_handler ) ) {
      fprintf(SE_ERR, "Error setting up signal handler for SIGIOT.\n");
      critical_error_exit();
      }
#endif
       
#ifdef SIGBUS
   if ( SIG_ERR == signal( SIGBUS, signal_exception_handler ) ) {
      fprintf(SE_ERR, "Error setting up signal handler for SIGBUS.\n");
      critical_error_exit();
      }
#endif
       
#ifdef SIGFPE
   if ( SIG_ERR == signal( SIGFPE, signal_exception_handler ) ) {
      fprintf(SE_ERR, "Error setting up signal handler for SIGFPE.\n");
      critical_error_exit();
      }
#endif
       
#ifdef SIGUSR1
   if ( SIG_ERR == signal( SIGUSR1, signal_exception_handler ) ) {
      fprintf(SE_ERR, "Error setting up signal handler for SIGUSR1.\n");
      critical_error_exit();
      }
#endif
       
#ifdef SIGSEGV
   if ( SIG_ERR == signal( SIGSEGV, signal_exception_handler ) ) {
      fprintf(SE_ERR, "Error setting up signal handler for SIGSEGV.\n");
      critical_error_exit();
      }
#endif
       
#ifdef SIGUSR2
   if ( SIG_ERR == signal( SIGUSR2, signal_exception_handler ) ) {
      fprintf(SE_ERR, "Error setting up signal handler for SIGUSR2.\n");
      critical_error_exit();
      }
#endif
       
#ifdef SIGPIPE
   if ( SIG_ERR == signal( SIGPIPE, signal_exception_handler ) ) {
      fprintf(SE_ERR, "Error setting up signal handler for SIGPIPE.\n");
      critical_error_exit();
      }
#endif
       
#ifdef SIGALRM
   if ( SIG_ERR == signal( SIGALRM, signal_exception_handler ) ) {
      fprintf(SE_ERR, "Error setting up signal handler for SIGALRM.\n");
      critical_error_exit();
      }
#endif
       
#ifdef SIGTERM
   if ( SIG_ERR == signal( SIGTERM, signal_exception_handler ) ) {
      fprintf(SE_ERR, "Error setting up signal handler for SIGTERM.\n");
      critical_error_exit();
      }
#endif
       
#ifdef SIGCHLD
   if ( SIG_ERR == signal( SIGCHLD, signal_exception_handler ) ) {
      fprintf(SE_ERR, "Error setting up signal handler for SIGCHLD.\n");
      critical_error_exit();
      }
#endif
       
#ifdef SIGCONT
   if ( SIG_ERR == signal( SIGCONT, signal_exception_handler ) ) {
      fprintf(SE_ERR, "Error setting up signal handler for SIGCONT.\n");
      critical_error_exit();
      }
#endif
       
#ifdef SIGTSTP
   if ( SIG_ERR == signal( SIGTSTP, signal_exception_handler ) ) {
      fprintf(SE_ERR, "Error setting up signal handler for SIGTSTP.\n");
      critical_error_exit();
      }
#endif
       
#ifdef SIGTTIN
   if ( SIG_ERR == signal( SIGTTIN, signal_exception_handler ) ) {
      fprintf(SE_ERR, "Error setting up signal handler for SIGTTIN.\n");
      critical_error_exit();
      }
#endif
       
#ifdef SIGTTOU
   if ( SIG_ERR == signal( SIGTTOU, signal_exception_handler ) ) {
      fprintf(SE_ERR, "Error setting up signal handler for SIGTTOU.\n");
      critical_error_exit();
      }
#endif
       
#ifdef SIGURG
   if ( SIG_ERR == signal( SIGURG, signal_exception_handler ) ) {
      fprintf(SE_ERR, "Error setting up signal handler for SIGURG.\n");
      critical_error_exit();
      }
#endif
       
#ifdef SIGXCPU
   if ( SIG_ERR == signal( SIGXCPU, signal_exception_handler ) ) {
      fprintf(SE_ERR, "Error setting up signal handler for SIGXCPU.\n");
      critical_error_exit();
      }
#endif
       
#ifdef SIGXFSZ
   if ( SIG_ERR == signal( SIGXFSZ, signal_exception_handler ) ) {
      fprintf(SE_ERR, "Error setting up signal handler for SIGXFSZ.\n");
      critical_error_exit();
      }
#endif
       
#ifdef SIGVTALRM
   if ( SIG_ERR == signal( SIGVTALRM, signal_exception_handler ) ) {
      fprintf(SE_ERR, "Error setting up signal handler for SIGVTALRM.\n");
      critical_error_exit();
      }
#endif
       
#ifdef SIGPROF
   if ( SIG_ERR == signal( SIGPROF, signal_exception_handler ) ) {
      fprintf(SE_ERR, "Error setting up signal handler for SIGPROF.\n");
      critical_error_exit();
      }
#endif
       
#ifdef SIGWINCH
   if ( SIG_ERR == signal( SIGWINCH, signal_exception_handler ) ) {
      fprintf(SE_ERR, "Error setting up signal handler for SIGWINCH.\n");
      critical_error_exit();
      }
#endif
       
#ifdef SIGIO
   if ( SIG_ERR == signal( SIGIO, signal_exception_handler ) ) {
      fprintf(SE_ERR, "Error setting up signal handler for SIGIO.\n");
      critical_error_exit();
      }
#endif
       
#ifdef SIGPWR
   if ( SIG_ERR == signal( SIGPWR, signal_exception_handler ) ) {
      fprintf(SE_ERR, "Error setting up signal handler for SIGPWR.\n");
      critical_error_exit();
      }
#endif
       
#else   /* SIG_ERR not defined, non-Posix system? */

/* These don't check return code for the signal() OS call.  Bad practice,
   but what can be done?  */

#ifdef SIGBREAK
   /* This signal does not exist on Unix systems. */
   signal( SIGBREAK, signal_exception_handler );
#endif

#ifdef SIGHUP
   signal( SIGHUP, signal_exception_handler );
#endif

#ifdef SIGINT
   signal( SIGINT, signal_exception_handler );
#endif

#ifdef SIGQUIT
   signal( SIGQUIT, signal_exception_handler );
#endif

#ifdef SIGILL
   signal( SIGILL, signal_exception_handler );
#endif

#ifdef SIGTRAP
   signal( SIGTRAP, signal_exception_handler );
#endif

#ifdef SIGIOT
   signal( SIGIOT, signal_exception_handler );
#endif

#ifdef SIGBUS
   signal( SIGBUS, signal_exception_handler );
#endif

#ifdef SIGFPE
   signal( SIGFPE, signal_exception_handler );
#endif

#ifdef SIGKILL
   /* This should silently fail on Unix systems, but is reported to work
      on other non-Unix systems.  You have been warned. */
   signal( SIGKILL, signal_exception_handler );
#endif

#ifdef SIGUSR1
   signal( SIGUSR1, signal_exception_handler );
#endif

#ifdef SIGSEGV
   signal( SIGSEGV, signal_exception_handler );
#endif

#ifdef SIGUSR2
   signal( SIGUSR2, signal_exception_handler );
#endif

#ifdef SIGPIPE
   signal( SIGPIPE, signal_exception_handler );
#endif

#ifdef SIGALRM
   signal( SIGALRM, signal_exception_handler );
#endif

#ifdef SIGTERM
   signal( SIGTERM, signal_exception_handler );
#endif

#ifdef SIGCHLD
   signal( SIGCHLD, signal_exception_handler );
#endif

#ifdef SIGCONT
   signal( SIGCONT, signal_exception_handler );
#endif

#ifdef SIGSTOP
   /* This should also silently fail on all Unix systems, but it may
      be effective on other OSs. */
   signal( SIGSTOP, signal_exception_handler );
#endif

#ifdef SIGTSTP
   signal( SIGTSTP, signal_exception_handler );
#endif

#ifdef SIGTTIN
   signal( SIGTTIN, signal_exception_handler );
#endif

#ifdef SIGTTOU
   signal( SIGTTOU, signal_exception_handler );
#endif

#ifdef SIGURG
   signal( SIGURG, signal_exception_handler );
#endif

#ifdef SIGXCPU
   signal( SIGXCPU, signal_exception_handler );
#endif

#ifdef SIGXFSZ
   signal( SIGXFSZ, signal_exception_handler );
#endif

#ifdef SIGTALRM
   signal( SIGTALRM, signal_exception_handler );
#endif

#ifdef SIGPROF
   signal( SIGPROF, signal_exception_handler );
#endif

#ifdef SIGWINCH
   signal( SIGWINCH, signal_exception_handler );
#endif

#ifdef SIGIO
   signal( SIGIO, signal_exception_handler );
#endif

#ifdef SIGPWR
   signal( SIGPWR, signal_exception_handler );
#endif

#endif  /* ifdef SIG_ERR */

}

#ifdef SE_CHECK
static void reset_assertion_checking(struct rescue_context * current_context) {
  /* Unwind the dump stack, resetting assertion checking when a rescue
     clause is invoked.  
     This function must be called just before the LONGJMP to the 
     enclosing rescue context.
  */
  while(se_dst!=current_context->top_of_ds){
    if(se_dst->fd!=NULL)se_dst->fd->assertion_flag=1;
    se_dst = se_dst->caller;
  }
}
#endif

void signal_exception_handler(int signal_number) {
  /* Set up to be called whenever an OS signal has been received.
     Checks to see if there is a rescue clause active (somewhere on the
     call stack), and if so, transfer control to that.
  */
  struct rescue_context *current_context;

#ifdef SIG_ERR
  /* some OS implementations automatically block a signal while
   * executing the signal handler, but some do not. */
  if ( SIG_ERR == signal( signal_number, SIG_IGN ) ) {
    fprintf(SE_ERR, "In signal_exception_handler: ");
    fprintf(SE_ERR, "Error turning off signal %d.\n", signal_number );
    critical_error_exit();
  }
#else
  signal( signal_number, SIG_IGN );
#endif

  internal_exception_number = Os_signal;
  original_internal_exception_number = 0;
  signal_exception_number = signal_number;
       
  if ( rescue_context_top != NULL ) {
    current_context = rescue_context_top;
    rescue_context_top = rescue_context_top->next;

    /* now re-enable that signal */
#ifdef SIG_ERR
    if ( SIG_ERR == signal( signal_number, signal_exception_handler ) ) {
      fprintf(SE_ERR, "In signal_exception_handler: ");
      fprintf(SE_ERR, "Error turning on signal %d.\n", signal_number );
      critical_error_exit();
    }
#else
    signal( signal_number, signal_exception_handler );
#endif

#ifdef SE_CHECK
    /* Unwind dump_stack structures PRIOR to jumping :
     */
    reset_assertion_checking(current_context) ;
#endif
    LONGJMP( current_context->jb, internal_exception_number );
  }

  /* No current rescue clause, exit with a dump : */
  print_exception();
  se_print_run_time_stack();
  se_exit(EXIT_FAILURE);
}

void internal_exception_handler(int exception_number) {
  /* Called whenever an internal (to SmallEiffel) exception is to
     be raised (`raise' feature, assertion violation, etc.).  

     Checks to see if there is a current rescue clause (somewhere 
     in the call stack), and transfers control to it.
     Else exit with a stack trace (if enabled).
  */
  struct rescue_context *current_context;

  /* UNCOMMENT THIS PART TO DEBUG WITH EXCEPTION:
     print_exception(); se_print_run_time_stack();
  */



  /* If this is not a routine failure, clear out old exception
   * information. */
  if ( exception_number != Routine_failure ) {
    internal_exception_number = exception_number;
    original_internal_exception_number = 0;
    signal_exception_number = 0;
  }
  else {
    original_internal_exception_number = internal_exception_number;
  }

  if ( rescue_context_top != NULL ) {
    current_context = rescue_context_top;
    rescue_context_top = rescue_context_top->next;
#ifdef SE_CHECK
    /* Unwind dump_stack structures PRIOR to jumping :
     */
    reset_assertion_checking(current_context) ;
#endif
    LONGJMP( current_context->jb, exception_number );
  }
  
  /* No current rescue clause, exit with a dump : */
  print_exception();
  se_print_run_time_stack();
  se_exit(EXIT_FAILURE);
}

#ifdef SE_CHECK
static void print_exception_case( int ex_num ) {
  switch( ex_num ) {
  case Check_instruction:
    fprintf(SE_ERR, "Check instruction failed.\n");
    break;
  case Class_invariant:
    fprintf(SE_ERR, "Class invariant not maintained.\n");
    break;
  case Developer_exception:
    fprintf(SE_ERR, "Developer exception:\n");
    break;
  case Incorrect_inspect_value:
    fprintf(SE_ERR, "Incorrect inspect value.\n");
    break;
  case Loop_invariant:
    fprintf(SE_ERR, "Loop invariant failed.\n");
    break;
  case Loop_variant:
    fprintf(SE_ERR, "Loop variant failed to decrease.\n");
    break;
  case No_more_memory:
    fprintf(SE_ERR, "Failed to allocate additional memory.\n");
    break;
  case Postcondition:
    fprintf(SE_ERR, "Postcondition (ensure clause) failed.\n");
    break;
  case Precondition:
    fprintf(SE_ERR, "Precondition (require clause) failed.\n");
    break;
  case Routine_failure:
    fprintf(SE_ERR, "Routine failure.\n");
    break;
  case Os_signal:
    fprintf(SE_ERR, "OS Signal (%d) received.\n", 
	    signal_exception_number );
    break;
  case Void_attached_to_expanded:
    fprintf(SE_ERR, "A Void became attached to an expanded object.\n");
    fprintf(SE_ERR, "Please report this problem to the SmallEiffel team.\n");
    break;
  case Void_call_target:
    fprintf(SE_ERR, "Feature call attempted on a Void reference.\n");
    break;
  default:
    fprintf(SE_ERR, "There was an unknown exception.\n");
    fprintf(SE_ERR, "Please report this problem to the SmallEiffel team.\n");
  }
}
#endif

void print_exception(void) {
  /* Display some information about last not handled exception. */
#ifdef SE_CHECK
  fprintf(SE_ERR,"Exception number %d not handled.\n",internal_exception_number);
  if ( internal_exception_number == Routine_failure ) {
    fprintf(SE_ERR, "Routine failure.  Original exception: \n");
    print_exception_case( original_internal_exception_number );
  }
  else {
    print_exception_case( internal_exception_number );
  }
  if ( additional_error_message != NULL ) {
    fprintf(SE_ERR, "%s\n", additional_error_message );
  }
#endif
}

/* $Revision: 1.4 $ */



T6 r6_ix_not(se_dump_stack*caller,T6 C){
T6 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f6_ix_not;
ds.current=((void**)&C);
ds.p=12608792;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
if(C){
}
else{
(ds.p=12610074);
R=1;
}
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f6_ix_not={"prefix not of BOOLEAN",1,1,"%E6%Result%E6%",1};


T6 r6_px_or(se_dump_stack*caller,T6 C,T6 a1){
T6 R=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f6_px_or;
ds.current=((void**)&C);
ds.p=12602376;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
(ds.p=12604180);
R=(C)||(a1);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f6_px_or={"infix or of BOOLEAN",1,2,"%E6%other%E6%Result%E6%",1};


T6 r6_px_and(se_dump_stack*caller,T6 C,T6 a1){
T6 R=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f6_px_and;
ds.current=((void**)&C);
ds.p=12597256;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
(ds.p=12599060);
R=(C)&&(a1);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f6_px_and={"infix and of BOOLEAN",1,2,"%E6%other%E6%Result%E6%",1};


T6 r6_px_xor(se_dump_stack*caller,T6 C,T6 a1){
T6 R=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f6_px_xor;
ds.current=((void**)&C);
ds.p=12606216;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(C){
(ds.p=12607258);
R=r6_ix_not(&ds,a1);
}
else{
(ds.p=12607770);
R=a1;
}
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f6_px_xor={"infix xor of BOOLEAN",1,2,"%E6%other%E6%Result%E6%",1};


T6 r3_px_6061(se_dump_stack*caller,T3 C,T3 a1){
T6 R=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f3_px_6061;
ds.current=((void**)&C);
ds.p=6316296;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
(ds.p=6317076);
R=(T3code(C))<=(T3code(a1));
if(f3_px_6061.assertion_flag){
f3_px_6061.assertion_flag=0;
(ds.p=60835386);
ac_ens((R)==(r6_px_or(&ds,r3_px_60(&ds,C,a1),r3is_equal(&ds,C,a1))),"definition");
f3_px_6061.assertion_flag=1;
}
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f3_px_6061={"infix <= of CHARACTER",1,2,"%E3%other%E3%Result%E6%",1};


T6 r3is_equal(se_dump_stack*caller,T3 C,T3 a1){
T6 R=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f3is_equal;
ds.current=((void**)&C);
ds.p=60829448;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
(ds.p=60829958);
R=(r6_ix_not(&ds,r3_px_60(&ds,C,a1)))&&(r6_ix_not(&ds,r3_px_60(&ds,a1,C)));
if(f3is_equal.assertion_flag){
f3is_equal.assertion_flag=0;
(ds.p=60830508);
ac_ens((R)==(r6_px_and(&ds,r6_ix_not(&ds,r3_px_60(&ds,C,a1)),r6_ix_not(&ds,r3_px_60(&ds,a1,C)))),"trichotomy");
(ds.p=2139486);
ac_ens((!((C)==(a1)))||(R),"consistent");
(ds.p=2139704);
ac_ens((!(R))||(r3is_equal(&ds,a1,C)),"symmetric");
f3is_equal.assertion_flag=1;
}
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f3is_equal={"is_equal of COMPARABLE",1,2,"%E3%other%E3%Result%E6%",1};


T6 r3is_digit(se_dump_stack*caller,T3 C){
T6 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f3is_digit;
ds.current=((void**)&C);
ds.p=6347016;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
if(((ds.p=6347818),r3_px_6261(&ds,C,((T3)'0')))){
(ds.p=6348058);
R=r3_px_6061(&ds,C,((T3)'9'));
}
if(f3is_digit.assertion_flag){
f3is_digit.assertion_flag=0;
(ds.p=6348832);
ac_ens((R)==(r3in_range(&ds,C,((T3)'0'),((T3)'9'))),NULL);
f3is_digit.assertion_flag=1;
}
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f3is_digit={"is_digit of CHARACTER",1,1,"%E3%Result%E6%",1};


T6 r3in_range(se_dump_stack*caller,T3 C,T3 a1,T3 a2){
T6 R=0;
void**locals[3];
se_dump_stack ds;
ds.fd=&f3in_range;
ds.current=((void**)&C);
ds.p=60841224;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&a2;
locals[2]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=60842004);
R=(r3_px_6261(&ds,C,a1))&&(r3_px_6061(&ds,C,a2));
if(f3in_range.assertion_flag){
f3in_range.assertion_flag=0;
(ds.p=60842530);
ac_ens((R)==(r6_px_and(&ds,r3_px_6261(&ds,C,a1),r3_px_6061(&ds,C,a2))),NULL);
f3in_range.assertion_flag=1;
}
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f3in_range={"in_range of COMPARABLE",1,3,"%E3%lower%E3%upper%E3%Result%E6%",1};


T6 r3is_hexadecimal_digit(se_dump_stack*caller,T3 C){
T6 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f3is_hexadecimal_digit;
ds.current=((void**)&C);
ds.p=6354696;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
if(((ds.p=6355482),r3is_digit(&ds,C))){
(ds.p=6355738);
R=1;
}
 else if(((ds.p=6356018),r3_px_6261(&ds,C,((T3)'a')))){
(ds.p=6356250);
R=r3_px_6061(&ds,C,((T3)'f'));
}
 else if(((ds.p=6356530),r3_px_6261(&ds,C,((T3)'A')))){
(ds.p=6356762);
R=r3_px_6061(&ds,C,((T3)'F'));
}
if(f3is_hexadecimal_digit.assertion_flag){
f3is_hexadecimal_digit.assertion_flag=0;
(ds.p=6357538);
ac_ens((R)==(r7has(&ds,ms3_736411847,C)),NULL);
f3is_hexadecimal_digit.assertion_flag=1;
}
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f3is_hexadecimal_digit={"is_hexadecimal_digit of CHARACTER",1,1,"%E3%Result%E6%",1};


T6 r3_px_6261(se_dump_stack*caller,T3 C,T3 a1){
T6 R=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f3_px_6261;
ds.current=((void**)&C);
ds.p=6319368;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
(ds.p=6320148);
R=(T3code(C))>=(T3code(a1));
if(f3_px_6261.assertion_flag){
f3_px_6261.assertion_flag=0;
(ds.p=60840506);
ac_ens((R)==(r3_px_6061(&ds,a1,C)),"definition");
f3_px_6261.assertion_flag=1;
}
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f3_px_6261={"infix >= of CHARACTER",1,2,"%E3%other%E3%Result%E6%",1};


T2 r3value(se_dump_stack*caller,T3 C){
T2 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f3value;
ds.current=((void**)&C);
ds.p=6320904;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f3value.assertion_flag){
f3value.assertion_flag=0;
(ds.p=6321684);
ac_req(r3is_digit(&ds,C),NULL);
f3value.assertion_flag=1;
}
(ds.p=6322196);
R=(T3code(C))-(T3code(((T3)'0')));
if(f3value.assertion_flag){
f3value.assertion_flag=0;
(ds.p=6322722);
ac_ens(r2in_range(&ds,R,0,9),NULL);
f3value.assertion_flag=1;
}
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f3value={"value of CHARACTER",1,1,"%E3%Result%E2%",1};


T6 r3_px_60(se_dump_stack*caller,T3 C,T3 a1){
T6 R=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f3_px_60;
ds.current=((void**)&C);
ds.p=6314760;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
(ds.p=6315540);
R=(T3code(C))<(T3code(a1));
if(f3_px_60.assertion_flag){
f3_px_60.assertion_flag=0;
(ds.p=60832826);
ac_ens((!(R))||(r6_ix_not(&ds,r3_px_60(&ds,a1,C))),"asymmetric");
f3_px_60.assertion_flag=1;
}
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f3_px_60={"infix < of CHARACTER",1,2,"%E3%other%E3%Result%E6%",1};


T2 r3decimal_value(se_dump_stack*caller,T3 C){
T2 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f3decimal_value;
ds.current=((void**)&C);
ds.p=6320904;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f3decimal_value.assertion_flag){
f3decimal_value.assertion_flag=0;
(ds.p=6321684);
ac_req(r3is_digit(&ds,C),NULL);
f3decimal_value.assertion_flag=1;
}
(ds.p=6322196);
R=(T3code(C))-(T3code(((T3)'0')));
if(f3decimal_value.assertion_flag){
f3decimal_value.assertion_flag=0;
(ds.p=6322722);
ac_ens(r2in_range(&ds,R,0,9),NULL);
f3decimal_value.assertion_flag=1;
}
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f3decimal_value={"decimal_value (value of CHARACTER)",1,1,"%E3%Result%E2%",1};


T3 r3to_upper(se_dump_stack*caller,T3 C){
T3 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f3to_upper;
ds.current=((void**)&C);
ds.p=6337800;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
if(((ds.p=6338596),(T3code(C))<(97))){
(ds.p=6338842);
R=C;
}
 else if(((ds.p=6339116),(T3code(C))>(122))){
(ds.p=6339354);
R=C;
}
else{
(ds.p=6339866);
R=((T3)((T3code(C))-(32)));
}
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f3to_upper={"to_upper of CHARACTER",1,1,"%E3%Result%E3%",1};


T2 r3hexadecimal_value(se_dump_stack*caller,T3 C){
T2 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f3hexadecimal_value;
ds.current=((void**)&C);
ds.p=6328584;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f3hexadecimal_value.assertion_flag){
f3hexadecimal_value.assertion_flag=0;
(ds.p=6329364);
ac_req(r3is_hexadecimal_digit(&ds,C),NULL);
f3hexadecimal_value.assertion_flag=1;
}
if(((ds.p=6329892),(T3code(C))<(T3code(((T3)'A'))))){
(ds.p=6330138);
R=(T3code(C))-(48);
}
 else if(((ds.p=6330412),(T3code(C))<(T3code(((T3)'a'))))){
(ds.p=6330650);
R=(T3code(C))-(55);
}
else{
(ds.p=6331162);
R=(T3code(C))-(87);
}
if(f3hexadecimal_value.assertion_flag){
f3hexadecimal_value.assertion_flag=0;
(ds.p=6331938);
ac_ens(r2in_range(&ds,R,0,15),NULL);
f3hexadecimal_value.assertion_flag=1;
}
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f3hexadecimal_value={"hexadecimal_value of CHARACTER",1,1,"%E3%Result%E2%",1};


T6 r17is_equal(se_dump_stack*caller,T17 C,T17 a1){
T6 R=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f17is_equal;
ds.current=((void**)&C);
ds.p=60829448;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
(ds.p=60829958);
R=(r6_ix_not(&ds,(C)<(a1)))&&(r6_ix_not(&ds,(a1)<(C)));
if(f17is_equal.assertion_flag){
f17is_equal.assertion_flag=0;
(ds.p=60830508);
ac_ens((R)==(r6_px_and(&ds,r6_ix_not(&ds,(C)<(a1)),r6_ix_not(&ds,(a1)<(C)))),"trichotomy");
(ds.p=2139486);
ac_ens((!((C)==(a1)))||(R),"consistent");
(ds.p=2139704);
ac_ens((!(R))||(r17is_equal(&ds,a1,C)),"symmetric");
f17is_equal.assertion_flag=1;
}
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f17is_equal={"is_equal of COMPARABLE",1,2,"%E17%other%E17%Result%E6%",1};


T6 r17divisible(se_dump_stack*caller,T17 a1){
T6 R=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f17divisible;
ds.current=NULL;
ds.p=102790152;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
(ds.p=102790676);
R=((/*RF2*/a1))!=(((T17)(0)));
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f17divisible={"divisible of UNSIGNED_REF",0,2,"other%E17%Result%E6%",1};


T6 r17in_range(se_dump_stack*caller,T17 C,T17 a1,T17 a2){
T6 R=0;
void**locals[3];
se_dump_stack ds;
ds.fd=&f17in_range;
ds.current=((void**)&C);
ds.p=60841224;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&a2;
locals[2]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=60842004);
R=((C)>=(a1))&&((C)<=(a2));
if(f17in_range.assertion_flag){
f17in_range.assertion_flag=0;
(ds.p=60842530);
ac_ens((R)==(r6_px_and(&ds,(C)>=(a1),(C)<=(a2))),NULL);
f17in_range.assertion_flag=1;
}
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f17in_range={"in_range of COMPARABLE",1,3,"%E17%lower%E17%upper%E17%Result%E6%",1};


void r17append_in_hexadecimal(se_dump_stack*caller,T17 C,T0* a1){
T17 _val=0;
T2 _j=0;
T2 _i=0;
void**locals[4];
se_dump_stack ds;
ds.fd=&f17append_in_hexadecimal;
ds.current=((void**)&C);
ds.p=35739400;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&_val;
locals[2]=(void**)&_j;
locals[3]=(void**)&_i;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f17append_in_hexadecimal.assertion_flag){
f17append_in_hexadecimal.assertion_flag=0;
(ds.p=35740450);
ac_req((a1)!=((void*)(NULL)),NULL);
f17append_in_hexadecimal.assertion_flag=1;
}
if(((ds.p=35741738),(C)==(0U))){
(ds.p=35741992);
r7extend(&ds,se_i7(&ds,((T7*)ci(7,a1,35741978))),((T3)'0'));
}
else{
(ds.p=35742752);
_i=((/*RF2*/(se_i7(&ds,((T7*)ci(7,a1,35742762))))->_count/*8*/))+(1);
(ds.p=35743008);
_val=C;
while (!(((ds.p=35743528),(_val)==(0U))))
{
(ds.p=35744046);
r7extend(&ds,se_i7(&ds,((T7*)ci(7,a1,35744032))),r17hexadecimal_digit(&ds,(_val)%(16U)));
(ds.p=35744288);
_val=(_val)/(16U);
}
(ds.p=35745056);
_j=(/*RF2*/(se_i7(&ds,((T7*)ci(7,a1,35745066))))->_count/*8*/);
while (!(((ds.p=35745572),(_i)>=(_j))))
{
(ds.p=35746094);
r7swap(&ds,se_i7(&ds,((T7*)ci(7,a1,35746080))),_i,_j);
(ds.p=35746336);
_j=(_j)-(1);
(ds.p=35746592);
_i=(_i)+(1);
}
}
se_dst=caller;/*unlink*/
}
se_frame_descriptor f17append_in_hexadecimal={"append_in_hexadecimal of UNSIGNED",1,4,"%E17%buffer%R7%val%E17%j%E2%i%E2%",1};


T3 r17hexadecimal_digit(se_dump_stack*caller,T17 C){
T3 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f17hexadecimal_digit;
ds.current=((void**)&C);
ds.p=35765256;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f17hexadecimal_digit.assertion_flag){
f17hexadecimal_digit.assertion_flag=0;
(ds.p=35766036);
ac_req(r17in_range(&ds,C,0U,15U),NULL);
f17hexadecimal_digit.assertion_flag=1;
}
(ds.p=35766548);
R=r2hexadecimal_digit(&ds,((T2)(C)));
if(f17hexadecimal_digit.assertion_flag){
f17hexadecimal_digit.assertion_flag=0;
(ds.p=35767102);
ac_ens(r7has(&ds,ms17_1949511993,R),NULL);
f17hexadecimal_digit.assertion_flag=1;
}
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f17hexadecimal_digit={"hexadecimal_digit of UNSIGNED",1,1,"%E17%Result%E3%",1};


T6 r2is_equal(se_dump_stack*caller,T2 C,T2 a1){
T6 R=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f2is_equal;
ds.current=((void**)&C);
ds.p=60829448;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
(ds.p=60829958);
R=(r6_ix_not(&ds,(C)<(a1)))&&(r6_ix_not(&ds,(a1)<(C)));
if(f2is_equal.assertion_flag){
f2is_equal.assertion_flag=0;
(ds.p=2139486);
ac_ens((!((C)==(a1)))||(R),"consistent");
(ds.p=2139704);
ac_ens((!(R))||(r2is_equal(&ds,a1,C)),"symmetric");
(ds.p=60830508);
ac_ens((R)==(r6_px_and(&ds,r6_ix_not(&ds,(C)<(a1)),r6_ix_not(&ds,(a1)<(C)))),"trichotomy");
f2is_equal.assertion_flag=1;
}
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f2is_equal={"is_equal of COMPARABLE",1,2,"%E2%other%E2%Result%E6%",1};


T6 r2divisible(se_dump_stack*caller,T2 a1){
T6 R=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f2divisible;
ds.current=NULL;
ds.p=58753544;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
(ds.p=58754068);
R=((/*RF2*/a1))!=(0);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f2divisible={"divisible of INTEGER_REF",0,2,"other%E2%Result%E6%",1};


T6 r2in_range(se_dump_stack*caller,T2 C,T2 a1,T2 a2){
T6 R=0;
void**locals[3];
se_dump_stack ds;
ds.fd=&f2in_range;
ds.current=((void**)&C);
ds.p=60841224;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&a2;
locals[2]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=60842004);
R=((C)>=(a1))&&((C)<=(a2));
if(f2in_range.assertion_flag){
f2in_range.assertion_flag=0;
(ds.p=60842530);
ac_ens((R)==(r6_px_and(&ds,(C)>=(a1),(C)<=(a2))),NULL);
f2in_range.assertion_flag=1;
}
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f2in_range={"in_range of COMPARABLE",1,3,"%E2%lower%E2%upper%E2%Result%E6%",1};


void r2store(se_dump_stack*caller,T2 C,T0* a1){
T2 _dec=0;
T2 _val=0;
void**locals[3];
se_dump_stack ds;
ds.fd=&f2store;
ds.current=((void**)&C);
ds.p=4389896;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&_dec;
locals[2]=(void**)&_val;
se_dst=&ds;/*link*/
if(((ds.p=4391216),(C)<(0))){
(ds.p=4391470);
X33put_character(&ds,4391456,a1,((T3)'\55'));
if(((ds.p=4391734),(C)<(-(9)))){
(ds.p=4391974);
_dec=-(10);
}
else{
(ds.p=4392486);
_dec=-(1);
}
}
else{
(ds.p=4393248);
_dec=1;
}
while (!(((ds.p=4394044),((C)/(_dec))<(10))))
{
(ds.p=4394522);
_dec=(_dec)*(10);
}
(ds.p=4395546);
_val=C;
if(f2store.assertion_flag){
f2store.assertion_flag=0;
(ds.p=4396066);
ac_liv((_dec)!=(0),NULL);
f2store.assertion_flag=1;
}
while (!(((ds.p=4396586),r6_px_or(&ds,(_dec)==(1),(_dec)==(-(1))))))
{
(ds.p=4397096);
X33put_character(&ds,4397082,a1,r2digit(&ds,(_val)/(_dec)));
(ds.p=4397338);
_val=(_val)%(_dec);
(ds.p=4397594);
_dec=(_dec)/(10);
if(f2store.assertion_flag){
f2store.assertion_flag=0;
(ds.p=4396066);
ac_liv((_dec)!=(0),NULL);
f2store.assertion_flag=1;
}
}
(ds.p=4398370);
X33put_character(&ds,4398356,a1,r2digit(&ds,(_val)/(_dec)));
se_dst=caller;/*unlink*/
}
se_frame_descriptor f2store={"store of INTEGER",1,3,"%E2%stream%R33%dec%E2%val%E2%",1};


T3 r2digit(se_dump_stack*caller,T2 C){
T3 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f2digit;
ds.current=((void**)&C);
ds.p=4359944;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f2digit.assertion_flag){
f2digit.assertion_flag=0;
(ds.p=4360724);
ac_req(r2in_range(&ds,C,0,9),NULL);
f2digit.assertion_flag=1;
}
(ds.p=4361236);
R=((T3)((C)+(T3code(((T3)'0')))));
if(f2digit.assertion_flag){
f2digit.assertion_flag=0;
(ds.p=4361778);
ac_ens(r7has(&ds,ms2_117797837,R),NULL);
(ds.p=4362030);
ac_ens((r3value(&ds,R))==(C),NULL);
f2digit.assertion_flag=1;
}
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f2digit={"digit (decimal_digit of INTEGER)",1,1,"%E2%Result%E3%",1};


T2 r2_px_94(se_dump_stack*caller,T2 C,T2 a1){
T2 R=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f2_px_94;
ds.current=((void**)&C);
ds.p=4235528;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f2_px_94.assertion_flag){
f2_px_94.assertion_flag=0;
(ds.p=62934812);
ac_req((a1)>=(0),NULL);
f2_px_94.assertion_flag=1;
}
if(((ds.p=4236066),(a1)==(0))){
(ds.p=4236314);
R=1;
}
 else if(((ds.p=4236596),((a1)%(2))==(0))){
(ds.p=4236826);
R=r2_px_94(&ds,(C)*(C),(a1)/(2));
}
else{
(ds.p=4237338);
R=(C)*(r2_px_94(&ds,C,(a1)-(1)));
}
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f2_px_94={"infix ^ of INTEGER",1,2,"%E2%exp%E2%Result%E2%",1};


T3 r2hexadecimal_digit(se_dump_stack*caller,T2 C){
T3 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f2hexadecimal_digit;
ds.current=((void**)&C);
ds.p=4362760;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f2hexadecimal_digit.assertion_flag){
f2hexadecimal_digit.assertion_flag=0;
(ds.p=4363540);
ac_req(r2in_range(&ds,C,0,15),NULL);
f2hexadecimal_digit.assertion_flag=1;
}
if(((ds.p=4364074),(C)<=(9))){
(ds.p=4364314);
R=r2digit(&ds,C);
}
else{
(ds.p=4364826);
R=((T3)((T3code(((T3)'A')))+((C)-(10))));
}
if(f2hexadecimal_digit.assertion_flag){
f2hexadecimal_digit.assertion_flag=0;
(ds.p=4365630);
ac_ens(r7has(&ds,ms2_1949511993,R),NULL);
f2hexadecimal_digit.assertion_flag=1;
}
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f2hexadecimal_digit={"hexadecimal_digit of INTEGER",1,1,"%E2%Result%E3%",1};


T46 r46realloc(se_dump_stack*caller,T46 C,T2 a1,T2 a2){
T46 R=NULL;
void**locals[3];
se_dump_stack ds;
ds.fd=&f46realloc;
ds.current=((void**)&C);
ds.p=86006280;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&a2;
locals[2]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f46realloc.assertion_flag){
f46realloc.assertion_flag=0;
(ds.p=86008084);
ac_req(r46is_not_null(&ds,C),NULL);
(ds.p=86008364);
ac_req((a1)>(0),NULL);
(ds.p=86008620);
ac_req((a1)<(a2),NULL);
f46realloc.assertion_flag=1;
}
(ds.p=86009108);
R=((T46)(se_calloc(a2,sizeof(T0*))));
(ds.p=86009378);
r46copy_from(&ds,R,C,(a1)-(1));
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f46realloc={"realloc of NATIVE_ARRAY",1,3,"%E46%old_nb_elts%E2%new_nb_elts%E2%Result%E46%",1};


T6 r46is_not_null(se_dump_stack*caller,T46 C){
T6 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f46is_not_null;
ds.current=((void**)&C);
ds.p=86132744;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=86133268);
R=(NULL!=((void*)C));
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f46is_not_null={"is_not_null of NATIVE_ARRAY",1,1,"%E46%Result%E6%",1};


void r46clear(se_dump_stack*caller,T46 C,T2 a1,T2 a2){
T2 _i=0;
T0* _v=NULL;
void**locals[4];
se_dump_stack ds;
ds.fd=&f46clear;
ds.current=((void**)&C);
ds.p=86086152;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&a2;
locals[2]=(void**)&_i;
locals[3]=(void**)&_v;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f46clear.assertion_flag){
f46clear.assertion_flag=0;
(ds.p=86087200);
ac_req((a1)>=(0),NULL);
(ds.p=86087456);
ac_req((a2)>=(a1),NULL);
f46clear.assertion_flag=1;
}
(ds.p=86088986);
_i=a1;
while (!(((ds.p=86089502),(_i)>(a2))))
{
(ds.p=86090010);
(C)[_i]=(_v);
(ds.p=86090266);
_i=(_i)+(1);
}
se_dst=caller;/*unlink*/
}
se_frame_descriptor f46clear={"clear of NATIVE_ARRAY",1,4,"%E46%lower%E2%upper%E2%i%E2%v%R24%",1};


void r46copy_from(se_dump_stack*caller,T46 C,T46 a1,T2 a2){
T2 _i=0;
void**locals[3];
se_dump_stack ds;
ds.fd=&f46copy_from;
ds.current=((void**)&C);
ds.p=86091272;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&a2;
locals[2]=(void**)&_i;
se_dst=&ds;/*link*/
(ds.p=86092826);
_i=a2;
while (!(((ds.p=86093342),(_i)<(0))))
{
(ds.p=86093850);
(C)[_i]=((a1)[_i]);
(ds.p=86094106);
_i=(_i)-(1);
}
se_dst=caller;/*unlink*/
}
se_frame_descriptor f46copy_from={"copy_from of NATIVE_ARRAY",1,3,"%E46%model%E46%upper%E2%i%E2%",1};


T42 r42realloc(se_dump_stack*caller,T42 C,T2 a1,T2 a2){
T42 R=NULL;
void**locals[3];
se_dump_stack ds;
ds.fd=&f42realloc;
ds.current=((void**)&C);
ds.p=86006280;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&a2;
locals[2]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f42realloc.assertion_flag){
f42realloc.assertion_flag=0;
(ds.p=86008084);
ac_req(r42is_not_null(&ds,C),NULL);
(ds.p=86008364);
ac_req((a1)>(0),NULL);
(ds.p=86008620);
ac_req((a1)<(a2),NULL);
f42realloc.assertion_flag=1;
}
(ds.p=86009108);
R=((T42)(se_calloc(a2,sizeof(T0*))));
(ds.p=86009378);
r42copy_from(&ds,R,C,(a1)-(1));
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f42realloc={"realloc of NATIVE_ARRAY",1,3,"%E42%old_nb_elts%E2%new_nb_elts%E2%Result%E42%",1};


T6 r42is_not_null(se_dump_stack*caller,T42 C){
T6 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f42is_not_null;
ds.current=((void**)&C);
ds.p=86132744;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=86133268);
R=(NULL!=((void*)C));
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f42is_not_null={"is_not_null of NATIVE_ARRAY",1,1,"%E42%Result%E6%",1};


void r42clear(se_dump_stack*caller,T42 C,T2 a1,T2 a2){
T2 _i=0;
T0* _v=NULL;
void**locals[4];
se_dump_stack ds;
ds.fd=&f42clear;
ds.current=((void**)&C);
ds.p=86086152;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&a2;
locals[2]=(void**)&_i;
locals[3]=(void**)&_v;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f42clear.assertion_flag){
f42clear.assertion_flag=0;
(ds.p=86087200);
ac_req((a1)>=(0),NULL);
(ds.p=86087456);
ac_req((a2)>=(a1),NULL);
f42clear.assertion_flag=1;
}
(ds.p=86088986);
_i=a1;
while (!(((ds.p=86089502),(_i)>(a2))))
{
(ds.p=86090010);
(C)[_i]=(_v);
(ds.p=86090266);
_i=(_i)+(1);
}
se_dst=caller;/*unlink*/
}
se_frame_descriptor f42clear={"clear of NATIVE_ARRAY",1,4,"%E42%lower%E2%upper%E2%i%E2%v%R22%",1};


void r42copy_from(se_dump_stack*caller,T42 C,T42 a1,T2 a2){
T2 _i=0;
void**locals[3];
se_dump_stack ds;
ds.fd=&f42copy_from;
ds.current=((void**)&C);
ds.p=86091272;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&a2;
locals[2]=(void**)&_i;
se_dst=&ds;/*link*/
(ds.p=86092826);
_i=a2;
while (!(((ds.p=86093342),(_i)<(0))))
{
(ds.p=86093850);
(C)[_i]=((a1)[_i]);
(ds.p=86094106);
_i=(_i)-(1);
}
se_dst=caller;/*unlink*/
}
se_frame_descriptor f42copy_from={"copy_from of NATIVE_ARRAY",1,3,"%E42%model%E42%upper%E2%i%E2%",1};


T61 r61realloc(se_dump_stack*caller,T61 C,T2 a1,T2 a2){
T61 R=NULL;
void**locals[3];
se_dump_stack ds;
ds.fd=&f61realloc;
ds.current=((void**)&C);
ds.p=86006280;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&a2;
locals[2]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f61realloc.assertion_flag){
f61realloc.assertion_flag=0;
(ds.p=86008084);
ac_req(r61is_not_null(&ds,C),NULL);
(ds.p=86008364);
ac_req((a1)>(0),NULL);
(ds.p=86008620);
ac_req((a1)<(a2),NULL);
f61realloc.assertion_flag=1;
}
(ds.p=86009108);
R=((T61)(se_calloc(a2,sizeof(T0*))));
(ds.p=86009378);
r61copy_from(&ds,R,C,(a1)-(1));
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f61realloc={"realloc of NATIVE_ARRAY",1,3,"%E61%old_nb_elts%E2%new_nb_elts%E2%Result%E61%",1};


void r61remove(se_dump_stack*caller,T61 C,T2 a1,T2 a2){
T2 _i=0;
void**locals[3];
se_dump_stack ds;
ds.fd=&f61remove;
ds.current=((void**)&C);
ds.p=86049288;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&a2;
locals[2]=(void**)&_i;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f61remove.assertion_flag){
f61remove.assertion_flag=0;
(ds.p=86050336);
ac_req((a1)>=(0),NULL);
(ds.p=86050592);
ac_req((a1)<=(a2),NULL);
f61remove.assertion_flag=1;
}
(ds.p=86051866);
_i=a1;
while (!(((ds.p=86052382),(_i)==(a2))))
{
(ds.p=86052890);
(C)[_i]=((C)[(_i)+(1)]);
(ds.p=86053146);
_i=(_i)+(1);
}
se_dst=caller;/*unlink*/
}
se_frame_descriptor f61remove={"remove of NATIVE_ARRAY",1,3,"%E61%index%E2%upper%E2%i%E2%",1};


void r61clear(se_dump_stack*caller,T61 C,T2 a1,T2 a2){
T2 _i=0;
T0* _v=NULL;
void**locals[4];
se_dump_stack ds;
ds.fd=&f61clear;
ds.current=((void**)&C);
ds.p=86086152;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&a2;
locals[2]=(void**)&_i;
locals[3]=(void**)&_v;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f61clear.assertion_flag){
f61clear.assertion_flag=0;
(ds.p=86087200);
ac_req((a1)>=(0),NULL);
(ds.p=86087456);
ac_req((a2)>=(a1),NULL);
f61clear.assertion_flag=1;
}
(ds.p=86088986);
_i=a1;
while (!(((ds.p=86089502),(_i)>(a2))))
{
(ds.p=86090010);
(C)[_i]=(_v);
(ds.p=86090266);
_i=(_i)+(1);
}
se_dst=caller;/*unlink*/
}
se_frame_descriptor f61clear={"clear of NATIVE_ARRAY",1,4,"%E61%lower%E2%upper%E2%i%E2%v%R7%",1};


T6 r61is_not_null(se_dump_stack*caller,T61 C){
T6 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f61is_not_null;
ds.current=((void**)&C);
ds.p=86132744;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=86133268);
R=(NULL!=((void*)C));
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f61is_not_null={"is_not_null of NATIVE_ARRAY",1,1,"%E61%Result%E6%",1};


T6 r61all_default(se_dump_stack*caller,T61 C,T2 a1){
T6 R=0;
T0* _model=NULL;
T2 _i=0;
void**locals[4];
se_dump_stack ds;
ds.fd=&f61all_default;
ds.current=((void**)&C);
ds.p=86122760;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
locals[2]=(void**)&_model;
locals[3]=(void**)&_i;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f61all_default.assertion_flag){
f61all_default.assertion_flag=0;
(ds.p=86123808);
ac_req((a1)>=(-(1)),NULL);
f61all_default.assertion_flag=1;
}
(ds.p=86125338);
R=1;
(ds.p=86125594);
_i=a1;
while (!(((ds.p=86126118),((_i)<(0))||(r6_ix_not(&ds,R)))))
{
(ds.p=86126618);
R=(_model)==((void*)((C)[_i]));
(ds.p=86126874);
_i=(_i)-(1);
}
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f61all_default={"all_default of NATIVE_ARRAY",1,4,"%E61%upper%E2%Result%E6%model%R7%i%E2%",1};


void r61copy_from(se_dump_stack*caller,T61 C,T61 a1,T2 a2){
T2 _i=0;
void**locals[3];
se_dump_stack ds;
ds.fd=&f61copy_from;
ds.current=((void**)&C);
ds.p=86091272;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&a2;
locals[2]=(void**)&_i;
se_dst=&ds;/*link*/
(ds.p=86092826);
_i=a2;
while (!(((ds.p=86093342),(_i)<(0))))
{
(ds.p=86093850);
(C)[_i]=((a1)[_i]);
(ds.p=86094106);
_i=(_i)-(1);
}
se_dst=caller;/*unlink*/
}
se_frame_descriptor f61copy_from={"copy_from of NATIVE_ARRAY",1,3,"%E61%model%E61%upper%E2%i%E2%",1};


T48 r48realloc(se_dump_stack*caller,T48 C,T2 a1,T2 a2){
T48 R=NULL;
void**locals[3];
se_dump_stack ds;
ds.fd=&f48realloc;
ds.current=((void**)&C);
ds.p=86006280;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&a2;
locals[2]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f48realloc.assertion_flag){
f48realloc.assertion_flag=0;
(ds.p=86008084);
ac_req(r48is_not_null(&ds,C),NULL);
(ds.p=86008364);
ac_req((a1)>(0),NULL);
(ds.p=86008620);
ac_req((a1)<(a2),NULL);
f48realloc.assertion_flag=1;
}
(ds.p=86009108);
R=((T48)(se_calloc(a2,sizeof(T0*))));
(ds.p=86009378);
r48copy_from(&ds,R,C,(a1)-(1));
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f48realloc={"realloc of NATIVE_ARRAY",1,3,"%E48%old_nb_elts%E2%new_nb_elts%E2%Result%E48%",1};


T6 r48is_not_null(se_dump_stack*caller,T48 C){
T6 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f48is_not_null;
ds.current=((void**)&C);
ds.p=86132744;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=86133268);
R=(NULL!=((void*)C));
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f48is_not_null={"is_not_null of NATIVE_ARRAY",1,1,"%E48%Result%E6%",1};


void r48clear(se_dump_stack*caller,T48 C,T2 a1,T2 a2){
T2 _i=0;
T0* _v=NULL;
void**locals[4];
se_dump_stack ds;
ds.fd=&f48clear;
ds.current=((void**)&C);
ds.p=86086152;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&a2;
locals[2]=(void**)&_i;
locals[3]=(void**)&_v;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f48clear.assertion_flag){
f48clear.assertion_flag=0;
(ds.p=86087200);
ac_req((a1)>=(0),NULL);
(ds.p=86087456);
ac_req((a2)>=(a1),NULL);
f48clear.assertion_flag=1;
}
(ds.p=86088986);
_i=a1;
while (!(((ds.p=86089502),(_i)>(a2))))
{
(ds.p=86090010);
(C)[_i]=(_v);
(ds.p=86090266);
_i=(_i)+(1);
}
se_dst=caller;/*unlink*/
}
se_frame_descriptor f48clear={"clear of NATIVE_ARRAY",1,4,"%E48%lower%E2%upper%E2%i%E2%v%R26%",1};


void r48copy_from(se_dump_stack*caller,T48 C,T48 a1,T2 a2){
T2 _i=0;
void**locals[3];
se_dump_stack ds;
ds.fd=&f48copy_from;
ds.current=((void**)&C);
ds.p=86091272;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&a2;
locals[2]=(void**)&_i;
se_dst=&ds;/*link*/
(ds.p=86092826);
_i=a2;
while (!(((ds.p=86093342),(_i)<(0))))
{
(ds.p=86093850);
(C)[_i]=((a1)[_i]);
(ds.p=86094106);
_i=(_i)-(1);
}
se_dst=caller;/*unlink*/
}
se_frame_descriptor f48copy_from={"copy_from of NATIVE_ARRAY",1,3,"%E48%model%E48%upper%E2%i%E2%",1};


T9 r9realloc(se_dump_stack*caller,T9 C,T2 a1,T2 a2){
T9 R=NULL;
void**locals[3];
se_dump_stack ds;
ds.fd=&f9realloc;
ds.current=((void**)&C);
ds.p=86006280;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&a2;
locals[2]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f9realloc.assertion_flag){
f9realloc.assertion_flag=0;
(ds.p=86008084);
ac_req(r9is_not_null(&ds,C),NULL);
(ds.p=86008364);
ac_req((a1)>(0),NULL);
(ds.p=86008620);
ac_req((a1)<(a2),NULL);
f9realloc.assertion_flag=1;
}
(ds.p=86009108);
R=((T9)(se_calloc(a2,sizeof(T3))));
(ds.p=86009378);
r9copy_from(&ds,R,C,(a1)-(1));
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f9realloc={"realloc of NATIVE_ARRAY",1,3,"%E9%old_nb_elts%E2%new_nb_elts%E2%Result%E9%",1};


T6 r9fast_memcmp(se_dump_stack*caller,T9 C,T9 a1,T2 a2){
T6 R=0;
T2 _i=0;
void**locals[4];
se_dump_stack ds;
ds.fd=&f9fast_memcmp;
ds.current=((void**)&C);
ds.p=86015752;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&a2;
locals[2]=(void**)&R;
locals[3]=(void**)&_i;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f9fast_memcmp.assertion_flag){
f9fast_memcmp.assertion_flag=0;
(ds.p=86016558);
ac_req((!((a2)>(0)))||(r9is_not_null(&ds,a1)),NULL);
f9fast_memcmp.assertion_flag=1;
}
(ds.p=86017818);
_i=(a2)-(1);
while (!(((ds.p=86018342),((_i)<(0))||(((C)[_i])!=((a1)[_i])))))
{
(ds.p=86018842);
_i=(_i)-(1);
}
(ds.p=86019348);
R=(_i)<(0);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f9fast_memcmp={"fast_memcmp of NATIVE_ARRAY",1,4,"%E9%other%E9%capacity%E2%Result%E6%i%E2%",1};


T6 r9fast_has(se_dump_stack*caller,T9 C,T3 a1,T2 a2){
T6 R=0;
T2 _i=0;
void**locals[4];
se_dump_stack ds;
ds.fd=&f9fast_has;
ds.current=((void**)&C);
ds.p=86039560;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&a2;
locals[2]=(void**)&R;
locals[3]=(void**)&_i;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f9fast_has.assertion_flag){
f9fast_has.assertion_flag=0;
(ds.p=86040608);
ac_req((a2)>=(-(1)),NULL);
f9fast_has.assertion_flag=1;
}
(ds.p=86041882);
_i=a2;
while (!(((ds.p=86042406),((_i)<(0))||((a1)==((C)[_i])))))
{
(ds.p=86042906);
_i=(_i)-(1);
}
(ds.p=86043412);
R=(_i)>=(0);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f9fast_has={"fast_has of NATIVE_ARRAY",1,4,"%E9%element%E3%upper%E2%Result%E6%i%E2%",1};


void r9copy_at(se_dump_stack*caller,T9 C,T2 a1,T9 a2,T2 a3){
T2 _i2=0;
T2 _i1=0;
void**locals[5];
se_dump_stack ds;
ds.fd=&f9copy_at;
ds.current=((void**)&C);
ds.p=86066184;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&a2;
locals[2]=(void**)&a3;
locals[3]=(void**)&_i2;
locals[4]=(void**)&_i1;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f9copy_at.assertion_flag){
f9copy_at.assertion_flag=0;
(ds.p=86067482);
ac_req((a1)>=(0),NULL);
(ds.p=86067758);
ac_req((a3)>=(0),NULL);
f9copy_at.assertion_flag=1;
}
(ds.p=86069018);
_i1=a1;
while (!(((ds.p=86069536),(_i2)==(a3))))
{
(ds.p=86070042);
(C)[_i1]=((a2)[_i2]);
(ds.p=86070298);
_i2=(_i2)+(1);
(ds.p=86070554);
_i1=(_i1)+(1);
}
se_dst=caller;/*unlink*/
}
se_frame_descriptor f9copy_at={"copy_at of NATIVE_ARRAY",1,5,"%E9%at%E2%src%E9%src_capacity%E2%i2%E2%i1%E2%",1};


T6 r9is_not_null(se_dump_stack*caller,T9 C){
T6 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f9is_not_null;
ds.current=((void**)&C);
ds.p=86132744;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=86133268);
R=(NULL!=((void*)C));
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f9is_not_null={"is_not_null of NATIVE_ARRAY",1,1,"%E9%Result%E6%",1};


void r9copy_from(se_dump_stack*caller,T9 C,T9 a1,T2 a2){
T2 _i=0;
void**locals[3];
se_dump_stack ds;
ds.fd=&f9copy_from;
ds.current=((void**)&C);
ds.p=86091272;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&a2;
locals[2]=(void**)&_i;
se_dst=&ds;/*link*/
(ds.p=86092826);
_i=a2;
while (!(((ds.p=86093342),(_i)<(0))))
{
(ds.p=86093850);
(C)[_i]=((a1)[_i]);
(ds.p=86094106);
_i=(_i)-(1);
}
se_dst=caller;/*unlink*/
}
se_frame_descriptor f9copy_from={"copy_from of NATIVE_ARRAY",1,3,"%E9%model%E9%upper%E2%i%E2%",1};


T6 r60is_not_null(se_dump_stack*caller,T60 C){
T6 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f60is_not_null;
ds.current=((void**)&C);
ds.p=86132744;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=86133268);
R=(NULL!=((void*)C));
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f60is_not_null={"is_not_null of NATIVE_ARRAY",1,1,"%E60%Result%E6%",1};


void r60clear(se_dump_stack*caller,T60 C,T2 a1,T2 a2){
T2 _i=0;
T0* _v=NULL;
void**locals[4];
se_dump_stack ds;
ds.fd=&f60clear;
ds.current=((void**)&C);
ds.p=86086152;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&a2;
locals[2]=(void**)&_i;
locals[3]=(void**)&_v;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f60clear.assertion_flag){
f60clear.assertion_flag=0;
(ds.p=86087200);
ac_req((a1)>=(0),NULL);
(ds.p=86087456);
ac_req((a2)>=(a1),NULL);
f60clear.assertion_flag=1;
}
(ds.p=86088986);
_i=a1;
while (!(((ds.p=86089502),(_i)>(a2))))
{
(ds.p=86090010);
(C)[_i]=(_v);
(ds.p=86090266);
_i=(_i)+(1);
}
se_dst=caller;/*unlink*/
}
se_frame_descriptor f60clear={"clear of NATIVE_ARRAY",1,4,"%E60%lower%E2%upper%E2%i%E2%v%R58%",1};


T6 r60all_default(se_dump_stack*caller,T60 C,T2 a1){
T6 R=0;
T0* _model=NULL;
T2 _i=0;
void**locals[4];
se_dump_stack ds;
ds.fd=&f60all_default;
ds.current=((void**)&C);
ds.p=86122760;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
locals[2]=(void**)&_model;
locals[3]=(void**)&_i;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f60all_default.assertion_flag){
f60all_default.assertion_flag=0;
(ds.p=86123808);
ac_req((a1)>=(-(1)),NULL);
f60all_default.assertion_flag=1;
}
(ds.p=86125338);
R=1;
(ds.p=86125594);
_i=a1;
while (!(((ds.p=86126118),((_i)<(0))||(r6_ix_not(&ds,R)))))
{
(ds.p=86126618);
R=(_model)==((void*)((C)[_i]));
(ds.p=86126874);
_i=(_i)-(1);
}
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f60all_default={"all_default of NATIVE_ARRAY",1,4,"%E60%upper%E2%Result%E6%model%R58%i%E2%",1};


T66 r66realloc(se_dump_stack*caller,T66 C,T2 a1,T2 a2){
T66 R=NULL;
void**locals[3];
se_dump_stack ds;
ds.fd=&f66realloc;
ds.current=((void**)&C);
ds.p=86006280;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&a2;
locals[2]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f66realloc.assertion_flag){
f66realloc.assertion_flag=0;
(ds.p=86008084);
ac_req(r66is_not_null(&ds,C),NULL);
(ds.p=86008364);
ac_req((a1)>(0),NULL);
(ds.p=86008620);
ac_req((a1)<(a2),NULL);
f66realloc.assertion_flag=1;
}
(ds.p=86009108);
R=((T66)(se_calloc(a2,sizeof(T0*))));
(ds.p=86009378);
r66copy_from(&ds,R,C,(a1)-(1));
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f66realloc={"realloc of NATIVE_ARRAY",1,3,"%E66%old_nb_elts%E2%new_nb_elts%E2%Result%E66%",1};


T6 r66is_not_null(se_dump_stack*caller,T66 C){
T6 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f66is_not_null;
ds.current=((void**)&C);
ds.p=86132744;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=86133268);
R=(NULL!=((void*)C));
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f66is_not_null={"is_not_null of NATIVE_ARRAY",1,1,"%E66%Result%E6%",1};


void r66clear(se_dump_stack*caller,T66 C,T2 a1,T2 a2){
T2 _i=0;
T0* _v=NULL;
void**locals[4];
se_dump_stack ds;
ds.fd=&f66clear;
ds.current=((void**)&C);
ds.p=86086152;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&a2;
locals[2]=(void**)&_i;
locals[3]=(void**)&_v;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f66clear.assertion_flag){
f66clear.assertion_flag=0;
(ds.p=86087200);
ac_req((a1)>=(0),NULL);
(ds.p=86087456);
ac_req((a2)>=(a1),NULL);
f66clear.assertion_flag=1;
}
(ds.p=86088986);
_i=a1;
while (!(((ds.p=86089502),(_i)>(a2))))
{
(ds.p=86090010);
(C)[_i]=(_v);
(ds.p=86090266);
_i=(_i)+(1);
}
se_dst=caller;/*unlink*/
}
se_frame_descriptor f66clear={"clear of NATIVE_ARRAY",1,4,"%E66%lower%E2%upper%E2%i%E2%v%R25%",1};


void r66copy_from(se_dump_stack*caller,T66 C,T66 a1,T2 a2){
T2 _i=0;
void**locals[3];
se_dump_stack ds;
ds.fd=&f66copy_from;
ds.current=((void**)&C);
ds.p=86091272;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&a2;
locals[2]=(void**)&_i;
se_dst=&ds;/*link*/
(ds.p=86092826);
_i=a2;
while (!(((ds.p=86093342),(_i)<(0))))
{
(ds.p=86093850);
(C)[_i]=((a1)[_i]);
(ds.p=86094106);
_i=(_i)-(1);
}
se_dst=caller;/*unlink*/
}
se_frame_descriptor f66copy_from={"copy_from of NATIVE_ARRAY",1,3,"%E66%model%E66%upper%E2%i%E2%",1};


T6 r55is_not_null(se_dump_stack*caller,T55 C){
T6 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f55is_not_null;
ds.current=((void**)&C);
ds.p=86132744;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=86133268);
R=(NULL!=((void*)C));
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f55is_not_null={"is_not_null of NATIVE_ARRAY",1,1,"%E55%Result%E6%",1};


void r55clear(se_dump_stack*caller,T55 C,T2 a1,T2 a2){
T2 _i=0;
T2 _v=0;
void**locals[4];
se_dump_stack ds;
ds.fd=&f55clear;
ds.current=((void**)&C);
ds.p=86086152;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&a2;
locals[2]=(void**)&_i;
locals[3]=(void**)&_v;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f55clear.assertion_flag){
f55clear.assertion_flag=0;
(ds.p=86087200);
ac_req((a1)>=(0),NULL);
(ds.p=86087456);
ac_req((a2)>=(a1),NULL);
f55clear.assertion_flag=1;
}
(ds.p=86088986);
_i=a1;
while (!(((ds.p=86089502),(_i)>(a2))))
{
(ds.p=86090010);
(C)[_i]=(_v);
(ds.p=86090266);
_i=(_i)+(1);
}
se_dst=caller;/*unlink*/
}
se_frame_descriptor f55clear={"clear of NATIVE_ARRAY",1,4,"%E55%lower%E2%upper%E2%i%E2%v%E2%",1};


T6 r55all_default(se_dump_stack*caller,T55 C,T2 a1){
T6 R=0;
T2 _model=0;
T2 _i=0;
void**locals[4];
se_dump_stack ds;
ds.fd=&f55all_default;
ds.current=((void**)&C);
ds.p=86122760;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
locals[2]=(void**)&_model;
locals[3]=(void**)&_i;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f55all_default.assertion_flag){
f55all_default.assertion_flag=0;
(ds.p=86123808);
ac_req((a1)>=(-(1)),NULL);
f55all_default.assertion_flag=1;
}
(ds.p=86125338);
R=1;
(ds.p=86125594);
_i=a1;
while (!(((ds.p=86126118),((_i)<(0))||(r6_ix_not(&ds,R)))))
{
(ds.p=86126618);
R=(_model)==((C)[_i]);
(ds.p=86126874);
_i=(_i)-(1);
}
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f55all_default={"all_default of NATIVE_ARRAY",1,4,"%E55%upper%E2%Result%E6%model%E2%i%E2%",1};


void r7copy(se_dump_stack*caller,T7* C,T0* a1){
void**locals[1];
se_dump_stack ds;
ds.fd=&f7copy;
ds.current=((void**)&C);
ds.p=14999304;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
se_dst=&ds;/*link*/
se_require_uppermost_flag=0;
se_require_last_result=1;
if(f7copy.assertion_flag){
f7copy.assertion_flag=0;
(ds.p=15000102);
ac_req(r7is_mutable(&ds,C),"mutable");
f7copy.assertion_flag=1;
}
se_require_uppermost_flag=1;
if(!se_require_last_result){
se_require_last_result=1;
if(f7copy.assertion_flag){
f7copy.assertion_flag=0;
(ds.p=2160704);
ac_req((a1)!=((void*)(NULL)),"other_not_void");
f7copy.assertion_flag=1;
}
}
(ds.p=15000596);
(/*SFN*/C->_count)=(/*RF2*/(se_i7(&ds,((T7*)ci(7,a1,15000614))))->_count/*8*/);
if(((ds.p=15000870),((/*RF2*/(C)->_count/*8*/))>(0))){
if(((ds.p=15001138),((/*RF2*/(C)->_capacity/*12*/))<((/*RF2*/(C)->_count/*8*/)))){
(ds.p=15001376);
(/*SFN*/C->_storage)=((T9)(se_calloc((/*RF2*/(C)->_count/*8*/),sizeof(T3))));
(ds.p=15001632);
(/*SFN*/C->_capacity)=(/*RF2*/(C)->_count/*8*/);
}
(ds.p=15002154);
r9copy_from(&ds,(/*RF2*/(C)->_storage/*4*/),(/*RF2*/(se_i7(&ds,((T7*)ci(7,a1,15002174))))->_storage/*4*/),((/*RF2*/(C)->_count/*8*/))-(1));
}
if(f7copy.assertion_flag){
f7copy.assertion_flag=0;
(ds.p=15002912);
ac_ens(((/*RF2*/(C)->_count/*8*/))==((/*RF2*/(se_i7(&ds,((T7*)ci(7,a1,15002916))))->_count/*8*/)),NULL);
(ds.p=2161448);
ac_ens(r7is_equal(&ds,C,a1),"is_equal");
f7copy.assertion_flag=1;
}
if(se_rci(C))se_i7(&ds,C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f7copy={"copy of STRING",1,1,"%R7%other%R7%",1};


T3 r7last(se_dump_stack*caller,T7* C){
T3 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f7last;
ds.current=((void**)&C);
ds.p=15155208;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f7last.assertion_flag){
f7last.assertion_flag=0;
(ds.p=15155988);
ac_req(r6_ix_not(&ds,r7is_empty(&ds,C)),NULL);
f7last.assertion_flag=1;
}
(ds.p=15156500);
R=((/*RF2*/(C)->_storage/*4*/))[((/*RF2*/(C)->_count/*8*/))-(1)];
if(f7last.assertion_flag){
f7last.assertion_flag=0;
(ds.p=15157036);
ac_ens((R)==(r7item(&ds,C,(/*RF2*/(C)->_count/*8*/))),"definition");
f7last.assertion_flag=1;
}
if(se_rci(C))se_i7(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f7last={"last of STRING",1,1,"%R7%Result%E3%",1};


void r7remove_first(se_dump_stack*caller,T7* C,T2 a1){
T2 o7_1642_23=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f7remove_first;
ds.current=((void**)&C);
ds.p=15097608;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&o7_1642_23;
se_dst=&ds;/*link*/
o7_1642_23=(/*RF2*/(C)->_count/*8*/);
se_require_uppermost_flag=1;
if(f7remove_first.assertion_flag){
f7remove_first.assertion_flag=0;
(ds.p=15098406);
ac_req(r7is_mutable(&ds,C),"mutable");
(ds.p=15098650);
ac_req((a1)>=(0),NULL);
(ds.p=15098912);
ac_req(((/*RF2*/(C)->_count/*8*/))>=(a1),NULL);
f7remove_first.assertion_flag=1;
}
if(((ds.p=15099424),(a1)>(0))){
(ds.p=15099674);
r7remove_between(&ds,C,1,a1);
}
if(f7remove_first.assertion_flag){
f7remove_first.assertion_flag=0;
(ds.p=15100448);
ac_ens(((/*RF2*/(C)->_count/*8*/))==((o7_1642_23)-(a1)),NULL);
f7remove_first.assertion_flag=1;
}
if(se_rci(C))se_i7(&ds,C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f7remove_first={"remove_first of STRING",1,2,"%R7%nb%E2%old l1642c23STRING%E2%",1};


void r7put(se_dump_stack*caller,T7* C,T3 a1,T2 a2){
void**locals[2];
se_dump_stack ds;
ds.fd=&f7put;
ds.current=((void**)&C);
ds.p=15010824;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&a2;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f7put.assertion_flag){
f7put.assertion_flag=0;
(ds.p=15011622);
ac_req(r7is_mutable(&ds,C),"mutable");
(ds.p=15011886);
ac_req(r7valid_index(&ds,C,a2),"valid_index");
f7put.assertion_flag=1;
}
(ds.p=15012388);
((/*RF2*/(C)->_storage/*4*/))[(a2)-(1)]=(a1);
if(f7put.assertion_flag){
f7put.assertion_flag=0;
(ds.p=15012900);
ac_ens((r7item(&ds,C,a2))==(a1),NULL);
f7put.assertion_flag=1;
}
if(se_rci(C))se_i7(&ds,C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f7put={"put of STRING",1,2,"%R7%c%E3%i%E2%",1};


T2 r7upper(se_dump_stack*caller,T7* C){
T2 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f7upper;
ds.current=((void**)&C);
ds.p=14724104;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=14725126);
R=(/*RF2*/(C)->_count/*8*/);
if(f7upper.assertion_flag){
f7upper.assertion_flag=0;
(ds.p=14725652);
ac_ens((R)==((/*RF2*/(C)->_count/*8*/)),NULL);
f7upper.assertion_flag=1;
}
if(se_rci(C))se_i7(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f7upper={"upper of STRING",1,1,"%R7%Result%E2%",1};


void r7remove_between(se_dump_stack*caller,T7* C,T2 a1,T2 a2){
T2 _i=0;
T2 o7_1677_23=0;
void**locals[4];
se_dump_stack ds;
ds.fd=&f7remove_between;
ds.current=((void**)&C);
ds.p=15104264;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&a2;
locals[2]=(void**)&_i;
locals[3]=(void**)&o7_1677_23;
se_dst=&ds;/*link*/
o7_1677_23=(/*RF2*/(C)->_count/*8*/);
se_require_uppermost_flag=1;
if(f7remove_between.assertion_flag){
f7remove_between.assertion_flag=0;
(ds.p=15105062);
ac_req(r7is_mutable(&ds,C),"mutable");
(ds.p=15105300);
ac_req(r7valid_index(&ds,C,a1),NULL);
(ds.p=15105556);
ac_req(r7valid_index(&ds,C,a2),NULL);
(ds.p=15105820);
ac_req((a1)<=(a2),NULL);
f7remove_between.assertion_flag=1;
}
(ds.p=15107098);
_i=a2;
while (!(((ds.p=15107614),(_i)>=((/*RF2*/(C)->_count/*8*/)))))
{
(ds.p=15108122);
r7put(&ds,C,r7item(&ds,C,(_i)+(1)),((a1)+(_i))-(a2));
(ds.p=15108378);
_i=(_i)+(1);
}
(ds.p=15108884);
(/*SFN*/C->_count)=((/*RF2*/(C)->_count/*8*/))-(((a2)-(a1))+(1));
if(f7remove_between.assertion_flag){
f7remove_between.assertion_flag=0;
(ds.p=15109408);
ac_ens(((/*RF2*/(C)->_count/*8*/))==((o7_1677_23)-(((a2)-(a1))+(1))),NULL);
f7remove_between.assertion_flag=1;
}
if(se_rci(C))se_i7(&ds,C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f7remove_between={"remove_between of STRING",1,4,"%R7%low%E2%up%E2%i%E2%old l1677c23STRING%E2%",1};


T6 r7is_equal(se_dump_stack*caller,T7* C,T0* a1){
T6 R=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f7is_equal;
ds.current=((void**)&C);
ds.p=14774792;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f7is_equal.assertion_flag){
f7is_equal.assertion_flag=0;
(ds.p=2138688);
ac_req((a1)!=((void*)(NULL)),"other_not_void");
f7is_equal.assertion_flag=1;
}
if(((ds.p=14775846),((/*RF2*/(C)->_count/*8*/))==((/*RF2*/(se_i7(&ds,((T7*)ci(7,a1,14775850))))->_count/*8*/)))){
(ds.p=14776090);
R=r9fast_memcmp(&ds,(/*RF2*/(C)->_storage/*4*/),(/*RF2*/(se_i7(&ds,((T7*)ci(7,a1,14776150))))->_storage/*4*/),(/*RF2*/(C)->_count/*8*/));
}
if(f7is_equal.assertion_flag){
f7is_equal.assertion_flag=0;
(ds.p=60830508);
ac_ens((R)==(r6_px_and(&ds,r6_ix_not(&ds,r7_px_60(&ds,se_i7(&ds,C),a1)),r6_ix_not(&ds,r7_px_60(&ds,se_i7(&ds,((T7*)ci(7,a1,60830576))),(T0*)C)))),"trichotomy");
(ds.p=2139486);
ac_ens((!(r7standard_is_equal(&ds,C,a1)))||(R),"consistent");
(ds.p=2139704);
ac_ens((!(R))||(r7is_equal(&ds,se_i7(&ds,((T7*)ci(7,a1,2139720))),(T0*)C)),"symmetric");
f7is_equal.assertion_flag=1;
}
if(se_rci(C))se_i7(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f7is_equal={"is_equal of STRING",1,2,"%R7%other%R7%Result%E6%",1};


T3 r7item(se_dump_stack*caller,T7* C,T2 a1){
T3 R=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f7item;
ds.current=((void**)&C);
ds.p=14753544;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f7item.assertion_flag){
f7item.assertion_flag=0;
(ds.p=14754350);
ac_req(r7valid_index(&ds,C,a1),"valid_index");
f7item.assertion_flag=1;
}
(ds.p=14754836);
R=((/*RF2*/(C)->_storage/*4*/))[(a1)-(1)];
if(se_rci(C))se_i7(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f7item={"item of STRING",1,2,"%R7%i%E2%Result%E3%",1};


T6 r7valid_index(se_dump_stack*caller,T7* C,T2 a1){
T6 R=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f7valid_index;
ds.current=((void**)&C);
ds.p=14755592;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=14756372);
R=((1)<=(a1))&&((a1)<=(r7upper(&ds,C)));
if(f7valid_index.assertion_flag){
f7valid_index.assertion_flag=0;
(ds.p=14756922);
ac_ens((R)==(r6_px_and(&ds,(1)<=(a1),(a1)<=(r7upper(&ds,C)))),"definition");
f7valid_index.assertion_flag=1;
}
if(se_rci(C))se_i7(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f7valid_index={"valid_index of STRING",1,2,"%R7%i%E2%Result%E6%",1};


void r7append(se_dump_stack*caller,T7* C,T0* a1){
T2 _new_capacity=0;
T2 _needed_capacity=0;
T2 _s_count=0;
void**locals[4];
se_dump_stack ds;
ds.fd=&f7append;
ds.current=((void**)&C);
ds.p=15025928;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&_new_capacity;
locals[2]=(void**)&_needed_capacity;
locals[3]=(void**)&_s_count;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f7append.assertion_flag){
f7append.assertion_flag=0;
(ds.p=15026726);
ac_req(r7is_mutable(&ds,C),"mutable");
(ds.p=15026992);
ac_req((a1)!=((void*)(NULL)),"s_not_void");
f7append.assertion_flag=1;
}
(ds.p=15028230);
_s_count=(/*RF2*/(se_i7(&ds,((T7*)ci(7,a1,15028252))))->_count/*8*/);
(ds.p=15028500);
_needed_capacity=((/*RF2*/(C)->_count/*8*/))+(_s_count);
if(((ds.p=15028794),(_needed_capacity)>((/*RF2*/(C)->_capacity/*12*/)))){
if(((ds.p=15029042),((/*RF2*/(C)->_capacity/*12*/))==(0))){
(ds.p=15029280);
(/*SFN*/C->_storage)=((T9)(se_calloc(_needed_capacity,sizeof(T3))));
(ds.p=15029536);
(/*SFN*/C->_capacity)=_needed_capacity;
}
else{
(ds.p=15030048);
_new_capacity=(2)*((/*RF2*/(C)->_capacity/*12*/));
if(((ds.p=15030342),(_needed_capacity)>(_new_capacity))){
(ds.p=15030566);
(/*SFN*/C->_storage)=r9realloc(&ds,(/*RF2*/(C)->_storage/*4*/),(/*RF2*/(C)->_capacity/*12*/),_needed_capacity);
(ds.p=15030822);
(/*SFN*/C->_capacity)=_needed_capacity;
}
else{
(ds.p=15031334);
(/*SFN*/C->_storage)=r9realloc(&ds,(/*RF2*/(C)->_storage/*4*/),(/*RF2*/(C)->_capacity/*12*/),_new_capacity);
(ds.p=15031590);
(/*SFN*/C->_capacity)=_new_capacity;
}
}
}
(ds.p=15032612);
r9copy_at(&ds,(/*RF2*/(C)->_storage/*4*/),(/*RF2*/(C)->_count/*8*/),(/*RF2*/(se_i7(&ds,((T7*)ci(7,a1,15032640))))->_storage/*4*/),_s_count);
(ds.p=15032852);
(/*SFN*/C->_count)=_needed_capacity;
if(se_rci(C))se_i7(&ds,C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f7append={"append of STRING",1,4,"%R7%s%R7%new_capacity%E2%needed_capacity%E2%s_count%E2%",1};


void r7make(se_dump_stack*caller,T7* C,T2 a1){
void**locals[1];
se_dump_stack ds;
ds.fd=&f7make;
ds.current=((void**)&C);
ds.p=14728456;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f7make.assertion_flag){
f7make.assertion_flag=0;
(ds.p=14729510);
ac_req(r7is_mutable(&ds,C),"mutable");
(ds.p=14729818);
ac_req((a1)>=(0),"non_negative_size");
f7make.assertion_flag=1;
}
if(((ds.p=14730298),(a1)>(0))){
if(((ds.p=14730546),((/*RF2*/(C)->_capacity/*12*/))<(a1))){
(ds.p=14730784);
(/*SFN*/C->_storage)=((T9)(se_calloc(a1,sizeof(T3))));
(ds.p=14731040);
(/*SFN*/C->_capacity)=a1;
}
}
(ds.p=14731796);
(/*SFN*/C->_count)=0;
if(f7make.assertion_flag){
f7make.assertion_flag=0;
(ds.p=14732340);
ac_ens((a1)<=((/*RF2*/(C)->_capacity/*12*/)),NULL);
(ds.p=14732604);
ac_ens(((/*RF2*/(C)->_count/*8*/))==(0),"empty_string");
f7make.assertion_flag=1;
}
if(se_rci(C))se_i7(&ds,C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f7make={"make of STRING",1,1,"%R7%needed_capacity%E2%",1};


T6 r7has_prefix(se_dump_stack*caller,T7* C,T0* a1){
T6 R=0;
T2 _i=0;
void**locals[3];
se_dump_stack ds;
ds.fd=&f7has_prefix;
ds.current=((void**)&C);
ds.p=14816008;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
locals[2]=(void**)&_i;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f7has_prefix.assertion_flag){
f7has_prefix.assertion_flag=0;
(ds.p=14816792);
ac_req((a1)!=((void*)(NULL)),NULL);
f7has_prefix.assertion_flag=1;
}
if(((ds.p=14817834),((/*RF2*/(se_i7(&ds,((T7*)ci(7,a1,14817818))))->_count/*8*/))<=((/*RF2*/(C)->_count/*8*/)))){
(ds.p=14818336);
_i=(/*RF2*/(se_i7(&ds,((T7*)ci(7,a1,14818346))))->_count/*8*/);
while (!(((ds.p=14818860),((_i)==(0))||((r7item(&ds,C,_i))!=(r7item(&ds,se_i7(&ds,((T7*)ci(7,a1,14818898))),_i))))))
{
(ds.p=14819360);
_i=(_i)-(1);
}
(ds.p=14819866);
R=(_i)==(0);
}
if(se_rci(C))se_i7(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f7has_prefix={"has_prefix of STRING",1,3,"%R7%p%R7%Result%E6%i%E2%",1};


T6 r7is_empty(se_dump_stack*caller,T7* C){
T6 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f7is_empty;
ds.current=((void**)&C);
ds.p=14750472;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=14751252);
R=((/*RF2*/(C)->_count/*8*/))==(0);
if(se_rci(C))se_i7(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f7is_empty={"is_empty of STRING",1,1,"%R7%Result%E6%",1};


T6 r7is_mutable(se_dump_stack*caller,T7* C){
T6 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f7is_mutable;
ds.current=((void**)&C);
ds.p=14747912;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=14748436);
R=((/*RF2*/(C)->_key/*16*/))==(0);
if(se_rci(C))se_i7(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f7is_mutable={"is_mutable of STRING",1,1,"%R7%Result%E6%",1};


void r7extend(se_dump_stack*caller,T7* C,T3 a1){
T2 _new_capacity=0;
T2 o7_1524_26=0;
void**locals[3];
se_dump_stack ds;
ds.fd=&f7extend;
ds.current=((void**)&C);
ds.p=15065352;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&_new_capacity;
locals[2]=(void**)&o7_1524_26;
se_dst=&ds;/*link*/
o7_1524_26=(/*RF2*/(C)->_count/*8*/);
se_require_uppermost_flag=1;
if(f7extend.assertion_flag){
f7extend.assertion_flag=0;
(ds.p=15066150);
ac_req(r7is_mutable(&ds,C),"mutable");
f7extend.assertion_flag=1;
}
if(((ds.p=15067180),((/*RF2*/(C)->_capacity/*12*/))>((/*RF2*/(C)->_count/*8*/)))){
}
 else if(((ds.p=15067444),((/*RF2*/(C)->_capacity/*12*/))==(0))){
(ds.p=15067674);
(/*SFN*/C->_capacity)=32;
(ds.p=15067930);
(/*SFN*/C->_storage)=((T9)(se_calloc((/*RF2*/(C)->_capacity/*12*/),sizeof(T3))));
}
else{
(ds.p=15068442);
_new_capacity=(2)*((/*RF2*/(C)->_capacity/*12*/));
(ds.p=15068698);
(/*SFN*/C->_storage)=r9realloc(&ds,(/*RF2*/(C)->_storage/*4*/),(/*RF2*/(C)->_capacity/*12*/),_new_capacity);
(ds.p=15068954);
(/*SFN*/C->_capacity)=_new_capacity;
}
(ds.p=15069476);
((/*RF2*/(C)->_storage/*4*/))[(/*RF2*/(C)->_count/*8*/)]=(a1);
(ds.p=15069716);
(/*SFN*/C->_count)=((/*RF2*/(C)->_count/*8*/))+(1);
if(f7extend.assertion_flag){
f7extend.assertion_flag=0;
(ds.p=15070240);
ac_ens(((/*RF2*/(C)->_count/*8*/))==((1)+(o7_1524_26)),NULL);
(ds.p=15070510);
ac_ens((r7item(&ds,C,(/*RF2*/(C)->_count/*8*/)))==(a1),NULL);
f7extend.assertion_flag=1;
}
if(se_rci(C))se_i7(&ds,C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f7extend={"extend (add_last of STRING)",1,3,"%R7%c%E3%new_capacity%E2%old l1524c26STRING%E2%",1};


void r7remove_last(se_dump_stack*caller,T7* C,T2 a1){
T2 o7_1654_22=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f7remove_last;
ds.current=((void**)&C);
ds.p=15101192;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&o7_1654_22;
se_dst=&ds;/*link*/
o7_1654_22=(/*RF2*/(C)->_count/*8*/);
se_require_uppermost_flag=1;
if(f7remove_last.assertion_flag){
f7remove_last.assertion_flag=0;
(ds.p=15101990);
ac_req(r7is_mutable(&ds,C),"mutable");
(ds.p=15102232);
ac_req((0)<=(a1),NULL);
(ds.p=15102490);
ac_req((a1)<=((/*RF2*/(C)->_count/*8*/)),NULL);
f7remove_last.assertion_flag=1;
}
(ds.p=15102996);
(/*SFN*/C->_count)=((/*RF2*/(C)->_count/*8*/))-(a1);
if(f7remove_last.assertion_flag){
f7remove_last.assertion_flag=0;
(ds.p=15103520);
ac_ens(((/*RF2*/(C)->_count/*8*/))==((o7_1654_22)-(a1)),NULL);
f7remove_last.assertion_flag=1;
}
if(se_rci(C))se_i7(&ds,C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f7remove_last={"remove_last of STRING",1,2,"%R7%nb%E2%old l1654c22STRING%E2%",1};


T6 r7_px_60(se_dump_stack*caller,T7* C,T0* a1){
T6 R=0;
T2 _i=0;
void**locals[3];
se_dump_stack ds;
ds.fd=&f7_px_60;
ds.current=((void**)&C);
ds.p=14762504;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
locals[2]=(void**)&_i;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f7_px_60.assertion_flag){
f7_px_60.assertion_flag=0;
(ds.p=60832060);
ac_req((a1)!=((void*)(NULL)),"other_exists");
f7_px_60.assertion_flag=1;
}
(ds.p=14764058);
_i=1;
while (!(((ds.p=14764826),((((/*RF2*/(C)->_count/*8*/))<(_i))||(((/*RF2*/(se_i7(&ds,((T7*)ci(7,a1,14764606))))->_count/*8*/))<(_i)))||((r7item(&ds,C,_i))!=(r7item(&ds,se_i7(&ds,((T7*)ci(7,a1,14764864))),_i))))))
{
(ds.p=14765338);
_i=(_i)+(1);
}
if(((ds.p=14765862),((/*RF2*/(C)->_count/*8*/))<(_i))){
(ds.p=14766106);
R=((/*RF2*/(se_i7(&ds,((T7*)ci(7,a1,14766126))))->_count/*8*/))>=(_i);
}
 else if(((ds.p=14766394),((/*RF2*/(se_i7(&ds,((T7*)ci(7,a1,14766370))))->_count/*8*/))<(_i))){
(ds.p=14766618);
R=0;
}
else{
(ds.p=14767130);
R=r3_px_60(&ds,r7item(&ds,C,_i),r7item(&ds,se_i7(&ds,((T7*)ci(7,a1,14767170))),_i));
}
if(f7_px_60.assertion_flag){
f7_px_60.assertion_flag=0;
(ds.p=60832826);
ac_ens((!(R))||(r6_ix_not(&ds,r7_px_60(&ds,se_i7(&ds,((T7*)ci(7,a1,60832852))),(T0*)C))),"asymmetric");
f7_px_60.assertion_flag=1;
}
if(se_rci(C))se_i7(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f7_px_60={"infix < of STRING",1,3,"%R7%other%R7%Result%E6%i%E2%",1};


T6 r7standard_is_equal(se_dump_stack*caller,T7* C,T0* a1){
T6 R=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f7standard_is_equal;
ds.current=((void**)&C);
ds.p=2145046;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f7standard_is_equal.assertion_flag){
f7standard_is_equal.assertion_flag=0;
(ds.p=2145824);
ac_req((a1)!=((void*)(NULL)),NULL);
f7standard_is_equal.assertion_flag=1;
}
R=((C->id==a1->id)?!memcmp(C,a1,sizeof(*C)):0);if(f7standard_is_equal.assertion_flag){
f7standard_is_equal.assertion_flag=0;
(ds.p=2146616);
ac_ens((!(R))||(r7standard_is_equal(&ds,se_i7(&ds,((T7*)ci(7,a1,2146632))),(T0*)C)),"symmetric");
f7standard_is_equal.assertion_flag=1;
}
if(se_rci(C))se_i7(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f7standard_is_equal={"standard_is_equal of GENERAL",1,2,"%R7%other%R7%Result%E6%",1};


T6 r7has(se_dump_stack*caller,T7* C,T3 a1){
T6 R=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f7has;
ds.current=((void**)&C);
ds.p=14801160;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=14801940);
R=r9fast_has(&ds,(/*RF2*/(C)->_storage/*4*/),a1,((/*RF2*/(C)->_count/*8*/))-(1));
if(se_rci(C))se_i7(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f7has={"has of STRING",1,2,"%R7%c%E3%Result%E6%",1};


T3 r7first(se_dump_stack*caller,T7* C){
T3 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f7first;
ds.current=((void**)&C);
ds.p=15152648;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f7first.assertion_flag){
f7first.assertion_flag=0;
(ds.p=15153428);
ac_req(r6_ix_not(&ds,r7is_empty(&ds,C)),NULL);
f7first.assertion_flag=1;
}
(ds.p=15153940);
R=((/*RF2*/(C)->_storage/*4*/))[0];
if(f7first.assertion_flag){
f7first.assertion_flag=0;
(ds.p=15154476);
ac_ens((R)==(r7item(&ds,C,1)),"definition");
f7first.assertion_flag=1;
}
if(se_rci(C))se_i7(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f7first={"first of STRING",1,1,"%R7%Result%E3%",1};


void r7clear(se_dump_stack*caller,T7* C){
se_dump_stack ds;
ds.fd=&f7clear;
ds.current=((void**)&C);
ds.p=14996488;
ds.caller=caller;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f7clear.assertion_flag){
f7clear.assertion_flag=0;
(ds.p=14997542);
ac_req(r7is_mutable(&ds,C),"mutable");
f7clear.assertion_flag=1;
}
(ds.p=14998036);
(/*SFN*/C->_count)=0;
if(f7clear.assertion_flag){
f7clear.assertion_flag=0;
(ds.p=14998560);
ac_ens(((/*RF2*/(C)->_count/*8*/))==(0),NULL);
f7clear.assertion_flag=1;
}
if(se_rci(C))se_i7(&ds,C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f7clear={"clear of STRING",1,0,"%R7%",1};


T8 r7to_external(se_dump_stack*caller,T7* C){
T8 R=NULL;
T2 o7_2090_22=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f7to_external;
ds.current=((void**)&C);
ds.p=15211272;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
locals[1]=(void**)&o7_2090_22;
se_dst=&ds;/*link*/
o7_2090_22=(/*RF2*/(C)->_count/*8*/);
if(((ds.p=15212844),((/*RF2*/(C)->_capacity/*12*/))==((/*RF2*/(C)->_count/*8*/)))){
(ds.p=15213082);
(/*SFN*/C->_storage)=r9realloc(&ds,(/*RF2*/(C)->_storage/*4*/),(/*RF2*/(C)->_capacity/*12*/),((/*RF2*/(C)->_capacity/*12*/))+(1));
(ds.p=15213338);
(/*SFN*/C->_capacity)=((/*RF2*/(C)->_capacity/*12*/))+(1);
}
if(((ds.p=15213890),(((/*RF2*/(C)->_storage/*4*/))[(/*RF2*/(C)->_count/*8*/)])!=(((T3)'\0')))){
(ds.p=15214122);
((/*RF2*/(C)->_storage/*4*/))[(/*RF2*/(C)->_count/*8*/)]=(((T3)'\0'));
}
(ds.p=15214612);
R=((void*)(/*RF2*/(C)->_storage/*4*/));
if(f7to_external.assertion_flag){
f7to_external.assertion_flag=0;
(ds.p=15215136);
ac_ens(((/*RF2*/(C)->_count/*8*/))==(o7_2090_22),NULL);
(ds.p=15215394);
ac_ens((NULL!=R),NULL);
f7to_external.assertion_flag=1;
}
if(se_rci(C))se_i7(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f7to_external={"to_external of STRING",1,2,"%R7%Result%E8%old l2090c22STRING%E2%",1};


void r7swap(se_dump_stack*caller,T7* C,T2 a1,T2 a2){
T3 _tmp=0;
T3 o7_1795_25=0;
T3 o7_1796_25=0;
void**locals[5];
se_dump_stack ds;
ds.fd=&f7swap;
ds.current=((void**)&C);
ds.p=15136776;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&a2;
locals[2]=(void**)&_tmp;
locals[3]=(void**)&o7_1795_25;
locals[4]=(void**)&o7_1796_25;
se_dst=&ds;/*link*/
o7_1795_25=r7item(&ds,C,a2);
o7_1796_25=r7item(&ds,C,a1);
se_require_uppermost_flag=1;
if(f7swap.assertion_flag){
f7swap.assertion_flag=0;
(ds.p=15137300);
ac_req(r7valid_index(&ds,C,a1),NULL);
(ds.p=15137556);
ac_req(r7valid_index(&ds,C,a2),NULL);
f7swap.assertion_flag=1;
}
(ds.p=15138580);
_tmp=r7item(&ds,C,a1);
(ds.p=15138836);
r7put(&ds,C,r7item(&ds,C,a2),a1);
(ds.p=15139092);
r7put(&ds,C,_tmp,a2);
if(f7swap.assertion_flag){
f7swap.assertion_flag=0;
(ds.p=15139622);
ac_ens((r7item(&ds,C,a1))==(o7_1795_25),NULL);
(ds.p=15139878);
ac_ens((r7item(&ds,C,a2))==(o7_1796_25),NULL);
f7swap.assertion_flag=1;
}
if(se_rci(C))se_i7(&ds,C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f7swap={"swap of STRING",1,5,"%R7%i1%E2%i2%E2%tmp%E3%old l1795c25STRING%E3%old l1796c25STRING%E3%",1};
se_frame_descriptor se_ifd7={"Class invariant of STRING",1,0,"%R7%",1};


T7*se_i7(se_dump_stack*caller,T7*C){
se_dump_stack ds;
ds.fd=&se_ifd7;
ds.current=((void**)&C);
ds.p=14714638;
ds.caller=caller;
se_dst=&ds;
if(ds.fd->assertion_flag){
ds.fd->assertion_flag=0;
(ds.p=15250188);
ac_inv((0)<=((/*RF2*/(C)->_count/*8*/)),NULL);
(ds.p=15250708);
ac_inv(((/*RF2*/(C)->_count/*8*/))<=((/*RF2*/(C)->_capacity/*12*/)),NULL);
(ds.p=15251234);
ac_inv((!(((/*RF2*/(C)->_capacity/*12*/))>(0)))||(r9is_not_null(&ds,(/*RF2*/(C)->_storage/*4*/))),NULL);
ds.fd->assertion_flag=1;
}
se_dst=caller;
return C;
}


T0* r40last(se_dump_stack*caller,T40* C){
T0* R=NULL;
void**locals[1];
se_dump_stack ds;
ds.fd=&f40last;
ds.current=((void**)&C);
ds.p=77619208;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f40last.assertion_flag){
f40last.assertion_flag=0;
(ds.p=79723796);
ac_req(r6_ix_not(&ds,r40is_empty(&ds,C)),NULL);
f40last.assertion_flag=1;
}
(ds.p=77619732);
R=r40item(&ds,C,(/*RF2*/(C)->_upper/*12*/));
if(f40last.assertion_flag){
f40last.assertion_flag=0;
(ds.p=79724578);
ac_ens((R)==((void*)(r40item(&ds,C,(/*RF2*/(C)->_upper/*12*/)))),NULL);
f40last.assertion_flag=1;
}
if(se_rci(C))se_i40(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f40last={"last of ARRAYED_COLLECTION",1,1,"%R40%Result%R22%",1};


T2 r40count(se_dump_stack*caller,T40* C){
T2 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f40count;
ds.current=((void**)&C);
ds.p=75534600;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=75535124);
R=((/*RF2*/(C)->_upper/*12*/))+(1);
if(f40count.assertion_flag){
f40count.assertion_flag=0;
(ds.p=79714338);
ac_ens((R)==((((/*RF2*/(C)->_upper/*12*/))-(0))+(1)),NULL);
f40count.assertion_flag=1;
}
if(se_rci(C))se_i40(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f40count={"count of FIXED_ARRAY",1,1,"%R40%Result%E2%",1};


void r40put(se_dump_stack*caller,T40* C,T0* a1,T2 a2){
T2 o38_140_22=0;
void**locals[3];
se_dump_stack ds;
ds.fd=&f40put;
ds.current=((void**)&C);
ds.p=75533320;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&a2;
locals[2]=(void**)&o38_140_22;
se_dst=&ds;/*link*/
o38_140_22=r40count(&ds,C);
se_require_uppermost_flag=1;
if(f40put.assertion_flag){
f40put.assertion_flag=0;
(ds.p=79726612);
ac_req(r40valid_index(&ds,C,a2),NULL);
f40put.assertion_flag=1;
}
(ds.p=75533860);
((/*RF2*/(C)->_storage/*4*/))[a2]=(a1);
if(f40put.assertion_flag){
f40put.assertion_flag=0;
(ds.p=79727396);
ac_ens((r40item(&ds,C,a2))==((void*)(a1)),NULL);
(ds.p=79727648);
ac_ens((r40count(&ds,C))==(o38_140_22),NULL);
f40put.assertion_flag=1;
}
if(se_rci(C))se_i40(&ds,C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f40put={"put of FIXED_ARRAY",1,3,"%R40%element%R22%i%E2%old l140c22COLLECTION%E2%",1};


T0* r40item(se_dump_stack*caller,T40* C,T2 a1){
T0* R=NULL;
void**locals[2];
se_dump_stack ds;
ds.fd=&f40item;
ds.current=((void**)&C);
ds.p=75532040;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f40item.assertion_flag){
f40item.assertion_flag=0;
(ds.p=79719700);
ac_req(r40valid_index(&ds,C,a1),NULL);
f40item.assertion_flag=1;
}
(ds.p=75532564);
R=((/*RF2*/(C)->_storage/*4*/))[a1];
if(se_rci(C))se_i40(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f40item={"item of FIXED_ARRAY",1,2,"%R40%i%E2%Result%R22%",1};


T6 r40valid_index(se_dump_stack*caller,T40* C,T2 a1){
T6 R=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f40valid_index;
ds.current=((void**)&C);
ds.p=79710486;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=79711508);
R=((0)<=(a1))&&((a1)<=((/*RF2*/(C)->_upper/*12*/)));
if(f40valid_index.assertion_flag){
f40valid_index.assertion_flag=0;
(ds.p=79712034);
ac_ens((R)==(((0)<=(a1))&&((a1)<=((/*RF2*/(C)->_upper/*12*/)))),NULL);
f40valid_index.assertion_flag=1;
}
if(se_rci(C))se_i40(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f40valid_index={"valid_index of COLLECTION",1,2,"%R40%index%E2%Result%E6%",1};


T6 r40is_empty(se_dump_stack*caller,T40* C){
T6 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f40is_empty;
ds.current=((void**)&C);
ds.p=77610760;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=77611284);
R=(r40count(&ds,C))==(0);
if(f40is_empty.assertion_flag){
f40is_empty.assertion_flag=0;
(ds.p=79716116);
ac_ens((R)==((r40count(&ds,C))==(0)),NULL);
f40is_empty.assertion_flag=1;
}
if(se_rci(C))se_i40(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f40is_empty={"is_empty of ARRAYED_COLLECTION",1,1,"%R40%Result%E6%",1};


void r40increase_capacity(se_dump_stack*caller,T40* C,T2 a1){
T2 _new_capacity=0;
T2 o37_198_25=0;
void**locals[3];
se_dump_stack ds;
ds.fd=&f40increase_capacity;
ds.current=((void**)&C);
ds.p=77639688;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&_new_capacity;
locals[2]=(void**)&o37_198_25;
se_dst=&ds;/*link*/
o37_198_25=(/*RF2*/(C)->_capacity/*8*/);
se_require_uppermost_flag=1;
if(f40increase_capacity.assertion_flag){
f40increase_capacity.assertion_flag=0;
(ds.p=77640494);
ac_req((a1)>((/*RF2*/(C)->_capacity/*8*/)),NULL);
f40increase_capacity.assertion_flag=1;
}
if(((ds.p=77641516),((/*RF2*/(C)->_capacity/*8*/))==(0))){
(ds.p=77641754);
(/*SFN*/C->_capacity)=a1;
(ds.p=77642010);
(/*SFN*/C->_storage)=((T42)(se_calloc((/*RF2*/(C)->_capacity/*8*/),sizeof(T0*))));
}
else{
(ds.p=77642784);
_new_capacity=((/*RF2*/(C)->_capacity/*8*/))*(2);
while (!(((ds.p=77643322),(_new_capacity)>=(a1))))
{
(ds.p=77643808);
_new_capacity=(_new_capacity)*(2);
}
(ds.p=77644314);
(/*SFN*/C->_storage)=r42realloc(&ds,(/*RF2*/(C)->_storage/*4*/),(/*RF2*/(C)->_capacity/*8*/),_new_capacity);
(ds.p=77644570);
(/*SFN*/C->_capacity)=_new_capacity;
}
if(f40increase_capacity.assertion_flag){
f40increase_capacity.assertion_flag=0;
(ds.p=77645350);
ac_ens(((/*RF2*/(C)->_capacity/*8*/))>(o37_198_25),NULL);
f40increase_capacity.assertion_flag=1;
}
if(se_rci(C))se_i40(&ds,C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f40increase_capacity={"increase_capacity of ARRAYED_COLLECTION",1,3,"%R40%min_capacity%E2%new_capacity%E2%old l198c25ARRAYED_COLLECTION%E2%",1};


void r40increment_upper(se_dump_stack*caller,T40* C){
se_dump_stack ds;
ds.fd=&f40increment_upper;
ds.current=((void**)&C);
ds.p=77637128;
ds.caller=caller;
se_dst=&ds;/*link*/
if(((ds.p=77637676),((/*RF2*/(C)->_capacity/*8*/))==(0))){
(ds.p=77637914);
r40increase_capacity(&ds,C,8);
}
 else if(((ds.p=77638190),(r40count(&ds,C))==((/*RF2*/(C)->_capacity/*8*/)))){
(ds.p=77638426);
r40increase_capacity(&ds,C,(r40count(&ds,C))+(1));
}
(ds.p=77638932);
(/*SFN*/C->_upper)=((/*RF2*/(C)->_upper/*12*/))+(1);
if(se_rci(C))se_i40(&ds,C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f40increment_upper={"increment_upper of ARRAYED_COLLECTION",1,0,"%R40%",1};


void r40add_last(se_dump_stack*caller,T40* C,T0* a1){
T2 o38_219_26=0;
T2 o38_220_22=0;
T2 o38_221_26=0;
void**locals[4];
se_dump_stack ds;
ds.fd=&f40add_last;
ds.current=((void**)&C);
ds.p=77623560;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&o38_219_26;
locals[2]=(void**)&o38_220_22;
locals[3]=(void**)&o38_221_26;
se_dst=&ds;/*link*/
o38_219_26=r40count(&ds,C);
o38_220_22=0;
o38_221_26=(/*RF2*/(C)->_upper/*12*/);
(ds.p=77624084);
r40increment_upper(&ds,C);
(ds.p=77624340);
r40put(&ds,C,a1,(/*RF2*/(C)->_upper/*12*/));
if(f40add_last.assertion_flag){
f40add_last.assertion_flag=0;
(ds.p=79747614);
ac_ens((r40last(&ds,C))==((void*)(a1)),NULL);
(ds.p=79747872);
ac_ens((r40count(&ds,C))==((1)+(o38_219_26)),NULL);
(ds.p=79748128);
ac_ens((0)==(o38_220_22),NULL);
(ds.p=79748384);
ac_ens(((/*RF2*/(C)->_upper/*12*/))==((1)+(o38_221_26)),NULL);
f40add_last.assertion_flag=1;
}
if(se_rci(C))se_i40(&ds,C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f40add_last={"add_last of ARRAYED_COLLECTION",1,4,"%R40%element%R22%old l219c26COLLECTION%E2%old l220c22COLLECTION%E2%old l221c26COLLECTION%E2%",1};


void r40with_capacity(se_dump_stack*caller,T40* C,T2 a1){
void**locals[1];
se_dump_stack ds;
ds.fd=&f40with_capacity;
ds.current=((void**)&C);
ds.p=75521800;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f40with_capacity.assertion_flag){
f40with_capacity.assertion_flag=0;
(ds.p=75522598);
ac_req((a1)>=(0),NULL);
f40with_capacity.assertion_flag=1;
}
if(((ds.p=75523116),((/*RF2*/(C)->_capacity/*8*/))<(a1))){
(ds.p=75523354);
(/*SFN*/C->_storage)=((T42)(se_calloc(a1,sizeof(T0*))));
(ds.p=75523610);
(/*SFN*/C->_capacity)=a1;
}
 else if(((ds.p=75523878),((/*RF2*/(C)->_capacity/*8*/))>(a1))){
(ds.p=75524124);
r42clear(&ds,(/*RF2*/(C)->_storage/*4*/),0,(/*RF2*/(C)->_upper/*12*/));
}
(ds.p=75524628);
(/*SFN*/C->_upper)=-(1);
if(f40with_capacity.assertion_flag){
f40with_capacity.assertion_flag=0;
(ds.p=75525158);
ac_ens(((/*RF2*/(C)->_capacity/*8*/))>=(a1),NULL);
(ds.p=75525396);
ac_ens(r40is_empty(&ds,C),NULL);
f40with_capacity.assertion_flag=1;
}
if(se_rci(C))se_i40(&ds,C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f40with_capacity={"with_capacity of FIXED_ARRAY",1,1,"%R40%needed_capacity%E2%",1};
se_frame_descriptor se_ifd40={"Class invariant of FIXED_ARRAY[CLASS_DEFINITION]",1,0,"%R40%",1};


T40*se_i40(se_dump_stack*caller,T40*C){
se_dump_stack ds;
ds.fd=&se_ifd40;
ds.current=((void**)&C);
ds.p=75509262;
ds.caller=caller;
se_dst=&ds;
if(ds.fd->assertion_flag){
ds.fd->assertion_flag=0;
(ds.p=79843888);
ac_inv((0)<=(((/*RF2*/(C)->_upper/*12*/))+(1)),"valid_bounds");
(ds.p=77646874);
ac_inv(((/*RF2*/(C)->_capacity/*8*/))>=((((/*RF2*/(C)->_upper/*12*/))-(0))+(1)),NULL);
(ds.p=77647394);
ac_inv((!(((/*RF2*/(C)->_capacity/*8*/))>(0)))||(r42is_not_null(&ds,(/*RF2*/(C)->_storage/*4*/))),NULL);
(ds.p=75569966);
ac_inv((r40count(&ds,C))<=((/*RF2*/(C)->_capacity/*8*/)),"valid_count");
ds.fd->assertion_flag=1;
}
se_dst=caller;
return C;
}


T0* r44last(se_dump_stack*caller,T44* C){
T0* R=NULL;
void**locals[1];
se_dump_stack ds;
ds.fd=&f44last;
ds.current=((void**)&C);
ds.p=77619208;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f44last.assertion_flag){
f44last.assertion_flag=0;
(ds.p=79723796);
ac_req(r6_ix_not(&ds,r44is_empty(&ds,C)),NULL);
f44last.assertion_flag=1;
}
(ds.p=77619732);
R=r44item(&ds,C,(/*RF2*/(C)->_upper/*12*/));
if(f44last.assertion_flag){
f44last.assertion_flag=0;
(ds.p=79724578);
ac_ens((R)==((void*)(r44item(&ds,C,(/*RF2*/(C)->_upper/*12*/)))),NULL);
f44last.assertion_flag=1;
}
if(se_rci(C))se_i44(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f44last={"last of ARRAYED_COLLECTION",1,1,"%R44%Result%R24%",1};


T2 r44count(se_dump_stack*caller,T44* C){
T2 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f44count;
ds.current=((void**)&C);
ds.p=75534600;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=75535124);
R=((/*RF2*/(C)->_upper/*12*/))+(1);
if(f44count.assertion_flag){
f44count.assertion_flag=0;
(ds.p=79714338);
ac_ens((R)==((((/*RF2*/(C)->_upper/*12*/))-(0))+(1)),NULL);
f44count.assertion_flag=1;
}
if(se_rci(C))se_i44(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f44count={"count of FIXED_ARRAY",1,1,"%R44%Result%E2%",1};


void r44put(se_dump_stack*caller,T44* C,T0* a1,T2 a2){
T2 o38_140_22=0;
void**locals[3];
se_dump_stack ds;
ds.fd=&f44put;
ds.current=((void**)&C);
ds.p=75533320;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&a2;
locals[2]=(void**)&o38_140_22;
se_dst=&ds;/*link*/
o38_140_22=r44count(&ds,C);
se_require_uppermost_flag=1;
if(f44put.assertion_flag){
f44put.assertion_flag=0;
(ds.p=79726612);
ac_req(r44valid_index(&ds,C,a2),NULL);
f44put.assertion_flag=1;
}
(ds.p=75533860);
((/*RF2*/(C)->_storage/*4*/))[a2]=(a1);
if(f44put.assertion_flag){
f44put.assertion_flag=0;
(ds.p=79727396);
ac_ens((r44item(&ds,C,a2))==((void*)(a1)),NULL);
(ds.p=79727648);
ac_ens((r44count(&ds,C))==(o38_140_22),NULL);
f44put.assertion_flag=1;
}
if(se_rci(C))se_i44(&ds,C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f44put={"put of FIXED_ARRAY",1,3,"%R44%element%R24%i%E2%old l140c22COLLECTION%E2%",1};


T0* r44item(se_dump_stack*caller,T44* C,T2 a1){
T0* R=NULL;
void**locals[2];
se_dump_stack ds;
ds.fd=&f44item;
ds.current=((void**)&C);
ds.p=75532040;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f44item.assertion_flag){
f44item.assertion_flag=0;
(ds.p=79719700);
ac_req(r44valid_index(&ds,C,a1),NULL);
f44item.assertion_flag=1;
}
(ds.p=75532564);
R=((/*RF2*/(C)->_storage/*4*/))[a1];
if(se_rci(C))se_i44(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f44item={"item of FIXED_ARRAY",1,2,"%R44%i%E2%Result%R24%",1};


T6 r44valid_index(se_dump_stack*caller,T44* C,T2 a1){
T6 R=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f44valid_index;
ds.current=((void**)&C);
ds.p=79710486;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=79711508);
R=((0)<=(a1))&&((a1)<=((/*RF2*/(C)->_upper/*12*/)));
if(f44valid_index.assertion_flag){
f44valid_index.assertion_flag=0;
(ds.p=79712034);
ac_ens((R)==(((0)<=(a1))&&((a1)<=((/*RF2*/(C)->_upper/*12*/)))),NULL);
f44valid_index.assertion_flag=1;
}
if(se_rci(C))se_i44(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f44valid_index={"valid_index of COLLECTION",1,2,"%R44%index%E2%Result%E6%",1};


T6 r44is_empty(se_dump_stack*caller,T44* C){
T6 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f44is_empty;
ds.current=((void**)&C);
ds.p=77610760;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=77611284);
R=(r44count(&ds,C))==(0);
if(f44is_empty.assertion_flag){
f44is_empty.assertion_flag=0;
(ds.p=79716116);
ac_ens((R)==((r44count(&ds,C))==(0)),NULL);
f44is_empty.assertion_flag=1;
}
if(se_rci(C))se_i44(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f44is_empty={"is_empty of ARRAYED_COLLECTION",1,1,"%R44%Result%E6%",1};


void r44increase_capacity(se_dump_stack*caller,T44* C,T2 a1){
T2 _new_capacity=0;
T2 o37_198_25=0;
void**locals[3];
se_dump_stack ds;
ds.fd=&f44increase_capacity;
ds.current=((void**)&C);
ds.p=77639688;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&_new_capacity;
locals[2]=(void**)&o37_198_25;
se_dst=&ds;/*link*/
o37_198_25=(/*RF2*/(C)->_capacity/*8*/);
se_require_uppermost_flag=1;
if(f44increase_capacity.assertion_flag){
f44increase_capacity.assertion_flag=0;
(ds.p=77640494);
ac_req((a1)>((/*RF2*/(C)->_capacity/*8*/)),NULL);
f44increase_capacity.assertion_flag=1;
}
if(((ds.p=77641516),((/*RF2*/(C)->_capacity/*8*/))==(0))){
(ds.p=77641754);
(/*SFN*/C->_capacity)=a1;
(ds.p=77642010);
(/*SFN*/C->_storage)=((T46)(se_calloc((/*RF2*/(C)->_capacity/*8*/),sizeof(T0*))));
}
else{
(ds.p=77642784);
_new_capacity=((/*RF2*/(C)->_capacity/*8*/))*(2);
while (!(((ds.p=77643322),(_new_capacity)>=(a1))))
{
(ds.p=77643808);
_new_capacity=(_new_capacity)*(2);
}
(ds.p=77644314);
(/*SFN*/C->_storage)=r46realloc(&ds,(/*RF2*/(C)->_storage/*4*/),(/*RF2*/(C)->_capacity/*8*/),_new_capacity);
(ds.p=77644570);
(/*SFN*/C->_capacity)=_new_capacity;
}
if(f44increase_capacity.assertion_flag){
f44increase_capacity.assertion_flag=0;
(ds.p=77645350);
ac_ens(((/*RF2*/(C)->_capacity/*8*/))>(o37_198_25),NULL);
f44increase_capacity.assertion_flag=1;
}
if(se_rci(C))se_i44(&ds,C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f44increase_capacity={"increase_capacity of ARRAYED_COLLECTION",1,3,"%R44%min_capacity%E2%new_capacity%E2%old l198c25ARRAYED_COLLECTION%E2%",1};


void r44increment_upper(se_dump_stack*caller,T44* C){
se_dump_stack ds;
ds.fd=&f44increment_upper;
ds.current=((void**)&C);
ds.p=77637128;
ds.caller=caller;
se_dst=&ds;/*link*/
if(((ds.p=77637676),((/*RF2*/(C)->_capacity/*8*/))==(0))){
(ds.p=77637914);
r44increase_capacity(&ds,C,8);
}
 else if(((ds.p=77638190),(r44count(&ds,C))==((/*RF2*/(C)->_capacity/*8*/)))){
(ds.p=77638426);
r44increase_capacity(&ds,C,(r44count(&ds,C))+(1));
}
(ds.p=77638932);
(/*SFN*/C->_upper)=((/*RF2*/(C)->_upper/*12*/))+(1);
if(se_rci(C))se_i44(&ds,C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f44increment_upper={"increment_upper of ARRAYED_COLLECTION",1,0,"%R44%",1};


void r44add_last(se_dump_stack*caller,T44* C,T0* a1){
T2 o38_219_26=0;
T2 o38_220_22=0;
T2 o38_221_26=0;
void**locals[4];
se_dump_stack ds;
ds.fd=&f44add_last;
ds.current=((void**)&C);
ds.p=77623560;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&o38_219_26;
locals[2]=(void**)&o38_220_22;
locals[3]=(void**)&o38_221_26;
se_dst=&ds;/*link*/
o38_219_26=r44count(&ds,C);
o38_220_22=0;
o38_221_26=(/*RF2*/(C)->_upper/*12*/);
(ds.p=77624084);
r44increment_upper(&ds,C);
(ds.p=77624340);
r44put(&ds,C,a1,(/*RF2*/(C)->_upper/*12*/));
if(f44add_last.assertion_flag){
f44add_last.assertion_flag=0;
(ds.p=79747614);
ac_ens((r44last(&ds,C))==((void*)(a1)),NULL);
(ds.p=79747872);
ac_ens((r44count(&ds,C))==((1)+(o38_219_26)),NULL);
(ds.p=79748128);
ac_ens((0)==(o38_220_22),NULL);
(ds.p=79748384);
ac_ens(((/*RF2*/(C)->_upper/*12*/))==((1)+(o38_221_26)),NULL);
f44add_last.assertion_flag=1;
}
if(se_rci(C))se_i44(&ds,C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f44add_last={"add_last of ARRAYED_COLLECTION",1,4,"%R44%element%R24%old l219c26COLLECTION%E2%old l220c22COLLECTION%E2%old l221c26COLLECTION%E2%",1};


void r44with_capacity(se_dump_stack*caller,T44* C,T2 a1){
void**locals[1];
se_dump_stack ds;
ds.fd=&f44with_capacity;
ds.current=((void**)&C);
ds.p=75521800;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f44with_capacity.assertion_flag){
f44with_capacity.assertion_flag=0;
(ds.p=75522598);
ac_req((a1)>=(0),NULL);
f44with_capacity.assertion_flag=1;
}
if(((ds.p=75523116),((/*RF2*/(C)->_capacity/*8*/))<(a1))){
(ds.p=75523354);
(/*SFN*/C->_storage)=((T46)(se_calloc(a1,sizeof(T0*))));
(ds.p=75523610);
(/*SFN*/C->_capacity)=a1;
}
 else if(((ds.p=75523878),((/*RF2*/(C)->_capacity/*8*/))>(a1))){
(ds.p=75524124);
r46clear(&ds,(/*RF2*/(C)->_storage/*4*/),0,(/*RF2*/(C)->_upper/*12*/));
}
(ds.p=75524628);
(/*SFN*/C->_upper)=-(1);
if(f44with_capacity.assertion_flag){
f44with_capacity.assertion_flag=0;
(ds.p=75525158);
ac_ens(((/*RF2*/(C)->_capacity/*8*/))>=(a1),NULL);
(ds.p=75525396);
ac_ens(r44is_empty(&ds,C),NULL);
f44with_capacity.assertion_flag=1;
}
if(se_rci(C))se_i44(&ds,C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f44with_capacity={"with_capacity of FIXED_ARRAY",1,1,"%R44%needed_capacity%E2%",1};
se_frame_descriptor se_ifd44={"Class invariant of FIXED_ARRAY[SPELLING]",1,0,"%R44%",1};


T44*se_i44(se_dump_stack*caller,T44*C){
se_dump_stack ds;
ds.fd=&se_ifd44;
ds.current=((void**)&C);
ds.p=75509262;
ds.caller=caller;
se_dst=&ds;
if(ds.fd->assertion_flag){
ds.fd->assertion_flag=0;
(ds.p=79843888);
ac_inv((0)<=(((/*RF2*/(C)->_upper/*12*/))+(1)),"valid_bounds");
(ds.p=77646874);
ac_inv(((/*RF2*/(C)->_capacity/*8*/))>=((((/*RF2*/(C)->_upper/*12*/))-(0))+(1)),NULL);
(ds.p=77647394);
ac_inv((!(((/*RF2*/(C)->_capacity/*8*/))>(0)))||(r46is_not_null(&ds,(/*RF2*/(C)->_storage/*4*/))),NULL);
(ds.p=75569966);
ac_inv((r44count(&ds,C))<=((/*RF2*/(C)->_capacity/*8*/)),"valid_count");
ds.fd->assertion_flag=1;
}
se_dst=caller;
return C;
}


T0* r64last(se_dump_stack*caller,T64* C){
T0* R=NULL;
void**locals[1];
se_dump_stack ds;
ds.fd=&f64last;
ds.current=((void**)&C);
ds.p=77619208;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f64last.assertion_flag){
f64last.assertion_flag=0;
(ds.p=79723796);
ac_req(r6_ix_not(&ds,r64is_empty(&ds,C)),NULL);
f64last.assertion_flag=1;
}
(ds.p=77619732);
R=r64item(&ds,C,(/*RF2*/(C)->_upper/*12*/));
if(f64last.assertion_flag){
f64last.assertion_flag=0;
(ds.p=79724578);
ac_ens((R)==((void*)(r64item(&ds,C,(/*RF2*/(C)->_upper/*12*/)))),NULL);
f64last.assertion_flag=1;
}
if(se_rci(C))se_i64(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f64last={"last of ARRAYED_COLLECTION",1,1,"%R64%Result%R25%",1};


T2 r64count(se_dump_stack*caller,T64* C){
T2 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f64count;
ds.current=((void**)&C);
ds.p=75534600;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=75535124);
R=((/*RF2*/(C)->_upper/*12*/))+(1);
if(f64count.assertion_flag){
f64count.assertion_flag=0;
(ds.p=79714338);
ac_ens((R)==((((/*RF2*/(C)->_upper/*12*/))-(0))+(1)),NULL);
f64count.assertion_flag=1;
}
if(se_rci(C))se_i64(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f64count={"count of FIXED_ARRAY",1,1,"%R64%Result%E2%",1};


void r64put(se_dump_stack*caller,T64* C,T0* a1,T2 a2){
T2 o38_140_22=0;
void**locals[3];
se_dump_stack ds;
ds.fd=&f64put;
ds.current=((void**)&C);
ds.p=75533320;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&a2;
locals[2]=(void**)&o38_140_22;
se_dst=&ds;/*link*/
o38_140_22=r64count(&ds,C);
se_require_uppermost_flag=1;
if(f64put.assertion_flag){
f64put.assertion_flag=0;
(ds.p=79726612);
ac_req(r64valid_index(&ds,C,a2),NULL);
f64put.assertion_flag=1;
}
(ds.p=75533860);
((/*RF2*/(C)->_storage/*4*/))[a2]=(a1);
if(f64put.assertion_flag){
f64put.assertion_flag=0;
(ds.p=79727396);
ac_ens((r64item(&ds,C,a2))==((void*)(a1)),NULL);
(ds.p=79727648);
ac_ens((r64count(&ds,C))==(o38_140_22),NULL);
f64put.assertion_flag=1;
}
if(se_rci(C))se_i64(&ds,C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f64put={"put of FIXED_ARRAY",1,3,"%R64%element%R25%i%E2%old l140c22COLLECTION%E2%",1};


T0* r64item(se_dump_stack*caller,T64* C,T2 a1){
T0* R=NULL;
void**locals[2];
se_dump_stack ds;
ds.fd=&f64item;
ds.current=((void**)&C);
ds.p=75532040;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f64item.assertion_flag){
f64item.assertion_flag=0;
(ds.p=79719700);
ac_req(r64valid_index(&ds,C,a1),NULL);
f64item.assertion_flag=1;
}
(ds.p=75532564);
R=((/*RF2*/(C)->_storage/*4*/))[a1];
if(se_rci(C))se_i64(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f64item={"item of FIXED_ARRAY",1,2,"%R64%i%E2%Result%R25%",1};


T6 r64valid_index(se_dump_stack*caller,T64* C,T2 a1){
T6 R=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f64valid_index;
ds.current=((void**)&C);
ds.p=79710486;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=79711508);
R=((0)<=(a1))&&((a1)<=((/*RF2*/(C)->_upper/*12*/)));
if(f64valid_index.assertion_flag){
f64valid_index.assertion_flag=0;
(ds.p=79712034);
ac_ens((R)==(((0)<=(a1))&&((a1)<=((/*RF2*/(C)->_upper/*12*/)))),NULL);
f64valid_index.assertion_flag=1;
}
if(se_rci(C))se_i64(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f64valid_index={"valid_index of COLLECTION",1,2,"%R64%index%E2%Result%E6%",1};


T6 r64is_empty(se_dump_stack*caller,T64* C){
T6 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f64is_empty;
ds.current=((void**)&C);
ds.p=77610760;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=77611284);
R=(r64count(&ds,C))==(0);
if(f64is_empty.assertion_flag){
f64is_empty.assertion_flag=0;
(ds.p=79716116);
ac_ens((R)==((r64count(&ds,C))==(0)),NULL);
f64is_empty.assertion_flag=1;
}
if(se_rci(C))se_i64(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f64is_empty={"is_empty of ARRAYED_COLLECTION",1,1,"%R64%Result%E6%",1};


void r64increase_capacity(se_dump_stack*caller,T64* C,T2 a1){
T2 _new_capacity=0;
T2 o37_198_25=0;
void**locals[3];
se_dump_stack ds;
ds.fd=&f64increase_capacity;
ds.current=((void**)&C);
ds.p=77639688;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&_new_capacity;
locals[2]=(void**)&o37_198_25;
se_dst=&ds;/*link*/
o37_198_25=(/*RF2*/(C)->_capacity/*8*/);
se_require_uppermost_flag=1;
if(f64increase_capacity.assertion_flag){
f64increase_capacity.assertion_flag=0;
(ds.p=77640494);
ac_req((a1)>((/*RF2*/(C)->_capacity/*8*/)),NULL);
f64increase_capacity.assertion_flag=1;
}
if(((ds.p=77641516),((/*RF2*/(C)->_capacity/*8*/))==(0))){
(ds.p=77641754);
(/*SFN*/C->_capacity)=a1;
(ds.p=77642010);
(/*SFN*/C->_storage)=((T66)(se_calloc((/*RF2*/(C)->_capacity/*8*/),sizeof(T0*))));
}
else{
(ds.p=77642784);
_new_capacity=((/*RF2*/(C)->_capacity/*8*/))*(2);
while (!(((ds.p=77643322),(_new_capacity)>=(a1))))
{
(ds.p=77643808);
_new_capacity=(_new_capacity)*(2);
}
(ds.p=77644314);
(/*SFN*/C->_storage)=r66realloc(&ds,(/*RF2*/(C)->_storage/*4*/),(/*RF2*/(C)->_capacity/*8*/),_new_capacity);
(ds.p=77644570);
(/*SFN*/C->_capacity)=_new_capacity;
}
if(f64increase_capacity.assertion_flag){
f64increase_capacity.assertion_flag=0;
(ds.p=77645350);
ac_ens(((/*RF2*/(C)->_capacity/*8*/))>(o37_198_25),NULL);
f64increase_capacity.assertion_flag=1;
}
if(se_rci(C))se_i64(&ds,C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f64increase_capacity={"increase_capacity of ARRAYED_COLLECTION",1,3,"%R64%min_capacity%E2%new_capacity%E2%old l198c25ARRAYED_COLLECTION%E2%",1};


void r64increment_upper(se_dump_stack*caller,T64* C){
se_dump_stack ds;
ds.fd=&f64increment_upper;
ds.current=((void**)&C);
ds.p=77637128;
ds.caller=caller;
se_dst=&ds;/*link*/
if(((ds.p=77637676),((/*RF2*/(C)->_capacity/*8*/))==(0))){
(ds.p=77637914);
r64increase_capacity(&ds,C,8);
}
 else if(((ds.p=77638190),(r64count(&ds,C))==((/*RF2*/(C)->_capacity/*8*/)))){
(ds.p=77638426);
r64increase_capacity(&ds,C,(r64count(&ds,C))+(1));
}
(ds.p=77638932);
(/*SFN*/C->_upper)=((/*RF2*/(C)->_upper/*12*/))+(1);
if(se_rci(C))se_i64(&ds,C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f64increment_upper={"increment_upper of ARRAYED_COLLECTION",1,0,"%R64%",1};


void r64add_last(se_dump_stack*caller,T64* C,T0* a1){
T2 o38_219_26=0;
T2 o38_220_22=0;
T2 o38_221_26=0;
void**locals[4];
se_dump_stack ds;
ds.fd=&f64add_last;
ds.current=((void**)&C);
ds.p=77623560;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&o38_219_26;
locals[2]=(void**)&o38_220_22;
locals[3]=(void**)&o38_221_26;
se_dst=&ds;/*link*/
o38_219_26=r64count(&ds,C);
o38_220_22=0;
o38_221_26=(/*RF2*/(C)->_upper/*12*/);
(ds.p=77624084);
r64increment_upper(&ds,C);
(ds.p=77624340);
r64put(&ds,C,a1,(/*RF2*/(C)->_upper/*12*/));
if(f64add_last.assertion_flag){
f64add_last.assertion_flag=0;
(ds.p=79747614);
ac_ens((r64last(&ds,C))==((void*)(a1)),NULL);
(ds.p=79747872);
ac_ens((r64count(&ds,C))==((1)+(o38_219_26)),NULL);
(ds.p=79748128);
ac_ens((0)==(o38_220_22),NULL);
(ds.p=79748384);
ac_ens(((/*RF2*/(C)->_upper/*12*/))==((1)+(o38_221_26)),NULL);
f64add_last.assertion_flag=1;
}
if(se_rci(C))se_i64(&ds,C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f64add_last={"add_last of ARRAYED_COLLECTION",1,4,"%R64%element%R25%old l219c26COLLECTION%E2%old l220c22COLLECTION%E2%old l221c26COLLECTION%E2%",1};


void r64with_capacity(se_dump_stack*caller,T64* C,T2 a1){
void**locals[1];
se_dump_stack ds;
ds.fd=&f64with_capacity;
ds.current=((void**)&C);
ds.p=75521800;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f64with_capacity.assertion_flag){
f64with_capacity.assertion_flag=0;
(ds.p=75522598);
ac_req((a1)>=(0),NULL);
f64with_capacity.assertion_flag=1;
}
if(((ds.p=75523116),((/*RF2*/(C)->_capacity/*8*/))<(a1))){
(ds.p=75523354);
(/*SFN*/C->_storage)=((T66)(se_calloc(a1,sizeof(T0*))));
(ds.p=75523610);
(/*SFN*/C->_capacity)=a1;
}
 else if(((ds.p=75523878),((/*RF2*/(C)->_capacity/*8*/))>(a1))){
(ds.p=75524124);
r66clear(&ds,(/*RF2*/(C)->_storage/*4*/),0,(/*RF2*/(C)->_upper/*12*/));
}
(ds.p=75524628);
(/*SFN*/C->_upper)=-(1);
if(f64with_capacity.assertion_flag){
f64with_capacity.assertion_flag=0;
(ds.p=75525158);
ac_ens(((/*RF2*/(C)->_capacity/*8*/))>=(a1),NULL);
(ds.p=75525396);
ac_ens(r64is_empty(&ds,C),NULL);
f64with_capacity.assertion_flag=1;
}
if(se_rci(C))se_i64(&ds,C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f64with_capacity={"with_capacity of FIXED_ARRAY",1,1,"%R64%needed_capacity%E2%",1};
se_frame_descriptor se_ifd64={"Class invariant of FIXED_ARRAY[NAME]",1,0,"%R64%",1};


T64*se_i64(se_dump_stack*caller,T64*C){
se_dump_stack ds;
ds.fd=&se_ifd64;
ds.current=((void**)&C);
ds.p=75509262;
ds.caller=caller;
se_dst=&ds;
if(ds.fd->assertion_flag){
ds.fd->assertion_flag=0;
(ds.p=79843888);
ac_inv((0)<=(((/*RF2*/(C)->_upper/*12*/))+(1)),"valid_bounds");
(ds.p=77646874);
ac_inv(((/*RF2*/(C)->_capacity/*8*/))>=((((/*RF2*/(C)->_upper/*12*/))-(0))+(1)),NULL);
(ds.p=77647394);
ac_inv((!(((/*RF2*/(C)->_capacity/*8*/))>(0)))||(r66is_not_null(&ds,(/*RF2*/(C)->_storage/*4*/))),NULL);
(ds.p=75569966);
ac_inv((r64count(&ds,C))<=((/*RF2*/(C)->_capacity/*8*/)),"valid_count");
ds.fd->assertion_flag=1;
}
se_dst=caller;
return C;
}


T2 r57count(se_dump_stack*caller,T57* C){
T2 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f57count;
ds.current=((void**)&C);
ds.p=75534600;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=75535124);
R=((/*RF2*/(C)->_upper/*12*/))+(1);
if(f57count.assertion_flag){
f57count.assertion_flag=0;
(ds.p=79714338);
ac_ens((R)==((((/*RF2*/(C)->_upper/*12*/))-(0))+(1)),NULL);
f57count.assertion_flag=1;
}
if(se_rci(C))se_i57(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f57count={"count of FIXED_ARRAY",1,1,"%R57%Result%E2%",1};


void r57put(se_dump_stack*caller,T57* C,T0* a1,T2 a2){
T2 o38_140_22=0;
void**locals[3];
se_dump_stack ds;
ds.fd=&f57put;
ds.current=((void**)&C);
ds.p=75533320;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&a2;
locals[2]=(void**)&o38_140_22;
se_dst=&ds;/*link*/
o38_140_22=r57count(&ds,C);
se_require_uppermost_flag=1;
if(f57put.assertion_flag){
f57put.assertion_flag=0;
(ds.p=79726612);
ac_req(r57valid_index(&ds,C,a2),NULL);
f57put.assertion_flag=1;
}
(ds.p=75533860);
((/*RF2*/(C)->_storage/*4*/))[a2]=(a1);
if(f57put.assertion_flag){
f57put.assertion_flag=0;
(ds.p=79727396);
ac_ens((r57item(&ds,C,a2))==((void*)(a1)),NULL);
(ds.p=79727648);
ac_ens((r57count(&ds,C))==(o38_140_22),NULL);
f57put.assertion_flag=1;
}
if(se_rci(C))se_i57(&ds,C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f57put={"put of FIXED_ARRAY",1,3,"%R57%element%R58%i%E2%old l140c22COLLECTION%E2%",1};


T0* r57item(se_dump_stack*caller,T57* C,T2 a1){
T0* R=NULL;
void**locals[2];
se_dump_stack ds;
ds.fd=&f57item;
ds.current=((void**)&C);
ds.p=75532040;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f57item.assertion_flag){
f57item.assertion_flag=0;
(ds.p=79719700);
ac_req(r57valid_index(&ds,C,a1),NULL);
f57item.assertion_flag=1;
}
(ds.p=75532564);
R=((/*RF2*/(C)->_storage/*4*/))[a1];
if(se_rci(C))se_i57(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f57item={"item of FIXED_ARRAY",1,2,"%R57%i%E2%Result%R58%",1};


T6 r57valid_index(se_dump_stack*caller,T57* C,T2 a1){
T6 R=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f57valid_index;
ds.current=((void**)&C);
ds.p=79710486;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=79711508);
R=((0)<=(a1))&&((a1)<=((/*RF2*/(C)->_upper/*12*/)));
if(f57valid_index.assertion_flag){
f57valid_index.assertion_flag=0;
(ds.p=79712034);
ac_ens((R)==(((0)<=(a1))&&((a1)<=((/*RF2*/(C)->_upper/*12*/)))),NULL);
f57valid_index.assertion_flag=1;
}
if(se_rci(C))se_i57(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f57valid_index={"valid_index of COLLECTION",1,2,"%R57%index%E2%Result%E6%",1};


void r57make(se_dump_stack*caller,T57* C,T2 a1){
T2 o36_91_26=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f57make;
ds.current=((void**)&C);
ds.p=75514376;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&o36_91_26;
se_dst=&ds;/*link*/
o36_91_26=(/*RF2*/(C)->_capacity/*8*/);
se_require_uppermost_flag=1;
if(f57make.assertion_flag){
f57make.assertion_flag=0;
(ds.p=75515432);
ac_req((a1)>=(0),NULL);
f57make.assertion_flag=1;
}
if(((ds.p=75515950),(a1)==(0))){
if(((ds.p=75516204),(((/*RF2*/(C)->_capacity/*8*/))>(0))&&(((/*RF2*/(C)->_upper/*12*/))>=(0)))){
(ds.p=75516450);
r60clear(&ds,(/*RF2*/(C)->_storage/*4*/),0,(/*RF2*/(C)->_upper/*12*/));
}
(ds.p=75516954);
(/*SFN*/C->_upper)=-(1);
}
 else if(((ds.p=75517236),((/*RF2*/(C)->_capacity/*8*/))==(0))){
(ds.p=75517466);
(/*SFN*/C->_storage)=((T60)(se_calloc(a1,sizeof(T0*))));
(ds.p=75517722);
(/*SFN*/C->_capacity)=a1;
(ds.p=75517978);
(/*SFN*/C->_upper)=(a1)-(1);
}
 else if(((ds.p=75518260),((/*RF2*/(C)->_capacity/*8*/))<(a1))){
(ds.p=75518490);
(/*SFN*/C->_storage)=((T60)(se_calloc(a1,sizeof(T0*))));
(ds.p=75518746);
(/*SFN*/C->_capacity)=a1;
(ds.p=75519002);
(/*SFN*/C->_upper)=(a1)-(1);
}
else{
(ds.p=75519516);
r60clear(&ds,(/*RF2*/(C)->_storage/*4*/),0,(/*RF2*/(C)->_upper/*12*/));
(ds.p=75519770);
(/*SFN*/C->_upper)=(a1)-(1);
}
if(f57make.assertion_flag){
f57make.assertion_flag=0;
(ds.p=75520544);
ac_ens((r57count(&ds,C))==(a1),NULL);
(ds.p=75520806);
ac_ens(((/*RF2*/(C)->_capacity/*8*/))>=(o36_91_26),NULL);
(ds.p=75521044);
ac_ens(r57all_default(&ds,C),NULL);
f57make.assertion_flag=1;
}
if(se_rci(C))se_i57(&ds,C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f57make={"make of FIXED_ARRAY",1,2,"%R57%new_count%E2%old l91c26FIXED_ARRAY%E2%",1};


T6 r57all_default(se_dump_stack*caller,T57* C){
T6 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f57all_default;
ds.current=((void**)&C);
ds.p=75549960;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=75550484);
R=r60all_default(&ds,(/*RF2*/(C)->_storage/*4*/),(/*RF2*/(C)->_upper/*12*/));
if(se_rci(C))se_i57(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f57all_default={"all_default of FIXED_ARRAY",1,1,"%R57%Result%E6%",1};
se_frame_descriptor se_ifd57={"Class invariant of FIXED_ARRAY[CIRCULAR_QUEUE[STRING]]",1,0,"%R57%",1};


T57*se_i57(se_dump_stack*caller,T57*C){
se_dump_stack ds;
ds.fd=&se_ifd57;
ds.current=((void**)&C);
ds.p=75509262;
ds.caller=caller;
se_dst=&ds;
if(ds.fd->assertion_flag){
ds.fd->assertion_flag=0;
(ds.p=79843888);
ac_inv((0)<=(((/*RF2*/(C)->_upper/*12*/))+(1)),"valid_bounds");
(ds.p=77646874);
ac_inv(((/*RF2*/(C)->_capacity/*8*/))>=((((/*RF2*/(C)->_upper/*12*/))-(0))+(1)),NULL);
(ds.p=77647394);
ac_inv((!(((/*RF2*/(C)->_capacity/*8*/))>(0)))||(r60is_not_null(&ds,(/*RF2*/(C)->_storage/*4*/))),NULL);
(ds.p=75569966);
ac_inv((r57count(&ds,C))<=((/*RF2*/(C)->_capacity/*8*/)),"valid_count");
ds.fd->assertion_flag=1;
}
se_dst=caller;
return C;
}


T2 r67count(se_dump_stack*caller,T67* C){
T2 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f67count;
ds.current=((void**)&C);
ds.p=75534600;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=75535124);
R=((/*RF2*/(C)->_upper/*12*/))+(1);
if(f67count.assertion_flag){
f67count.assertion_flag=0;
(ds.p=79714338);
ac_ens((R)==((((/*RF2*/(C)->_upper/*12*/))-(0))+(1)),NULL);
f67count.assertion_flag=1;
}
if(se_rci(C))se_i67(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f67count={"count of FIXED_ARRAY",1,1,"%R67%Result%E2%",1};


void r67put(se_dump_stack*caller,T67* C,T0* a1,T2 a2){
T2 o38_140_22=0;
void**locals[3];
se_dump_stack ds;
ds.fd=&f67put;
ds.current=((void**)&C);
ds.p=75533320;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&a2;
locals[2]=(void**)&o38_140_22;
se_dst=&ds;/*link*/
o38_140_22=r67count(&ds,C);
se_require_uppermost_flag=1;
if(f67put.assertion_flag){
f67put.assertion_flag=0;
(ds.p=79726612);
ac_req(r67valid_index(&ds,C,a2),NULL);
f67put.assertion_flag=1;
}
(ds.p=75533860);
((/*RF2*/(C)->_storage/*4*/))[a2]=(a1);
if(f67put.assertion_flag){
f67put.assertion_flag=0;
(ds.p=79727396);
ac_ens((r67item(&ds,C,a2))==((void*)(a1)),NULL);
(ds.p=79727648);
ac_ens((r67count(&ds,C))==(o38_140_22),NULL);
f67put.assertion_flag=1;
}
if(se_rci(C))se_i67(&ds,C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f67put={"put of FIXED_ARRAY",1,3,"%R67%element%R7%i%E2%old l140c22COLLECTION%E2%",1};


T0* r67item(se_dump_stack*caller,T67* C,T2 a1){
T0* R=NULL;
void**locals[2];
se_dump_stack ds;
ds.fd=&f67item;
ds.current=((void**)&C);
ds.p=75532040;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f67item.assertion_flag){
f67item.assertion_flag=0;
(ds.p=79719700);
ac_req(r67valid_index(&ds,C,a1),NULL);
f67item.assertion_flag=1;
}
(ds.p=75532564);
R=((/*RF2*/(C)->_storage/*4*/))[a1];
if(se_rci(C))se_i67(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f67item={"item of FIXED_ARRAY",1,2,"%R67%i%E2%Result%R7%",1};


T6 r67valid_index(se_dump_stack*caller,T67* C,T2 a1){
T6 R=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f67valid_index;
ds.current=((void**)&C);
ds.p=79710486;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=79711508);
R=((0)<=(a1))&&((a1)<=((/*RF2*/(C)->_upper/*12*/)));
if(f67valid_index.assertion_flag){
f67valid_index.assertion_flag=0;
(ds.p=79712034);
ac_ens((R)==(((0)<=(a1))&&((a1)<=((/*RF2*/(C)->_upper/*12*/)))),NULL);
f67valid_index.assertion_flag=1;
}
if(se_rci(C))se_i67(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f67valid_index={"valid_index of COLLECTION",1,2,"%R67%index%E2%Result%E6%",1};


void r67make(se_dump_stack*caller,T67* C,T2 a1){
T2 o36_91_26=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f67make;
ds.current=((void**)&C);
ds.p=75514376;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&o36_91_26;
se_dst=&ds;/*link*/
o36_91_26=(/*RF2*/(C)->_capacity/*8*/);
se_require_uppermost_flag=1;
if(f67make.assertion_flag){
f67make.assertion_flag=0;
(ds.p=75515432);
ac_req((a1)>=(0),NULL);
f67make.assertion_flag=1;
}
if(((ds.p=75515950),(a1)==(0))){
if(((ds.p=75516204),(((/*RF2*/(C)->_capacity/*8*/))>(0))&&(((/*RF2*/(C)->_upper/*12*/))>=(0)))){
(ds.p=75516450);
r61clear(&ds,(/*RF2*/(C)->_storage/*4*/),0,(/*RF2*/(C)->_upper/*12*/));
}
(ds.p=75516954);
(/*SFN*/C->_upper)=-(1);
}
 else if(((ds.p=75517236),((/*RF2*/(C)->_capacity/*8*/))==(0))){
(ds.p=75517466);
(/*SFN*/C->_storage)=((T61)(se_calloc(a1,sizeof(T0*))));
(ds.p=75517722);
(/*SFN*/C->_capacity)=a1;
(ds.p=75517978);
(/*SFN*/C->_upper)=(a1)-(1);
}
 else if(((ds.p=75518260),((/*RF2*/(C)->_capacity/*8*/))<(a1))){
(ds.p=75518490);
(/*SFN*/C->_storage)=((T61)(se_calloc(a1,sizeof(T0*))));
(ds.p=75518746);
(/*SFN*/C->_capacity)=a1;
(ds.p=75519002);
(/*SFN*/C->_upper)=(a1)-(1);
}
else{
(ds.p=75519516);
r61clear(&ds,(/*RF2*/(C)->_storage/*4*/),0,(/*RF2*/(C)->_upper/*12*/));
(ds.p=75519770);
(/*SFN*/C->_upper)=(a1)-(1);
}
if(f67make.assertion_flag){
f67make.assertion_flag=0;
(ds.p=75520544);
ac_ens((r67count(&ds,C))==(a1),NULL);
(ds.p=75520806);
ac_ens(((/*RF2*/(C)->_capacity/*8*/))>=(o36_91_26),NULL);
(ds.p=75521044);
ac_ens(r67all_default(&ds,C),NULL);
f67make.assertion_flag=1;
}
if(se_rci(C))se_i67(&ds,C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f67make={"make of FIXED_ARRAY",1,2,"%R67%new_count%E2%old l91c26FIXED_ARRAY%E2%",1};


T6 r67is_empty(se_dump_stack*caller,T67* C){
T6 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f67is_empty;
ds.current=((void**)&C);
ds.p=77610760;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=77611284);
R=(r67count(&ds,C))==(0);
if(f67is_empty.assertion_flag){
f67is_empty.assertion_flag=0;
(ds.p=79716116);
ac_ens((R)==((r67count(&ds,C))==(0)),NULL);
f67is_empty.assertion_flag=1;
}
if(se_rci(C))se_i67(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f67is_empty={"is_empty of ARRAYED_COLLECTION",1,1,"%R67%Result%E6%",1};


T6 r67all_default(se_dump_stack*caller,T67* C){
T6 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f67all_default;
ds.current=((void**)&C);
ds.p=75549960;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=75550484);
R=r61all_default(&ds,(/*RF2*/(C)->_storage/*4*/),(/*RF2*/(C)->_upper/*12*/));
if(se_rci(C))se_i67(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f67all_default={"all_default of FIXED_ARRAY",1,1,"%R67%Result%E6%",1};
se_frame_descriptor se_ifd67={"Class invariant of FIXED_ARRAY[STRING]",1,0,"%R67%",1};


T67*se_i67(se_dump_stack*caller,T67*C){
se_dump_stack ds;
ds.fd=&se_ifd67;
ds.current=((void**)&C);
ds.p=75509262;
ds.caller=caller;
se_dst=&ds;
if(ds.fd->assertion_flag){
ds.fd->assertion_flag=0;
(ds.p=79843888);
ac_inv((0)<=(((/*RF2*/(C)->_upper/*12*/))+(1)),"valid_bounds");
(ds.p=77646874);
ac_inv(((/*RF2*/(C)->_capacity/*8*/))>=((((/*RF2*/(C)->_upper/*12*/))-(0))+(1)),NULL);
(ds.p=77647394);
ac_inv((!(((/*RF2*/(C)->_capacity/*8*/))>(0)))||(r61is_not_null(&ds,(/*RF2*/(C)->_storage/*4*/))),NULL);
(ds.p=75569966);
ac_inv((r67count(&ds,C))<=((/*RF2*/(C)->_capacity/*8*/)),"valid_count");
ds.fd->assertion_flag=1;
}
se_dst=caller;
return C;
}


T2 r53count(se_dump_stack*caller,T53* C){
T2 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f53count;
ds.current=((void**)&C);
ds.p=75534600;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=75535124);
R=((/*RF2*/(C)->_upper/*12*/))+(1);
if(f53count.assertion_flag){
f53count.assertion_flag=0;
(ds.p=79714338);
ac_ens((R)==((((/*RF2*/(C)->_upper/*12*/))-(0))+(1)),NULL);
f53count.assertion_flag=1;
}
if(se_rci(C))se_i53(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f53count={"count of FIXED_ARRAY",1,1,"%R53%Result%E2%",1};


void r53put(se_dump_stack*caller,T53* C,T2 a1,T2 a2){
T2 o38_140_22=0;
void**locals[3];
se_dump_stack ds;
ds.fd=&f53put;
ds.current=((void**)&C);
ds.p=75533320;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&a2;
locals[2]=(void**)&o38_140_22;
se_dst=&ds;/*link*/
o38_140_22=r53count(&ds,C);
se_require_uppermost_flag=1;
if(f53put.assertion_flag){
f53put.assertion_flag=0;
(ds.p=79726612);
ac_req(r53valid_index(&ds,C,a2),NULL);
f53put.assertion_flag=1;
}
(ds.p=75533860);
((/*RF2*/(C)->_storage/*4*/))[a2]=(a1);
if(f53put.assertion_flag){
f53put.assertion_flag=0;
(ds.p=79727396);
ac_ens((r53item(&ds,C,a2))==(a1),NULL);
(ds.p=79727648);
ac_ens((r53count(&ds,C))==(o38_140_22),NULL);
f53put.assertion_flag=1;
}
if(se_rci(C))se_i53(&ds,C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f53put={"put of FIXED_ARRAY",1,3,"%R53%element%E2%i%E2%old l140c22COLLECTION%E2%",1};


T2 r53item(se_dump_stack*caller,T53* C,T2 a1){
T2 R=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f53item;
ds.current=((void**)&C);
ds.p=75532040;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f53item.assertion_flag){
f53item.assertion_flag=0;
(ds.p=79719700);
ac_req(r53valid_index(&ds,C,a1),NULL);
f53item.assertion_flag=1;
}
(ds.p=75532564);
R=((/*RF2*/(C)->_storage/*4*/))[a1];
if(se_rci(C))se_i53(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f53item={"item of FIXED_ARRAY",1,2,"%R53%i%E2%Result%E2%",1};


T6 r53valid_index(se_dump_stack*caller,T53* C,T2 a1){
T6 R=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f53valid_index;
ds.current=((void**)&C);
ds.p=79710486;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=79711508);
R=((0)<=(a1))&&((a1)<=((/*RF2*/(C)->_upper/*12*/)));
if(f53valid_index.assertion_flag){
f53valid_index.assertion_flag=0;
(ds.p=79712034);
ac_ens((R)==(((0)<=(a1))&&((a1)<=((/*RF2*/(C)->_upper/*12*/)))),NULL);
f53valid_index.assertion_flag=1;
}
if(se_rci(C))se_i53(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f53valid_index={"valid_index of COLLECTION",1,2,"%R53%index%E2%Result%E6%",1};


void r53make(se_dump_stack*caller,T53* C,T2 a1){
T2 o36_91_26=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f53make;
ds.current=((void**)&C);
ds.p=75514376;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&o36_91_26;
se_dst=&ds;/*link*/
o36_91_26=(/*RF2*/(C)->_capacity/*8*/);
se_require_uppermost_flag=1;
if(f53make.assertion_flag){
f53make.assertion_flag=0;
(ds.p=75515432);
ac_req((a1)>=(0),NULL);
f53make.assertion_flag=1;
}
if(((ds.p=75515950),(a1)==(0))){
if(((ds.p=75516204),(((/*RF2*/(C)->_capacity/*8*/))>(0))&&(((/*RF2*/(C)->_upper/*12*/))>=(0)))){
(ds.p=75516450);
r55clear(&ds,(/*RF2*/(C)->_storage/*4*/),0,(/*RF2*/(C)->_upper/*12*/));
}
(ds.p=75516954);
(/*SFN*/C->_upper)=-(1);
}
 else if(((ds.p=75517236),((/*RF2*/(C)->_capacity/*8*/))==(0))){
(ds.p=75517466);
(/*SFN*/C->_storage)=((T55)(se_calloc(a1,sizeof(T2))));
(ds.p=75517722);
(/*SFN*/C->_capacity)=a1;
(ds.p=75517978);
(/*SFN*/C->_upper)=(a1)-(1);
}
 else if(((ds.p=75518260),((/*RF2*/(C)->_capacity/*8*/))<(a1))){
(ds.p=75518490);
(/*SFN*/C->_storage)=((T55)(se_calloc(a1,sizeof(T2))));
(ds.p=75518746);
(/*SFN*/C->_capacity)=a1;
(ds.p=75519002);
(/*SFN*/C->_upper)=(a1)-(1);
}
else{
(ds.p=75519516);
r55clear(&ds,(/*RF2*/(C)->_storage/*4*/),0,(/*RF2*/(C)->_upper/*12*/));
(ds.p=75519770);
(/*SFN*/C->_upper)=(a1)-(1);
}
if(f53make.assertion_flag){
f53make.assertion_flag=0;
(ds.p=75520544);
ac_ens((r53count(&ds,C))==(a1),NULL);
(ds.p=75520806);
ac_ens(((/*RF2*/(C)->_capacity/*8*/))>=(o36_91_26),NULL);
(ds.p=75521044);
ac_ens(r53all_default(&ds,C),NULL);
f53make.assertion_flag=1;
}
if(se_rci(C))se_i53(&ds,C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f53make={"make of FIXED_ARRAY",1,2,"%R53%new_count%E2%old l91c26FIXED_ARRAY%E2%",1};


T6 r53all_default(se_dump_stack*caller,T53* C){
T6 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f53all_default;
ds.current=((void**)&C);
ds.p=75549960;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=75550484);
R=r55all_default(&ds,(/*RF2*/(C)->_storage/*4*/),(/*RF2*/(C)->_upper/*12*/));
if(se_rci(C))se_i53(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f53all_default={"all_default of FIXED_ARRAY",1,1,"%R53%Result%E6%",1};
se_frame_descriptor se_ifd53={"Class invariant of FIXED_ARRAY[INTEGER]",1,0,"%R53%",1};


T53*se_i53(se_dump_stack*caller,T53*C){
se_dump_stack ds;
ds.fd=&se_ifd53;
ds.current=((void**)&C);
ds.p=75509262;
ds.caller=caller;
se_dst=&ds;
if(ds.fd->assertion_flag){
ds.fd->assertion_flag=0;
(ds.p=79843888);
ac_inv((0)<=(((/*RF2*/(C)->_upper/*12*/))+(1)),"valid_bounds");
(ds.p=77646874);
ac_inv(((/*RF2*/(C)->_capacity/*8*/))>=((((/*RF2*/(C)->_upper/*12*/))-(0))+(1)),NULL);
(ds.p=77647394);
ac_inv((!(((/*RF2*/(C)->_capacity/*8*/))>(0)))||(r55is_not_null(&ds,(/*RF2*/(C)->_storage/*4*/))),NULL);
(ds.p=75569966);
ac_inv((r53count(&ds,C))<=((/*RF2*/(C)->_capacity/*8*/)),"valid_count");
ds.fd->assertion_flag=1;
}
se_dst=caller;
return C;
}


T0* r43last(se_dump_stack*caller,T43* C){
T0* R=NULL;
void**locals[1];
se_dump_stack ds;
ds.fd=&f43last;
ds.current=((void**)&C);
ds.p=77619208;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f43last.assertion_flag){
f43last.assertion_flag=0;
(ds.p=79723796);
ac_req(r6_ix_not(&ds,r43is_empty(&ds,C)),NULL);
f43last.assertion_flag=1;
}
(ds.p=77619732);
R=r43item(&ds,C,(/*RF2*/(C)->_upper/*12*/));
if(f43last.assertion_flag){
f43last.assertion_flag=0;
(ds.p=79724578);
ac_ens((R)==((void*)(r43item(&ds,C,(/*RF2*/(C)->_upper/*12*/)))),NULL);
f43last.assertion_flag=1;
}
if(se_rci(C))se_i43(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f43last={"last of ARRAYED_COLLECTION",1,1,"%R43%Result%R26%",1};


T2 r43count(se_dump_stack*caller,T43* C){
T2 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f43count;
ds.current=((void**)&C);
ds.p=75534600;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=75535124);
R=((/*RF2*/(C)->_upper/*12*/))+(1);
if(f43count.assertion_flag){
f43count.assertion_flag=0;
(ds.p=79714338);
ac_ens((R)==((((/*RF2*/(C)->_upper/*12*/))-(0))+(1)),NULL);
f43count.assertion_flag=1;
}
if(se_rci(C))se_i43(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f43count={"count of FIXED_ARRAY",1,1,"%R43%Result%E2%",1};


void r43put(se_dump_stack*caller,T43* C,T0* a1,T2 a2){
T2 o38_140_22=0;
void**locals[3];
se_dump_stack ds;
ds.fd=&f43put;
ds.current=((void**)&C);
ds.p=75533320;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&a2;
locals[2]=(void**)&o38_140_22;
se_dst=&ds;/*link*/
o38_140_22=r43count(&ds,C);
se_require_uppermost_flag=1;
if(f43put.assertion_flag){
f43put.assertion_flag=0;
(ds.p=79726612);
ac_req(r43valid_index(&ds,C,a2),NULL);
f43put.assertion_flag=1;
}
(ds.p=75533860);
((/*RF2*/(C)->_storage/*4*/))[a2]=(a1);
if(f43put.assertion_flag){
f43put.assertion_flag=0;
(ds.p=79727396);
ac_ens((r43item(&ds,C,a2))==((void*)(a1)),NULL);
(ds.p=79727648);
ac_ens((r43count(&ds,C))==(o38_140_22),NULL);
f43put.assertion_flag=1;
}
if(se_rci(C))se_i43(&ds,C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f43put={"put of FIXED_ARRAY",1,3,"%R43%element%R26%i%E2%old l140c22COLLECTION%E2%",1};


T0* r43item(se_dump_stack*caller,T43* C,T2 a1){
T0* R=NULL;
void**locals[2];
se_dump_stack ds;
ds.fd=&f43item;
ds.current=((void**)&C);
ds.p=75532040;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f43item.assertion_flag){
f43item.assertion_flag=0;
(ds.p=79719700);
ac_req(r43valid_index(&ds,C,a1),NULL);
f43item.assertion_flag=1;
}
(ds.p=75532564);
R=((/*RF2*/(C)->_storage/*4*/))[a1];
if(se_rci(C))se_i43(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f43item={"item of FIXED_ARRAY",1,2,"%R43%i%E2%Result%R26%",1};


T6 r43valid_index(se_dump_stack*caller,T43* C,T2 a1){
T6 R=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f43valid_index;
ds.current=((void**)&C);
ds.p=79710486;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=79711508);
R=((0)<=(a1))&&((a1)<=((/*RF2*/(C)->_upper/*12*/)));
if(f43valid_index.assertion_flag){
f43valid_index.assertion_flag=0;
(ds.p=79712034);
ac_ens((R)==(((0)<=(a1))&&((a1)<=((/*RF2*/(C)->_upper/*12*/)))),NULL);
f43valid_index.assertion_flag=1;
}
if(se_rci(C))se_i43(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f43valid_index={"valid_index of COLLECTION",1,2,"%R43%index%E2%Result%E6%",1};


T6 r43is_empty(se_dump_stack*caller,T43* C){
T6 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f43is_empty;
ds.current=((void**)&C);
ds.p=77610760;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=77611284);
R=(r43count(&ds,C))==(0);
if(f43is_empty.assertion_flag){
f43is_empty.assertion_flag=0;
(ds.p=79716116);
ac_ens((R)==((r43count(&ds,C))==(0)),NULL);
f43is_empty.assertion_flag=1;
}
if(se_rci(C))se_i43(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f43is_empty={"is_empty of ARRAYED_COLLECTION",1,1,"%R43%Result%E6%",1};


void r43increase_capacity(se_dump_stack*caller,T43* C,T2 a1){
T2 _new_capacity=0;
T2 o37_198_25=0;
void**locals[3];
se_dump_stack ds;
ds.fd=&f43increase_capacity;
ds.current=((void**)&C);
ds.p=77639688;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&_new_capacity;
locals[2]=(void**)&o37_198_25;
se_dst=&ds;/*link*/
o37_198_25=(/*RF2*/(C)->_capacity/*8*/);
se_require_uppermost_flag=1;
if(f43increase_capacity.assertion_flag){
f43increase_capacity.assertion_flag=0;
(ds.p=77640494);
ac_req((a1)>((/*RF2*/(C)->_capacity/*8*/)),NULL);
f43increase_capacity.assertion_flag=1;
}
if(((ds.p=77641516),((/*RF2*/(C)->_capacity/*8*/))==(0))){
(ds.p=77641754);
(/*SFN*/C->_capacity)=a1;
(ds.p=77642010);
(/*SFN*/C->_storage)=((T48)(se_calloc((/*RF2*/(C)->_capacity/*8*/),sizeof(T0*))));
}
else{
(ds.p=77642784);
_new_capacity=((/*RF2*/(C)->_capacity/*8*/))*(2);
while (!(((ds.p=77643322),(_new_capacity)>=(a1))))
{
(ds.p=77643808);
_new_capacity=(_new_capacity)*(2);
}
(ds.p=77644314);
(/*SFN*/C->_storage)=r48realloc(&ds,(/*RF2*/(C)->_storage/*4*/),(/*RF2*/(C)->_capacity/*8*/),_new_capacity);
(ds.p=77644570);
(/*SFN*/C->_capacity)=_new_capacity;
}
if(f43increase_capacity.assertion_flag){
f43increase_capacity.assertion_flag=0;
(ds.p=77645350);
ac_ens(((/*RF2*/(C)->_capacity/*8*/))>(o37_198_25),NULL);
f43increase_capacity.assertion_flag=1;
}
if(se_rci(C))se_i43(&ds,C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f43increase_capacity={"increase_capacity of ARRAYED_COLLECTION",1,3,"%R43%min_capacity%E2%new_capacity%E2%old l198c25ARRAYED_COLLECTION%E2%",1};


void r43increment_upper(se_dump_stack*caller,T43* C){
se_dump_stack ds;
ds.fd=&f43increment_upper;
ds.current=((void**)&C);
ds.p=77637128;
ds.caller=caller;
se_dst=&ds;/*link*/
if(((ds.p=77637676),((/*RF2*/(C)->_capacity/*8*/))==(0))){
(ds.p=77637914);
r43increase_capacity(&ds,C,8);
}
 else if(((ds.p=77638190),(r43count(&ds,C))==((/*RF2*/(C)->_capacity/*8*/)))){
(ds.p=77638426);
r43increase_capacity(&ds,C,(r43count(&ds,C))+(1));
}
(ds.p=77638932);
(/*SFN*/C->_upper)=((/*RF2*/(C)->_upper/*12*/))+(1);
if(se_rci(C))se_i43(&ds,C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f43increment_upper={"increment_upper of ARRAYED_COLLECTION",1,0,"%R43%",1};


void r43add_last(se_dump_stack*caller,T43* C,T0* a1){
T2 o38_219_26=0;
T2 o38_220_22=0;
T2 o38_221_26=0;
void**locals[4];
se_dump_stack ds;
ds.fd=&f43add_last;
ds.current=((void**)&C);
ds.p=77623560;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&o38_219_26;
locals[2]=(void**)&o38_220_22;
locals[3]=(void**)&o38_221_26;
se_dst=&ds;/*link*/
o38_219_26=r43count(&ds,C);
o38_220_22=0;
o38_221_26=(/*RF2*/(C)->_upper/*12*/);
(ds.p=77624084);
r43increment_upper(&ds,C);
(ds.p=77624340);
r43put(&ds,C,a1,(/*RF2*/(C)->_upper/*12*/));
if(f43add_last.assertion_flag){
f43add_last.assertion_flag=0;
(ds.p=79747614);
ac_ens((r43last(&ds,C))==((void*)(a1)),NULL);
(ds.p=79747872);
ac_ens((r43count(&ds,C))==((1)+(o38_219_26)),NULL);
(ds.p=79748128);
ac_ens((0)==(o38_220_22),NULL);
(ds.p=79748384);
ac_ens(((/*RF2*/(C)->_upper/*12*/))==((1)+(o38_221_26)),NULL);
f43add_last.assertion_flag=1;
}
if(se_rci(C))se_i43(&ds,C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f43add_last={"add_last of ARRAYED_COLLECTION",1,4,"%R43%element%R26%old l219c26COLLECTION%E2%old l220c22COLLECTION%E2%old l221c26COLLECTION%E2%",1};


void r43with_capacity(se_dump_stack*caller,T43* C,T2 a1){
void**locals[1];
se_dump_stack ds;
ds.fd=&f43with_capacity;
ds.current=((void**)&C);
ds.p=75521800;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f43with_capacity.assertion_flag){
f43with_capacity.assertion_flag=0;
(ds.p=75522598);
ac_req((a1)>=(0),NULL);
f43with_capacity.assertion_flag=1;
}
if(((ds.p=75523116),((/*RF2*/(C)->_capacity/*8*/))<(a1))){
(ds.p=75523354);
(/*SFN*/C->_storage)=((T48)(se_calloc(a1,sizeof(T0*))));
(ds.p=75523610);
(/*SFN*/C->_capacity)=a1;
}
 else if(((ds.p=75523878),((/*RF2*/(C)->_capacity/*8*/))>(a1))){
(ds.p=75524124);
r48clear(&ds,(/*RF2*/(C)->_storage/*4*/),0,(/*RF2*/(C)->_upper/*12*/));
}
(ds.p=75524628);
(/*SFN*/C->_upper)=-(1);
if(f43with_capacity.assertion_flag){
f43with_capacity.assertion_flag=0;
(ds.p=75525158);
ac_ens(((/*RF2*/(C)->_capacity/*8*/))>=(a1),NULL);
(ds.p=75525396);
ac_ens(r43is_empty(&ds,C),NULL);
f43with_capacity.assertion_flag=1;
}
if(se_rci(C))se_i43(&ds,C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f43with_capacity={"with_capacity of FIXED_ARRAY",1,1,"%R43%needed_capacity%E2%",1};
se_frame_descriptor se_ifd43={"Class invariant of FIXED_ARRAY[FEATURE_DEFINITION]",1,0,"%R43%",1};


T43*se_i43(se_dump_stack*caller,T43*C){
se_dump_stack ds;
ds.fd=&se_ifd43;
ds.current=((void**)&C);
ds.p=75509262;
ds.caller=caller;
se_dst=&ds;
if(ds.fd->assertion_flag){
ds.fd->assertion_flag=0;
(ds.p=79843888);
ac_inv((0)<=(((/*RF2*/(C)->_upper/*12*/))+(1)),"valid_bounds");
(ds.p=77646874);
ac_inv(((/*RF2*/(C)->_capacity/*8*/))>=((((/*RF2*/(C)->_upper/*12*/))-(0))+(1)),NULL);
(ds.p=77647394);
ac_inv((!(((/*RF2*/(C)->_capacity/*8*/))>(0)))||(r48is_not_null(&ds,(/*RF2*/(C)->_storage/*4*/))),NULL);
(ds.p=75569966);
ac_inv((r43count(&ds,C))<=((/*RF2*/(C)->_capacity/*8*/)),"valid_count");
ds.fd->assertion_flag=1;
}
se_dst=caller;
return C;
}


T0* r58last(se_dump_stack*caller,T58* C){
T0* R=NULL;
void**locals[1];
se_dump_stack ds;
ds.fd=&f58last;
ds.current=((void**)&C);
ds.p=117466888;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=0;
se_require_last_result=1;
if(f58last.assertion_flag){
f58last.assertion_flag=0;
(ds.p=117467412);
ac_req(r6_ix_not(&ds,r58is_empty(&ds,C)),NULL);
f58last.assertion_flag=1;
}
se_require_uppermost_flag=1;
if(!se_require_last_result){
se_require_last_result=1;
if(f58last.assertion_flag){
f58last.assertion_flag=0;
(ds.p=79723796);
ac_req(r6_ix_not(&ds,r58is_empty(&ds,C)),NULL);
f58last.assertion_flag=1;
}
}
(ds.p=117467924);
R=((/*RF2*/(C)->_storage/*4*/))[r58tail(&ds,C)];
if(f58last.assertion_flag){
f58last.assertion_flag=0;
(ds.p=117468450);
ac_ens((R)==((void*)(r58item(&ds,C,(/*RF2*/(C)->_upper/*12*/)))),NULL);
(ds.p=79724578);
ac_ens((R)==((void*)(r58item(&ds,C,(/*RF2*/(C)->_upper/*12*/)))),NULL);
f58last.assertion_flag=1;
}
if(se_rci(C))se_i58(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f58last={"last of CIRCULAR_QUEUE",1,1,"%R58%Result%R7%",1};


void r58remove_first(se_dump_stack*caller,T58* C){
T2 o56_259_22=0;
T2 o38_293_23=0;
T2 o38_294_24=0;
T2 o38_294_54=0;
void**locals[4];
se_dump_stack ds;
ds.fd=&f58remove_first;
ds.current=((void**)&C);
ds.p=117504776;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&o56_259_22;
locals[1]=(void**)&o38_293_23;
locals[2]=(void**)&o38_294_24;
locals[3]=(void**)&o38_294_54;
se_dst=&ds;/*link*/
o56_259_22=1;
o38_293_23=r58count(&ds,C);
o38_294_24=1;
o38_294_54=(/*RF2*/(C)->_upper/*12*/);
se_require_uppermost_flag=1;
if(f58remove_first.assertion_flag){
f58remove_first.assertion_flag=0;
(ds.p=79766036);
ac_req(r6_ix_not(&ds,r58is_empty(&ds,C)),NULL);
f58remove_first.assertion_flag=1;
}
(ds.p=117505300);
(/*SFN*/C->_upper)=((/*RF2*/(C)->_upper/*12*/))-(1);
(ds.p=117505556);
(/*SFN*/C->_head)=((/*RF2*/(C)->_head/*16*/))+(1);
if(((ds.p=117505828),((/*RF2*/(C)->_head/*16*/))==((/*RF2*/(C)->_capacity/*8*/)))){
(ds.p=117506074);
(/*SFN*/C->_head)=0;
}
if(f58remove_first.assertion_flag){
f58remove_first.assertion_flag=0;
(ds.p=117506848);
ac_ens((1)==(o56_259_22),NULL);
(ds.p=79766816);
ac_ens((r58count(&ds,C))==((o38_293_23)-(1)),NULL);
(ds.p=79767112);
ac_ens(r6_px_xor(&ds,(1)==((o38_294_24)+(1)),((/*RF2*/(C)->_upper/*12*/))==((o38_294_54)-(1))),NULL);
f58remove_first.assertion_flag=1;
}
if(se_rci(C))se_i58(&ds,C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f58remove_first={"remove_first of CIRCULAR_QUEUE",1,4,"%R58%old l259c22CIRCULAR_QUEUE%E2%old l293c23COLLECTION%E2%old l294c24COLLECTION%E2%old l294c54COLLECTION%E2%",1};


T2 r58count(se_dump_stack*caller,T58* C){
T2 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f58count;
ds.current=((void**)&C);
ds.p=117463304;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=117463828);
R=(/*RF2*/(C)->_upper/*12*/);
if(f58count.assertion_flag){
f58count.assertion_flag=0;
(ds.p=79714338);
ac_ens((R)==((((/*RF2*/(C)->_upper/*12*/))-(1))+(1)),NULL);
f58count.assertion_flag=1;
}
if(se_rci(C))se_i58(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f58count={"count of CIRCULAR_QUEUE",1,1,"%R58%Result%E2%",1};


void r58put(se_dump_stack*caller,T58* C,T0* a1,T2 a2){
T2 o38_140_22=0;
void**locals[3];
se_dump_stack ds;
ds.fd=&f58put;
ds.current=((void**)&C);
ds.p=117470472;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&a2;
locals[2]=(void**)&o38_140_22;
se_dst=&ds;/*link*/
o38_140_22=r58count(&ds,C);
se_require_uppermost_flag=1;
if(f58put.assertion_flag){
f58put.assertion_flag=0;
(ds.p=79726612);
ac_req(r58valid_index(&ds,C,a2),NULL);
f58put.assertion_flag=1;
}
(ds.p=117471012);
((/*RF2*/(C)->_storage/*4*/))[r58rotate(&ds,C,a2)]=(a1);
if(f58put.assertion_flag){
f58put.assertion_flag=0;
(ds.p=79727396);
ac_ens((r58item(&ds,C,a2))==((void*)(a1)),NULL);
(ds.p=79727648);
ac_ens((r58count(&ds,C))==(o38_140_22),NULL);
f58put.assertion_flag=1;
}
if(se_rci(C))se_i58(&ds,C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f58put={"put of CIRCULAR_QUEUE",1,3,"%R58%element%R7%index%E2%old l140c22COLLECTION%E2%",1};


T0* r58item(se_dump_stack*caller,T58* C,T2 a1){
T0* R=NULL;
void**locals[2];
se_dump_stack ds;
ds.fd=&f58item;
ds.current=((void**)&C);
ds.p=117469192;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f58item.assertion_flag){
f58item.assertion_flag=0;
(ds.p=79719700);
ac_req(r58valid_index(&ds,C,a1),NULL);
f58item.assertion_flag=1;
}
(ds.p=117469716);
R=((/*RF2*/(C)->_storage/*4*/))[r58rotate(&ds,C,a1)];
if(se_rci(C))se_i58(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f58item={"item of CIRCULAR_QUEUE",1,2,"%R58%index%E2%Result%R7%",1};


T6 r58valid_index(se_dump_stack*caller,T58* C,T2 a1){
T6 R=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f58valid_index;
ds.current=((void**)&C);
ds.p=79710486;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=79711508);
R=((1)<=(a1))&&((a1)<=((/*RF2*/(C)->_upper/*12*/)));
if(f58valid_index.assertion_flag){
f58valid_index.assertion_flag=0;
(ds.p=79712034);
ac_ens((R)==(((1)<=(a1))&&((a1)<=((/*RF2*/(C)->_upper/*12*/)))),NULL);
f58valid_index.assertion_flag=1;
}
if(se_rci(C))se_i58(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f58valid_index={"valid_index of COLLECTION",1,2,"%R58%index%E2%Result%E6%",1};


void r58make(se_dump_stack*caller,T58* C){
se_dump_stack ds;
ds.fd=&f58make;
ds.current=((void**)&C);
ds.p=117455624;
ds.caller=caller;
se_dst=&ds;/*link*/
(ds.p=117456404);
(/*SFN*/C->_upper)=0;
(ds.p=117456660);
(/*SFN*/C->_head)=0;
if(f58make.assertion_flag){
f58make.assertion_flag=0;
(ds.p=117457172);
ac_ens(r58is_empty(&ds,C),NULL);
f58make.assertion_flag=1;
}
if(se_rci(C))se_i58(&ds,C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f58make={"make of CIRCULAR_QUEUE",1,0,"%R58%",1};


void r58remove(se_dump_stack*caller,T58* C,T2 a1){
T2 _idx=0;
T2 o38_304_23=0;
T2 o38_305_23=0;
void**locals[4];
se_dump_stack ds;
ds.fd=&f58remove;
ds.current=((void**)&C);
ds.p=117507592;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&_idx;
locals[2]=(void**)&o38_304_23;
locals[3]=(void**)&o38_305_23;
se_dst=&ds;/*link*/
o38_304_23=r58count(&ds,C);
o38_305_23=(/*RF2*/(C)->_upper/*12*/);
se_require_uppermost_flag=1;
if(f58remove.assertion_flag){
f58remove.assertion_flag=0;
(ds.p=79768852);
ac_req(r58valid_index(&ds,C,a1),NULL);
f58remove.assertion_flag=1;
}
(ds.p=117508628);
_idx=r58rotate(&ds,C,a1);
if(((ds.p=117509158),(a1)==(1))){
(ds.p=117509402);
r58remove_first(&ds,C);
}
 else if(((ds.p=117509678),(a1)==((/*RF2*/(C)->_upper/*12*/)))){
(ds.p=117509914);
r58remove_last(&ds,C);
}
 else if(((ds.p=117510186),(_idx)<(r58tail(&ds,C)))){
(ds.p=117510442);
r61remove(&ds,(/*RF2*/(C)->_storage/*4*/),_idx,r58tail(&ds,C));
(ds.p=117510682);
(/*SFN*/C->_upper)=((/*RF2*/(C)->_upper/*12*/))-(1);
}
else{
while (!(((ds.p=117511720),(_idx)==((/*RF2*/(C)->_head/*16*/)))))
{
(ds.p=117512240);
((/*RF2*/(C)->_storage/*4*/))[_idx]=(((/*RF2*/(C)->_storage/*4*/))[(_idx)-(1)]);
(ds.p=117512480);
_idx=(_idx)-(1);
}
(ds.p=117512986);
(/*SFN*/C->_head)=((/*RF2*/(C)->_head/*16*/))+(1);
}
if(f58remove.assertion_flag){
f58remove.assertion_flag=0;
(ds.p=79769632);
ac_ens((r58count(&ds,C))==((o38_304_23)-(1)),NULL);
(ds.p=79769888);
ac_ens(((/*RF2*/(C)->_upper/*12*/))==((o38_305_23)-(1)),NULL);
f58remove.assertion_flag=1;
}
if(se_rci(C))se_i58(&ds,C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f58remove={"remove of CIRCULAR_QUEUE",1,4,"%R58%index%E2%idx%E2%old l304c23COLLECTION%E2%old l305c23COLLECTION%E2%",1};


T6 r58is_empty(se_dump_stack*caller,T58* C){
T6 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f58is_empty;
ds.current=((void**)&C);
ds.p=77610760;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=77611284);
R=(r58count(&ds,C))==(0);
if(f58is_empty.assertion_flag){
f58is_empty.assertion_flag=0;
(ds.p=79716116);
ac_ens((R)==((r58count(&ds,C))==(0)),NULL);
f58is_empty.assertion_flag=1;
}
if(se_rci(C))se_i58(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f58is_empty={"is_empty of ARRAYED_COLLECTION",1,1,"%R58%Result%E6%",1};


void r58increase_capacity(se_dump_stack*caller,T58* C,T2 a1){
T2 _new_capacity=0;
T2 _new_space=0;
T2 _i=0;
T2 o56_359_25=0;
T2 o37_198_25=0;
void**locals[6];
se_dump_stack ds;
ds.fd=&f58increase_capacity;
ds.current=((void**)&C);
ds.p=117522184;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&_new_capacity;
locals[2]=(void**)&_new_space;
locals[3]=(void**)&_i;
locals[4]=(void**)&o56_359_25;
locals[5]=(void**)&o37_198_25;
se_dst=&ds;/*link*/
o56_359_25=(/*RF2*/(C)->_capacity/*8*/);
o37_198_25=(/*RF2*/(C)->_capacity/*8*/);
se_require_uppermost_flag=0;
se_require_last_result=1;
if(f58increase_capacity.assertion_flag){
f58increase_capacity.assertion_flag=0;
(ds.p=117522990);
ac_req((a1)>((/*RF2*/(C)->_capacity/*8*/)),NULL);
f58increase_capacity.assertion_flag=1;
}
se_require_uppermost_flag=1;
if(!se_require_last_result){
se_require_last_result=1;
if(f58increase_capacity.assertion_flag){
f58increase_capacity.assertion_flag=0;
(ds.p=77640494);
ac_req((a1)>((/*RF2*/(C)->_capacity/*8*/)),NULL);
f58increase_capacity.assertion_flag=1;
}
}
if(((ds.p=117524524),((/*RF2*/(C)->_capacity/*8*/))==(0))){
(ds.p=117524762);
(/*SFN*/C->_capacity)=a1;
(ds.p=117525018);
(/*SFN*/C->_storage)=((T61)(se_calloc((/*RF2*/(C)->_capacity/*8*/),sizeof(T0*))));
}
else{
(ds.p=117525792);
_new_capacity=((/*RF2*/(C)->_capacity/*8*/))*(2);
while (!(((ds.p=117526330),(_new_capacity)>=(a1))))
{
(ds.p=117526816);
_new_capacity=(_new_capacity)*(2);
}
(ds.p=117527322);
(/*SFN*/C->_storage)=r61realloc(&ds,(/*RF2*/(C)->_storage/*4*/),(/*RF2*/(C)->_capacity/*8*/),_new_capacity);
if(((ds.p=117527866),(r6_ix_not(&ds,r58is_empty(&ds,C)))&&((r58tail(&ds,C))<((/*RF2*/(C)->_head/*16*/))))){
(ds.p=117528096);
_new_space=(_new_capacity)-((/*RF2*/(C)->_capacity/*8*/));
{int c=0;int v=0;
(ds.p=117528614);
_i=((/*RF2*/(C)->_capacity/*8*/))-(1);
while (!(((ds.p=117529642),(_i)<((/*RF2*/(C)->_head/*16*/)))))
{
(ds.p=117529126);
v=ac_lvc(c++,v,_i);
(ds.p=117530166);
((/*RF2*/(C)->_storage/*4*/))[(_i)+(_new_space)]=(((/*RF2*/(C)->_storage/*4*/))[_i]);
(ds.p=117530406);
_i=(_i)-(1);
}
}
(ds.p=117530912);
(/*SFN*/C->_head)=((/*RF2*/(C)->_head/*16*/))+(_new_space);
}
(ds.p=117531674);
(/*SFN*/C->_capacity)=_new_capacity;
}
if(f58increase_capacity.assertion_flag){
f58increase_capacity.assertion_flag=0;
(ds.p=117532454);
ac_ens(((/*RF2*/(C)->_capacity/*8*/))>(o56_359_25),NULL);
(ds.p=77645350);
ac_ens(((/*RF2*/(C)->_capacity/*8*/))>(o37_198_25),NULL);
f58increase_capacity.assertion_flag=1;
}
if(se_rci(C))se_i58(&ds,C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f58increase_capacity={"increase_capacity of CIRCULAR_QUEUE",1,6,"%R58%min_capacity%E2%new_capacity%E2%new_space%E2%i%E2%old l359c25CIRCULAR_QUEUE%E2%old l198c25ARRAYED_COLLECTION%E2%",1};


T2 r58rotate(se_dump_stack*caller,T58* C,T2 a1){
T2 R=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f58rotate;
ds.current=((void**)&C);
ds.p=117517320;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f58rotate.assertion_flag){
f58rotate.assertion_flag=0;
(ds.p=117517844);
ac_req(r58valid_index(&ds,C,a1),NULL);
f58rotate.assertion_flag=1;
}
(ds.p=117518356);
R=(((/*RF2*/(C)->_head/*16*/))+(a1))-(1);
if(((ds.p=117518888),(R)>=((/*RF2*/(C)->_capacity/*8*/)))){
(ds.p=117519130);
R=(R)-((/*RF2*/(C)->_capacity/*8*/));
}
if(f58rotate.assertion_flag){
f58rotate.assertion_flag=0;
(ds.p=117519916);
ac_ens(r6_px_and(&ds,(0)<=(R),(R)<((/*RF2*/(C)->_capacity/*8*/))),NULL);
(ds.p=117520176);
ac_ens((!((R)==((/*RF2*/(C)->_head/*16*/))))||((a1)==(1)),NULL);
(ds.p=117520432);
ac_ens((!((R)>((/*RF2*/(C)->_head/*16*/))))||((a1)==(((R)-((/*RF2*/(C)->_head/*16*/)))+(1))),NULL);
(ds.p=117520688);
ac_ens((!((R)<((/*RF2*/(C)->_head/*16*/))))||((a1)==(((R)+(((/*RF2*/(C)->_capacity/*8*/))-((/*RF2*/(C)->_head/*16*/))))+(1))),NULL);
(ds.p=117520940);
ac_ens((!(((/*RF2*/(C)->_head/*16*/))<(r58tail(&ds,C))))||(r6_px_and(&ds,((/*RF2*/(C)->_head/*16*/))<=(R),(R)<=(r58tail(&ds,C)))),NULL);
(ds.p=117521196);
ac_ens((!(((/*RF2*/(C)->_head/*16*/))>(r58tail(&ds,C))))||(r6_px_or(&ds,((/*RF2*/(C)->_head/*16*/))<=(R),(R)<=(r58tail(&ds,C)))),NULL);
f58rotate.assertion_flag=1;
}
if(se_rci(C))se_i58(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f58rotate={"rotate of CIRCULAR_QUEUE",1,2,"%R58%index%E2%Result%E2%",1};


void r58remove_last(se_dump_stack*caller,T58* C){
T2 o38_314_23=0;
T2 o38_315_23=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f58remove_last;
ds.current=((void**)&C);
ds.p=77627400;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&o38_314_23;
locals[1]=(void**)&o38_315_23;
se_dst=&ds;/*link*/
o38_314_23=r58count(&ds,C);
o38_315_23=(/*RF2*/(C)->_upper/*12*/);
se_require_uppermost_flag=1;
if(f58remove_last.assertion_flag){
f58remove_last.assertion_flag=0;
(ds.p=79771412);
ac_req(r6_ix_not(&ds,r58is_empty(&ds,C)),NULL);
f58remove_last.assertion_flag=1;
}
(ds.p=77627924);
(/*SFN*/C->_upper)=((/*RF2*/(C)->_upper/*12*/))-(1);
if(f58remove_last.assertion_flag){
f58remove_last.assertion_flag=0;
(ds.p=79772192);
ac_ens((r58count(&ds,C))==((o38_314_23)-(1)),NULL);
(ds.p=79772448);
ac_ens(((/*RF2*/(C)->_upper/*12*/))==((o38_315_23)-(1)),NULL);
f58remove_last.assertion_flag=1;
}
if(se_rci(C))se_i58(&ds,C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f58remove_last={"remove_last of ARRAYED_COLLECTION",1,2,"%R58%old l314c23COLLECTION%E2%old l315c23COLLECTION%E2%",1};


void r58increment_upper(se_dump_stack*caller,T58* C){
se_dump_stack ds;
ds.fd=&f58increment_upper;
ds.current=((void**)&C);
ds.p=77637128;
ds.caller=caller;
se_dst=&ds;/*link*/
if(((ds.p=77637676),((/*RF2*/(C)->_capacity/*8*/))==(0))){
(ds.p=77637914);
r58increase_capacity(&ds,C,8);
}
 else if(((ds.p=77638190),(r58count(&ds,C))==((/*RF2*/(C)->_capacity/*8*/)))){
(ds.p=77638426);
r58increase_capacity(&ds,C,(r58count(&ds,C))+(1));
}
(ds.p=77638932);
(/*SFN*/C->_upper)=((/*RF2*/(C)->_upper/*12*/))+(1);
if(se_rci(C))se_i58(&ds,C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f58increment_upper={"increment_upper of ARRAYED_COLLECTION",1,0,"%R58%",1};


T6 r58fast_has(se_dump_stack*caller,T58* C,T0* a1){
T6 R=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f58fast_has;
ds.current=((void**)&C);
ds.p=79777544;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=79778580);
R=r58valid_index(&ds,C,r58fast_index_of(&ds,C,a1));
if(se_rci(C))se_i58(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f58fast_has={"fast_has of COLLECTION",1,2,"%R58%x%R7%Result%E6%",1};


void r58add_last(se_dump_stack*caller,T58* C,T0* a1){
T2 o38_219_26=0;
T2 o38_220_22=0;
T2 o38_221_26=0;
void**locals[4];
se_dump_stack ds;
ds.fd=&f58add_last;
ds.current=((void**)&C);
ds.p=77623560;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&o38_219_26;
locals[2]=(void**)&o38_220_22;
locals[3]=(void**)&o38_221_26;
se_dst=&ds;/*link*/
o38_219_26=r58count(&ds,C);
o38_220_22=1;
o38_221_26=(/*RF2*/(C)->_upper/*12*/);
(ds.p=77624084);
r58increment_upper(&ds,C);
(ds.p=77624340);
r58put(&ds,C,a1,(/*RF2*/(C)->_upper/*12*/));
if(f58add_last.assertion_flag){
f58add_last.assertion_flag=0;
(ds.p=79747614);
ac_ens((r58last(&ds,C))==((void*)(a1)),NULL);
(ds.p=79747872);
ac_ens((r58count(&ds,C))==((1)+(o38_219_26)),NULL);
(ds.p=79748128);
ac_ens((1)==(o38_220_22),NULL);
(ds.p=79748384);
ac_ens(((/*RF2*/(C)->_upper/*12*/))==((1)+(o38_221_26)),NULL);
f58add_last.assertion_flag=1;
}
if(se_rci(C))se_i58(&ds,C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f58add_last={"add_last of ARRAYED_COLLECTION",1,4,"%R58%element%R7%old l219c26COLLECTION%E2%old l220c22COLLECTION%E2%old l221c26COLLECTION%E2%",1};


T0* r58first(se_dump_stack*caller,T58* C){
T0* R=NULL;
void**locals[1];
se_dump_stack ds;
ds.fd=&f58first;
ds.current=((void**)&C);
ds.p=117464584;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=0;
se_require_last_result=1;
if(f58first.assertion_flag){
f58first.assertion_flag=0;
(ds.p=117465108);
ac_req(r6_ix_not(&ds,r58is_empty(&ds,C)),NULL);
f58first.assertion_flag=1;
}
se_require_uppermost_flag=1;
if(!se_require_last_result){
se_require_last_result=1;
if(f58first.assertion_flag){
f58first.assertion_flag=0;
(ds.p=79721504);
ac_req((r58count(&ds,C))>=(1),NULL);
f58first.assertion_flag=1;
}
}
(ds.p=117465620);
R=((/*RF2*/(C)->_storage/*4*/))[(/*RF2*/(C)->_head/*16*/)];
if(f58first.assertion_flag){
f58first.assertion_flag=0;
(ds.p=117466146);
ac_ens((R)==((void*)(r58item(&ds,C,1))),NULL);
(ds.p=79722274);
ac_ens((R)==((void*)(r58item(&ds,C,1))),NULL);
f58first.assertion_flag=1;
}
if(se_rci(C))se_i58(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f58first={"first of CIRCULAR_QUEUE",1,1,"%R58%Result%R7%",1};


T2 r58fast_index_of(se_dump_stack*caller,T58* C,T0* a1){
T2 R=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f58fast_index_of;
ds.current=((void**)&C);
ds.p=117501960;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=117502746);
R=1;
while (!(((ds.p=117503288),((R)>((/*RF2*/(C)->_upper/*12*/)))||((r58item(&ds,C,R))==((void*)(a1))))))
{
(ds.p=117503770);
R=(R)+(1);
}
if(f58fast_index_of.assertion_flag){
f58fast_index_of.assertion_flag=0;
(ds.p=79785248);
ac_ens((1)<=(R),NULL);
(ds.p=79785506);
ac_ens((R)<=(((/*RF2*/(C)->_upper/*12*/))+(1)),NULL);
(ds.p=79785780);
ac_ens((!((R)<=((/*RF2*/(C)->_upper/*12*/))))||((a1)==((void*)(r58item(&ds,C,R)))),NULL);
f58fast_index_of.assertion_flag=1;
}
if(se_rci(C))se_i58(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f58fast_index_of={"fast_index_of of CIRCULAR_QUEUE",1,2,"%R58%element%R7%Result%E2%",1};


T2 r58tail(se_dump_stack*caller,T58* C){
T2 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f58tail;
ds.current=((void**)&C);
ds.p=117515016;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
if(((ds.p=117515546),r58is_empty(&ds,C))){
(ds.p=117515802);
R=-(1);
}
else{
(ds.p=117516314);
R=r58rotate(&ds,C,(/*RF2*/(C)->_upper/*12*/));
}
if(se_rci(C))se_i58(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f58tail={"tail of CIRCULAR_QUEUE",1,1,"%R58%Result%E2%",1};
se_frame_descriptor se_ifd58={"Class invariant of CIRCULAR_QUEUE[STRING]",1,0,"%R58%",1};


T58*se_i58(se_dump_stack*caller,T58*C){
se_dump_stack ds;
ds.fd=&se_ifd58;
ds.current=((void**)&C);
ds.p=117450510;
ds.caller=caller;
se_dst=&ds;
if(ds.fd->assertion_flag){
ds.fd->assertion_flag=0;
(ds.p=79843888);
ac_inv((1)<=(((/*RF2*/(C)->_upper/*12*/))+(1)),"valid_bounds");
(ds.p=77646874);
ac_inv(((/*RF2*/(C)->_capacity/*8*/))>=((((/*RF2*/(C)->_upper/*12*/))-(1))+(1)),NULL);
(ds.p=77647394);
ac_inv((!(((/*RF2*/(C)->_capacity/*8*/))>(0)))||(r61is_not_null(&ds,(/*RF2*/(C)->_storage/*4*/))),NULL);
(ds.p=117534002);
ac_inv((r58count(&ds,C))<=((/*RF2*/(C)->_capacity/*8*/)),"valid_count");
(ds.p=117534250);
ac_inv((0)<=((/*RF2*/(C)->_head/*16*/)),"head_positive");
(ds.p=117534528);
ac_inv((!(((/*RF2*/(C)->_capacity/*8*/))==(0)))||(((/*RF2*/(C)->_head/*16*/))==(0)),"head_zero");
(ds.p=117534786);
ac_inv((!(((/*RF2*/(C)->_capacity/*8*/))!=(0)))||(((/*RF2*/(C)->_head/*16*/))<((/*RF2*/(C)->_capacity/*8*/))),"valid_head");
ds.fd->assertion_flag=1;
}
se_dst=caller;
return C;
}
T0*oBC52singleton_memory=NULL;
int fBC52singleton_memory=0;


T0* r52singleton_memory(se_dump_stack*caller,T52* C){
if(fBC52singleton_memory==0){fBC52singleton_memory=1;{
void**locals[1];
se_dump_stack ds;
ds.fd=&f52singleton_memory;
ds.current=((void**)&C);
ds.p=109171208;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&oBC52singleton_memory;
se_dst=&ds;/*link*/
(ds.p=109171732);
oBC52singleton_memory=((T0*)(C));
if(se_rci(C))se_i52(&ds,C);
se_dst=caller;/*unlink*/
}}
return oBC52singleton_memory;
}
se_frame_descriptor f52singleton_memory={"singleton_memory of STRING_POOL",1,1,"%R52%Result%R52%",1};


void r52put(se_dump_stack*caller,T52* C,T0* a1){
T6 _found=0;
T0* _list=NULL;
T2 _idx2=0;
T2 _idx1=0;
void**locals[5];
se_dump_stack ds;
ds.fd=&f52put;
ds.current=((void**)&C);
ds.p=109086216;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&_found;
locals[2]=(void**)&_list;
locals[3]=(void**)&_idx2;
locals[4]=(void**)&_idx1;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f52put.assertion_flag){
f52put.assertion_flag=0;
(ds.p=109086744);
ac_req((a1)!=((void*)(NULL)),NULL);
f52put.assertion_flag=1;
}
(ds.p=109088276);
_idx1=r52index_of_at_most(&ds,C,(/*RF2*/(se_i7(&ds,((T7*)ci(7,a1,109088326))))->_capacity/*12*/));
(ds.p=109088532);
_list=r57item(&ds,se_i57(&ds,((T57*)ci(57,(/*RF2*/(C)->_available/*8*/),109088548))),_idx1);
if(((ds.p=109088804),(_list)==((void*)(NULL)))){
(ds.p=109089050);
{T58*n=((T58*)se_malloc(sizeof(*n))/*20*/);
*n=M58;
r58make(&ds,n);
_list=((T0*)n);
se_i58(&ds,n);}
(ds.p=109089326);
r57put(&ds,se_i57(&ds,((T57*)ci(57,(/*RF2*/(C)->_available/*8*/),109089306))),_list,_idx1);
}
(ds.p=109089822);
r58add_last(&ds,se_i58(&ds,((T58*)ci(58,_list,109089812))),a1);
if(((ds.p=109090330),(/*RF2*/(C)->_check_for_capacity_changes/*4*/))){
if(((ds.p=109090614),((/*RF2*/(se_i7(&ds,((T7*)ci(7,a1,109090592))))->_capacity/*12*/))>(8192))){
(ds.p=109090848);
_idx1=(_idx1)+(1);
}
{int c=0;int v=0;
(ds.p=109091616);
_idx2=0;
(ds.p=109091872);
_list=r57item(&ds,se_i57(&ds,((T57*)ci(57,(/*RF2*/(C)->_on_loan/*12*/),109091888))),_idx2);
(ds.p=109092128);
_found=((_list)!=((void*)(NULL)))&&(r58fast_has(&ds,se_i58(&ds,((T58*)ci(58,_list,109092192))),a1));
while (!(((ds.p=109093164),(_found)||((_idx2)==((/*RF2*/(se_i57(&ds,((T57*)ci(57,(/*RF2*/(C)->_on_loan/*12*/),109093194))))->_upper/*12*/))))))
{
(ds.p=109092668);
v=ac_lvc(c++,v,((/*RF2*/(se_i57(&ds,((T57*)ci(57,(/*RF2*/(C)->_on_loan/*12*/),109092640))))->_upper/*12*/))-(_idx2));
(ds.p=109093664);
_idx2=(_idx2)+(1);
(ds.p=109093920);
_list=r57item(&ds,se_i57(&ds,((T57*)ci(57,(/*RF2*/(C)->_on_loan/*12*/),109093936))),_idx2);
(ds.p=109094176);
_found=((_list)!=((void*)(NULL)))&&(r58fast_has(&ds,se_i58(&ds,((T58*)ci(58,_list,109094240))),a1));
}
}
if(f52put.assertion_flag){
f52put.assertion_flag=0;
(ds.p=109094972);
ac_civ(_found,"alien_string");
f52put.assertion_flag=1;
}
if(_found){
(ds.p=109095722);
r58remove(&ds,se_i58(&ds,((T58*)ci(58,_list,109095712))),r58fast_index_of(&ds,se_i58(&ds,((T58*)ci(58,_list,109095736))),a1));
if(f52put.assertion_flag){
f52put.assertion_flag=0;
(ds.p=109096276);
ac_civ((_idx1)==(_idx2),"capacity_changed");
f52put.assertion_flag=1;
}
}
}
if(f52put.assertion_flag){
f52put.assertion_flag=0;
(ds.p=109097582);
ac_ens((r57item(&ds,se_i57(&ds,((T57*)ci(57,(/*RF2*/(C)->_available/*8*/),109097492))),r52index_of_at_most(&ds,C,(/*RF2*/(se_i7(&ds,((T7*)ci(7,a1,109097556))))->_capacity/*12*/))))!=((void*)(NULL)),NULL);
(ds.p=109097848);
ac_ens((r58last(&ds,se_i58(&ds,((T58*)ci(58,r57item(&ds,se_i57(&ds,((T57*)ci(57,(/*RF2*/(C)->_available/*8*/),109097748))),r52index_of_at_most(&ds,C,(/*RF2*/(se_i7(&ds,((T7*)ci(7,a1,109097812))))->_capacity/*12*/))),109097768)))))==((void*)(a1)),NULL);
f52put.assertion_flag=1;
}
if(se_rci(C))se_i52(&ds,C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f52put={"put of STRING_POOL",1,5,"%R52%s%R7%found%E6%list%R58%idx2%E2%idx1%E2%",1};


T2 r52index_of_at_least(se_dump_stack*caller,T52* C,T2 a1){
T2 R=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f52index_of_at_least;
ds.current=((void**)&C);
ds.p=109145352;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f52index_of_at_least.assertion_flag){
f52index_of_at_least.assertion_flag=0;
(ds.p=109146408);
ac_req(r52is_in_range(&ds,C,a1),"in_range");
f52index_of_at_least.assertion_flag=1;
}
if(((ds.p=109147436),(a1)<=(256))){
if(((ds.p=109147698),(a1)<=(64))){
if(((ds.p=109147960),(a1)<=(32))){
(ds.p=109148198);
R=0;
}
else{
(ds.p=109148710);
R=1;
}
}
else{
if(((ds.p=109149496),(a1)<=(128))){
(ds.p=109149734);
R=2;
}
else{
(ds.p=109150246);
R=3;
}
}
}
else{
if(((ds.p=109151282),(a1)<=(1024))){
if(((ds.p=109151544),(a1)<=(512))){
(ds.p=109151782);
R=4;
}
else{
(ds.p=109152294);
R=5;
}
}
else{
if(((ds.p=109153080),(a1)<=(2048))){
(ds.p=109153318);
R=6;
}
 else if(((ds.p=109153600),(a1)<=(4096))){
(ds.p=109153830);
R=7;
}
else{
(ds.p=109154342);
R=8;
}
}
}
if(se_rci(C))se_i52(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f52index_of_at_least={"index_of_at_least of STRING_POOL",1,2,"%R52%capacity%E2%Result%E2%",1};


T0* r52item(se_dump_stack*caller,T52* C,T2 a1){
T0* R=NULL;
T0* _list=NULL;
T2 _idx=0;
void**locals[4];
se_dump_stack ds;
ds.fd=&f52item;
ds.current=((void**)&C);
ds.p=109077512;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
locals[2]=(void**)&_list;
locals[3]=(void**)&_idx;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f52item.assertion_flag){
f52item.assertion_flag=0;
(ds.p=109078036);
ac_req(r52is_in_range(&ds,C,a1),NULL);
f52item.assertion_flag=1;
}
(ds.p=109079316);
_idx=r52index_of_at_least(&ds,C,a1);
(ds.p=109079572);
_list=r57item(&ds,se_i57(&ds,((T57*)ci(57,(/*RF2*/(C)->_available/*8*/),109079588))),_idx);
if(((ds.p=109079858),((_list)==((void*)(NULL)))||(r58is_empty(&ds,se_i58(&ds,((T58*)ci(58,_list,109079874))))))){
(ds.p=109080090);
{T7*n=((T7*)se_malloc(sizeof(*n))/*20*/);
*n=M7;
r7make(&ds,n,(r2_px_94(&ds,2,_idx))*(32));
R=((T0*)n);
se_i7(&ds,n);}
(ds.p=109080366);
r53put(&ds,se_i53(&ds,((T53*)ci(53,(/*RF2*/(C)->_num_alloc/*16*/),109080346))),(r53item(&ds,se_i53(&ds,((T53*)ci(53,(/*RF2*/(C)->_num_alloc/*16*/),109080374))),_idx))+(1),_idx);
}
else{
(ds.p=109080858);
R=r58first(&ds,se_i58(&ds,((T58*)ci(58,_list,109080878))));
(ds.p=109081124);
r58remove_first(&ds,se_i58(&ds,((T58*)ci(58,_list,109081114))));
(ds.p=109081384);
r7clear(&ds,se_i7(&ds,((T7*)ci(7,R,109081370))));
}
if(((ds.p=109082138),(/*RF2*/(C)->_check_for_capacity_changes/*4*/))){
if(((ds.p=109082432),((/*RF2*/(se_i7(&ds,((T7*)ci(7,R,109082400))))->_capacity/*12*/))>(8192))){
(ds.p=109082656);
_idx=(_idx)+(1);
}
(ds.p=109083162);
_list=r57item(&ds,se_i57(&ds,((T57*)ci(57,(/*RF2*/(C)->_on_loan/*12*/),109083178))),_idx);
if(((ds.p=109083434),(_list)==((void*)(NULL)))){
(ds.p=109083680);
{T58*n=((T58*)se_malloc(sizeof(*n))/*20*/);
*n=M58;
r58make(&ds,n);
_list=((T0*)n);
se_i58(&ds,n);}
(ds.p=109083952);
r57put(&ds,se_i57(&ds,((T57*)ci(57,(/*RF2*/(C)->_on_loan/*12*/),109083936))),_list,_idx);
}
(ds.p=109084452);
r58add_last(&ds,se_i58(&ds,((T58*)ci(58,_list,109084442))),R);
}
if(f52item.assertion_flag){
f52item.assertion_flag=0;
(ds.p=109085218);
ac_ens((R)!=((void*)(NULL)),NULL);
(ds.p=109085492);
ac_ens(((/*RF2*/(se_i7(&ds,((T7*)ci(7,R,109085460))))->_capacity/*12*/))>=(a1),NULL);
f52item.assertion_flag=1;
}
if(se_rci(C))se_i52(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f52item={"item of STRING_POOL",1,4,"%R52%requested_capacity%E2%Result%R7%list%R58%idx%E2%",1};


T2 r52index_of_at_most(se_dump_stack*caller,T52* C,T2 a1){
T2 R=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f52index_of_at_most;
ds.current=((void**)&C);
ds.p=109155848;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(((ds.p=109158444),(a1)<(512))){
if(((ds.p=109158706),(a1)<(128))){
if(((ds.p=109158968),(a1)<(64))){
(ds.p=109159206);
R=0;
}
else{
(ds.p=109159718);
R=1;
}
}
else{
if(((ds.p=109160504),(a1)<(256))){
(ds.p=109160742);
R=2;
}
else{
(ds.p=109161254);
R=3;
}
}
}
else{
if(((ds.p=109162290),(a1)<(2048))){
if(((ds.p=109162552),(a1)<(1024))){
(ds.p=109162790);
R=4;
}
else{
(ds.p=109163302);
R=5;
}
}
else{
if(((ds.p=109164088),(a1)<(4096))){
(ds.p=109164326);
R=6;
}
 else if(((ds.p=109164608),(a1)<(8192))){
(ds.p=109164838);
R=7;
}
else{
(ds.p=109165350);
R=8;
}
}
}
if(se_rci(C))se_i52(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f52index_of_at_most={"index_of_at_most of STRING_POOL",1,2,"%R52%capacity%E2%Result%E2%",1};


T6 r52is_exact_size(se_dump_stack*caller,T52* C,T2 a1){
T6 R=0;
T2 _size=0;
void**locals[3];
se_dump_stack ds;
ds.fd=&f52is_exact_size;
ds.current=((void**)&C);
ds.p=109100296;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
locals[2]=(void**)&_size;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f52is_exact_size.assertion_flag){
f52is_exact_size.assertion_flag=0;
(ds.p=109101076);
ac_req(r52is_in_range(&ds,C,a1),NULL);
f52is_exact_size.assertion_flag=1;
}
(ds.p=109102362);
_size=32;
while (!(((ds.p=109102888),(R)||((_size)>(8192)))))
{
(ds.p=109103386);
R=(a1)==(_size);
(ds.p=109103642);
_size=(_size)*(2);
}
if(se_rci(C))se_i52(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f52is_exact_size={"is_exact_size of STRING_POOL",1,3,"%R52%capacity%E2%Result%E6%size%E2%",1};


void r52make(se_dump_stack*caller,T52* C){
se_dump_stack ds;
ds.fd=&f52make;
ds.current=((void**)&C);
ds.p=109168904;
ds.caller=caller;
se_dst=&ds;/*link*/
(ds.p=109169428);
{T57*n=((T57*)se_malloc(sizeof(*n))/*16*/);
*n=M57;
r57make(&ds,n,r52num_different_sizes(&ds,C));
(/*SFN*/C->_available)=((T0*)n);
se_i57(&ds,n);}
(ds.p=109169684);
{T57*n=((T57*)se_malloc(sizeof(*n))/*16*/);
*n=M57;
r57make(&ds,n,(r52num_different_sizes(&ds,C))+(1));
(/*SFN*/C->_on_loan)=((T0*)n);
se_i57(&ds,n);}
(ds.p=109169940);
{T53*n=((T53*)se_malloc(sizeof(*n))/*16*/);
*n=M53;
r53make(&ds,n,r52num_different_sizes(&ds,C));
(/*SFN*/C->_num_alloc)=((T0*)n);
se_i53(&ds,n);}
if(se_rci(C))se_i52(&ds,C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f52make={"make of STRING_POOL",1,0,"%R52%",1};
T2 oBC52num_different_sizes=0;
int fBC52num_different_sizes=0;


T2 r52num_different_sizes(se_dump_stack*caller,T52* C){
if(fBC52num_different_sizes==0){fBC52num_different_sizes=1;{
T2 _size=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f52num_different_sizes;
ds.current=((void**)&C);
ds.p=109105160;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&oBC52num_different_sizes;
locals[1]=(void**)&_size;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f52num_different_sizes.assertion_flag){
f52num_different_sizes.assertion_flag=0;
(ds.p=109105940);
ac_req(r52is_exact_size(&ds,C,8192),NULL);
f52num_different_sizes.assertion_flag=1;
}
(ds.p=109107226);
_size=32;
(ds.p=109107482);
oBC52num_different_sizes=1;
while (!(((ds.p=109108004),(_size)==(8192))))
{
(ds.p=109108506);
_size=(_size)*(2);
(ds.p=109108762);
oBC52num_different_sizes=(oBC52num_different_sizes)+(1);
}
if(se_rci(C))se_i52(&ds,C);
se_dst=caller;/*unlink*/
}}
return oBC52num_different_sizes;
}
se_frame_descriptor f52num_different_sizes={"num_different_sizes of STRING_POOL",1,2,"%R52%Result%E2%size%E2%",1};


T6 r52is_in_range(se_dump_stack*caller,T52* C,T2 a1){
T6 R=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f52is_in_range;
ds.current=((void**)&C);
ds.p=109099016;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=109099540);
R=r6_px_and(&ds,(0)<(a1),(a1)<=(8192));
if(se_rci(C))se_i52(&ds,C);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f52is_in_range={"is_in_range of STRING_POOL",1,2,"%R52%capacity%E2%Result%E6%",1};
se_frame_descriptor se_ifd52={"Class invariant of STRING_POOL",1,0,"%R52%",1};


T52*se_i52(se_dump_stack*caller,T52*C){
se_dump_stack ds;
ds.fd=&se_ifd52;
ds.current=((void**)&C);
ds.p=109074446;
ds.caller=caller;
se_dst=&ds;
if(ds.fd->assertion_flag){
ds.fd->assertion_flag=0;
(ds.p=109173054);
ac_inv((C)==((void*)(r52singleton_memory(&ds,C))),"is_real_singleton");
ds.fd->assertion_flag=1;
}
se_dst=caller;
return C;
}


T0* r25name(se_dump_stack*caller,T25* C){
T0* R=NULL;
T2 _size=0;
T2 _i=0;
void**locals[3];
se_dump_stack ds;
ds.fd=&f25name;
ds.current=((void**)&C);
ds.p=52450056;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
locals[1]=(void**)&_size;
locals[2]=(void**)&_i;
se_dst=&ds;/*link*/
if(((ds.p=52451378),((/*RF2*/(C)->_name_string/*12*/))==((void*)(NULL)))){
{int c=0;int v=0;
(ds.p=52451872);
_i=0;
while (!(((ds.p=52452900),(_i)>((/*RF2*/(se_i44(&ds,((T44*)ci(44,(/*RF2*/(C)->_spellings/*8*/),52452904))))->_upper/*12*/)))))
{
(ds.p=52452416);
v=ac_lvc(c++,v,((/*RF2*/(se_i44(&ds,((T44*)ci(44,(/*RF2*/(C)->_spellings/*8*/),52452384))))->_upper/*12*/))-(_i));
(ds.p=52453408);
_size=((_size)+((/*RF2*/(se_i7(&ds,((T7*)ci(7,(/*RF2*/(((T24*)ci(24,r44item(&ds,se_i44(&ds,((T44*)ci(44,(/*RF2*/(C)->_spellings/*8*/),52453438))),_i),52453458)))->_spelling/*8*/),52453474))))->_count/*8*/)))+(1);
(ds.p=52453664);
_i=(_i)+(1);
}
}
(ds.p=52454426);
{T7*n=((T7*)se_malloc(sizeof(*n))/*20*/);
*n=M7;
r7make(&ds,n,_size);
(/*SFN*/C->_name_string)=((T0*)n);
se_i7(&ds,n);}
}
else{
(ds.p=52454962);
r7clear(&ds,se_i7(&ds,((T7*)ci(7,(/*RF2*/(C)->_name_string/*12*/),52454938))));
}
{int c=0;int v=0;
(ds.p=52455962);
_i=0;
while (!(((ds.p=52456990),(_i)>((/*RF2*/(se_i44(&ds,((T44*)ci(44,(/*RF2*/(C)->_spellings/*8*/),52456994))))->_upper/*12*/)))))
{
(ds.p=52456506);
v=ac_lvc(c++,v,((/*RF2*/(se_i44(&ds,((T44*)ci(44,(/*RF2*/(C)->_spellings/*8*/),52456474))))->_upper/*12*/))-(_i));
if(((ds.p=52457508),(_i)>(0))){
(ds.p=52457784);
r7extend(&ds,se_i7(&ds,((T7*)ci(7,(/*RF2*/(C)->_name_string/*12*/),52457760))),((T3)'\137'));
}
(ds.p=52458290);
r7append(&ds,se_i7(&ds,((T7*)ci(7,(/*RF2*/(C)->_name_string/*12*/),52458266))),(/*RF2*/(((T24*)ci(24,r44item(&ds,se_i44(&ds,((T44*)ci(44,(/*RF2*/(C)->_spellings/*8*/),52458304))),_i),52458324)))->_spelling/*8*/));
(ds.p=52458522);
_i=(_i)+(1);
}
}
(ds.p=52459284);
R=(/*RF2*/(C)->_name_string/*12*/);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f25name={"name of NAME",1,3,"%R25%Result%R7%size%E2%i%E2%",1};


T0* r25find_spelling_from_reference(se_dump_stack*caller,T25* C,T17 a1){
T0* R=NULL;
T2 _i=0;
void**locals[3];
se_dump_stack ds;
ds.fd=&f25find_spelling_from_reference;
ds.current=((void**)&C);
ds.p=39913480;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
locals[2]=(void**)&_i;
se_dst=&ds;/*link*/
{int c=0;int v=0;
(ds.p=39914778);
_i=0;
while (!(((ds.p=39915850),((_i)>((/*RF2*/(se_i44(&ds,((T44*)ci(44,r25all_spellings(&ds),39915810))))->_upper/*12*/)))||((R)!=((void*)(NULL))))))
{
(ds.p=39915330);
v=ac_lvc(c++,v,((/*RF2*/(se_i44(&ds,((T44*)ci(44,r25all_spellings(&ds),39915290))))->_upper/*12*/))-(_i));
if(((ds.p=39916384),((/*RF2*/(((T24*)ci(24,r44item(&ds,se_i44(&ds,((T44*)ci(44,r25all_spellings(&ds),39916320))),_i),39916348)))->_reference/*4*/))==(a1))){
(ds.p=39916576);
R=r44item(&ds,se_i44(&ds,((T44*)ci(44,r25all_spellings(&ds),39916596))),_i);
}
(ds.p=39917338);
_i=(_i)+(1);
}
}
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f25find_spelling_from_reference={"find_spelling_from_reference of GLOBALS",1,3,"%R25%ref%E17%Result%R24%i%E2%",1};


void r25skip_time(se_dump_stack*caller,T25* C,T0* a1){
void**locals[1];
se_dump_stack ds;
ds.fd=&f25skip_time;
ds.current=((void**)&C);
ds.p=39967496;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
se_dst=&ds;/*link*/
if(((ds.p=39968048),((/*RF2*/(se_i7(&ds,((T7*)ci(7,a1,39968026))))->_count/*8*/))<(32))){
(ds.p=39968302);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39968282)),((T0*)ms19_683379699a));
(ds.p=39968558);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39968538)),a1);
(ds.p=39968814);
r50put_new_line(&ds,((T50*)ci(50,oBC1std_error,39968794)));
(ds.p=39969050);
exit(1);
}
if(((ds.p=39969844),(r7item(&ds,se_i7(&ds,((T7*)ci(7,a1,39969818))),1))!=(((T3)'\42')))){
(ds.p=39970094);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39970074)),((T0*)ms19_1538229628));
(ds.p=39970350);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39970330)),a1);
(ds.p=39970606);
r50put_new_line(&ds,((T50*)ci(50,oBC1std_error,39970586)));
(ds.p=39970842);
exit(1);
}
if(((ds.p=39971638),(r7item(&ds,se_i7(&ds,((T7*)ci(7,a1,39971610))),32))!=(((T3)'\42')))){
(ds.p=39971886);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39971866)),((T0*)ms19_1061971043));
(ds.p=39972142);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39972122)),a1);
(ds.p=39972398);
r50put_new_line(&ds,((T50*)ci(50,oBC1std_error,39972378)));
(ds.p=39972634);
exit(1);
}
(ds.p=39973918);
r7remove_first(&ds,se_i7(&ds,((T7*)ci(7,a1,39973908))),32);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f25skip_time={"skip_time of GLOBALS",1,1,"%R25%line%R7%",1};


void r25make_from_csv(se_dump_stack*caller,T25* C,T0* a1){
T17 _dummy=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f25make_from_csv;
ds.current=((void**)&C);
ds.p=52489992;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&_dummy;
se_dst=&ds;/*link*/
(ds.p=52491028);
{T44*n=((T44*)se_malloc(sizeof(*n))/*16*/);
*n=M44;
r44with_capacity(&ds,n,4);
(/*SFN*/C->_spellings)=((T0*)n);
se_i44(&ds,n);}
(ds.p=52491540);
(/*SFN*/C->_reference)=r25scan_reference(&ds,C,a1);
(ds.p=52492052);
r25check_comma(&ds,C,a1);
(ds.p=52492564);
r25skip_time(&ds,C,a1);
(ds.p=52493076);
r25check_comma(&ds,C,a1);
(ds.p=52493588);
_dummy=r25scan_reference(&ds,C,a1);
(ds.p=52494100);
r25check_comma(&ds,C,a1);
(ds.p=52494612);
_dummy=r25scan_reference(&ds,C,a1);
while (!(((ds.p=52495652),r7is_empty(&ds,se_i7(&ds,((T7*)ci(7,a1,52495642)))))))
{
(ds.p=52496154);
r25check_comma(&ds,C,a1);
(ds.p=52496666);
_dummy=r25scan_reference(&ds,C,a1);
(ds.p=52497198);
r44add_last(&ds,se_i44(&ds,((T44*)ci(44,(/*RF2*/(C)->_spellings/*8*/),52497178))),r25find_spelling_from_reference(&ds,C,_dummy));
}
se_dst=caller;/*unlink*/
}
se_frame_descriptor f25make_from_csv={"make_from_csv of NAME",1,2,"%R25%line%R7%dummy%E17%",1};


T0* r25name_capitalized(se_dump_stack*caller,T25* C){
T0* R=NULL;
T2 _i=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f25name_capitalized;
ds.current=((void**)&C);
ds.p=52460040;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
locals[1]=(void**)&_i;
se_dst=&ds;/*link*/
(ds.p=52461076);
R=r25name(&ds,C);
(ds.p=52461602);
r7put(&ds,se_i7(&ds,((T7*)ci(7,R,52461588))),r3to_upper(&ds,r7first(&ds,se_i7(&ds,((T7*)ci(7,R,52461610))))),1);
if(((ds.p=52462120),r7has_prefix(&ds,se_i7(&ds,((T7*)ci(7,R,52462106))),((T0*)ms25_2795)))){
(ds.p=52462376);
r7put(&ds,se_i7(&ds,((T7*)ci(7,R,52462362))),r3to_upper(&ds,r7item(&ds,se_i7(&ds,((T7*)ci(7,R,52462384))),2)),2);
}
if(((ds.p=52463144),r7has_prefix(&ds,se_i7(&ds,((T7*)ci(7,R,52463130))),((T0*)ms25_2270)))){
(ds.p=52463400);
r7put(&ds,se_i7(&ds,((T7*)ci(7,R,52463386))),r3to_upper(&ds,r7item(&ds,se_i7(&ds,((T7*)ci(7,R,52463408))),2)),2);
}
if(((ds.p=52464168),r7has_prefix(&ds,se_i7(&ds,((T7*)ci(7,R,52464154))),((T0*)ms25_2478)))){
(ds.p=52464424);
r7put(&ds,se_i7(&ds,((T7*)ci(7,R,52464410))),r3to_upper(&ds,r7item(&ds,se_i7(&ds,((T7*)ci(7,R,52464432))),2)),2);
}
if(((ds.p=52465192),r7has_prefix(&ds,se_i7(&ds,((T7*)ci(7,R,52465178))),((T0*)ms25_13509)))){
(ds.p=52465448);
r7put(&ds,se_i7(&ds,((T7*)ci(7,R,52465434))),r3to_upper(&ds,r7item(&ds,se_i7(&ds,((T7*)ci(7,R,52465456))),2)),2);
(ds.p=52465704);
r7put(&ds,se_i7(&ds,((T7*)ci(7,R,52465690))),r3to_upper(&ds,r7item(&ds,se_i7(&ds,((T7*)ci(7,R,52465712))),3)),3);
}
(ds.p=52466714);
_i=2;
while (!(((ds.p=52467230),(_i)>(r7upper(&ds,se_i7(&ds,((T7*)ci(7,R,52467234))))))))
{
if(((ds.p=52467774),(r7item(&ds,se_i7(&ds,((T7*)ci(7,R,52467744))),_i))==(((T3)'\137')))){
(ds.p=52468000);
_i=(_i)+(1);
(ds.p=52468270);
r7put(&ds,se_i7(&ds,((T7*)ci(7,R,52468256))),r3to_upper(&ds,r7item(&ds,se_i7(&ds,((T7*)ci(7,R,52468278))),_i)),_i);
}
(ds.p=52468762);
_i=(_i)+(1);
}
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f25name_capitalized={"name_capitalized of NAME",1,2,"%R25%Result%R7%i%E2%",1};


T17 r25scan_reference(se_dump_stack*caller,T25* C,T0* a1){
T17 R=0;
T2 _i=0;
void**locals[3];
se_dump_stack ds;
ds.fd=&f25scan_reference;
ds.current=((void**)&C);
ds.p=39951880;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
locals[2]=(void**)&_i;
se_dst=&ds;/*link*/
if(((ds.p=39952944),((/*RF2*/(se_i7(&ds,((T7*)ci(7,a1,39952922))))->_count/*8*/))<(10))){
(ds.p=39953198);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39953178)),((T0*)ms19_683379699));
(ds.p=39953454);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39953434)),a1);
(ds.p=39953710);
r50put_new_line(&ds,((T50*)ci(50,oBC1std_error,39953690)));
(ds.p=39953946);
exit(1);
}
if(((ds.p=39954714),r6_ix_not(&ds,r7has_prefix(&ds,se_i7(&ds,((T7*)ci(7,a1,39954722))),((T0*)ms19_360))))){
(ds.p=39954990);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39954970)),((T0*)ms19_1773176095));
(ds.p=39955246);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39955226)),a1);
(ds.p=39955502);
r50put_new_line(&ds,((T50*)ci(50,oBC1std_error,39955482)));
(ds.p=39955738);
exit(1);
}
{int c=0;int v=0;
(ds.p=39956762);
_i=3;
while (!(((ds.p=39957790),(_i)>(10))))
{
(ds.p=39957280);
v=ac_lvc(c++,v,(10)-(_i));
if(((ds.p=39958304),r6_ix_not(&ds,r3is_hexadecimal_digit(&ds,r7item(&ds,se_i7(&ds,((T7*)ci(7,a1,39958312))),_i))))){
(ds.p=39958580);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39958560)),((T0*)ms19_433290798));
(ds.p=39958836);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39958816)),a1);
(ds.p=39959092);
r50put_new_line(&ds,((T50*)ci(50,oBC1std_error,39959072)));
(ds.p=39959328);
exit(1);
}
(ds.p=39960090);
_i=(_i)+(1);
}
}
{int c=0;int v=0;
(ds.p=39961114);
_i=3;
while (!(((ds.p=39962142),(_i)>(10))))
{
(ds.p=39961632);
v=ac_lvc(c++,v,(10)-(_i));
(ds.p=39962650);
R=((R)*(16U))+(((T17)(r3hexadecimal_value(&ds,r7item(&ds,se_i7(&ds,((T7*)ci(7,a1,39962700))),_i)))));
(ds.p=39962906);
_i=(_i)+(1);
}
}
(ds.p=39963678);
r7remove_first(&ds,se_i7(&ds,((T7*)ci(7,a1,39963668))),10);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f25scan_reference={"scan_reference of GLOBALS",1,3,"%R25%line%R7%Result%E17%i%E2%",1};
T0*oBC19all_spellings=NULL;
int fBC19all_spellings=0;


T0* r25all_spellings(se_dump_stack*caller){
if(fBC19all_spellings==0){fBC19all_spellings=1;{
void**locals[1];
se_dump_stack ds;
ds.fd=&f25all_spellings;
ds.current=NULL;
ds.p=39869448;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&oBC19all_spellings;
se_dst=&ds;/*link*/
(ds.p=39869972);
{T44*n=((T44*)se_malloc(sizeof(*n))/*16*/);
*n=M44;
oBC19all_spellings=((T0*)n);
r44with_capacity(&ds,n,256);
se_i44(&ds,n);}
se_dst=caller;/*unlink*/
}}
return oBC19all_spellings;
}
se_frame_descriptor f25all_spellings={"all_spellings of GLOBALS",0,1,"Result%R44%",1};


void r25check_comma(se_dump_stack*caller,T25* C,T0* a1){
void**locals[1];
se_dump_stack ds;
ds.fd=&f25check_comma;
ds.current=((void**)&C);
ds.p=39964424;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
se_dst=&ds;/*link*/
if(((ds.p=39964976),(r7first(&ds,se_i7(&ds,((T7*)ci(7,a1,39964954)))))==(((T3)'\54')))){
(ds.p=39965220);
r7remove_first(&ds,se_i7(&ds,((T7*)ci(7,a1,39965210))),1);
}
else{
(ds.p=39965742);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39965722)),((T0*)ms19_495303630));
(ds.p=39965998);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39965978)),a1);
(ds.p=39966254);
r50put_new_line(&ds,((T50*)ci(50,oBC1std_error,39966234)));
(ds.p=39966490);
exit(1);
}
se_dst=caller;/*unlink*/
}
se_frame_descriptor f25check_comma={"check_comma of GLOBALS",1,1,"%R25%line%R7%",1};
T0*oBC1std_error=NULL;


void r32put_new_line(se_dump_stack*caller,T32* C){
se_dump_stack ds;
ds.fd=&f32put_new_line;
ds.current=((void**)&C);
ds.p=69283080;
ds.caller=caller;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f32put_new_line.assertion_flag){
f32put_new_line.assertion_flag=0;
(ds.p=69283860);
ac_req(r32is_connected(&ds,C),NULL);
f32put_new_line.assertion_flag=1;
}
(ds.p=69284372);
r32put_character(&ds,C,((T3)'\n'));
se_dst=caller;/*unlink*/
}
se_frame_descriptor f32put_new_line={"put_new_line of OUTPUT_STREAM",1,0,"%R32%",1};


void r32disconnect(se_dump_stack*caller,T32* C){
se_dump_stack ds;
ds.fd=&f32disconnect;
ds.current=((void**)&C);
ds.p=67131912;
ds.caller=caller;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f32disconnect.assertion_flag){
f32disconnect.assertion_flag=0;
(ds.p=67132436);
ac_req(r32is_connected(&ds,C),NULL);
f32disconnect.assertion_flag=1;
}
(ds.p=67132948);
r32fclose(&ds,(/*RF2*/(C)->_output_stream/*8*/));
(ds.p=67133204);
(/*SFN*/C->_path)=NULL;
se_dst=caller;/*unlink*/
}
se_frame_descriptor f32disconnect={"disconnect of STD_FILE_WRITE",1,0,"%R32%",1};


T6 r32is_connected(se_dump_stack*caller,T32* C){
T6 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f32is_connected;
ds.current=((void**)&C);
ds.p=67135496;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=67136020);
R=((/*RF2*/(C)->_path/*4*/))!=((void*)(NULL));
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f32is_connected={"is_connected of STD_FILE_WRITE",1,1,"%R32%Result%E6%",1};


void r32make(se_dump_stack*caller,T32* C){
se_dump_stack ds;
ds.fd=&f32make;
ds.current=((void**)&C);
ds.p=67133960;
ds.caller=caller;
se_dst=&ds;/*link*/
se_dst=caller;/*unlink*/
}
se_frame_descriptor f32make={"make of STD_FILE_WRITE",1,0,"%R32%",1};


void r32connect_to(se_dump_stack*caller,T32* C,T0* a1){
void**locals[1];
se_dump_stack ds;
ds.fd=&f32connect_to;
ds.current=((void**)&C);
ds.p=67128328;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f32connect_to.assertion_flag){
f32connect_to.assertion_flag=0;
(ds.p=67128852);
ac_req(r6_ix_not(&ds,r32is_connected(&ds,C)),NULL);
(ds.p=67129108);
ac_req(r6_ix_not(&ds,r7is_empty(&ds,se_i7(&ds,((T7*)ci(7,a1,67129116))))),NULL);
f32connect_to.assertion_flag=1;
}
(ds.p=67129620);
r32make(&ds,C);
(ds.p=67129876);
(/*SFN*/C->_output_stream)=fopen((char*)r7to_external(&ds,se_i7(&ds,((T7*)ci(7,a1,67129928)))),"wa");
if(((ds.p=67130166),(NULL!=(/*RF2*/(C)->_output_stream/*8*/)))){
(ds.p=67130394);
(/*SFN*/C->_path)=a1;
}
se_dst=caller;/*unlink*/
}
se_frame_descriptor f32connect_to={"connect_to of STD_FILE_WRITE",1,1,"%R32%new_path%R7%",1};


void r32put_integer(se_dump_stack*caller,T32* C,T2 a1){
void**locals[1];
se_dump_stack ds;
ds.fd=&f32put_integer;
ds.current=((void**)&C);
ds.p=69238280;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f32put_integer.assertion_flag){
f32put_integer.assertion_flag=0;
(ds.p=69239060);
ac_req(r32is_connected(&ds,C),NULL);
f32put_integer.assertion_flag=1;
}
(ds.p=69239576);
r2store(&ds,a1,(T0*)C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f32put_integer={"put_integer of OUTPUT_STREAM",1,1,"%R32%i%E2%",1};


void r32put_character(se_dump_stack*caller,T32* C,T3 a1){
void**locals[1];
se_dump_stack ds;
ds.fd=&f32put_character;
ds.current=((void**)&C);
ds.p=67138056;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f32put_character.assertion_flag){
f32put_character.assertion_flag=0;
(ds.p=69230100);
ac_req(r32is_connected(&ds,C),NULL);
f32put_character.assertion_flag=1;
}
(ds.p=67138580);
putc(a1,((FILE*)((/*RF2*/(C)->_output_stream/*8*/))));
se_dst=caller;/*unlink*/
}
se_frame_descriptor f32put_character={"put_character of STD_FILE_WRITE",1,1,"%R32%c%E3%",1};


void r32put_string(se_dump_stack*caller,T32* C,T0* a1){
T2 _i=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f32put_string;
ds.current=((void**)&C);
ds.p=69231624;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&_i;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f32put_string.assertion_flag){
f32put_string.assertion_flag=0;
(ds.p=69232404);
ac_req(r32is_connected(&ds,C),NULL);
(ds.p=69232664);
ac_req((a1)!=((void*)(NULL)),NULL);
f32put_string.assertion_flag=1;
}
(ds.p=69233946);
_i=1;
while (!(((ds.p=69234462),(_i)>((/*RF2*/(se_i7(&ds,((T7*)ci(7,a1,69234466))))->_count/*8*/)))))
{
(ds.p=69234970);
r32put_character(&ds,C,r7item(&ds,se_i7(&ds,((T7*)ci(7,a1,69234998))),_i));
(ds.p=69235226);
_i=(_i)+(1);
}
se_dst=caller;/*unlink*/
}
se_frame_descriptor f32put_string={"put_string of OUTPUT_STREAM",1,2,"%R32%s%R7%i%E2%",1};


void r32fclose(se_dump_stack*caller,T8 a1){
void**locals[1];
se_dump_stack ds;
ds.fd=&f32fclose;
ds.current=NULL;
ds.p=67145992;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
se_dst=&ds;/*link*/
fclose(a1);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f32fclose={"fclose of STD_FILE_WRITE",0,1,"stream_pointer%E8%",1};


void r62disconnect(se_dump_stack*caller,T62* C){
se_dump_stack ds;
ds.fd=&f62disconnect;
ds.current=((void**)&C);
ds.p=130047240;
ds.caller=caller;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f62disconnect.assertion_flag){
f62disconnect.assertion_flag=0;
(ds.p=130047764);
ac_req(r62is_connected(&ds,C),NULL);
f62disconnect.assertion_flag=1;
}
(ds.p=130048276);
r62fclose(&ds,(/*RF2*/(C)->_input_stream/*12*/));
(ds.p=130048532);
(/*SFN*/C->_path)=NULL;
se_dst=caller;/*unlink*/
}
se_frame_descriptor f62disconnect={"disconnect of STD_FILE_READ",1,0,"%R62%",1};


T6 r62is_connected(se_dump_stack*caller,T62* C){
T6 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f62is_connected;
ds.current=((void**)&C);
ds.p=130040840;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=130041364);
R=((/*RF2*/(C)->_path/*8*/))!=((void*)(NULL));
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f62is_connected={"is_connected of STD_FILE_READ",1,1,"%R62%Result%E6%",1};


void r62read_character(se_dump_stack*caller,T62* C){
se_dump_stack ds;
ds.fd=&f62read_character;
ds.current=((void**)&C);
ds.p=130049288;
ds.caller=caller;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f62read_character.assertion_flag){
f62read_character.assertion_flag=0;
(ds.p=132145172);
ac_req(r6_ix_not(&ds,r62end_of_input(&ds,C)),NULL);
f62read_character.assertion_flag=1;
}
if(((ds.p=130049818),(/*RF2*/(C)->_push_back_flag/*4*/))){
(ds.p=130050074);
(/*SFN*/C->_push_back_flag)=0;
}
else{
(ds.p=130050586);
(/*SFN*/C->_memory)=getc((FILE*)((/*RF2*/(C)->_input_stream/*12*/)));
}
if(f62read_character.assertion_flag){
f62read_character.assertion_flag=0;
(ds.p=132145940);
ac_ens(r6_ix_not(&ds,(/*RF2*/(C)->_push_back_flag/*4*/)),NULL);
f62read_character.assertion_flag=1;
}
se_dst=caller;/*unlink*/
}
se_frame_descriptor f62read_character={"read_character of STD_FILE_READ",1,0,"%R62%",1};


void r62make(se_dump_stack*caller,T62* C){
se_dump_stack ds;
ds.fd=&f62make;
ds.current=((void**)&C);
ds.p=130042120;
ds.caller=caller;
se_dst=&ds;/*link*/
se_dst=caller;/*unlink*/
}
se_frame_descriptor f62make={"make of STD_FILE_READ",1,0,"%R62%",1};


void r62read_line_in(se_dump_stack*caller,T62* C,T0* a1){
void**locals[1];
se_dump_stack ds;
ds.fd=&f62read_line_in;
ds.current=((void**)&C);
ds.p=130055944;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f62read_line_in.assertion_flag){
f62read_line_in.assertion_flag=0;
(ds.p=132323604);
ac_req(r6_ix_not(&ds,r62end_of_input(&ds,C)),NULL);
(ds.p=132323860);
ac_req((a1)!=((void*)(NULL)),NULL);
f62read_line_in.assertion_flag=1;
}
(ds.p=130056482);
r7clear(&ds,se_i7(&ds,((T7*)ci(7,a1,130056468))));
(ds.p=130056986);
r62read_character(&ds,C);
while (!(((ds.p=130058272),((((/*RF2*/(C)->_memory/*16*/))==((EOF)))||(((/*RF2*/(C)->_memory/*16*/))==(T3code(((T3)'\n')))))||(((/*RF2*/(C)->_memory/*16*/))==(T3code(((T3)'\15')))))))
{
(ds.p=130059048);
r7extend(&ds,se_i7(&ds,((T7*)ci(7,a1,130059034))),((T3)((/*RF2*/(C)->_memory/*16*/))));
(ds.p=130059290);
r62read_character(&ds,C);
}
if(((ds.p=130059816),((/*RF2*/(C)->_memory/*16*/))==(T3code(((T3)'\15'))))){
(ds.p=130060058);
r62read_character(&ds,C);
if(((ds.p=130060334),((/*RF2*/(C)->_memory/*16*/))!=(T3code(((T3)'\n'))))){
(ds.p=130060576);
(/*SFN*/C->_push_back_flag)=1;
}
}
se_dst=caller;/*unlink*/
}
se_frame_descriptor f62read_line_in={"read_line_in of STD_FILE_READ",1,1,"%R62%buffer%R7%",1};


T6 r62end_of_input(se_dump_stack*caller,T62* C){
T6 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f62end_of_input;
ds.current=((void**)&C);
ds.p=130054152;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f62end_of_input.assertion_flag){
f62end_of_input.assertion_flag=0;
(ds.p=132142868);
ac_req(r62is_connected(&ds,C),NULL);
f62end_of_input.assertion_flag=1;
}
if(((ds.p=130054682),r6_ix_not(&ds,(/*RF2*/(C)->_push_back_flag/*4*/)))){
(ds.p=130054938);
R=((/*RF2*/(C)->_memory/*16*/))==((EOF));
}
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f62end_of_input={"end_of_input of STD_FILE_READ",1,1,"%R62%Result%E6%",1};


void r62connect_to(se_dump_stack*caller,T62* C,T0* a1){
T8 _p=NULL;
void**locals[2];
se_dump_stack ds;
ds.fd=&f62connect_to;
ds.current=((void**)&C);
ds.p=130043144;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&_p;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f62connect_to.assertion_flag){
f62connect_to.assertion_flag=0;
(ds.p=130043668);
ac_req(r6_ix_not(&ds,r62is_connected(&ds,C)),NULL);
(ds.p=130043924);
ac_req(r6_ix_not(&ds,r7is_empty(&ds,se_i7(&ds,((T7*)ci(7,a1,130043932))))),NULL);
f62connect_to.assertion_flag=1;
}
(ds.p=130044948);
_p=r7to_external(&ds,se_i7(&ds,((T7*)ci(7,a1,130044958))));
(ds.p=130045204);
(/*SFN*/C->_input_stream)=fopen((char*)_p,"ra");
if(((ds.p=130045492),(NULL!=(/*RF2*/(C)->_input_stream/*12*/)))){
(ds.p=130045722);
(/*SFN*/C->_push_back_flag)=0;
(ds.p=130045978);
(/*SFN*/C->_memory)=T3code(((T3)'\0'));
(ds.p=130046234);
(/*SFN*/C->_path)=a1;
}
se_dst=caller;/*unlink*/
}
se_frame_descriptor f62connect_to={"connect_to of STD_FILE_READ",1,2,"%R62%new_path%R7%p%E8%",1};


void r62fclose(se_dump_stack*caller,T8 a1){
void**locals[1];
se_dump_stack ds;
ds.fd=&f62fclose;
ds.current=NULL;
ds.p=130071304;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
se_dst=&ds;/*link*/
fclose(a1);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f62fclose={"fclose of STD_FILE_READ",0,1,"stream_pointer%E8%",1};


void r24skip_time(se_dump_stack*caller,T24* C,T0* a1){
void**locals[1];
se_dump_stack ds;
ds.fd=&f24skip_time;
ds.current=((void**)&C);
ds.p=39967496;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
se_dst=&ds;/*link*/
if(((ds.p=39968048),((/*RF2*/(se_i7(&ds,((T7*)ci(7,a1,39968026))))->_count/*8*/))<(32))){
(ds.p=39968302);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39968282)),((T0*)ms19_683379699a));
(ds.p=39968558);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39968538)),a1);
(ds.p=39968814);
r50put_new_line(&ds,((T50*)ci(50,oBC1std_error,39968794)));
(ds.p=39969050);
exit(1);
}
if(((ds.p=39969844),(r7item(&ds,se_i7(&ds,((T7*)ci(7,a1,39969818))),1))!=(((T3)'\42')))){
(ds.p=39970094);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39970074)),((T0*)ms19_1538229628));
(ds.p=39970350);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39970330)),a1);
(ds.p=39970606);
r50put_new_line(&ds,((T50*)ci(50,oBC1std_error,39970586)));
(ds.p=39970842);
exit(1);
}
if(((ds.p=39971638),(r7item(&ds,se_i7(&ds,((T7*)ci(7,a1,39971610))),32))!=(((T3)'\42')))){
(ds.p=39971886);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39971866)),((T0*)ms19_1061971043));
(ds.p=39972142);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39972122)),a1);
(ds.p=39972398);
r50put_new_line(&ds,((T50*)ci(50,oBC1std_error,39972378)));
(ds.p=39972634);
exit(1);
}
(ds.p=39973918);
r7remove_first(&ds,se_i7(&ds,((T7*)ci(7,a1,39973908))),32);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f24skip_time={"skip_time of GLOBALS",1,1,"%R24%line%R7%",1};


void r24make_from_csv(se_dump_stack*caller,T24* C,T0* a1){
T17 _dummy=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f24make_from_csv;
ds.current=((void**)&C);
ds.p=50351880;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&_dummy;
se_dst=&ds;/*link*/
(ds.p=50352916);
(/*SFN*/C->_reference)=r24scan_reference(&ds,C,a1);
(ds.p=50353428);
r24check_comma(&ds,C,a1);
(ds.p=50353940);
r24skip_time(&ds,C,a1);
(ds.p=50354452);
r24check_comma(&ds,C,a1);
(ds.p=50354964);
_dummy=r24scan_reference(&ds,C,a1);
(ds.p=50355476);
r24check_comma(&ds,C,a1);
(ds.p=50355988);
_dummy=r24scan_reference(&ds,C,a1);
(ds.p=50356500);
r24check_comma(&ds,C,a1);
if(((ds.p=50357040),(r7first(&ds,se_i7(&ds,((T7*)ci(7,a1,50357018)))))!=(((T3)'\42')))){
(ds.p=50357294);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,50357274)),((T0*)ms24_1416753280));
(ds.p=50357550);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,50357530)),a1);
(ds.p=50357806);
r50put_new_line(&ds,((T50*)ci(50,oBC1std_error,50357786)));
(ds.p=50358042);
exit(1);
}
if(((ds.p=50358830),(r7last(&ds,se_i7(&ds,((T7*)ci(7,a1,50358810)))))!=(((T3)'\42')))){
(ds.p=50359086);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,50359066)),((T0*)ms24_1807165412));
(ds.p=50359342);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,50359322)),a1);
(ds.p=50359598);
r50put_new_line(&ds,((T50*)ci(50,oBC1std_error,50359578)));
(ds.p=50359834);
exit(1);
}
(ds.p=50360606);
r7remove_first(&ds,se_i7(&ds,((T7*)ci(7,a1,50360596))),1);
(ds.p=50360862);
r7remove_last(&ds,se_i7(&ds,((T7*)ci(7,a1,50360852))),1);
(ds.p=50361364);
{T7*n=((T7*)se_malloc(sizeof(*n))/*20*/);
*n=M7;
r7copy(&ds,n,a1);
(/*SFN*/C->_spelling)=((T0*)n);
se_i7(&ds,n);}
se_dst=caller;/*unlink*/
}
se_frame_descriptor f24make_from_csv={"make_from_csv of SPELLING",1,2,"%R24%line%R7%dummy%E17%",1};


T17 r24scan_reference(se_dump_stack*caller,T24* C,T0* a1){
T17 R=0;
T2 _i=0;
void**locals[3];
se_dump_stack ds;
ds.fd=&f24scan_reference;
ds.current=((void**)&C);
ds.p=39951880;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
locals[2]=(void**)&_i;
se_dst=&ds;/*link*/
if(((ds.p=39952944),((/*RF2*/(se_i7(&ds,((T7*)ci(7,a1,39952922))))->_count/*8*/))<(10))){
(ds.p=39953198);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39953178)),((T0*)ms19_683379699));
(ds.p=39953454);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39953434)),a1);
(ds.p=39953710);
r50put_new_line(&ds,((T50*)ci(50,oBC1std_error,39953690)));
(ds.p=39953946);
exit(1);
}
if(((ds.p=39954714),r6_ix_not(&ds,r7has_prefix(&ds,se_i7(&ds,((T7*)ci(7,a1,39954722))),((T0*)ms19_360))))){
(ds.p=39954990);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39954970)),((T0*)ms19_1773176095));
(ds.p=39955246);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39955226)),a1);
(ds.p=39955502);
r50put_new_line(&ds,((T50*)ci(50,oBC1std_error,39955482)));
(ds.p=39955738);
exit(1);
}
{int c=0;int v=0;
(ds.p=39956762);
_i=3;
while (!(((ds.p=39957790),(_i)>(10))))
{
(ds.p=39957280);
v=ac_lvc(c++,v,(10)-(_i));
if(((ds.p=39958304),r6_ix_not(&ds,r3is_hexadecimal_digit(&ds,r7item(&ds,se_i7(&ds,((T7*)ci(7,a1,39958312))),_i))))){
(ds.p=39958580);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39958560)),((T0*)ms19_433290798));
(ds.p=39958836);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39958816)),a1);
(ds.p=39959092);
r50put_new_line(&ds,((T50*)ci(50,oBC1std_error,39959072)));
(ds.p=39959328);
exit(1);
}
(ds.p=39960090);
_i=(_i)+(1);
}
}
{int c=0;int v=0;
(ds.p=39961114);
_i=3;
while (!(((ds.p=39962142),(_i)>(10))))
{
(ds.p=39961632);
v=ac_lvc(c++,v,(10)-(_i));
(ds.p=39962650);
R=((R)*(16U))+(((T17)(r3hexadecimal_value(&ds,r7item(&ds,se_i7(&ds,((T7*)ci(7,a1,39962700))),_i)))));
(ds.p=39962906);
_i=(_i)+(1);
}
}
(ds.p=39963678);
r7remove_first(&ds,se_i7(&ds,((T7*)ci(7,a1,39963668))),10);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f24scan_reference={"scan_reference of GLOBALS",1,3,"%R24%line%R7%Result%E17%i%E2%",1};


void r24check_comma(se_dump_stack*caller,T24* C,T0* a1){
void**locals[1];
se_dump_stack ds;
ds.fd=&f24check_comma;
ds.current=((void**)&C);
ds.p=39964424;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
se_dst=&ds;/*link*/
if(((ds.p=39964976),(r7first(&ds,se_i7(&ds,((T7*)ci(7,a1,39964954)))))==(((T3)'\54')))){
(ds.p=39965220);
r7remove_first(&ds,se_i7(&ds,((T7*)ci(7,a1,39965210))),1);
}
else{
(ds.p=39965742);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39965722)),((T0*)ms19_495303630));
(ds.p=39965998);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39965978)),a1);
(ds.p=39966254);
r50put_new_line(&ds,((T50*)ci(50,oBC1std_error,39966234)));
(ds.p=39966490);
exit(1);
}
se_dst=caller;/*unlink*/
}
se_frame_descriptor f24check_comma={"check_comma of GLOBALS",1,1,"%R24%line%R7%",1};
T0*oBC19all_names=NULL;
int fBC19all_names=0;


T0* r22all_names(se_dump_stack*caller){
if(fBC19all_names==0){fBC19all_names=1;{
void**locals[1];
se_dump_stack ds;
ds.fd=&f22all_names;
ds.current=NULL;
ds.p=39868168;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&oBC19all_names;
se_dst=&ds;/*link*/
(ds.p=39868692);
{T64*n=((T64*)se_malloc(sizeof(*n))/*16*/);
*n=M64;
oBC19all_names=((T0*)n);
r64with_capacity(&ds,n,256);
se_i64(&ds,n);}
se_dst=caller;/*unlink*/
}}
return oBC19all_names;
}
se_frame_descriptor f22all_names={"all_names of GLOBALS",0,1,"Result%R64%",1};
T0*oBC19all_features=NULL;
int fBC19all_features=0;


T0* r22all_features(se_dump_stack*caller){
if(fBC19all_features==0){fBC19all_features=1;{
void**locals[1];
se_dump_stack ds;
ds.fd=&f22all_features;
ds.current=NULL;
ds.p=39866888;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&oBC19all_features;
se_dst=&ds;/*link*/
(ds.p=39867412);
{T43*n=((T43*)se_malloc(sizeof(*n))/*16*/);
*n=M43;
oBC19all_features=((T0*)n);
r43with_capacity(&ds,n,64);
se_i43(&ds,n);}
se_dst=caller;/*unlink*/
}}
return oBC19all_features;
}
se_frame_descriptor f22all_features={"all_features of GLOBALS",0,1,"Result%R43%",1};


T0* r22find_feature_from_reference(se_dump_stack*caller,T22* C,T17 a1){
T0* R=NULL;
T2 _i=0;
void**locals[3];
se_dump_stack ds;
ds.fd=&f22find_feature_from_reference;
ds.current=((void**)&C);
ds.p=39936520;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
locals[2]=(void**)&_i;
se_dst=&ds;/*link*/
{int c=0;int v=0;
(ds.p=39937818);
_i=0;
while (!(((ds.p=39938888),((_i)>((/*RF2*/(se_i43(&ds,((T43*)ci(43,r22all_features(&ds),39938850))))->_upper/*12*/)))||((R)!=((void*)(NULL))))))
{
(ds.p=39938368);
v=ac_lvc(c++,v,((/*RF2*/(se_i43(&ds,((T43*)ci(43,r22all_features(&ds),39938330))))->_upper/*12*/))-(_i));
if(((ds.p=39939422),((/*RF2*/(((T26*)ci(26,r43item(&ds,se_i43(&ds,((T43*)ci(43,r22all_features(&ds),39939360))),_i),39939386)))->_reference/*4*/))==(a1))){
(ds.p=39939616);
R=r43item(&ds,se_i43(&ds,((T43*)ci(43,r22all_features(&ds),39939636))),_i);
}
(ds.p=39940378);
_i=(_i)+(1);
}
}
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f22find_feature_from_reference={"find_feature_from_reference of GLOBALS",1,3,"%R22%ref%E17%Result%R26%i%E2%",1};


void r22skip_time(se_dump_stack*caller,T22* C,T0* a1){
void**locals[1];
se_dump_stack ds;
ds.fd=&f22skip_time;
ds.current=((void**)&C);
ds.p=39967496;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
se_dst=&ds;/*link*/
if(((ds.p=39968048),((/*RF2*/(se_i7(&ds,((T7*)ci(7,a1,39968026))))->_count/*8*/))<(32))){
(ds.p=39968302);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39968282)),((T0*)ms19_683379699a));
(ds.p=39968558);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39968538)),a1);
(ds.p=39968814);
r50put_new_line(&ds,((T50*)ci(50,oBC1std_error,39968794)));
(ds.p=39969050);
exit(1);
}
if(((ds.p=39969844),(r7item(&ds,se_i7(&ds,((T7*)ci(7,a1,39969818))),1))!=(((T3)'\42')))){
(ds.p=39970094);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39970074)),((T0*)ms19_1538229628));
(ds.p=39970350);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39970330)),a1);
(ds.p=39970606);
r50put_new_line(&ds,((T50*)ci(50,oBC1std_error,39970586)));
(ds.p=39970842);
exit(1);
}
if(((ds.p=39971638),(r7item(&ds,se_i7(&ds,((T7*)ci(7,a1,39971610))),32))!=(((T3)'\42')))){
(ds.p=39971886);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39971866)),((T0*)ms19_1061971043));
(ds.p=39972142);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39972122)),a1);
(ds.p=39972398);
r50put_new_line(&ds,((T50*)ci(50,oBC1std_error,39972378)));
(ds.p=39972634);
exit(1);
}
(ds.p=39973918);
r7remove_first(&ds,se_i7(&ds,((T7*)ci(7,a1,39973908))),32);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f22skip_time={"skip_time of GLOBALS",1,1,"%R22%line%R7%",1};


void r22make_from_csv(se_dump_stack*caller,T22* C,T0* a1){
T17 _dummy=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f22make_from_csv;
ds.current=((void**)&C);
ds.p=46165768;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&_dummy;
se_dst=&ds;/*link*/
(ds.p=46166804);
{T43*n=((T43*)se_malloc(sizeof(*n))/*16*/);
*n=M43;
r43with_capacity(&ds,n,4);
(/*SFN*/C->_features)=((T0*)n);
se_i43(&ds,n);}
(ds.p=46167316);
(/*SFN*/C->_reference)=r22scan_reference(&ds,C,a1);
(ds.p=46167828);
r22check_comma(&ds,C,a1);
(ds.p=46168340);
r22skip_time(&ds,C,a1);
(ds.p=46168852);
r22check_comma(&ds,C,a1);
(ds.p=46169364);
_dummy=r22scan_reference(&ds,C,a1);
(ds.p=46169876);
r22check_comma(&ds,C,a1);
(ds.p=46170388);
_dummy=r22scan_reference(&ds,C,a1);
(ds.p=46170900);
r22check_comma(&ds,C,a1);
(ds.p=46171412);
_dummy=r22scan_reference(&ds,C,a1);
(ds.p=46171924);
(/*SFN*/C->_name)=r22find_name_from_reference(&ds,C,_dummy);
while (!(((ds.p=46172964),r7is_empty(&ds,se_i7(&ds,((T7*)ci(7,a1,46172954)))))))
{
(ds.p=46173466);
r22check_comma(&ds,C,a1);
(ds.p=46173978);
_dummy=r22scan_reference(&ds,C,a1);
(ds.p=46174508);
r43add_last(&ds,se_i43(&ds,((T43*)ci(43,(/*RF2*/(C)->_features/*12*/),46174490))),r22find_feature_from_reference(&ds,C,_dummy));
}
se_dst=caller;/*unlink*/
}
se_frame_descriptor f22make_from_csv={"make_from_csv of CLASS_DEFINITION",1,2,"%R22%line%R7%dummy%E17%",1};


T17 r22scan_reference(se_dump_stack*caller,T22* C,T0* a1){
T17 R=0;
T2 _i=0;
void**locals[3];
se_dump_stack ds;
ds.fd=&f22scan_reference;
ds.current=((void**)&C);
ds.p=39951880;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
locals[2]=(void**)&_i;
se_dst=&ds;/*link*/
if(((ds.p=39952944),((/*RF2*/(se_i7(&ds,((T7*)ci(7,a1,39952922))))->_count/*8*/))<(10))){
(ds.p=39953198);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39953178)),((T0*)ms19_683379699));
(ds.p=39953454);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39953434)),a1);
(ds.p=39953710);
r50put_new_line(&ds,((T50*)ci(50,oBC1std_error,39953690)));
(ds.p=39953946);
exit(1);
}
if(((ds.p=39954714),r6_ix_not(&ds,r7has_prefix(&ds,se_i7(&ds,((T7*)ci(7,a1,39954722))),((T0*)ms19_360))))){
(ds.p=39954990);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39954970)),((T0*)ms19_1773176095));
(ds.p=39955246);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39955226)),a1);
(ds.p=39955502);
r50put_new_line(&ds,((T50*)ci(50,oBC1std_error,39955482)));
(ds.p=39955738);
exit(1);
}
{int c=0;int v=0;
(ds.p=39956762);
_i=3;
while (!(((ds.p=39957790),(_i)>(10))))
{
(ds.p=39957280);
v=ac_lvc(c++,v,(10)-(_i));
if(((ds.p=39958304),r6_ix_not(&ds,r3is_hexadecimal_digit(&ds,r7item(&ds,se_i7(&ds,((T7*)ci(7,a1,39958312))),_i))))){
(ds.p=39958580);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39958560)),((T0*)ms19_433290798));
(ds.p=39958836);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39958816)),a1);
(ds.p=39959092);
r50put_new_line(&ds,((T50*)ci(50,oBC1std_error,39959072)));
(ds.p=39959328);
exit(1);
}
(ds.p=39960090);
_i=(_i)+(1);
}
}
{int c=0;int v=0;
(ds.p=39961114);
_i=3;
while (!(((ds.p=39962142),(_i)>(10))))
{
(ds.p=39961632);
v=ac_lvc(c++,v,(10)-(_i));
(ds.p=39962650);
R=((R)*(16U))+(((T17)(r3hexadecimal_value(&ds,r7item(&ds,se_i7(&ds,((T7*)ci(7,a1,39962700))),_i)))));
(ds.p=39962906);
_i=(_i)+(1);
}
}
(ds.p=39963678);
r7remove_first(&ds,se_i7(&ds,((T7*)ci(7,a1,39963668))),10);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f22scan_reference={"scan_reference of GLOBALS",1,3,"%R22%line%R7%Result%E17%i%E2%",1};


void r22check_comma(se_dump_stack*caller,T22* C,T0* a1){
void**locals[1];
se_dump_stack ds;
ds.fd=&f22check_comma;
ds.current=((void**)&C);
ds.p=39964424;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
se_dst=&ds;/*link*/
if(((ds.p=39964976),(r7first(&ds,se_i7(&ds,((T7*)ci(7,a1,39964954)))))==(((T3)'\54')))){
(ds.p=39965220);
r7remove_first(&ds,se_i7(&ds,((T7*)ci(7,a1,39965210))),1);
}
else{
(ds.p=39965742);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39965722)),((T0*)ms19_495303630));
(ds.p=39965998);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39965978)),a1);
(ds.p=39966254);
r50put_new_line(&ds,((T50*)ci(50,oBC1std_error,39966234)));
(ds.p=39966490);
exit(1);
}
se_dst=caller;/*unlink*/
}
se_frame_descriptor f22check_comma={"check_comma of GLOBALS",1,1,"%R22%line%R7%",1};


T0* r22find_name_from_reference(se_dump_stack*caller,T22* C,T17 a1){
T0* R=NULL;
T2 _i=0;
void**locals[3];
se_dump_stack ds;
ds.fd=&f22find_name_from_reference;
ds.current=((void**)&C);
ds.p=39923208;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
locals[2]=(void**)&_i;
se_dst=&ds;/*link*/
{int c=0;int v=0;
(ds.p=39924506);
_i=0;
while (!(((ds.p=39925570),((_i)>((/*RF2*/(se_i64(&ds,((T64*)ci(64,r22all_names(&ds),39925538))))->_upper/*12*/)))||((R)!=((void*)(NULL))))))
{
(ds.p=39925050);
v=ac_lvc(c++,v,((/*RF2*/(se_i64(&ds,((T64*)ci(64,r22all_names(&ds),39925018))))->_upper/*12*/))-(_i));
if(((ds.p=39926104),((/*RF2*/(((T25*)ci(25,r64item(&ds,se_i64(&ds,((T64*)ci(64,r22all_names(&ds),39926048))),_i),39926068)))->_reference/*4*/))==(a1))){
(ds.p=39926304);
R=r64item(&ds,se_i64(&ds,((T64*)ci(64,r22all_names(&ds),39926324))),_i);
}
(ds.p=39927066);
_i=(_i)+(1);
}
}
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f22find_name_from_reference={"find_name_from_reference of GLOBALS",1,3,"%R22%ref%E17%Result%R25%i%E2%",1};


T0* r26all_names(se_dump_stack*caller){
if(fBC19all_names==0){fBC19all_names=1;{
void**locals[1];
se_dump_stack ds;
ds.fd=&f26all_names;
ds.current=NULL;
ds.p=39868168;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&oBC19all_names;
se_dst=&ds;/*link*/
(ds.p=39868692);
{T64*n=((T64*)se_malloc(sizeof(*n))/*16*/);
*n=M64;
oBC19all_names=((T0*)n);
r64with_capacity(&ds,n,256);
se_i64(&ds,n);}
se_dst=caller;/*unlink*/
}}
return oBC19all_names;
}
se_frame_descriptor f26all_names={"all_names of GLOBALS",0,1,"Result%R64%",1};


void r26skip_time(se_dump_stack*caller,T26* C,T0* a1){
void**locals[1];
se_dump_stack ds;
ds.fd=&f26skip_time;
ds.current=((void**)&C);
ds.p=39967496;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
se_dst=&ds;/*link*/
if(((ds.p=39968048),((/*RF2*/(se_i7(&ds,((T7*)ci(7,a1,39968026))))->_count/*8*/))<(32))){
(ds.p=39968302);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39968282)),((T0*)ms19_683379699a));
(ds.p=39968558);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39968538)),a1);
(ds.p=39968814);
r50put_new_line(&ds,((T50*)ci(50,oBC1std_error,39968794)));
(ds.p=39969050);
exit(1);
}
if(((ds.p=39969844),(r7item(&ds,se_i7(&ds,((T7*)ci(7,a1,39969818))),1))!=(((T3)'\42')))){
(ds.p=39970094);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39970074)),((T0*)ms19_1538229628));
(ds.p=39970350);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39970330)),a1);
(ds.p=39970606);
r50put_new_line(&ds,((T50*)ci(50,oBC1std_error,39970586)));
(ds.p=39970842);
exit(1);
}
if(((ds.p=39971638),(r7item(&ds,se_i7(&ds,((T7*)ci(7,a1,39971610))),32))!=(((T3)'\42')))){
(ds.p=39971886);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39971866)),((T0*)ms19_1061971043));
(ds.p=39972142);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39972122)),a1);
(ds.p=39972398);
r50put_new_line(&ds,((T50*)ci(50,oBC1std_error,39972378)));
(ds.p=39972634);
exit(1);
}
(ds.p=39973918);
r7remove_first(&ds,se_i7(&ds,((T7*)ci(7,a1,39973908))),32);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f26skip_time={"skip_time of GLOBALS",1,1,"%R26%line%R7%",1};


void r26make_from_csv(se_dump_stack*caller,T26* C,T0* a1){
T17 _dummy=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f26make_from_csv;
ds.current=((void**)&C);
ds.p=54553608;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&_dummy;
se_dst=&ds;/*link*/
(ds.p=54554644);
(/*SFN*/C->_reference)=r26scan_reference(&ds,C,a1);
(ds.p=54555156);
r26check_comma(&ds,C,a1);
(ds.p=54555668);
r26skip_time(&ds,C,a1);
(ds.p=54556180);
r26check_comma(&ds,C,a1);
(ds.p=54556692);
_dummy=r26scan_reference(&ds,C,a1);
(ds.p=54557204);
r26check_comma(&ds,C,a1);
(ds.p=54557716);
_dummy=r26scan_reference(&ds,C,a1);
(ds.p=54558228);
r26check_comma(&ds,C,a1);
(ds.p=54558740);
(/*SFN*/C->_type)=r26scan_reference(&ds,C,a1);
(ds.p=54559252);
r26check_comma(&ds,C,a1);
(ds.p=54559764);
_dummy=r26scan_reference(&ds,C,a1);
(ds.p=54560276);
(/*SFN*/C->_name)=r26find_name_from_reference(&ds,C,_dummy);
(ds.p=54560788);
r26check_comma(&ds,C,a1);
if(((ds.p=54561328),((/*RF2*/(se_i7(&ds,((T7*)ci(7,a1,54561306))))->_count/*8*/))>(2))){
(ds.p=54561582);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,54561562)),((T0*)ms26_1859534213));
(ds.p=54561838);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,54561818)),a1);
(ds.p=54562094);
r50put_new_line(&ds,((T50*)ci(50,oBC1std_error,54562074)));
(ds.p=54562330);
exit(1);
}
if(((ds.p=54563098),r6_ix_not(&ds,r3is_digit(&ds,r7item(&ds,se_i7(&ds,((T7*)ci(7,a1,54563106))),1))))){
(ds.p=54563374);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,54563354)),((T0*)ms26_164777188a));
(ds.p=54563630);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,54563610)),a1);
(ds.p=54563886);
r50put_new_line(&ds,((T50*)ci(50,oBC1std_error,54563866)));
(ds.p=54564122);
exit(1);
}
if(((ds.p=54564920),(((/*RF2*/(se_i7(&ds,((T7*)ci(7,a1,54564890))))->_count/*8*/))==(2))&&(r6_ix_not(&ds,r3is_digit(&ds,r7item(&ds,se_i7(&ds,((T7*)ci(7,a1,54564946))),2)))))){
(ds.p=54565166);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,54565146)),((T0*)ms26_164777188));
(ds.p=54565422);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,54565402)),a1);
(ds.p=54565678);
r50put_new_line(&ds,((T50*)ci(50,oBC1std_error,54565658)));
(ds.p=54565914);
exit(1);
}
(ds.p=54566676);
(/*SFN*/C->_number)=r3decimal_value(&ds,r7item(&ds,se_i7(&ds,((T7*)ci(7,a1,54566696))),1));
if(((ds.p=54567216),((/*RF2*/(se_i7(&ds,((T7*)ci(7,a1,54567194))))->_count/*8*/))==(2))){
(ds.p=54567448);
(/*SFN*/C->_number)=(((/*RF2*/(C)->_number/*16*/))*(10))+(r3decimal_value(&ds,r7item(&ds,se_i7(&ds,((T7*)ci(7,a1,54567496))),2)));
}
se_dst=caller;/*unlink*/
}
se_frame_descriptor f26make_from_csv={"make_from_csv of FEATURE_DEFINITION",1,2,"%R26%line%R7%dummy%E17%",1};


T17 r26scan_reference(se_dump_stack*caller,T26* C,T0* a1){
T17 R=0;
T2 _i=0;
void**locals[3];
se_dump_stack ds;
ds.fd=&f26scan_reference;
ds.current=((void**)&C);
ds.p=39951880;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
locals[2]=(void**)&_i;
se_dst=&ds;/*link*/
if(((ds.p=39952944),((/*RF2*/(se_i7(&ds,((T7*)ci(7,a1,39952922))))->_count/*8*/))<(10))){
(ds.p=39953198);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39953178)),((T0*)ms19_683379699));
(ds.p=39953454);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39953434)),a1);
(ds.p=39953710);
r50put_new_line(&ds,((T50*)ci(50,oBC1std_error,39953690)));
(ds.p=39953946);
exit(1);
}
if(((ds.p=39954714),r6_ix_not(&ds,r7has_prefix(&ds,se_i7(&ds,((T7*)ci(7,a1,39954722))),((T0*)ms19_360))))){
(ds.p=39954990);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39954970)),((T0*)ms19_1773176095));
(ds.p=39955246);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39955226)),a1);
(ds.p=39955502);
r50put_new_line(&ds,((T50*)ci(50,oBC1std_error,39955482)));
(ds.p=39955738);
exit(1);
}
{int c=0;int v=0;
(ds.p=39956762);
_i=3;
while (!(((ds.p=39957790),(_i)>(10))))
{
(ds.p=39957280);
v=ac_lvc(c++,v,(10)-(_i));
if(((ds.p=39958304),r6_ix_not(&ds,r3is_hexadecimal_digit(&ds,r7item(&ds,se_i7(&ds,((T7*)ci(7,a1,39958312))),_i))))){
(ds.p=39958580);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39958560)),((T0*)ms19_433290798));
(ds.p=39958836);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39958816)),a1);
(ds.p=39959092);
r50put_new_line(&ds,((T50*)ci(50,oBC1std_error,39959072)));
(ds.p=39959328);
exit(1);
}
(ds.p=39960090);
_i=(_i)+(1);
}
}
{int c=0;int v=0;
(ds.p=39961114);
_i=3;
while (!(((ds.p=39962142),(_i)>(10))))
{
(ds.p=39961632);
v=ac_lvc(c++,v,(10)-(_i));
(ds.p=39962650);
R=((R)*(16U))+(((T17)(r3hexadecimal_value(&ds,r7item(&ds,se_i7(&ds,((T7*)ci(7,a1,39962700))),_i)))));
(ds.p=39962906);
_i=(_i)+(1);
}
}
(ds.p=39963678);
r7remove_first(&ds,se_i7(&ds,((T7*)ci(7,a1,39963668))),10);
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f26scan_reference={"scan_reference of GLOBALS",1,3,"%R26%line%R7%Result%E17%i%E2%",1};


void r26check_comma(se_dump_stack*caller,T26* C,T0* a1){
void**locals[1];
se_dump_stack ds;
ds.fd=&f26check_comma;
ds.current=((void**)&C);
ds.p=39964424;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
se_dst=&ds;/*link*/
if(((ds.p=39964976),(r7first(&ds,se_i7(&ds,((T7*)ci(7,a1,39964954)))))==(((T3)'\54')))){
(ds.p=39965220);
r7remove_first(&ds,se_i7(&ds,((T7*)ci(7,a1,39965210))),1);
}
else{
(ds.p=39965742);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39965722)),((T0*)ms19_495303630));
(ds.p=39965998);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,39965978)),a1);
(ds.p=39966254);
r50put_new_line(&ds,((T50*)ci(50,oBC1std_error,39966234)));
(ds.p=39966490);
exit(1);
}
se_dst=caller;/*unlink*/
}
se_frame_descriptor f26check_comma={"check_comma of GLOBALS",1,1,"%R26%line%R7%",1};


T0* r26find_name_from_reference(se_dump_stack*caller,T26* C,T17 a1){
T0* R=NULL;
T2 _i=0;
void**locals[3];
se_dump_stack ds;
ds.fd=&f26find_name_from_reference;
ds.current=((void**)&C);
ds.p=39923208;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
locals[2]=(void**)&_i;
se_dst=&ds;/*link*/
{int c=0;int v=0;
(ds.p=39924506);
_i=0;
while (!(((ds.p=39925570),((_i)>((/*RF2*/(se_i64(&ds,((T64*)ci(64,r26all_names(&ds),39925538))))->_upper/*12*/)))||((R)!=((void*)(NULL))))))
{
(ds.p=39925050);
v=ac_lvc(c++,v,((/*RF2*/(se_i64(&ds,((T64*)ci(64,r26all_names(&ds),39925018))))->_upper/*12*/))-(_i));
if(((ds.p=39926104),((/*RF2*/(((T25*)ci(25,r64item(&ds,se_i64(&ds,((T64*)ci(64,r26all_names(&ds),39926048))),_i),39926068)))->_reference/*4*/))==(a1))){
(ds.p=39926304);
R=r64item(&ds,se_i64(&ds,((T64*)ci(64,r26all_names(&ds),39926324))),_i);
}
(ds.p=39927066);
_i=(_i)+(1);
}
}
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f26find_name_from_reference={"find_name_from_reference of GLOBALS",1,3,"%R26%ref%E17%Result%R25%i%E2%",1};


void r51put_new_line(se_dump_stack*caller,T51* C){
se_dump_stack ds;
ds.fd=&f51put_new_line;
ds.current=((void**)&C);
ds.p=69283080;
ds.caller=caller;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
(ds.p=69284372);
r51put_character(&ds,C,((T3)'\n'));
se_dst=caller;/*unlink*/
}
se_frame_descriptor f51put_new_line={"put_new_line of OUTPUT_STREAM",1,0,"%R51%",1};


void r51make(se_dump_stack*caller,T51* C){
se_dump_stack ds;
ds.fd=&f51make;
ds.current=((void**)&C);
ds.p=106970888;
ds.caller=caller;
se_dst=&ds;/*link*/
se_dst=caller;/*unlink*/
}
se_frame_descriptor f51make={"make of STD_OUTPUT",1,0,"%R51%",1};


void r51put_integer(se_dump_stack*caller,T51* C,T2 a1){
void**locals[1];
se_dump_stack ds;
ds.fd=&f51put_integer;
ds.current=((void**)&C);
ds.p=69238280;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
(ds.p=69239576);
r2store(&ds,a1,(T0*)C);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f51put_integer={"put_integer of OUTPUT_STREAM",1,1,"%R51%i%E2%",1};


void r51put_unsigned_in_hexadecimal(se_dump_stack*caller,T51* C,T17 a1){
T0* _tmp_string=NULL;
void**locals[2];
se_dump_stack ds;
ds.fd=&f51put_unsigned_in_hexadecimal;
ds.current=((void**)&C);
ds.p=69250824;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&_tmp_string;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
(ds.p=69252628);
_tmp_string=r52item(&ds,se_i52(&ds,((T52*)ci(52,r51string_pool(&ds),69252656))),64);
(ds.p=69252888);
r17append_in_hexadecimal(&ds,a1,_tmp_string);
(ds.p=69253140);
r51put_string(&ds,C,_tmp_string);
(ds.p=69253420);
r52put(&ds,se_i52(&ds,((T52*)ci(52,r51string_pool(&ds),69253396))),_tmp_string);
se_dst=caller;/*unlink*/
}
se_frame_descriptor f51put_unsigned_in_hexadecimal={"put_unsigned_in_hexadecimal of OUTPUT_STREAM",1,2,"%R51%u%E17%tmp_string%R7%",1};
T0*oBC1string_pool=NULL;
int fBC1string_pool=0;


T0* r51string_pool(se_dump_stack*caller){
if(fBC1string_pool==0){fBC1string_pool=1;{
void**locals[1];
se_dump_stack ds;
ds.fd=&f51string_pool;
ds.current=NULL;
ds.p=2264598;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&oBC1string_pool;
se_dst=&ds;/*link*/
(ds.p=2265108);
{T52*n=((T52*)se_malloc(sizeof(*n))/*20*/);
*n=M52;
oBC1string_pool=((T0*)n);
r52make(&ds,n);
se_i52(&ds,n);}
se_dst=caller;/*unlink*/
}}
return oBC1string_pool;
}
se_frame_descriptor f51string_pool={"string_pool of GENERAL",0,1,"Result%R52%",1};


void r51put_character(se_dump_stack*caller,T51* C,T3 a1){
void**locals[1];
se_dump_stack ds;
ds.fd=&f51put_character;
ds.current=((void**)&C);
ds.p=106972424;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
(ds.p=106972948);
putc(a1,((FILE*)(stdout)));
se_dst=caller;/*unlink*/
}
se_frame_descriptor f51put_character={"put_character of STD_OUTPUT",1,1,"%R51%c%E3%",1};


void r51put_string(se_dump_stack*caller,T51* C,T0* a1){
T2 _i=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f51put_string;
ds.current=((void**)&C);
ds.p=69231624;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&_i;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f51put_string.assertion_flag){
f51put_string.assertion_flag=0;
(ds.p=69232664);
ac_req((a1)!=((void*)(NULL)),NULL);
f51put_string.assertion_flag=1;
}
(ds.p=69233946);
_i=1;
while (!(((ds.p=69234462),(_i)>((/*RF2*/(se_i7(&ds,((T7*)ci(7,a1,69234466))))->_count/*8*/)))))
{
(ds.p=69234970);
r51put_character(&ds,C,r7item(&ds,se_i7(&ds,((T7*)ci(7,a1,69234998))),_i));
(ds.p=69235226);
_i=(_i)+(1);
}
se_dst=caller;/*unlink*/
}
se_frame_descriptor f51put_string={"put_string of OUTPUT_STREAM",1,2,"%R51%s%R7%i%E2%",1};


void r50put_new_line(se_dump_stack*caller,T50* C){
se_dump_stack ds;
ds.fd=&f50put_new_line;
ds.current=((void**)&C);
ds.p=69283080;
ds.caller=caller;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
(ds.p=69284372);
r50put_character(&ds,C,((T3)'\n'));
se_dst=caller;/*unlink*/
}
se_frame_descriptor f50put_new_line={"put_new_line of OUTPUT_STREAM",1,0,"%R50%",1};


void r50make(se_dump_stack*caller,T50* C){
se_dump_stack ds;
ds.fd=&f50make;
ds.current=((void**)&C);
ds.p=104873224;
ds.caller=caller;
se_dst=&ds;/*link*/
se_dst=caller;/*unlink*/
}
se_frame_descriptor f50make={"make of STD_ERROR",1,0,"%R50%",1};


void r50put_character(se_dump_stack*caller,T50* C,T3 a1){
void**locals[1];
se_dump_stack ds;
ds.fd=&f50put_character;
ds.current=((void**)&C);
ds.p=104874760;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
(ds.p=104875284);
putc(a1,((FILE*)(stderr)));
se_dst=caller;/*unlink*/
}
se_frame_descriptor f50put_character={"put_character of STD_ERROR",1,1,"%R50%c%E3%",1};


void r50put_string(se_dump_stack*caller,T50* C,T0* a1){
T2 _i=0;
void**locals[2];
se_dump_stack ds;
ds.fd=&f50put_string;
ds.current=((void**)&C);
ds.p=69231624;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&_i;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f50put_string.assertion_flag){
f50put_string.assertion_flag=0;
(ds.p=69232664);
ac_req((a1)!=((void*)(NULL)),NULL);
f50put_string.assertion_flag=1;
}
(ds.p=69233946);
_i=1;
while (!(((ds.p=69234462),(_i)>((/*RF2*/(se_i7(&ds,((T7*)ci(7,a1,69234466))))->_count/*8*/)))))
{
(ds.p=69234970);
r50put_character(&ds,C,r7item(&ds,se_i7(&ds,((T7*)ci(7,a1,69234998))),_i));
(ds.p=69235226);
_i=(_i)+(1);
}
se_dst=caller;/*unlink*/
}
se_frame_descriptor f50put_string={"put_string of OUTPUT_STREAM",1,2,"%R50%s%R7%i%E2%",1};
T0*oBC19all_classes=NULL;
int fBC19all_classes=0;


T0* r18all_classes(se_dump_stack*caller){
if(fBC19all_classes==0){fBC19all_classes=1;{
void**locals[1];
se_dump_stack ds;
ds.fd=&f18all_classes;
ds.current=NULL;
ds.p=39865608;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&oBC19all_classes;
se_dst=&ds;/*link*/
(ds.p=39866132);
{T40*n=((T40*)se_malloc(sizeof(*n))/*16*/);
*n=M40;
oBC19all_classes=((T0*)n);
r40with_capacity(&ds,n,64);
se_i40(&ds,n);}
se_dst=caller;/*unlink*/
}}
return oBC19all_classes;
}
se_frame_descriptor f18all_classes={"all_classes of GLOBALS",0,1,"Result%R40%",1};


T0* r18all_names(se_dump_stack*caller){
if(fBC19all_names==0){fBC19all_names=1;{
void**locals[1];
se_dump_stack ds;
ds.fd=&f18all_names;
ds.current=NULL;
ds.p=39868168;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&oBC19all_names;
se_dst=&ds;/*link*/
(ds.p=39868692);
{T64*n=((T64*)se_malloc(sizeof(*n))/*16*/);
*n=M64;
oBC19all_names=((T0*)n);
r64with_capacity(&ds,n,256);
se_i64(&ds,n);}
se_dst=caller;/*unlink*/
}}
return oBC19all_names;
}
se_frame_descriptor f18all_names={"all_names of GLOBALS",0,1,"Result%R64%",1};
T0*oBC1command_arguments=NULL;
int fBC1command_arguments=0;


T0* r18command_arguments(se_dump_stack*caller){
if(fBC1command_arguments==0){fBC1command_arguments=1;{
T0* _arg=NULL;
T2 _i=0;
void**locals[3];
se_dump_stack ds;
ds.fd=&f18command_arguments;
ds.current=NULL;
ds.p=2232342;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&oBC1command_arguments;
locals[1]=(void**)&_arg;
locals[2]=(void**)&_i;
se_dst=&ds;/*link*/
(ds.p=2234394);
_i=se_argc;
(ds.p=2234650);
{T67*n=((T67*)se_malloc(sizeof(*n))/*16*/);
*n=M67;
oBC1command_arguments=((T0*)n);
r67make(&ds,n,_i);
se_i67(&ds,n);}
while (!(((ds.p=2235166),(_i)==(0))))
{
(ds.p=2235674);
_i=(_i)-(1);
(ds.p=2235930);
_arg=((T0*)se_string(se_argv[_i]));
(ds.p=2236200);
r67put(&ds,se_i67(&ds,((T67*)ci(67,oBC1command_arguments,2236186))),_arg,_i);
}
if(f18command_arguments.assertion_flag){
f18command_arguments.assertion_flag=0;
(ds.p=2236948);
ac_ens(r6_ix_not(&ds,r67is_empty(&ds,se_i67(&ds,((T67*)ci(67,oBC1command_arguments,2236956))))),NULL);
f18command_arguments.assertion_flag=1;
}
se_dst=caller;/*unlink*/
}}
return oBC1command_arguments;
}
se_frame_descriptor f18command_arguments={"command_arguments of GENERAL",0,3,"Result%R67%arg%R7%i%E2%",1};


T2 r18argument_count(se_dump_stack*caller,T18* C){
T2 R=0;
void**locals[1];
se_dump_stack ds;
ds.fd=&f18argument_count;
ds.current=((void**)&C);
ds.p=2226952;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&R;
se_dst=&ds;/*link*/
(ds.p=2227988);
R=(/*RF2*/(se_i67(&ds,((T67*)ci(67,r18command_arguments(&ds),2228008))))->_upper/*12*/);
if(f18argument_count.assertion_flag){
f18argument_count.assertion_flag=0;
(ds.p=2228514);
ac_ens((R)>=(0),NULL);
f18argument_count.assertion_flag=1;
}
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f18argument_count={"argument_count of GENERAL",1,1,"%R18%Result%E2%",1};


T0* r18all_features(se_dump_stack*caller){
if(fBC19all_features==0){fBC19all_features=1;{
void**locals[1];
se_dump_stack ds;
ds.fd=&f18all_features;
ds.current=NULL;
ds.p=39866888;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&oBC19all_features;
se_dst=&ds;/*link*/
(ds.p=39867412);
{T43*n=((T43*)se_malloc(sizeof(*n))/*16*/);
*n=M43;
oBC19all_features=((T0*)n);
r43with_capacity(&ds,n,64);
se_i43(&ds,n);}
se_dst=caller;/*unlink*/
}}
return oBC19all_features;
}
se_frame_descriptor f18all_features={"all_features of GLOBALS",0,1,"Result%R43%",1};


void r18make(se_dump_stack*caller,T18* C){
T6 _verbose=0;
T0* _type=NULL;
T0* _spelling=NULL;
T0* _name=NULL;
T0* _feature_def=NULL;
T0* _class_def=NULL;
T2 _j=0;
T2 _i=0;
T0* _line=NULL;
void**locals[9];
se_dump_stack ds;
ds.fd=&f18make;
ds.current=((void**)&C);
ds.p=37761544;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&_verbose;
locals[1]=(void**)&_type;
locals[2]=(void**)&_spelling;
locals[3]=(void**)&_name;
locals[4]=(void**)&_feature_def;
locals[5]=(void**)&_class_def;
locals[6]=(void**)&_j;
locals[7]=(void**)&_i;
locals[8]=(void**)&_line;
se_dst=&ds;/*link*/
(ds.p=37764372);
{T7*n=((T7*)se_malloc(sizeof(*n))/*20*/);
*n=M7;
r7make(&ds,n,256);
_line=((T0*)n);
se_i7(&ds,n);}
if(((ds.p=37764920),(r18argument_count(&ds,C))>(0))){
if(((ds.p=37765190),((r18argument_count(&ds,C))>(1))||(r6_ix_not(&ds,r6_px_or(&ds,r7is_equal(&ds,se_i7(&ds,((T7*)ci(7,r18argument(&ds,C,1),37765216))),((T0*)ms18_23340076)),r7is_equal(&ds,se_i7(&ds,((T7*)ci(7,r18argument(&ds,C,1),37765290))),((T0*)ms18_343))))))){
(ds.p=37765428);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,37765408)),((T0*)ms18_585664352));
(ds.p=37765664);
exit(1);
}
(ds.p=37766170);
_verbose=1;
}
(ds.p=37767462);
r62connect_to(&ds,((T62*)ci(62,r18csv_file(&ds),37767444)),((T0*)ms18_1631001923));
if(((ds.p=37767962),r6_ix_not(&ds,r62is_connected(&ds,((T62*)ci(62,r18csv_file(&ds),37767970)))))){
(ds.p=37768238);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,37768218)),((T0*)ms18_951510288));
(ds.p=37768474);
exit(1);
}
(ds.p=37769516);
r62read_line_in(&ds,((T62*)ci(62,r18csv_file(&ds),37769498)),_line);
while (!(((ds.p=37770028),r62end_of_input(&ds,((T62*)ci(62,r18csv_file(&ds),37770010))))))
{
(ds.p=37770522);
{T24*n=((T24*)se_malloc(sizeof(*n))/*12*/);
*n=M24;
r24make_from_csv(&ds,n,_line);
_spelling=((T0*)n);
}
(ds.p=37771062);
r44add_last(&ds,se_i44(&ds,((T44*)ci(44,r18all_spellings(&ds),37771034))),_spelling);
(ds.p=37771564);
r62read_line_in(&ds,((T62*)ci(62,r18csv_file(&ds),37771546)),_line);
}
(ds.p=37772326);
r62disconnect(&ds,((T62*)ci(62,r18csv_file(&ds),37772308)));
(ds.p=37773082);
_i=0;
while (!(((ds.p=37773598),(_i)>((/*RF2*/(se_i44(&ds,((T44*)ci(44,r18all_spellings(&ds),37773602))))->_upper/*12*/)))))
{
(ds.p=37774106);
_spelling=r44item(&ds,se_i44(&ds,((T44*)ci(44,r18all_spellings(&ds),37774130))),_i);
if(_verbose){
(ds.p=37774902);
r51put_string(&ds,((T51*)ci(51,oBC1std_output,37774880)),((T0*)ms18_1101464864));
(ds.p=37775158);
r51put_unsigned_in_hexadecimal(&ds,((T51*)ci(51,oBC1std_output,37775136)),(/*RF2*/(((T24*)ci(24,_spelling,37775214)))->_reference/*4*/));
(ds.p=37775414);
r51put_string(&ds,((T51*)ci(51,oBC1std_output,37775392)),((T0*)ms18_32aaaa));
(ds.p=37775670);
r51put_string(&ds,((T51*)ci(51,oBC1std_output,37775648)),(/*RF2*/(((T24*)ci(24,_spelling,37775692)))->_spelling/*8*/));
(ds.p=37775926);
r51put_new_line(&ds,((T51*)ci(51,oBC1std_output,37775904)));
}
(ds.p=37776666);
_i=(_i)+(1);
}
(ds.p=37778214);
r62connect_to(&ds,((T62*)ci(62,r18csv_file(&ds),37778196)),((T0*)ms18_10522043));
if(((ds.p=37778714),r6_ix_not(&ds,r62is_connected(&ds,((T62*)ci(62,r18csv_file(&ds),37778722)))))){
(ds.p=37778990);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,37778970)),((T0*)ms18_2083738964));
(ds.p=37779226);
exit(1);
}
(ds.p=37780268);
r62read_line_in(&ds,((T62*)ci(62,r18csv_file(&ds),37780250)),_line);
while (!(((ds.p=37780780),r62end_of_input(&ds,((T62*)ci(62,r18csv_file(&ds),37780762))))))
{
(ds.p=37781274);
{T25*n=((T25*)se_malloc(sizeof(*n))/*16*/);
*n=M25;
r25make_from_csv(&ds,n,_line);
_name=((T0*)n);
}
(ds.p=37781806);
r64add_last(&ds,se_i64(&ds,((T64*)ci(64,r18all_names(&ds),37781786))),_name);
(ds.p=37782316);
r62read_line_in(&ds,((T62*)ci(62,r18csv_file(&ds),37782298)),_line);
}
(ds.p=37783078);
r62disconnect(&ds,((T62*)ci(62,r18csv_file(&ds),37783060)));
(ds.p=37783834);
_i=0;
while (!(((ds.p=37784350),(_i)>((/*RF2*/(se_i64(&ds,((T64*)ci(64,r18all_names(&ds),37784354))))->_upper/*12*/)))))
{
(ds.p=37784858);
_name=r64item(&ds,se_i64(&ds,((T64*)ci(64,r18all_names(&ds),37784874))),_i);
if(_verbose){
(ds.p=37785654);
r51put_string(&ds,((T51*)ci(51,oBC1std_output,37785632)),((T0*)ms18_8021535));
(ds.p=37785910);
r51put_unsigned_in_hexadecimal(&ds,((T51*)ci(51,oBC1std_output,37785888)),(/*RF2*/(((T25*)ci(25,_name,37785966)))->_reference/*4*/));
(ds.p=37786166);
r51put_string(&ds,((T51*)ci(51,oBC1std_output,37786144)),((T0*)ms18_32aaa));
(ds.p=37786422);
r51put_string(&ds,((T51*)ci(51,oBC1std_output,37786400)),r25name(&ds,((T25*)ci(25,_name,37786444))));
(ds.p=37786678);
r51put_new_line(&ds,((T51*)ci(51,oBC1std_output,37786656)));
}
(ds.p=37787418);
_i=(_i)+(1);
}
(ds.p=37788966);
r62connect_to(&ds,((T62*)ci(62,r18csv_file(&ds),37788948)),((T0*)ms18_1436505586));
if(((ds.p=37789466),r6_ix_not(&ds,r62is_connected(&ds,((T62*)ci(62,r18csv_file(&ds),37789474)))))){
(ds.p=37789742);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,37789722)),((T0*)ms18_1420068785));
(ds.p=37789978);
exit(1);
}
(ds.p=37791020);
r62read_line_in(&ds,((T62*)ci(62,r18csv_file(&ds),37791002)),_line);
while (!(((ds.p=37791532),r62end_of_input(&ds,((T62*)ci(62,r18csv_file(&ds),37791514))))))
{
(ds.p=37792026);
{T26*n=((T26*)se_malloc(sizeof(*n))/*20*/);
*n=M26;
r26make_from_csv(&ds,n,_line);
_feature_def=((T0*)n);
}
(ds.p=37792564);
r43add_last(&ds,se_i43(&ds,((T43*)ci(43,r18all_features(&ds),37792538))),_feature_def);
(ds.p=37793068);
r62read_line_in(&ds,((T62*)ci(62,r18csv_file(&ds),37793050)),_line);
}
(ds.p=37793830);
r62disconnect(&ds,((T62*)ci(62,r18csv_file(&ds),37793812)));
(ds.p=37794586);
_i=0;
while (!(((ds.p=37795102),(_i)>((/*RF2*/(se_i43(&ds,((T43*)ci(43,r18all_features(&ds),37795106))))->_upper/*12*/)))))
{
(ds.p=37795610);
_feature_def=r43item(&ds,se_i43(&ds,((T43*)ci(43,r18all_features(&ds),37795640))),_i);
if(_verbose){
(ds.p=37796406);
r51put_string(&ds,((T51*)ci(51,oBC1std_output,37796384)),((T0*)ms18_930068410));
(ds.p=37796662);
r51put_unsigned_in_hexadecimal(&ds,((T51*)ci(51,oBC1std_output,37796640)),(/*RF2*/(((T26*)ci(26,_feature_def,37796718)))->_reference/*4*/));
(ds.p=37796918);
r51put_string(&ds,((T51*)ci(51,oBC1std_output,37796896)),((T0*)ms18_32aa));
(ds.p=37797174);
r51put_string(&ds,((T51*)ci(51,oBC1std_output,37797152)),r25name(&ds,((T25*)ci(25,(/*RF2*/(((T26*)ci(26,_feature_def,37797196)))->_name/*12*/),37797220))));
(ds.p=37797430);
r51put_string(&ds,((T51*)ci(51,oBC1std_output,37797408)),((T0*)ms18_32a));
(ds.p=37797686);
r51put_integer(&ds,((T51*)ci(51,oBC1std_output,37797664)),(/*RF2*/(((T26*)ci(26,_feature_def,37797710)))->_number/*16*/));
(ds.p=37797942);
r51put_new_line(&ds,((T51*)ci(51,oBC1std_output,37797920)));
}
(ds.p=37798682);
_i=(_i)+(1);
}
(ds.p=37800230);
r62connect_to(&ds,((T62*)ci(62,r18csv_file(&ds),37800212)),((T0*)ms18_1632845627));
if(((ds.p=37800730),r6_ix_not(&ds,r62is_connected(&ds,((T62*)ci(62,r18csv_file(&ds),37800738)))))){
(ds.p=37801006);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,37800986)),((T0*)ms18_1112394744));
(ds.p=37801242);
exit(1);
}
(ds.p=37802284);
r62read_line_in(&ds,((T62*)ci(62,r18csv_file(&ds),37802266)),_line);
while (!(((ds.p=37802796),r62end_of_input(&ds,((T62*)ci(62,r18csv_file(&ds),37802778))))))
{
(ds.p=37803290);
{T22*n=((T22*)se_malloc(sizeof(*n))/*16*/);
*n=M22;
r22make_from_csv(&ds,n,_line);
_class_def=((T0*)n);
}
(ds.p=37803826);
r40add_last(&ds,se_i40(&ds,((T40*)ci(40,r18all_classes(&ds),37803802))),_class_def);
(ds.p=37804332);
r62read_line_in(&ds,((T62*)ci(62,r18csv_file(&ds),37804314)),_line);
}
(ds.p=37805094);
r62disconnect(&ds,((T62*)ci(62,r18csv_file(&ds),37805076)));
(ds.p=37805850);
_i=0;
while (!(((ds.p=37806366),(_i)>((/*RF2*/(se_i40(&ds,((T40*)ci(40,r18all_classes(&ds),37806370))))->_upper/*12*/)))))
{
(ds.p=37806874);
_class_def=r40item(&ds,se_i40(&ds,((T40*)ci(40,r18all_classes(&ds),37806900))),_i);
if(_verbose){
(ds.p=37807670);
r51put_string(&ds,((T51*)ci(51,oBC1std_output,37807648)),((T0*)ms18_36564660));
(ds.p=37807926);
r51put_unsigned_in_hexadecimal(&ds,((T51*)ci(51,oBC1std_output,37807904)),(/*RF2*/(((T22*)ci(22,_class_def,37807982)))->_reference/*4*/));
(ds.p=37808182);
r51put_string(&ds,((T51*)ci(51,oBC1std_output,37808160)),((T0*)ms18_32));
(ds.p=37808438);
r51put_string(&ds,((T51*)ci(51,oBC1std_output,37808416)),r25name(&ds,((T25*)ci(25,(/*RF2*/(((T22*)ci(22,_class_def,37808460)))->_name/*8*/),37808480))));
(ds.p=37808694);
r51put_new_line(&ds,((T51*)ci(51,oBC1std_output,37808672)));
}
(ds.p=37809434);
_i=(_i)+(1);
}
(ds.p=37810708);
{T32*n=((T32*)se_malloc(sizeof(*n))/*12*/);
*n=M32;
r32connect_to(&ds,n,((T0*)ms18_1208554584));
(/*SFN*/C->_out_file)=((T0*)n);
}
if(((ds.p=37811226),r6_ix_not(&ds,r32is_connected(&ds,((T32*)ci(32,(/*RF2*/(C)->_out_file/*4*/),37811234)))))){
(ds.p=37811502);
r50put_string(&ds,((T50*)ci(50,oBC1std_error,37811482)),((T0*)ms18_992129236));
(ds.p=37811738);
exit(1);
}
(ds.p=37812518);
r32put_string(&ds,((T32*)ci(32,(/*RF2*/(C)->_out_file/*4*/),37812500)),((T0*)ms18_928730390));
(ds.p=37812774);
r32put_string(&ds,((T32*)ci(32,(/*RF2*/(C)->_out_file/*4*/),37812756)),((T0*)ms18_1471027379));
(ds.p=37813030);
r32put_string(&ds,((T32*)ci(32,(/*RF2*/(C)->_out_file/*4*/),37813012)),((T0*)ms18_2037755417));
(ds.p=37813286);
r32put_string(&ds,((T32*)ci(32,(/*RF2*/(C)->_out_file/*4*/),37813268)),((T0*)ms18_741426632));
(ds.p=37813542);
r32put_new_line(&ds,((T32*)ci(32,(/*RF2*/(C)->_out_file/*4*/),37813524)));
(ds.p=37813798);
r32put_new_line(&ds,((T32*)ci(32,(/*RF2*/(C)->_out_file/*4*/),37813780)));
(ds.p=37814554);
_i=0;
while (!(((ds.p=37815070),(_i)>((/*RF2*/(se_i40(&ds,((T40*)ci(40,r18all_classes(&ds),37815074))))->_upper/*12*/)))))
{
(ds.p=37815578);
_class_def=r40item(&ds,se_i40(&ds,((T40*)ci(40,r18all_classes(&ds),37815604))),_i);
if(((ds.p=37816658),(r43count(&ds,se_i43(&ds,((T43*)ci(43,(/*RF2*/(((T22*)ci(22,_class_def,37816608)))->_features/*12*/),37816628)))))>(0))){
(ds.p=37816882);
r32put_string(&ds,((T32*)ci(32,(/*RF2*/(C)->_out_file/*4*/),37816864)),((T0*)ms18_583186920));
(ds.p=37817138);
r32put_string(&ds,((T32*)ci(32,(/*RF2*/(C)->_out_file/*4*/),37817120)),((T0*)ms18_73249748));
(ds.p=37817894);
_j=0;
while (!(((ds.p=37818410),(_j)>((/*RF2*/(se_i43(&ds,((T43*)ci(43,(/*RF2*/(((T22*)ci(22,_class_def,37818414)))->_features/*12*/),37818434))))->_upper/*12*/)))))
{
(ds.p=37818918);
_type=r18find_class_from_reference(&ds,C,(/*RF2*/(((T26*)ci(26,r43item(&ds,se_i43(&ds,((T43*)ci(43,(/*RF2*/(((T22*)ci(22,_class_def,37818986)))->_features/*12*/),37819006))),_j),37819024)))->_type/*8*/));
if(((ds.p=37819466),r7is_equal(&ds,se_i7(&ds,((T7*)ci(7,r25name(&ds,((T25*)ci(25,(/*RF2*/(((T22*)ci(22,_type,37819436)))->_name/*8*/),37819446))),37819456))),((T0*)ms18_1211759081)))){
(ds.p=37819710);
r32put_string(&ds,((T32*)ci(32,(/*RF2*/(C)->_out_file/*4*/),37819692)),((T0*)ms18_391620192));
}
 else if(((ds.p=37819986),r7is_equal(&ds,se_i7(&ds,((T7*)ci(7,r25name(&ds,((T25*)ci(25,(/*RF2*/(((T22*)ci(22,_type,37819956)))->_name/*8*/),37819966))),37819976))),((T0*)ms18_15956)))){
(ds.p=37820222);
r32put_string(&ds,((T32*)ci(32,(/*RF2*/(C)->_out_file/*4*/),37820204)),((T0*)ms18_78448212));
}
 else if(((ds.p=37820498),r7is_equal(&ds,se_i7(&ds,((T7*)ci(7,r25name(&ds,((T25*)ci(25,(/*RF2*/(((T22*)ci(22,_type,37820468)))->_name/*8*/),37820478))),37820488))),((T0*)ms18_48745269)))){
(ds.p=37820734);
r32put_string(&ds,((T32*)ci(32,(/*RF2*/(C)->_out_file/*4*/),37820716)),((T0*)ms18_15677902));
}
 else if(((ds.p=37821010),r7is_equal(&ds,se_i7(&ds,((T7*)ci(7,r25name(&ds,((T25*)ci(25,(/*RF2*/(((T22*)ci(22,_type,37820980)))->_name/*8*/),37820990))),37821000))),((T0*)ms18_278058207)))){
(ds.p=37821246);
r32put_string(&ds,((T32*)ci(32,(/*RF2*/(C)->_out_file/*4*/),37821228)),((T0*)ms18_1720878936));
}
(ds.p=37822008);
r32put_string(&ds,((T32*)ci(32,(/*RF2*/(C)->_out_file/*4*/),37821990)),r25name(&ds,((T25*)ci(25,(/*RF2*/(((T26*)ci(26,r43item(&ds,se_i43(&ds,((T43*)ci(43,(/*RF2*/(((T22*)ci(22,_class_def,37822030)))->_features/*12*/),37822050))),_j),37822068)))->_name/*12*/),37822084))));
if(((ds.p=37822576),((/*RF2*/(((T26*)ci(26,r43item(&ds,se_i43(&ds,((T43*)ci(43,(/*RF2*/(((T22*)ci(22,_class_def,37822508)))->_features/*12*/),37822528))),_j),37822546)))->_number/*16*/))!=(1))){
(ds.p=37822782);
r32put_character(&ds,((T32*)ci(32,(/*RF2*/(C)->_out_file/*4*/),37822764)),((T3)'\133'));
(ds.p=37823038);
r32put_integer(&ds,((T32*)ci(32,(/*RF2*/(C)->_out_file/*4*/),37823020)),(/*RF2*/(((T26*)ci(26,r43item(&ds,se_i43(&ds,((T43*)ci(43,(/*RF2*/(((T22*)ci(22,_class_def,37823062)))->_features/*12*/),37823082))),_j),37823100)))->_number/*16*/));
(ds.p=37823294);
r32put_character(&ds,((T32*)ci(32,(/*RF2*/(C)->_out_file/*4*/),37823276)),((T3)'\135'));
}
(ds.p=37824056);
r32put_string(&ds,((T32*)ci(32,(/*RF2*/(C)->_out_file/*4*/),37824038)),((T0*)ms18_305));
(ds.p=37824550);
_j=(_j)+(1);
}
(ds.p=37825330);
r32put_string(&ds,((T32*)ci(32,(/*RF2*/(C)->_out_file/*4*/),37825312)),((T0*)ms18_1319045275));
(ds.p=37825586);
r32put_string(&ds,((T32*)ci(32,(/*RF2*/(C)->_out_file/*4*/),37825568)),r25name_capitalized(&ds,((T25*)ci(25,(/*RF2*/(((T22*)ci(22,_class_def,37825608)))->_name/*8*/),37825628))));
(ds.p=37825842);
r32put_string(&ds,((T32*)ci(32,(/*RF2*/(C)->_out_file/*4*/),37825824)),((T0*)ms18_1535));
}
(ds.p=37826586);
_i=(_i)+(1);
}
(ds.p=37827366);
r32put_new_line(&ds,((T32*)ci(32,(/*RF2*/(C)->_out_file/*4*/),37827348)));
(ds.p=37827878);
r32disconnect(&ds,((T32*)ci(32,(/*RF2*/(C)->_out_file/*4*/),37827860)));
se_dst=caller;/*unlink*/
}
se_frame_descriptor f18make={"make of CONVERT_CSV_TO_C_STRUCTS",1,9,"%R18%verbose%E6%type%R22%spelling%R24%name%R25%feature_def%R26%class_def%R22%j%E2%i%E2%line%R7%",1};


T0* r18find_class_from_reference(se_dump_stack*caller,T18* C,T17 a1){
T0* R=NULL;
T2 _i=0;
void**locals[3];
se_dump_stack ds;
ds.fd=&f18find_class_from_reference;
ds.current=((void**)&C);
ds.p=39946760;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
locals[2]=(void**)&_i;
se_dst=&ds;/*link*/
{int c=0;int v=0;
(ds.p=39948058);
_i=0;
while (!(((ds.p=39949126),((_i)>((/*RF2*/(se_i40(&ds,((T40*)ci(40,r18all_classes(&ds),39949090))))->_upper/*12*/)))||((R)!=((void*)(NULL))))))
{
(ds.p=39948606);
v=ac_lvc(c++,v,((/*RF2*/(se_i40(&ds,((T40*)ci(40,r18all_classes(&ds),39948570))))->_upper/*12*/))-(_i));
if(((ds.p=39949660),((/*RF2*/(((T22*)ci(22,r40item(&ds,se_i40(&ds,((T40*)ci(40,r18all_classes(&ds),39949600))),_i),39949624)))->_reference/*4*/))==(a1))){
(ds.p=39949856);
R=r40item(&ds,se_i40(&ds,((T40*)ci(40,r18all_classes(&ds),39949876))),_i);
}
(ds.p=39950618);
_i=(_i)+(1);
}
}
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f18find_class_from_reference={"find_class_from_reference of GLOBALS",1,3,"%R18%ref%E17%Result%R22%i%E2%",1};
T0*oBC1std_output=NULL;


T0* r18all_spellings(se_dump_stack*caller){
if(fBC19all_spellings==0){fBC19all_spellings=1;{
void**locals[1];
se_dump_stack ds;
ds.fd=&f18all_spellings;
ds.current=NULL;
ds.p=39869448;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&oBC19all_spellings;
se_dst=&ds;/*link*/
(ds.p=39869972);
{T44*n=((T44*)se_malloc(sizeof(*n))/*16*/);
*n=M44;
oBC19all_spellings=((T0*)n);
r44with_capacity(&ds,n,256);
se_i44(&ds,n);}
se_dst=caller;/*unlink*/
}}
return oBC19all_spellings;
}
se_frame_descriptor f18all_spellings={"all_spellings of GLOBALS",0,1,"Result%R44%",1};


T0* r18argument(se_dump_stack*caller,T18* C,T2 a1){
T0* R=NULL;
void**locals[2];
se_dump_stack ds;
ds.fd=&f18argument;
ds.current=((void**)&C);
ds.p=2229256;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&a1;
locals[1]=(void**)&R;
se_dst=&ds;/*link*/
se_require_uppermost_flag=1;
if(f18argument.assertion_flag){
f18argument.assertion_flag=0;
(ds.p=2230296);
ac_req((a1)>=(0),NULL);
(ds.p=2230552);
ac_req((a1)<=(r18argument_count(&ds,C)),NULL);
f18argument.assertion_flag=1;
}
(ds.p=2231060);
R=r67item(&ds,se_i67(&ds,((T67*)ci(67,r18command_arguments(&ds),2231080))),a1);
if(f18argument.assertion_flag){
f18argument.assertion_flag=0;
(ds.p=2231586);
ac_ens((R)!=((void*)(NULL)),NULL);
f18argument.assertion_flag=1;
}
se_dst=caller;/*unlink*/
return R;
}
se_frame_descriptor f18argument={"argument of GENERAL",1,2,"%R18%i%E2%Result%R7%",1};
T0*oBC18csv_file=NULL;
int fBC18csv_file=0;


T0* r18csv_file(se_dump_stack*caller){
if(fBC18csv_file==0){fBC18csv_file=1;{
void**locals[1];
se_dump_stack ds;
ds.fd=&f18csv_file;
ds.current=NULL;
ds.p=37829384;
ds.caller=caller;
ds.locals=locals;
locals[0]=(void**)&oBC18csv_file;
se_dst=&ds;/*link*/
(ds.p=37829908);
{T62*n=((T62*)se_malloc(sizeof(*n))/*20*/);
*n=M62;
oBC18csv_file=((T0*)n);
r62make(&ds,n);
}
se_dst=caller;/*unlink*/
}}
return oBC18csv_file;
}
se_frame_descriptor f18csv_file={"csv_file of CONVERT_CSV_TO_C_STRUCTS",0,1,"Result%R62%",1};
T18*eiffel_root_object=NULL;
int se_argc;
char**se_argv;
T7* g[69];
T7* t[69];
char* p[69];
void(*se_prinT[69])(void**);


void initialize_eiffel_runtime(int argc,char*argv[]){
se_frame_descriptor irfd={"Initialising runtime.",0,0,"",1};
se_dump_stack ds = {NULL,NULL,0,NULL,NULL};
ds.fd=&irfd;
ds.caller=se_dst;
se_argc=argc;
se_argv=argv;
setup_signal_handler();
p[0]="???";
p[39]="/usr/local/fine/lib/std/safe_equal.e";
p[33]="/usr/local/fine/lib/std/output_stream.e";
p[23]="./reference_counter.e";
p[20]="/usr/local/fine/lib/std/platform.e";
p[52]="/usr/local/fine/lib/std/string_pool.e";
p[2]="/usr/local/fine/lib/std/integer.e";
p[7]="/usr/local/fine/lib/std/string.e";
p[29]="/usr/local/fine/lib/std/comparable.e";
p[32]="/usr/local/fine/lib/std/std_file_write.e";
p[28]="/usr/local/fine/lib/std/integer_ref.e";
p[10]="/usr/local/fine/lib/std/any.e";
p[51]="/usr/local/fine/lib/std/std_output.e";
p[36]="/usr/local/fine/lib/std/fixed_array.e";
p[30]="/usr/local/fine/lib/std/numeric.e";
p[1]="/usr/local/fine/lib/std/general.e";
p[17]="/usr/local/fine/lib/std/unsigned.e";
p[50]="/usr/local/fine/lib/std/std_error.e";
p[49]="/usr/local/fine/lib/std/unsigned_ref.e";
p[19]="./globals.e";
p[31]="/usr/local/fine/lib/std/hashable.e";
p[34]="/usr/local/fine/lib/std/pointer_ref.e";
p[8]="/usr/local/fine/lib/std/pointer.e";
p[26]="./feature_definition.e";
p[22]="./class_definition.e";
p[25]="./name.e";
p[24]="./spelling.e";
p[18]="./convert_csv_to_c_structs.e";
p[41]="/usr/local/fine/lib/std/native_array.e";
p[38]="/usr/local/fine/lib/std/collection.e";
p[56]="/usr/local/fine/lib/std/circular_queue.e";
p[35]="/usr/local/fine/lib/std/character_ref.e";
p[3]="/usr/local/fine/lib/std/character.e";
p[63]="/usr/local/fine/lib/std/input_stream.e";
p[6]="/usr/local/fine/lib/std/boolean.e";
p[62]="/usr/local/fine/lib/std/std_file_read.e";
p[27]="/usr/local/fine/lib/std/storable.e";
p[21]="/usr/local/fine/lib/std/boolean_ref.e";
p[37]="/usr/local/fine/lib/std/arrayed_collection.e";
se_prinT[52]=((void(*)(void**))se_prinT52);
se_prinT[40]=((void(*)(void**))se_prinT40);
p[40]=p[36];
se_prinT[8]=((void(*)(void**))se_prinT8);
se_prinT[6]=((void(*)(void**))se_prinT6);
se_prinT[44]=((void(*)(void**))se_prinT44);
p[44]=p[36];
se_prinT[25]=((void(*)(void**))se_prinT25);
se_prinT[3]=((void(*)(void**))se_prinT3);
se_prinT[46]=((void(*)(void**))se_prinT46);
p[46]=p[41];
se_prinT[32]=((void(*)(void**))se_prinT32);
se_prinT[64]=((void(*)(void**))se_prinT64);
p[64]=p[36];
se_prinT[57]=((void(*)(void**))se_prinT57);
p[57]=p[36];
se_prinT[42]=((void(*)(void**))se_prinT42);
p[42]=p[41];
se_prinT[67]=((void(*)(void**))se_prinT67);
p[67]=p[36];
se_prinT[61]=((void(*)(void**))se_prinT61);
p[61]=p[41];
se_prinT[48]=((void(*)(void**))se_prinT48);
p[48]=p[41];
se_prinT[7]=((void(*)(void**))se_prinT7);
se_prinT[62]=((void(*)(void**))se_prinT62);
se_prinT[9]=((void(*)(void**))se_prinT9);
p[9]=p[41];
se_prinT[17]=((void(*)(void**))se_prinT17);
se_prinT[58]=((void(*)(void**))se_prinT58);
p[58]=p[56];
se_prinT[24]=((void(*)(void**))se_prinT24);
se_prinT[22]=((void(*)(void**))se_prinT22);
se_prinT[53]=((void(*)(void**))se_prinT53);
p[53]=p[36];
se_prinT[60]=((void(*)(void**))se_prinT60);
p[60]=p[41];
se_prinT[2]=((void(*)(void**))se_prinT2);
se_prinT[18]=((void(*)(void**))se_prinT18);
se_prinT[66]=((void(*)(void**))se_prinT66);
p[66]=p[41];
se_prinT[26]=((void(*)(void**))se_prinT26);
se_prinT[55]=((void(*)(void**))se_prinT55);
p[55]=p[41];
se_prinT[43]=((void(*)(void**))se_prinT43);
p[43]=p[36];
se_prinT[51]=((void(*)(void**))se_prinT51);
se_prinT[50]=((void(*)(void**))se_prinT50);
g[39]=se_string("SAFE_EQUAL");
g[33]=se_string("OUTPUT_STREAM");
g[23]=se_string("REFERENCE_COUNTER");
g[20]=se_string("PLATFORM");
g[52]=se_string("STRING_POOL");
g[2]=se_string("INTEGER");
g[7]=se_string("STRING");
g[29]=se_string("COMPARABLE");
g[32]=se_string("STD_FILE_WRITE");
g[28]=se_string("INTEGER_REF");
g[10]=se_string("ANY");
g[51]=se_string("STD_OUTPUT");
g[36]=se_string("FIXED_ARRAY");
g[30]=se_string("NUMERIC");
g[1]=se_string("GENERAL");
g[17]=se_string("UNSIGNED");
g[50]=se_string("STD_ERROR");
g[49]=se_string("UNSIGNED_REF");
g[19]=se_string("GLOBALS");
g[31]=se_string("HASHABLE");
g[34]=se_string("POINTER_REF");
g[8]=se_string("POINTER");
g[26]=se_string("FEATURE_DEFINITION");
g[22]=se_string("CLASS_DEFINITION");
g[25]=se_string("NAME");
g[24]=se_string("SPELLING");
g[18]=se_string("CONVERT_CSV_TO_C_STRUCTS");
g[41]=se_string("NATIVE_ARRAY");
g[38]=se_string("COLLECTION");
g[56]=se_string("CIRCULAR_QUEUE");
g[35]=se_string("CHARACTER_REF");
g[3]=se_string("CHARACTER");
g[63]=se_string("INPUT_STREAM");
g[6]=se_string("BOOLEAN");
g[62]=se_string("STD_FILE_READ");
g[0]=se_string("NONE");
g[27]=se_string("STORABLE");
g[21]=se_string("BOOLEAN_REF");
g[37]=se_string("ARRAYED_COLLECTION");
g[40]=g[36];
g[44]=g[36];
g[46]=g[41];
g[64]=g[36];
g[57]=g[36];
g[42]=g[41];
g[67]=g[36];
g[61]=g[41];
g[48]=g[41];
g[9]=g[41];
g[58]=g[56];
g[53]=g[36];
g[60]=g[41];
g[66]=g[41];
g[55]=g[41];
g[43]=g[36];
t[52]=g[52];
t[40]=se_string("FIXED_ARRAY[CLASS_DEFINITION]");
t[8]=g[8];
t[6]=g[6];
t[44]=se_string("FIXED_ARRAY[SPELLING]");
t[25]=g[25];
t[3]=g[3];
t[46]=se_string("NATIVE_ARRAY[SPELLING]");
t[32]=g[32];
t[64]=se_string("FIXED_ARRAY[NAME]");
t[57]=se_string("FIXED_ARRAY[CIRCULAR_QUEUE[STRING]]");
t[42]=se_string("NATIVE_ARRAY[CLASS_DEFINITION]");
t[67]=se_string("FIXED_ARRAY[STRING]");
t[61]=se_string("NATIVE_ARRAY[STRING]");
t[48]=se_string("NATIVE_ARRAY[FEATURE_DEFINITION]");
t[7]=g[7];
t[62]=g[62];
t[9]=se_string("NATIVE_ARRAY[CHARACTER]");
t[17]=g[17];
t[58]=se_string("CIRCULAR_QUEUE[STRING]");
t[24]=g[24];
t[22]=g[22];
t[53]=se_string("FIXED_ARRAY[INTEGER]");
t[60]=se_string("NATIVE_ARRAY[CIRCULAR_QUEUE[STRING]]");
t[2]=g[2];
t[18]=g[18];
t[66]=se_string("NATIVE_ARRAY[NAME]");
t[26]=g[26];
t[55]=se_string("NATIVE_ARRAY[INTEGER]");
t[43]=se_string("FIXED_ARRAY[FEATURE_DEFINITION]");
t[51]=g[51];
t[50]=g[50];
se_msi1();
/*PCO*/
(ds.p=2193172);
{T50*n=((T50*)se_malloc(sizeof(*n))/*4*/);
*n=M50;
oBC1std_error=((T0*)n);
r50make(&ds,n);
}
/*PCO*/
(ds.p=2191636);
{T51*n=((T51*)se_malloc(sizeof(*n))/*4*/);
*n=M51;
oBC1std_output=((T0*)n);
r51make(&ds,n);
}
/*PCO*/
eiffel_root_object=((T18*)se_malloc(sizeof(*eiffel_root_object))/*8*/);
*eiffel_root_object=M18;
se_dst=NULL;
}
int  main(int argc,char*argv[]){
initialize_eiffel_runtime(argc,argv);
{T18*n=eiffel_root_object;
se_frame_descriptor root={"System root.",1,0,"%R18%",1};
se_dump_stack ds;
ds.fd=&root;
ds.current=((void**)(&n));
ds.p=37761544;
ds.caller=NULL;
se_dst=&ds;/*link*/
r18make(&ds,n);
}
return 0;}
T7*ms18_1436505586;
T7*ms19_495303630;
T7*ms26_1859534213;
T7*ms18_78448212;
T7*ms19_433290798;
T7*ms19_683379699;
T7*ms18_15956;
T7*ms25_13509;
T7*ms18_930068410;
T7*ms18_1420068785;
T7*ms19_1061971043;
T7*ms19_683379699a;
T7*ms24_1807165412;
T7*ms18_36564660;
T7*ms18_585664352;
T7*ms24_1416753280;
T7*ms18_305;
T7*ms18_343;
T7*ms18_32a;
T7*ms18_391620192;
T7*ms18_32aaaa;
T7*ms18_10522043;
T7*ms19_360;
T7*ms18_1208554584;
T7*ms18_8021535;
T7*ms18_1211759081;
T7*ms18_32aaa;
T7*ms18_992129236;
T7*ms18_2037755417;
T7*ms18_15677902;
T7*ms18_1319045275;
T7*ms19_1538229628;
T7*ms18_1535;
T7*ms19_1773176095;
T7*ms18_278058207;
T7*ms25_2270;
T7*ms26_164777188a;
T7*ms17_1949511993;
T7*ms25_2478;
T7*ms3_736411847;
T7*ms25_2795;
T7*ms18_32aa;
T7*ms18_48745269;
T7*ms18_1631001923;
T7*ms18_73249748;
T7*ms2_117797837;
T7*ms18_1101464864;
T7*ms18_1632845627;
T7*ms18_2083738964;
T7*ms2_1949511993;
T7*ms18_1471027379;
T7*ms18_1112394744;
T7*ms18_32;
T7*ms18_928730390;
T7*ms18_1720878936;
T7*ms18_23340076;
T7*ms26_164777188;
T7*ms18_583186920;
T7*ms18_951510288;
T7*ms18_741426632;


T7*se_ms(int c,char*e){
/* Allocation of a Manifest STRING.*/
T7*s=((T7*)se_malloc(sizeof(T7)));
s->id=7;
s->_count=c;
s->_capacity=c+1;
s->_storage=((T9)se_malloc(c+1));
memcpy(s->_storage,e,c+1);
return s;}


T7*se_string(char*e){
/* Creation of an Eiffel STRING by copying C char*e */
int c=strlen(e);
T7*s;
s=((T7*)se_malloc(sizeof(*s))/*20*/);
*s=M7;
s->_count=c;
s->_capacity=c+1;
s->_storage=((T9)se_malloc(c+1));
memcpy(s->_storage,e,c+1);
return s;}


void se_msi1(void){
ms18_1436505586=se_ms(22,"feature_definition.csv");
ms19_495303630=se_ms(15,"missing comma: ");
ms26_1859534213=se_ms(39,"read feature definition line too long: ");
ms18_78448212=se_ms(10,"    uint8 ");
ms19_433290798=se_ms(32,"scan_reference - invalid digit: ");
ms19_683379699=se_ms(33,"scan_reference - line too short: ");
ms18_15956=se_ms(4,"byte");
ms25_13509=se_ms(4,"Sha1");
ms18_930068410=se_ms(11,"Feature: 0x");
ms18_1420068785=se_ms(39,"unable to open: feature_definition.csv\n");
ms19_1061971043=se_ms(35,"scan_reference - missing ending \": ");
ms19_683379699a=se_ms(33,"scan_reference - line too short: ");
ms24_1807165412=se_ms(37,"reading spelling - missing ending \": ");
ms18_36564660=se_ms(9,"Class: 0x");
ms18_585664352=se_ms(44,"usage: convert_cvs_to_c_structs [--verbose]\n");
ms24_1416753280=se_ms(40,"reading spelling - missing beginning \": ");
ms18_305=se_ms(2,";\n");
ms18_343=se_ms(2,"-v");
ms18_32a=se_ms(1," ");
ms18_391620192=se_ms(11,"    ObjRef ");
ms18_32aaaa=se_ms(1," ");
ms18_10522043=se_ms(8,"name.csv");
ms19_360=se_ms(2,"0x");
ms18_1208554584=se_ms(11,"c_structs.h");
ms18_8021535=se_ms(8,"Name: 0x");
ms18_1211759081=se_ms(16,"object_reference");
ms18_32aaa=se_ms(1," ");
ms18_992129236=se_ms(28,"unable to open: c_structs.h\n");
ms18_2037755417=se_ms(82,"/* files.  You should not make changes to this file.  Any changes should be    */\n");
ms18_15677902=se_ms(9,"    char ");
ms18_1319045275=se_ms(11,"} C_struct_");
ms19_1538229628=se_ms(38,"scan_reference - missing beginning \": ");
ms18_1535=se_ms(3,";\n\n");
ms19_1773176095=se_ms(29,"scan_reference - missing 0x: ");
ms18_278058207=se_ms(10,"time_stamp");
ms25_2270=se_ms(3,"Cd_");
ms26_164777188a=se_ms(41,"read feature definition - invalid digit: ");
ms17_1949511993=se_ms(16,"0123456789ABCDEF");
ms25_2478=se_ms(3,"Md5");
ms3_736411847=se_ms(22,"0123456789abcdefABCDEF");
ms25_2795=se_ms(3,"Us_");
ms18_32aa=se_ms(1," ");
ms18_48745269=se_ms(9,"character");
ms18_1631001923=se_ms(12,"spelling.csv");
ms18_73249748=se_ms(24,"    EveryObject header;\n");
ms2_117797837=se_ms(10,"0123456789");
ms18_1101464864=se_ms(12,"Spelling: 0x");
ms18_1632845627=se_ms(20,"class_definition.csv");
ms18_2083738964=se_ms(25,"unable to open: name.csv\n");
ms2_1949511993=se_ms(16,"0123456789ABCDEF");
se_msi2();
}


void se_msi2(void){
ms18_1471027379=se_ms(82,"/* class_definition.csv, feature_definition.csv, name.csv, and spelling.csv    */\n");
ms18_1112394744=se_ms(37,"unable to open: class_definition.csv\n");
ms18_32=se_ms(1," ");
ms18_928730390=se_ms(82,"/* This file was generated by the convert_csv_to_c_structs.e program from the  */\n");
ms18_1720878936=se_ms(14,"    TimeStamp ");
ms18_23340076=se_ms(9,"--verbose");
ms26_164777188=se_ms(41,"read feature definition - invalid digit: ");
ms18_583186920=se_ms(17,"typedef struct {\n");
ms18_951510288=se_ms(29,"unable to open: spelling.csv\n");
ms18_741426632=se_ms(82,"/* made to the .cvs files and then rerun the convert_csv_to_c_structs program. */\n");
}


void X33put_character(se_dump_stack*caller,se_position position,T0*C,T3 a1){
se_dump_stack ds=*caller;
ds.caller=caller;
{Tid id=vc(C,position)->id;
switch(id){
case 32:r32put_character(&ds,((T32*)C),a1);

break;
case 50:r50put_character(&ds,((T50*)C),a1);

break;
case 51:r51put_character(&ds,((T51*)C),a1);

break;
default: error2(C,position);
}
}
se_dst=caller;
}

#ifdef __cplusplus
}
#endif
