// -*- C++ -*-

/* 
 * GChemPaint library
 * mesomer.cc
 *
 * Copyright (C) 2005 Jean Bréfort <jean.brefort@normalesup.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#include "mesomer.h"
#include "mesomery.h"
#include "molecule.h"
#include "document.h"

TypeId MesomerType;

gcpMesomer::gcpMesomer (): Object (MesomerType)
{
}

gcpMesomer::~gcpMesomer ()
{
	if (IsLocked ())
		return;
	gcpDocument *pDoc = reinterpret_cast<gcpDocument *> (GetDocument ());
	gcpOperation *pOp = pDoc->GetCurrentOperation ();
	gcpMesomery *ms = reinterpret_cast<gcpMesomery *> (GetParent ());
	if (!ms)
		return;
	map<string, Object *>::iterator i;
	Object *Child, *Group = ms->GetGroup ();
	while (HasChildren ()) {
		Child = GetFirstChild (i);
		GetParent ()->GetParent ()->AddChild (Child);
		if (pOp && !Group)
			pOp->AddObject (Child, 1);
	}
}

gcpMesomer::gcpMesomer (gcpMesomery* mesomery, gcpMolecule* molecule) throw (std::invalid_argument): Object (MesomerType)
{
	if (!mesomery || !molecule)
		throw invalid_argument ("NULL argument to gcpMesomer constructor!");
	SetId (const_cast<char*> ("ms1"));
	mesomery->AddChild (this);
	GetDocument ()->EmptyTranslationTable();
	AddChild (molecule);
	Molecule = molecule;
}

void gcpMesomer::AddArrow (gcpMesomeryArrow *arrow, gcpMesomer *mesomer) throw (std::invalid_argument)
{
	if (Arrows[mesomer])
		throw invalid_argument (_("Only one arrow can link two given mesomers."));
	Arrows[mesomer] = arrow;
}

void gcpMesomer::RemoveArrow (gcpMesomeryArrow *arrow, gcpMesomer *mesomer)
{
	Arrows.erase (mesomer);
}

double gcpMesomer::GetYAlign ()
{
	return (Molecule)? Molecule->GetYAlign (): 0.;
}

bool gcpMesomer::OnSignal (SignalId Signal, Object *Child)
{
	if (GetChildrenNumber () != 1) {
		delete GetParent ();
		return false;
	}
	return true;
}

bool gcpMesomer::Load(xmlNodePtr node)
{
	if (Object::Load (node)) {
		if (GetChildrenNumber () != 1)
			return false;
		map<string, Object*>::iterator i;
		Molecule = reinterpret_cast<gcpMolecule *> (GetFirstChild (i));
		return true;
	}
	return false;
}
