// -*- C++ -*-

/* 
 * GChemPaint arrows plugin
 * arrowtool.h 
 *
 * Copyright (C) 2001-2004
 *
 * Developed by Jean Bréfort <jean.brefort@normalesup.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#ifndef GCHEMPAINT_ARROW_TOOL_H
#define GCHEMPAINT_ARROW_TOOL_H

#include "lib/tool.h"
#include "lib/arrow.h"

enum {
	gcpDoubleHeadedArrow = gcpFullReversibleArrow + 1,
	gcpDoubleQueuedArrow
};

class gcpArrowTool: public gcpTool
{
public:
	gcpArrowTool (gcpApplication* App, unsigned ArrowType = gcpSimpleArrow);
	~gcpArrowTool ();
	
	virtual bool OnClicked ();
	virtual void OnDrag ();
	virtual void OnRelease ();
	virtual void SetOptions ();
	void SetArrowType (unsigned ArrowType) {m_ArrowType = ArrowType;}

protected:
	GnomeCanvasPoints *points;

private:
	double m_dAngle;
	unsigned m_ArrowType;
};

#endif	//GCHEMPAINT_ARROW_TOOL_H
