/*
 * Fisoco, a FInding SOrting and COnverting free software
 * Copyright 2015 Félicien PILLOT <felicien.pillot@member.fsf.org>
 *
 * This file is part of Fisoco.
 *
 * Fisoco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Fisoco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Fisoco.  If not, see <http://www.gnu.org/licenses/>.
 *
 *//////////////////////////////////////
/****************
 *   Cmain.cc   *
 *    ~~~~~~    *
 ****************/

#if HAVE_CONFIG_H
#  include <config.h>
#endif /* HAVE_CONFIG_H */
#if HAVE_UNISTD_H
#  include <unistd.h>
#endif /* HAVE_UNISTD_H */
// i18n
#include "../include/gettext.h"
// Fisoco headers
#include "../include/run.h"

int
getdir (std::string search,
	std::map<std::string, std::string> &files,
	std::string dir)
{
  DIR *dp;
  struct dirent *dirp;
  struct stat st;
  std::string type;
  
  if((dp = opendir(dir.c_str())) == NULL) {
    std::cout << "Error opening " << dir << std::endl;
    exit (0);
  }
  
  while ((dirp = readdir(dp)) != NULL)
    {
      std::string path = dir + "/" + (std::string) dirp->d_name;
      stat (path.c_str(), &st);
      if (S_ISDIR (st.st_mode))
	type = "Directory";
      else
	type = "File";
      files[std::string(dirp->d_name)] = type;
    }
  closedir(dp);
  return 0;
}

std::map<std::string, std::string>
extr_files (std::string search, std::map<std::string, std::string> res)
{
  std::map<std::string, std::string> files;
  
  for (std::map<std::string, std::string>::iterator file = res.begin ();
       file != res.end (); ++file)
    {
      if ((*file).second == "File" &&
	  (std::search ((*file).first.begin (),
			(*file).first.end (), 
			search.begin (),
			search.end () )
	   != (*file).first.end () ))
	  files[(*file).first] = "File";
    }
  return files;
}

std::list<std::string>
extr_dirs (std::map<std::string, std::string> res)
{
  std::list<std::string> dirs;
  
  for (std::map<std::string, std::string>::iterator dir = res.begin ();
       dir != res.end (); ++dir)
    {
      if ((*dir).second == "Directory" && (*dir).first != "." && (*dir).first != "..")
	dirs.push_back ((*dir).first);
    }
  return dirs;
}
