/*
 * Fisoco, a FInding SOrting and COnverting free software
 * Copyright 2015 Félicien PILLOT <felicien.pillot@member.fsf.org>
 *
 * This file is part of Fisoco.
 *
 * Fisoco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Fisoco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Fisoco.  If not, see <http://www.gnu.org/licenses/>.
 *
 *//////////////////////////////////////
/****************
 *    main.cc   *
 *    ~~~~~~    *
 ****************/

#if HAVE_CONFIG_H
#  include <config.h>
#endif /* HAVE_CONFIG_H */
#if HAVE_UNISTD_H
#  include <unistd.h>
#endif /* HAVE_UNISTD_H */
// C headers
#include <iostream>
#include <getopt.h>
// i18n
#include "../include/gettext.h"
#include <locale.h>
#include <cstdlib>
// Gtkmm headers
#include <gtkmm/application.h>
// Fisoco headers
#include "../include/main.h"
#include "../include/Cmain.h"

using namespace std;

int
main (int argc, char* argv[])
{
  /* locale settings */
  setlocale (LC_CTYPE, "");
  setlocale (LC_MESSAGES, "");
  bindtextdomain (PACKAGE, LOCALEDIR);
  textdomain ( PACKAGE);
  cout << PACKAGE << gettext (" launched !") << endl;
  /* graphical interface */
  Glib::RefPtr<Gtk::Application> main =
    Gtk::Application::create (argc, argv,
			      "org.gtkmm.examples.base");
  Cmain_ui main_window;
  return main->run (main_window);
}

void
usage ()
{
  printf ("Coucou");
}

void
version ()
{
  printf ("Fisoco  Copyright  (C) 2015  Felicien PILLOT <felicien.pillot@mem"
	  "ber.fsf.org>\nThis program comes with ABSOLUTELY NO WARRANTY; for"
	  " details use -w option.\nThis is free software, and you are welco"
	  "me to redistribute\nit under certain condition (option -c for det"
	  "ails).\n");
}
