/*
 * Fisoco, a FInding SOrting and COnverting free software
 * Copyright 2015 Félicien PILLOT <felicien.pillot@member.fsf.org>
 *
 * This file is part of Fisoco.
 *
 * Fisoco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Fisoco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Fisoco.  If not, see <http://www.gnu.org/licenses/>.
 *
 *//////////////////////////////////////
/****************
 *   Cmain.cc   *
 *    ~~~~~~    *
 ****************/

#if HAVE_CONFIG_H
#  include <config.h>
#endif /* HAVE_CONFIG_H */
#if HAVE_UNISTD_H
#  include <unistd.h>
#endif /* HAVE_UNISTD_H */
// i18n
#include "../include/gettext.h"
// Fisoco headers
#include "../include/Cmain.h"
#include "../include/run.h"

Cmain_ui::Cmain_ui ()
  : main_all_ (Gtk::ORIENTATION_VERTICAL),
    main_search_ (Gtk::ORIENTATION_VERTICAL),
    main_interface_ (Gtk::ORIENTATION_HORIZONTAL),
    right_buttons_ (Gtk::ORIENTATION_VERTICAL),
    cancel_button_ (gettext ("Cancel")),
    search_button_ (gettext ("Search")),
    select_button_ (gettext ("Select")),
    move_button_ (gettext ("Move")),
    convert_button_ (gettext ("Convert")),
    new_search_button_ (gettext ("New search"))
  {
    /* window */
    set_title (gettext ("Fisoco - Main window"));
    set_border_width (5);
    set_default_size (1000, 500);
    /* labels */
    main_text_top_.set_markup (gettext ("Please choose your files, then conv"
					   "ert or move them"));
    main_text_top_.set_justify (Gtk::JUSTIFY_CENTER);
    main_text_top_.set_line_wrap ();
    /* treeview definition */
    m_refTreeModel = Gtk::TreeStore::create(main_columns_);
    m_TreeView.set_model(m_refTreeModel);
    m_TreeView.set_reorderable();
    m_TreeView.append_column("Results", main_columns_.m_col_id);
    m_TreeView.append_column("Name", main_columns_.m_col_name);
    m_TreeView.append_column("Type", main_columns_.m_col_type);
    /* treeview and treemodel/treestore */
    m_ScrolledWindow_.add (m_TreeView);
    m_ScrolledWindow_.set_policy (Gtk::POLICY_AUTOMATIC, Gtk::POLICY_AUTOMATIC);
    /* search box */
    main_entry_.set_max_length (40);
    main_entry_.set_placeholder_text (gettext ("Search files..."));
    search_buttons_.pack_start (cancel_button_);
    search_buttons_.pack_start (search_button_);
    search_buttons_.set_layout (Gtk::BUTTONBOX_END);
    main_search_.pack_start (main_entry_, Gtk::PACK_SHRINK, 10);
    main_search_.pack_start (search_buttons_, Gtk::PACK_SHRINK, 5);
    search_frame_.set_border_width (5);
    search_frame_.set_shadow_type (Gtk::SHADOW_ETCHED_IN);
    search_frame_.add (main_search_);
    // interface box
    right_buttons_.pack_start (select_button_, Gtk::PACK_EXPAND_WIDGET);
    right_buttons_.pack_start (move_button_, Gtk::PACK_EXPAND_WIDGET);
    right_buttons_.pack_start (convert_button_, Gtk::PACK_EXPAND_PADDING);
    right_buttons_.pack_start (new_search_button_, Gtk::PACK_EXPAND_PADDING);
    right_buttons_.set_layout (Gtk::BUTTONBOX_SPREAD);
    main_interface_.pack_start (m_ScrolledWindow_, Gtk::PACK_EXPAND_WIDGET, 20);
    main_interface_.pack_start (right_buttons_, Gtk::PACK_SHRINK, 5);
    /* all */
    main_all_.pack_start (main_text_top_);
    main_all_.pack_start (search_frame_, Gtk::SHRINK, 5);
    main_all_.pack_start (main_interface_);
    template_box.pack_start (main_all_);
    /* treeview selection */
    Glib::RefPtr<Gtk::TreeSelection> refTreeSelection =
      m_TreeView.get_selection();
    refTreeSelection->set_mode(Gtk::SELECTION_MULTIPLE);
    /* signals */
    refTreeSelection->selected_foreach_iter
      (sigc::mem_fun (*this, &Cmain_ui::selected_row_callback) );
    m_TreeView.signal_row_activated()
      .connect (sigc::mem_fun (*this,
			     &Cmain_ui::on_treeview_row_activated) );
    cancel_button_.signal_clicked ()
      .connect (sigc::mem_fun (*this,
			       &Cmain_ui::cancelB_clicked) );
    search_button_.signal_clicked ()
      .connect (sigc::mem_fun (*this,
			       &Cmain_ui::searchB_clicked) );
    select_button_.signal_clicked ()
      .connect (sigc::mem_fun (*this,
			       &Cmain_ui::selectB_clicked) );
    move_button_.signal_clicked ()
      .connect (sigc::mem_fun (*this,
			       &Cmain_ui::moveB_clicked) );
    convert_button_.signal_clicked ()
      .connect (sigc::mem_fun (*this,
			       &Cmain_ui::convertB_clicked) );
    new_search_button_.signal_clicked ()
      .connect (sigc::mem_fun (*this,
			       &Cmain_ui::new_searchB_clicked) );
    /* display */
    show_all_children ();
    main_interface_.hide ();
  }

void
Cmain_ui::on_treeview_row_activated(const Gtk::TreeModel::Path& path,
			    Gtk::TreeViewColumn* column)
{
  Gtk::TreeModel::iterator iter = m_refTreeModel->get_iter(path);
  if(iter)
    {
      Gtk::TreeModel::Row row = *iter;
      std::cout << "Row activated: ID=" << row[main_columns_.m_col_id] << ", Name="
		<< row[main_columns_.m_col_name] << std::endl;
    }
}

void
Cmain_ui::selected_row_callback (const Gtk::TreeModel::iterator& iter)
{
  Gtk::TreeModel::Row row = *iter;
  Glib::ustring rowName = row[main_columns_.m_col_name];
  std::cout << gettext ("The column ") << rowName <<
    gettext (" has been selected.") << std::endl;
}

void
Cmain_ui::cancelB_clicked ()
{
  std::cout << gettext ("Button 'Cancel' selected !!") << std::endl;
  main_entry_.set_text ("");
}

void
Cmain_ui::searchB_clicked ()
{
  std::cout << gettext ("Button 'Search' selected !!") << std::endl;
  Glib::ustring search = main_entry_.get_text ();
  std::string dir = "/home/fefe/Documents";
  std::map<std::string, std::string> results;

  getdir (search, results, dir);
  fill_view_recurs (search, results, dir);
  
  main_interface_.show_now ();
}

void
Cmain_ui::selectB_clicked ()
{
  std::cout << gettext ("Button 'Select' selected !!") << std::endl;
}

void
Cmain_ui::moveB_clicked ()
{
  std::cout << gettext ("Button 'Move' selected !!") << std::endl;
}

void
Cmain_ui::convertB_clicked ()
{
  std::cout << gettext ("Button 'Convert' selected !!") << std::endl;
}

void
Cmain_ui::new_searchB_clicked ()
{
  std::cout << gettext ("Button 'New search' selected !!") << std::endl;
  m_refTreeModel->clear();

  if (main_interface_.is_visible ())
    {
      main_interface_.hide ();
      Cmain_ui::cancelB_clicked ();
    }
  else
    {
      std::cout << gettext ("Failed :)") << std::endl;
    }
}

void
Cmain_ui::fill_view_recurs (std::string search,
			    std::map<std::string, std::string> results,
			    std::string dir)
{
  std::cout << "Processing directory (" << dir << ")..." << std::endl;
  std::map<std::string, std::string> files = extr_files (search, results);

  if (files.size () != 0)
    {
      Gtk::TreeModel::Row row = *(m_refTreeModel->append());
      row[main_columns_.m_col_id] = files.size ();
      row[main_columns_.m_col_type] = "Directory";
      row[main_columns_.m_col_name] = dir;
      
      for (std::map<std::string, std::string>::iterator f = files.begin ();
	   f != files.end (); ++f)
	{
	  int y = 0;
	  Gtk::TreeModel::Row childrow = *(m_refTreeModel->append(row.children()));
	  childrow[main_columns_.m_col_id] = y;
	  childrow[main_columns_.m_col_name] = (*f).first;
	  childrow[main_columns_.m_col_type] = (*f).second;
	}
    }
  
  std::list<std::string> directories = extr_dirs (results);
  for (std::list<std::string>::iterator d = directories.begin ();
       d != directories.end (); ++d)
    {
      std::string new_dir = dir + "/" + *d;
      std::map<std::string, std::string> new_results;
      getdir (search, new_results, new_dir);
      fill_view_recurs (search, new_results, new_dir);
    }
}

Cmain_ui::~Cmain_ui()
{
}
