#include "auximagem.h"
#include <QDebug>


#ifndef cvCopyImage
    #define cvCopyImage cvCopy
#endif
#ifndef cvQueryHistValue_1D
    #define cvQueryHistValue_1D cvGetReal1D
#endif

/** Aux Imagem:
 * Classe AuxImage, contem metodos para a analise e processamento de imagens.
 * -> Metodo histogram calcula o histograma de imagem em niveis de cinza.
 * @author: Michel Melo da Silva
 * @date: 2011/01/28
 * @last: 2011/01/28
 */
AuxImagem::AuxImagem()
{
}

/** Histogram:
 * Metodo utilizado para calcular o histograma de uma imagem do formato iplImage
 * de 8-bits e um canal. Recebe a imagem como parametro, cria uma nova imagem
 * na qual sera desenhado o histograma e a retorna.
 * @return: IplImage*
 * @param: IplImage* -> ponteiro para a imagem que sera calculado o histograma.
 * @author: Michel Melo da Silva
 * @date: 2011/01/24
 * @last: 2012/10/16
 */
IplImage* AuxImagem::histogram(IplImage *image)
{
    // Parametros de criacao do histograma.
    int dim = 1;               // Numero de dimensoes do histograma.
    int hist_size = 256;       // Tamanho do histograma.
    int sizes[] = {hist_size}; // Tamanho do vetor de cada dimensoo.
    int type = CV_HIST_ARRAY;  // Tipo de Histograma.

    float xranges[] = { 0, 255 };
    float* ranges[] = { xranges };

    float sum=0.0;
    float mean=0.0;
    float moment2=0.0;
    float std=0.0;


    // Cria e calcula o histograma.
    CvHistogram* hist = cvCreateHist( dim, sizes, type, ranges, 1 );
    cvCalcHist( &image, hist, 0, NULL);

    // Calcular o maior valor no histograma.
    float max = 0;
    cvGetMinMaxHistValue( hist, 0, &max, 0, 0);

    // Carrega imagem para armazenar os desenhos da curva do histograma.
    IplImage* histImg = cvCreateImage(cvSize(300,200), 8, 3);
    cvSet(histImg, CV_RGB(255,255,255));
    if(histImg == NULL)
    {
        qWarning() <<"IplImage=NULL";
    }
    // Desenha o Histograma.
    float value;
    int norm;

    // Preenche a imagem do histograma.

    for(int i=0; i < hist_size; i++)
    {
        // Le o valor no histograma.
        value = cvQueryHistValue_1D( hist, i );
        mean    = mean + i*value;
        moment2 = moment2 + i*i*value;
        sum     = sum + value;
        // Normaliza o valor entre 0 e 150.
        norm = cvRound((value/max)*150);
        // Desenha a linha que representa esta cor no histograma.
        cvLine(histImg, cvPoint(i+22,175), cvPoint(i+22,175-norm), CV_RGB(0,0,0));
    }
    cvReleaseHist(&hist);

    mean    = mean/sum;
    moment2 = moment2/sum;
    std     = sqrt(moment2-mean*mean);

    CvFont font;
    double hScale=0.5;
    double vScale=0.5;
    int    lineWidth=1;
    cvInitFont(&font,CV_FONT_HERSHEY_SIMPLEX|CV_FONT_ITALIC, hScale,vScale,0,lineWidth);
    char buffer[256];
    sprintf(buffer,"Mean:%6.2f      Std:%6.2f",mean,std);
    cvPutText (histImg,buffer,cvPoint(25,190), &font, cvScalar(10,10,190,0));
    sprintf(buffer,"Histogram");
    cvPutText (histImg,buffer,cvPoint(110,10), &font, cvScalar(10,10,10,0));

    // Retorna a imagem formada.
    return histImg;
}

/** ColoreImagem:
 * Metodo utilizado para colorir uma imagem do formato iplImage de 8-bits e um
 * canal. Recebe a imagem como parametro, cria uma nova imagem de 8-bits e tres
 * canais na qual sera feito a coloracao artificial da imagem recebida.
 * @return: IplImage*
 * @param: IplImage* -> ponteiro para a imagem que sera calculado o histograma.
 * @author: Michel Melo da Silva
 * @date: 2011/02/14
 * @last: 2011/02/14
 */
IplImage* AuxImagem::coloreImagem(IplImage *image)
{
    // Cria uma imagem de 8-bits e 3 canais com a mesma resolucao da imagem
    // recebida como parametro.
    IplImage* result = cvCreateImage(cvSize(image->widthStep,image->height),8,3);

    int red,green,blue;
    unsigned char aux;

    // Percorre todos os dados da imagem.
    for (int y = 0; y < image->imageSize; y++) {

        aux = image->imageData[y];

        if(aux < 64){
            red = 0;
            green = (aux*4);
            blue = 255;
         } else {
             if(aux < 128){
                red = 0;
                green = 255;
                blue = (255 - (aux-64)*4);
            } else {
                if(aux < 192){
                    red = ((aux-128) * 4);
                    green = 255;
                    blue = 0;
                } else {
                    red = 255;
                    green = (255 - (aux-192) * 4);
                    blue = 0;
                }
            }
        }

        result->imageData[y*3+2] = red;
        result->imageData[y*3+1] = green;
        result->imageData[y*3+0] = blue;

    }

    return result;
}
